/*
 * Decompiled with CFR 0.152.
 */
package annotations.field;

import annotations.field.AFTVisitor;
import annotations.field.AnnotationFieldType;
import annotations.field.ScalarAFT;
import java.util.Collection;

public final class ArrayAFT
extends AnnotationFieldType {
    public final ScalarAFT elementType;

    public ArrayAFT(ScalarAFT elementType) {
        this.elementType = elementType;
    }

    @Override
    public boolean isValidValue(Object o) {
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection asCollection = (Collection)o;
        if (this.elementType == null) {
            return asCollection.size() == 0;
        }
        for (Object elt : asCollection) {
            if (this.elementType.isValidValue(elt)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return (this.elementType == null ? "unknown" : this.elementType.toString()) + "[]";
    }

    @Override
    public String format(Object o) {
        Collection asCollection = (Collection)o;
        StringBuilder result = new StringBuilder();
        result.append("{");
        for (Object elt : asCollection) {
            if (result.length() > 1) {
                result.append(",");
            }
            result.append(this.elementType.format(elt));
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public <R, T> R accept(AFTVisitor<R, T> v, T arg) {
        return v.visitArrayAFT(this, arg);
    }
}

