/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.Criteria;
import annotator.find.Criterion;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

final class InPackageCriterion
implements Criterion {
    private final String name;

    InPackageCriterion(String name) {
        this.name = name;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.IN_PACKAGE;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        assert (path == null || path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        if (path == null) {
            return false;
        }
        Criteria.dbug.debug("InPackageCriterion.isSatisfiedBy(%s); this=%s", Main.pathToString(path), this.toString());
        do {
            Tree tree;
            if ((tree = path.getLeaf()).getKind() != Tree.Kind.COMPILATION_UNIT) continue;
            CompilationUnitTree cu = (CompilationUnitTree)tree;
            ExpressionTree pn = cu.getPackageName();
            if (pn == null) {
                return this.name == null || this.name.equals("");
            }
            String packageName = pn.toString();
            return this.name != null && this.name.equals(packageName);
        } while ((path = path.getParentPath()) != null && path.getLeaf() != null);
        Criteria.dbug.debug("InPackageCriterion.isSatisfiedBy => false", new Object[0]);
        return false;
    }

    public String toString() {
        return "in package '" + this.name + "'";
    }
}

