/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.type;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.TypeMetaModel;
import com.github.javaparser.utils.Utils;
import java.util.List;

public abstract class Type
extends Node {
    private List<ArrayType.ArrayBracketPair> arrayBracketPairs;
    private NodeList<AnnotationExpr> annotations;

    protected Type(TokenRange range) {
        this(range, new NodeList<AnnotationExpr>());
    }

    @AllFieldsConstructor
    public Type(NodeList<AnnotationExpr> annotations) {
        this(null, annotations);
    }

    public Type(TokenRange tokenRange, NodeList<AnnotationExpr> annotations) {
        super(tokenRange);
        this.setAnnotations(annotations);
        this.customInitialization();
    }

    public NodeList<AnnotationExpr> getAnnotations() {
        return this.annotations;
    }

    public AnnotationExpr getAnnotation(int i) {
        return (AnnotationExpr)this.getAnnotations().get(i);
    }

    public Type setAnnotations(NodeList<AnnotationExpr> annotations) {
        Utils.assertNotNull(annotations);
        if (annotations == this.annotations) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.ANNOTATIONS, this.annotations, annotations);
        if (this.annotations != null) {
            this.annotations.setParentNode(null);
        }
        this.annotations = annotations;
        this.setAsParentNodeOf(annotations);
        return this;
    }

    public Type getElementType() {
        if (this instanceof ArrayType) {
            return ((ArrayType)this).getComponentType().getElementType();
        }
        return this;
    }

    public int getArrayLevel() {
        if (this instanceof ArrayType) {
            return 1 + ((ArrayType)this).getComponentType().getArrayLevel();
        }
        return 0;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (this.annotations.get(i) != node) continue;
            this.annotations.remove(i);
            return true;
        }
        return super.remove(node);
    }

    public abstract String asString();

    @Override
    public Type clone() {
        return (Type)this.accept(new CloneVisitor(), null);
    }

    @Override
    public TypeMetaModel getMetaModel() {
        return JavaParserMetaModel.typeMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (this.annotations.get(i) != node) continue;
            this.annotations.set(i, (AnnotationExpr)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    public List<AnnotationExpr> getAnnotationsAtLevel(int level) {
        if (level >= this.getArrayCount() || level < 0) {
            throw new IllegalArgumentException("The level argument should be greater then 0 andless then the array count (" + this.getArrayCount() + "). Specified level is " + level);
        }
        return this.arrayBracketPairs.get(level).getAnnotations();
    }

    public List<ArrayType.ArrayBracketPair> getArrayBracketPairs() {
        return this.arrayBracketPairs;
    }

    public Type setArrayBracketPairs(List<ArrayType.ArrayBracketPair> arrayBracketPairs) {
        this.arrayBracketPairs = arrayBracketPairs;
        return this;
    }

    public int getArrayCount() {
        return this.arrayBracketPairs == null ? 0 : this.arrayBracketPairs.size();
    }
}

