/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexAbstractTransfer;
import org.checkerframework.checker.index.IndexRefinementInfo;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.index.qual.SubstringIndexFor;
import org.checkerframework.checker.index.upperbound.UBQualifier;
import org.checkerframework.checker.index.upperbound.UpperBoundAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NumericalAdditionNode;
import org.checkerframework.dataflow.cfg.node.NumericalMultiplicationNode;
import org.checkerframework.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.dataflow.cfg.node.TypeCastNode;
import org.checkerframework.dataflow.util.NodeUtils;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.javacutil.AnnotationProvider;

public class UpperBoundTransfer
extends IndexAbstractTransfer {
    private UpperBoundAnnotatedTypeFactory atypeFactory;

    public UpperBoundTransfer(CFAnalysis analysis) {
        super(analysis);
        this.atypeFactory = (UpperBoundAnnotatedTypeFactory)analysis.getTypeFactory();
    }

    @Override
    public TransferResult<CFValue, CFStore> visitAssignment(AssignmentNode node, TransferInput<CFValue, CFStore> in) {
        ArrayCreationNode acNode;
        TransferResult<CFValue, CFStore> result = super.visitAssignment(node, in);
        Node expNode = node.getExpression();
        Node expNodeSansCast = expNode instanceof TypeCastNode ? ((TypeCastNode)expNode).getOperand() : expNode;
        ArrayCreationNode arrayCreationNode = acNode = expNodeSansCast instanceof ArrayCreationNode ? (acNode = (ArrayCreationNode)expNodeSansCast) : null;
        if (acNode != null) {
            List<Node> nodeList = acNode.getDimensions();
            if (nodeList.size() < 1) {
                return result;
            }
            Node dim = acNode.getDimension(0);
            UBQualifier previousQualifier = this.getUBQualifier(dim, in);
            FlowExpressions.Receiver arrayRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node.getTarget());
            String arrayString = arrayRec.toString();
            UBQualifier.LessThanLengthOf newInfo = (UBQualifier.LessThanLengthOf)UBQualifier.createUBQualifier(arrayString, "-1");
            UBQualifier combined = previousQualifier.glb(newInfo);
            AnnotationMirror newAnno = this.atypeFactory.convertUBQualifierToAnnotation(combined);
            FlowExpressions.Receiver dimRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), dim);
            result.getRegularStore().insertValue(dimRec, newAnno);
            this.propagateToOperands(newInfo, dim, in, result.getRegularStore());
        }
        return result;
    }

    private void propagateToOperands(UBQualifier.LessThanLengthOf typeOfNode, Node node, TransferInput<CFValue, CFStore> in, CFStore store) {
        if (node instanceof NumericalAdditionNode) {
            Node right = ((NumericalAdditionNode)node).getRightOperand();
            Node left = ((NumericalAdditionNode)node).getLeftOperand();
            this.propagateToAdditionOperand(typeOfNode, left, right, in, store);
            this.propagateToAdditionOperand(typeOfNode, right, left, in, store);
        } else if (node instanceof NumericalSubtractionNode) {
            this.propagateToSubtractionOperands(typeOfNode, (NumericalSubtractionNode)node, in, store);
        } else if (node instanceof NumericalMultiplicationNode && (this.atypeFactory.hasLowerBoundTypeByClass(node, NonNegative.class) || this.atypeFactory.hasLowerBoundTypeByClass(node, Positive.class))) {
            Node right = ((NumericalMultiplicationNode)node).getRightOperand();
            Node left = ((NumericalMultiplicationNode)node).getLeftOperand();
            this.propagateToMultiplicationOperand(typeOfNode, left, right, in, store);
            this.propagateToMultiplicationOperand(typeOfNode, right, left, in, store);
        }
    }

    private void propagateToMultiplicationOperand(UBQualifier.LessThanLengthOf typeOfMultiplication, Node node, Node other, TransferInput<CFValue, CFStore> in, CFStore store) {
        if (this.atypeFactory.hasLowerBoundTypeByClass(other, Positive.class)) {
            Long minValue = IndexUtil.getMinValue(other.getTree(), this.atypeFactory.getValueAnnotatedTypeFactory());
            if (minValue != null && minValue > 1L) {
                typeOfMultiplication = (UBQualifier.LessThanLengthOf)typeOfMultiplication.plusOffset(1);
            }
            UBQualifier qual = this.getUBQualifier(node, in);
            UBQualifier newQual = qual.glb(typeOfMultiplication);
            FlowExpressions.Receiver rec = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, node);
            store.insertValue(rec, this.atypeFactory.convertUBQualifierToAnnotation(newQual));
        }
    }

    private void propagateToSubtractionOperands(UBQualifier.LessThanLengthOf typeOfSubtraction, NumericalSubtractionNode node, TransferInput<CFValue, CFStore> in, CFStore store) {
        UBQualifier left = this.getUBQualifier(node.getLeftOperand(), in);
        UBQualifier newInfo = typeOfSubtraction.minusOffset(node.getRightOperand(), this.atypeFactory);
        UBQualifier newLeft = left.glb(newInfo);
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, node.getLeftOperand());
        store.insertValue(leftRec, this.atypeFactory.convertUBQualifierToAnnotation(newLeft));
    }

    private void propagateToAdditionOperand(UBQualifier.LessThanLengthOf typeOfAddition, Node operand, Node other, TransferInput<CFValue, CFStore> in, CFStore store) {
        UBQualifier operandQual = this.getUBQualifier(operand, in);
        UBQualifier newQual = operandQual.glb(typeOfAddition.plusOffset(other, this.atypeFactory));
        if (this.atypeFactory.hasLowerBoundTypeByClass(other, Positive.class)) {
            newQual = newQual.glb(typeOfAddition.plusOffset(1));
        } else if (this.atypeFactory.hasLowerBoundTypeByClass(other, NonNegative.class)) {
            newQual = newQual.glb(typeOfAddition);
        }
        FlowExpressions.Receiver operandRec = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, operand);
        store.insertValue(operandRec, this.atypeFactory.convertUBQualifierToAnnotation(newQual));
    }

    @Override
    protected void refineGT(Node larger, AnnotationMirror largerAnno, Node smaller, AnnotationMirror smallerAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        UBQualifier largerQual = UBQualifier.createUBQualifier(largerAnno);
        UBQualifier largerQualPlus1 = largerQual.plusOffset(1);
        UBQualifier rightQualifier = UBQualifier.createUBQualifier(smallerAnno);
        UBQualifier refinedRight = rightQualifier.glb(largerQualPlus1);
        if (largerQualPlus1.isLessThanLengthQualifier()) {
            this.propagateToOperands((UBQualifier.LessThanLengthOf)largerQualPlus1, smaller, in, store);
        }
        FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), smaller);
        store.insertValue(rightRec, this.atypeFactory.convertUBQualifierToAnnotation(refinedRight));
    }

    @Override
    protected void refineGTE(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        UBQualifier leftQualifier = UBQualifier.createUBQualifier(leftAnno);
        UBQualifier rightQualifier = UBQualifier.createUBQualifier(rightAnno);
        UBQualifier refinedRight = rightQualifier.glb(leftQualifier);
        if (leftQualifier.isLessThanLengthQualifier()) {
            this.propagateToOperands((UBQualifier.LessThanLengthOf)leftQualifier, right, in, store);
        }
        FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), right);
        store.insertValue(rightRec, this.atypeFactory.convertUBQualifierToAnnotation(refinedRight));
    }

    @Override
    protected TransferResult<CFValue, CFStore> strengthenAnnotationOfEqualTo(TransferResult<CFValue, CFStore> res, Node firstNode, Node secondNode, CFValue firstValue, CFValue secondValue, boolean notEqualTo) {
        TransferResult<CFValue, CFStore> result = super.strengthenAnnotationOfEqualTo(res, firstNode, secondNode, firstValue, secondValue, notEqualTo);
        IndexRefinementInfo rfi = new IndexRefinementInfo(result, this.analysis, firstNode, secondNode);
        if (rfi.leftAnno == null || rfi.rightAnno == null) {
            return result;
        }
        CFStore equalsStore = notEqualTo ? rfi.elseStore : rfi.thenStore;
        CFStore notEqualStore = notEqualTo ? rfi.thenStore : rfi.elseStore;
        this.refineEq(rfi.left, rfi.leftAnno, rfi.right, rfi.rightAnno, equalsStore);
        this.refineNeqSequenceLength(rfi.left, rfi.right, rfi.rightAnno, notEqualStore);
        this.refineNeqSequenceLength(rfi.right, rfi.left, rfi.leftAnno, notEqualStore);
        return rfi.newResult;
    }

    private void refineEq(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store) {
        UBQualifier leftQualifier = UBQualifier.createUBQualifier(leftAnno);
        UBQualifier rightQualifier = UBQualifier.createUBQualifier(rightAnno);
        UBQualifier glb = rightQualifier.glb(leftQualifier);
        AnnotationMirror glbAnno = this.atypeFactory.convertUBQualifierToAnnotation(glb);
        List<Node> internalsRight = this.splitAssignments(right);
        for (Node internal : internalsRight) {
            FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), internal);
            store.insertValue(rightRec, glbAnno);
        }
        List<Node> internalsLeft = this.splitAssignments(left);
        for (Node internal : internalsLeft) {
            FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), internal);
            store.insertValue(leftRec, glbAnno);
        }
    }

    private void refineNeqSequenceLength(Node lengthAccess, Node otherNode, AnnotationMirror otherNodeAnno, CFStore store) {
        String sequence;
        UBQualifier otherQualifier;
        FlowExpressions.Receiver ma;
        FlowExpressions.Receiver receiver = null;
        int lengthOffset = 0;
        if (lengthAccess instanceof NumericalSubtractionNode) {
            NumericalSubtractionNode subtraction = (NumericalSubtractionNode)lengthAccess;
            Node offsetNode = subtraction.getRightOperand();
            Long offsetValue = IndexUtil.getExactValue(offsetNode.getTree(), this.atypeFactory.getValueAnnotatedTypeFactory());
            if (offsetValue != null && offsetValue > Integer.MIN_VALUE && offsetValue <= Integer.MAX_VALUE) {
                lengthOffset = offsetValue.intValue();
                lengthAccess = subtraction.getLeftOperand();
            } else {
                return;
            }
        }
        if (NodeUtils.isArrayLengthFieldAccess(lengthAccess)) {
            FlowExpressions.FieldAccess fa = FlowExpressions.internalReprOfFieldAccess(this.atypeFactory, (FieldAccessNode)lengthAccess);
            receiver = fa.getReceiver();
        } else if (this.atypeFactory.getMethodIdentifier().isStringLengthInvocation(lengthAccess) && (ma = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, lengthAccess)) instanceof FlowExpressions.MethodCall) {
            receiver = ((FlowExpressions.MethodCall)ma).getReceiver();
        }
        if (receiver != null && !receiver.containsUnknown() && (otherQualifier = UBQualifier.createUBQualifier(otherNodeAnno)).hasSequenceWithOffset(sequence = receiver.toString(), lengthOffset - 1)) {
            UBQualifier newQualifier = UBQualifier.createUBQualifier(sequence, Integer.toString(lengthOffset));
            otherQualifier = otherQualifier.glb(newQualifier);
            for (Node internal : this.splitAssignments(otherNode)) {
                FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), internal);
                store.insertValue(leftRec, this.atypeFactory.convertUBQualifierToAnnotation(otherQualifier));
            }
        }
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalAddition(NumericalAdditionNode n, TransferInput<CFValue, CFStore> in) {
        UBQualifier left = this.getUBQualifierForAddition(n.getLeftOperand(), in);
        UBQualifier T = left.minusOffset(n.getRightOperand(), this.atypeFactory);
        UBQualifier right = this.getUBQualifierForAddition(n.getRightOperand(), in);
        UBQualifier S = right.minusOffset(n.getLeftOperand(), this.atypeFactory);
        UBQualifier glb = T.glb(S);
        if (left.isLessThanLengthQualifier() && right.isLessThanLengthQualifier()) {
            UBQualifier r = this.removeSequenceLengths((UBQualifier.LessThanLengthOf)left, (UBQualifier.LessThanLengthOf)right);
            glb = glb.glb(r);
            UBQualifier l = this.removeSequenceLengths((UBQualifier.LessThanLengthOf)right, (UBQualifier.LessThanLengthOf)left);
            glb = glb.glb(l);
        }
        return this.createTransferResult(n, in, glb);
    }

    private UBQualifier removeSequenceLengths(UBQualifier.LessThanLengthOf i, UBQualifier.LessThanLengthOf j) {
        ArrayList<String> lessThan = new ArrayList<String>();
        ArrayList<String> lessThanOrEqaul = new ArrayList<String>();
        for (String string : i.getSequences()) {
            if (i.isLessThanLengthOf(string)) {
                lessThan.add(string);
                continue;
            }
            if (!i.hasSequenceWithOffset(string, -1)) continue;
            lessThanOrEqaul.add(string);
        }
        UBQualifier lessThanEqQ = j.removeSequenceLengthAccess(lessThanOrEqaul);
        UBQualifier uBQualifier = j.removeSequenceLengthAccessAndNeg1(lessThan);
        return lessThanEqQ.glb(uBQualifier);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalSubtraction(NumericalSubtractionNode n, TransferInput<CFValue, CFStore> in) {
        UBQualifier left = this.getUBQualifier(n.getLeftOperand(), in);
        UBQualifier leftWithOffset = left.plusOffset(n.getRightOperand(), this.atypeFactory);
        if ((this.atypeFactory.hasLowerBoundTypeByClass(n.getRightOperand(), NonNegative.class) || this.atypeFactory.hasLowerBoundTypeByClass(n.getRightOperand(), Positive.class)) && left.isLessThanLengthQualifier()) {
            leftWithOffset = left.glb(leftWithOffset);
        }
        return this.createTransferResult(n, in, leftWithOffset);
    }

    private TransferResult<CFValue, CFStore> visitLengthAccess(Node n, TransferInput<CFValue, CFStore> in, FlowExpressions.Receiver sequenceRec, Tree sequenceTree) {
        List<Object> sameLenSequences;
        AnnotationMirror sameLenAnno = this.atypeFactory.sameLenAnnotationFromTree(sequenceTree);
        List<Object> list = sameLenSequences = sameLenAnno == null ? new ArrayList() : IndexUtil.getValueOfAnnotationWithStringArgument(sameLenAnno);
        if (!sameLenSequences.contains(sequenceRec.toString())) {
            sameLenSequences.add(sequenceRec.toString());
        }
        ArrayList<String> offsets = new ArrayList<String>(sameLenSequences.size());
        for (String string : sameLenSequences) {
            offsets.add("-1");
        }
        if (CFAbstractStore.canInsertReceiver(sequenceRec)) {
            UBQualifier qualifier = UBQualifier.createUBQualifier(sameLenSequences, offsets);
            UBQualifier uBQualifier = this.getUBQualifier(n, in);
            return this.createTransferResult(n, in, qualifier.glb(uBQualifier));
        }
        return null;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitFieldAccess(FieldAccessNode n, TransferInput<CFValue, CFStore> in) {
        Tree arrayTree;
        FlowExpressions.FieldAccess arrayLength;
        FlowExpressions.Receiver arrayRec;
        TransferResult<CFValue, CFStore> result;
        if (NodeUtils.isArrayLengthFieldAccess(n) && (result = this.visitLengthAccess(n, in, arrayRec = (arrayLength = FlowExpressions.internalReprOfFieldAccess(this.atypeFactory, n)).getReceiver(), arrayTree = n.getReceiver().getTree())) != null) {
            return result;
        }
        return super.visitFieldAccess(n, in);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<CFValue, CFStore> in) {
        Tree stringTree;
        FlowExpressions.Receiver stringRec;
        TransferResult<CFValue, CFStore> result;
        FlowExpressions.Receiver stringLength;
        if (this.atypeFactory.getMethodIdentifier().isStringLengthInvocation(n) && (stringLength = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, n)) instanceof FlowExpressions.MethodCall && (result = this.visitLengthAccess(n, in, stringRec = ((FlowExpressions.MethodCall)stringLength).getReceiver(), stringTree = n.getTarget().getReceiver().getTree())) != null) {
            return result;
        }
        return super.visitMethodInvocation(n, in);
    }

    private UBQualifier getUBQualifierForAddition(Node n, TransferInput<CFValue, CFStore> in) {
        UBQualifier ubQualifier = this.getUBQualifier(n, in);
        Tree nodeTree = n.getTree();
        AnnotatedTypeMirror substringIndexType = this.atypeFactory.getSubstringIndexAnnotatedTypeFactory().getAnnotatedType(nodeTree);
        AnnotationMirror substringIndexAnno = substringIndexType.getAnnotation(SubstringIndexFor.class);
        AnnotatedTypeMirror lowerBoundType = this.atypeFactory.getLowerBoundAnnotatedTypeFactory().getAnnotatedType(nodeTree);
        if (substringIndexAnno != null && (lowerBoundType.hasAnnotation(NonNegative.class) || lowerBoundType.hasAnnotation(Positive.class))) {
            UBQualifier substringIndexQualifier = UBQualifier.createUBQualifier(substringIndexAnno);
            ubQualifier = ubQualifier.glb(substringIndexQualifier);
        }
        return ubQualifier;
    }

    private UBQualifier getUBQualifier(Node n, TransferInput<CFValue, CFStore> in) {
        UBQualifier qualifier;
        QualifierHierarchy hierarchy = this.analysis.getTypeFactory().getQualifierHierarchy();
        FlowExpressions.Receiver rec = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, n);
        CFValue value = null;
        if (CFAbstractStore.canInsertReceiver(rec)) {
            value = (CFValue)in.getRegularStore().getValue(rec);
        }
        if (value == null) {
            value = (CFValue)this.analysis.getValue(n);
        }
        if ((qualifier = this.getUBQualifier(hierarchy, value)).isUnknown()) {
            CFValue valueFromFactory = (CFValue)this.getValueFromFactory(n.getTree(), n);
            return this.getUBQualifier(hierarchy, valueFromFactory);
        }
        return qualifier;
    }

    private UBQualifier getUBQualifier(QualifierHierarchy hierarchy, CFValue value) {
        if (value == null) {
            return UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
        }
        Set<AnnotationMirror> set = value.getAnnotations();
        AnnotationMirror anno = hierarchy.findAnnotationInHierarchy(set, this.atypeFactory.UNKNOWN);
        if (anno == null) {
            return UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
        }
        return UBQualifier.createUBQualifier(anno);
    }

    private TransferResult<CFValue, CFStore> createTransferResult(Node n, TransferInput<CFValue, CFStore> in, UBQualifier qualifier) {
        AnnotationMirror newAnno = this.atypeFactory.convertUBQualifierToAnnotation(qualifier);
        CFValue value = (CFValue)this.analysis.createSingleAnnotationValue(newAnno, n.getType());
        if (in.containsTwoStores()) {
            CFStore thenStore = in.getThenStore();
            CFStore elseStore = in.getElseStore();
            return new ConditionalTransferResult<CFValue, CFStore>(this.finishValue(value, thenStore, elseStore), thenStore, elseStore);
        }
        CFStore info = in.getRegularStore();
        return new RegularTransferResult<CFValue, CFStore>(this.finishValue(value, info), info);
    }
}

