/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.javacutil.AnnotationUtils;

public class KeyForValue
extends CFAbstractValue<KeyForValue> {
    private Set<String> keyForMaps = null;

    public KeyForValue(CFAbstractAnalysis<KeyForValue, ?, ?> analysis, Set<AnnotationMirror> annotations, TypeMirror underlyingType) {
        super(analysis, annotations, underlyingType);
        AnnotationMirror keyfor = AnnotationUtils.getAnnotationByClass(annotations, KeyFor.class);
        if (keyfor != null && (underlyingType.getKind() == TypeKind.TYPEVAR || underlyingType.getKind() == TypeKind.WILDCARD)) {
            this.keyForMaps = new LinkedHashSet<String>();
            List<String> list = AnnotationUtils.getElementValueArray(keyfor, "value", String.class, true);
            this.keyForMaps.addAll(list);
        }
    }

    public Set<String> getKeyForMaps() {
        return this.keyForMaps;
    }

    @Override
    public KeyForValue leastUpperBound(KeyForValue other) {
        KeyForValue lub = super.leastUpperBound(other);
        if (other == null || other.keyForMaps == null || this.keyForMaps == null) {
            return lub;
        }
        lub.keyForMaps = new LinkedHashSet<String>();
        lub.keyForMaps.addAll(this.keyForMaps);
        lub.keyForMaps.retainAll(other.keyForMaps);
        if (lub.keyForMaps.isEmpty()) {
            lub.keyForMaps = null;
        }
        return lub;
    }

    @Override
    public KeyForValue mostSpecific(KeyForValue other, KeyForValue backup) {
        KeyForValue mostSpecific = super.mostSpecific(other, backup);
        if (mostSpecific == null) {
            if (other == null) {
                return this;
            }
            if (other.getAnnotations().isEmpty()) {
                other.addKeyFor(this.keyForMaps);
                return other;
            }
            if (this.getAnnotations().isEmpty()) {
                this.addKeyFor(other.keyForMaps);
                return this;
            }
            return null;
        }
        mostSpecific.addKeyFor(this.keyForMaps);
        if (other != null) {
            mostSpecific.addKeyFor(other.keyForMaps);
        }
        return mostSpecific;
    }

    private void addKeyFor(Set<String> newKeyForMaps) {
        if (newKeyForMaps == null || newKeyForMaps.isEmpty()) {
            return;
        }
        if (this.keyForMaps == null) {
            this.keyForMaps = new LinkedHashSet<String>();
        }
        this.keyForMaps.addAll(newKeyForMaps);
    }
}

