/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.stub;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseProblemException;
import com.github.javaparser.Problem;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.StubUnit;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.type.WildcardType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.FromStubFile;
import org.checkerframework.framework.stub.StubUtil;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.AnnotatedTypeMerger;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.Pair;

public class StubParser {
    private final boolean warnIfNotFound;
    private final boolean warnIfStubOverwritesBytecode;
    private final boolean debugStubParser;
    private final String filename;
    private final StubUnit stubUnit;
    private final ProcessingEnvironment processingEnv;
    private final AnnotatedTypeFactory atypeFactory;
    private final Elements elements;
    private final Map<String, AnnotationMirror> supportedAnnotations;
    private final List<String> importedConstants;
    private final Map<String, TypeElement> importedTypes;
    private final Map<FieldAccessExpr, VariableElement> faexprcache;
    private final Map<NameExpr, VariableElement> nexprcache;
    private final AnnotationMirror fromStubFile;
    private final List<AnnotatedTypeMirror.AnnotatedTypeVariable> typeParameters = new ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable>();
    private CompilationUnit theCompilationUnit;
    private String currentClass;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator").intern();
    private static final Set<String> warnings = new HashSet<String>();

    public StubParser(String filename, InputStream inputStream, AnnotatedTypeFactory factory, ProcessingEnvironment env) {
        StubUnit parsedStubUnit;
        this.filename = filename;
        this.atypeFactory = factory;
        this.processingEnv = env;
        this.elements = env.getElementUtils();
        this.importedConstants = new ArrayList<String>();
        this.importedTypes = new HashMap<String, TypeElement>();
        Map<String, String> options = env.getOptions();
        this.warnIfNotFound = options.containsKey("stubWarnIfNotFound");
        this.warnIfStubOverwritesBytecode = options.containsKey("stubWarnIfOverwritesBytecode");
        this.debugStubParser = options.containsKey("stubDebug");
        if (this.debugStubParser) {
            this.stubDebug(String.format("parsing stub file %s", filename));
        }
        try {
            parsedStubUnit = JavaParser.parseStubUnit(inputStream);
        }
        catch (ParseProblemException e) {
            StringBuilder message = new StringBuilder("exception from StubParser.parse for file " + filename + "; current class: " + this.currentClass + ". Encountered problems: ");
            for (Problem p : e.getProblems()) {
                message.append(p.getVerboseMessage());
                message.append('\n');
            }
            this.stubAlwaysWarn(message.toString(), new Object[0]);
            parsedStubUnit = null;
        }
        catch (Exception e) {
            this.stubAlwaysWarn("unexpected exception " + e.getClass() + " from StubParser.parse for file " + filename + "; current class: " + this.currentClass + ". Encountered problems: " + e.getMessage(), new Object[0]);
            parsedStubUnit = null;
        }
        this.stubUnit = parsedStubUnit;
        this.supportedAnnotations = this.getSupportedAnnotations();
        if (parsedStubUnit != null && this.supportedAnnotations.isEmpty()) {
            this.stubWarnIfNotFound(String.format("No supported annotations found! This likely means stub file %s doesn't import them correctly.", filename));
        }
        this.faexprcache = new HashMap<FieldAccessExpr, VariableElement>();
        this.nexprcache = new HashMap<NameExpr, VariableElement>();
        this.fromStubFile = AnnotationBuilder.fromClass(this.elements, FromStubFile.class);
    }

    private Map<String, AnnotationMirror> annosInPackage(PackageElement packageElement) {
        return this.createImportedAnnotationsMap(ElementFilter.typesIn(packageElement.getEnclosedElements()));
    }

    private Map<String, AnnotationMirror> annosInType(TypeElement typeElement) {
        return this.createImportedAnnotationsMap(ElementFilter.typesIn(typeElement.getEnclosedElements()));
    }

    private Map<String, AnnotationMirror> createImportedAnnotationsMap(List<TypeElement> typeElements) {
        HashMap<String, AnnotationMirror> r = new HashMap<String, AnnotationMirror>();
        for (TypeElement typeElm : typeElements) {
            if (typeElm.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            AnnotationMirror anno = AnnotationBuilder.fromName(this.elements, typeElm.getQualifiedName());
            StubParser.putNew(r, typeElm.getSimpleName().toString(), anno);
        }
        return r;
    }

    private static List<String> getImportableMembers(TypeElement typeElement) {
        ArrayList<String> result = new ArrayList<String>();
        List<VariableElement> memberElements = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        for (VariableElement varElement : memberElements) {
            if (varElement.getConstantValue() == null && varElement.getKind() != ElementKind.ENUM_CONSTANT) continue;
            result.add(String.format("%s.%s", typeElement.getQualifiedName().toString(), varElement.getSimpleName().toString()));
        }
        return result;
    }

    private Map<String, AnnotationMirror> getSupportedAnnotations() {
        if (this.stubUnit == null) {
            return null;
        }
        assert (!this.stubUnit.getCompilationUnits().isEmpty());
        CompilationUnit cu = this.stubUnit.getCompilationUnits().get(0);
        HashMap<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
        if (cu.getImports() == null) {
            return result;
        }
        for (ImportDeclaration importDecl : cu.getImports()) {
            String imported = importDecl.getNameAsString();
            try {
                if (importDecl.isAsterisk()) {
                    QualifiedNameable element;
                    if (importDecl.isStatic()) {
                        element = this.findType(imported, "Imported type not found");
                        if (element == null) continue;
                        StubParser.putAllNew(result, this.annosInType((TypeElement)element));
                        this.importedConstants.addAll(StubParser.getImportableMembers((TypeElement)element));
                        this.addEnclosingTypesToImportedTypes(element);
                        continue;
                    }
                    element = this.findPackage(imported);
                    if (element == null) continue;
                    StubParser.putAllNew(result, this.annosInPackage((PackageElement)element));
                    this.addEnclosingTypesToImportedTypes(element);
                    continue;
                }
                TypeElement importType = this.elements.getTypeElement(imported);
                if (importType == null && !importDecl.isStatic()) {
                    this.stubWarnIfNotFound("Imported type not found: " + imported);
                    continue;
                }
                if (importType == null) {
                    Pair<String, String> typeParts = StubUtil.partitionQualifiedName(imported);
                    String type = (String)typeParts.first;
                    String fieldName = (String)typeParts.second;
                    TypeElement enclType = this.findType(type, String.format("Enclosing type of static field %s not found", fieldName));
                    if (enclType == null || this.findFieldElement(enclType, fieldName) == null) continue;
                    this.importedConstants.add(imported);
                    continue;
                }
                if (importType.getKind() == ElementKind.ANNOTATION_TYPE) {
                    AnnotationMirror anno = AnnotationBuilder.fromName(this.elements, imported);
                    if (anno != null) {
                        Element annoElt = anno.getAnnotationType().asElement();
                        StubParser.putNew(result, annoElt.getSimpleName().toString(), anno);
                        this.importedTypes.put(annoElt.getSimpleName().toString(), (TypeElement)annoElt);
                        continue;
                    }
                    this.stubWarnIfNotFound("Could not load import: " + imported);
                    continue;
                }
                this.importedConstants.add(imported);
                TypeElement element = this.findType(imported, "Imported type not found");
                this.importedTypes.put(element.getSimpleName().toString(), element);
            }
            catch (AssertionError error) {
                this.stubWarnIfNotFound("" + error);
            }
        }
        return result;
    }

    private void addEnclosingTypesToImportedTypes(Element element) {
        for (Element element2 : element.getEnclosedElements()) {
            if (!element2.getKind().isClass()) continue;
            this.importedTypes.put(element2.getSimpleName().toString(), (TypeElement)element2);
        }
    }

    public void parse(Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        if (this.stubUnit == null) {
            return;
        }
        this.parse(this.stubUnit, atypes, declAnnos);
    }

    private void parse(StubUnit index, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        for (CompilationUnit cu : index.getCompilationUnits()) {
            this.parse(cu, atypes, declAnnos);
        }
    }

    private void parse(CompilationUnit cu, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        NodeList<AnnotationExpr> packageAnnos;
        String packageName;
        this.theCompilationUnit = cu;
        if (!cu.getPackageDeclaration().isPresent()) {
            packageName = null;
            packageAnnos = null;
        } else {
            packageName = cu.getPackageDeclaration().get().getNameAsString();
            packageAnnos = cu.getPackageDeclaration().get().getAnnotations();
            this.parsePackage(cu.getPackageDeclaration().get(), atypes, declAnnos);
        }
        if (cu.getTypes() != null) {
            for (TypeDeclaration<?> typeDeclaration : cu.getTypes()) {
                this.parse(typeDeclaration, packageName, packageAnnos, atypes, declAnnos);
            }
        }
    }

    private void parsePackage(PackageDeclaration packDecl, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        assert (packDecl != null);
        String packageName = packDecl.getNameAsString();
        PackageElement elem = this.elements.getPackageElement(packageName);
        if (elem != null) {
            this.annotateDecl(declAnnos, elem, packDecl.getAnnotations());
        }
    }

    private void parse(TypeDeclaration<?> typeDecl, String packageName, List<AnnotationExpr> packageAnnos, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        String typeName;
        this.currentClass = typeName = (packageName == null ? "" : packageName + ".") + typeDecl.getNameAsString();
        TypeElement typeElt = this.elements.getTypeElement(typeName);
        if (typeElt == null) {
            boolean warn = true;
            if (typeDecl.getAnnotations() != null) {
                for (AnnotationExpr anno : typeDecl.getAnnotations()) {
                    if (!anno.getNameAsString().contentEquals("NoStubParserWarning")) continue;
                    warn = false;
                }
            }
            if (packageAnnos != null) {
                for (AnnotationExpr anno : packageAnnos) {
                    if (!anno.getNameAsString().contentEquals("NoStubParserWarning")) continue;
                    warn = false;
                }
            }
            boolean bl = warn = warn || this.debugStubParser;
            if (warn) {
                this.stubWarnIfNotFound("Type not found: " + typeName);
            }
            return;
        }
        if (typeElt.getKind() == ElementKind.ENUM) {
            this.typeParameters.addAll(this.parseEnum((EnumDeclaration)typeDecl, typeElt, atypes, declAnnos));
        } else if (typeElt.getKind() == ElementKind.ANNOTATION_TYPE) {
            this.stubWarnIfNotFound("Skipping annotation type: " + typeName);
        } else if (typeDecl instanceof ClassOrInterfaceDeclaration) {
            this.typeParameters.addAll(this.parseType((ClassOrInterfaceDeclaration)typeDecl, typeElt, atypes, declAnnos));
        }
        Map<Element, BodyDeclaration<?>> elementsToDecl = this.getMembers(typeElt, typeDecl);
        block9: for (Map.Entry<Element, BodyDeclaration<?>> entry : elementsToDecl.entrySet()) {
            Element elt = entry.getKey();
            BodyDeclaration<?> decl = entry.getValue();
            switch (elt.getKind()) {
                case FIELD: 
                case ENUM_CONSTANT: {
                    this.parseField((FieldDeclaration)decl, (VariableElement)elt, atypes, declAnnos);
                    continue block9;
                }
                case CONSTRUCTOR: {
                    this.parseConstructor((ConstructorDeclaration)decl, (ExecutableElement)elt, atypes, declAnnos);
                    continue block9;
                }
                case METHOD: {
                    this.parseMethod((MethodDeclaration)decl, (ExecutableElement)elt, atypes, declAnnos);
                    continue block9;
                }
                case CLASS: 
                case INTERFACE: {
                    this.parse((ClassOrInterfaceDeclaration)decl, typeName, packageAnnos, atypes, declAnnos);
                    continue block9;
                }
                case ENUM: {
                    this.parse((EnumDeclaration)decl, typeName, packageAnnos, atypes, declAnnos);
                    continue block9;
                }
            }
            this.stubWarnIfNotFound("StubParser ignoring: " + elt);
        }
        this.typeParameters.clear();
    }

    private List<AnnotatedTypeMirror.AnnotatedTypeVariable> parseType(ClassOrInterfaceDeclaration decl, TypeElement elt, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        this.annotateDecl(declAnnos, elt, decl.getAnnotations());
        AnnotatedTypeMirror.AnnotatedDeclaredType type = this.atypeFactory.fromElement(elt);
        this.annotate((AnnotatedTypeMirror)type, decl.getAnnotations());
        List<AnnotatedTypeMirror> typeArguments = type.getTypeArguments();
        NodeList<TypeParameter> typeParameters = decl.getTypeParameters();
        if (this.debugStubParser) {
            int numArgs;
            int numParams = typeParameters == null ? 0 : typeParameters.size();
            int n = numArgs = typeArguments == null ? 0 : typeArguments.size();
            if (numParams != numArgs) {
                this.stubDebug(String.format("parseType:  mismatched sizes for typeParameters=%s (size %d) and typeArguments=%s (size %d); decl=%s; elt=%s (%s); type=%s (%s); theCompilationUnit=%s", typeParameters, numParams, typeArguments, numArgs, decl.toString().replace(LINE_SEPARATOR, " "), elt.toString().replace(LINE_SEPARATOR, " "), elt.getClass(), type, type.getClass(), this.theCompilationUnit));
            }
        }
        this.annotateTypeParameters(decl, elt, atypes, typeArguments, typeParameters);
        this.annotateSupertypes(decl, type);
        StubParser.putNew(atypes, elt, type);
        ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable> typeVariables = new ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable>();
        for (AnnotatedTypeMirror typeV : type.getTypeArguments()) {
            if (typeV.getKind() != TypeKind.TYPEVAR) {
                this.stubAlwaysWarn("expected an AnnotatedTypeVariable but found type kind " + (Object)((Object)typeV.getKind()) + ": " + typeV, new Object[0]);
                continue;
            }
            typeVariables.add((AnnotatedTypeMirror.AnnotatedTypeVariable)typeV);
        }
        return typeVariables;
    }

    private List<AnnotatedTypeMirror.AnnotatedTypeVariable> parseEnum(EnumDeclaration decl, TypeElement elt, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        this.annotateDecl(declAnnos, elt, decl.getAnnotations());
        AnnotatedTypeMirror.AnnotatedDeclaredType type = this.atypeFactory.fromElement(elt);
        this.annotate((AnnotatedTypeMirror)type, decl.getAnnotations());
        StubParser.putNew(atypes, elt, type);
        ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable> typeVariables = new ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable>();
        for (AnnotatedTypeMirror typeV : type.getTypeArguments()) {
            if (typeV.getKind() != TypeKind.TYPEVAR) {
                this.stubAlwaysWarn("expected an AnnotatedTypeVariable but found type kind " + (Object)((Object)typeV.getKind()) + ": " + typeV, new Object[0]);
                continue;
            }
            typeVariables.add((AnnotatedTypeMirror.AnnotatedTypeVariable)typeV);
        }
        return typeVariables;
    }

    private void annotateSupertypes(ClassOrInterfaceDeclaration typeDecl, AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        AnnotatedTypeMirror.AnnotatedDeclaredType foundType;
        if (typeDecl.getExtendedTypes() != null) {
            for (ClassOrInterfaceType superType : typeDecl.getExtendedTypes()) {
                foundType = this.findType(superType, type.directSuperTypes());
                assert (foundType != null) : "StubParser: could not find superclass " + superType + " from type " + type + "\nStub file does not match bytecode";
                if (foundType == null) continue;
                this.annotate((AnnotatedTypeMirror)foundType, superType);
            }
        }
        if (typeDecl.getImplementedTypes() != null) {
            for (ClassOrInterfaceType superType : typeDecl.getImplementedTypes()) {
                foundType = this.findType(superType, type.directSuperTypes());
                assert (foundType != null || superType.toString().equals("AutoCloseable") || superType.toString().equals("java.io.Closeable") || superType.toString().equals("Closeable")) : "StubParser: could not find superinterface " + superType + " from type " + type + "\nStub file does not match bytecode";
                if (foundType == null) continue;
                this.annotate((AnnotatedTypeMirror)foundType, superType);
            }
        }
    }

    private void parseMethod(MethodDeclaration decl, ExecutableElement elt, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        NodeList<AnnotationExpr> list = decl.getType().getAnnotations();
        decl.getType().setAnnotations(decl.getAnnotations());
        decl.setAnnotations((NodeList)list);
        this.annotateDecl(declAnnos, elt, decl.getAnnotations());
        this.annotateDecl(declAnnos, elt, decl.getType().getAnnotations());
        this.addDeclAnnotations(declAnnos, elt);
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.atypeFactory.fromElement(elt);
        this.annotateTypeParameters(decl, elt, atypes, methodType.getTypeVariables(), decl.getTypeParameters());
        this.typeParameters.addAll(methodType.getTypeVariables());
        this.annotate(methodType.getReturnType(), decl.getType());
        NodeList<Parameter> params = decl.getParameters();
        List<? extends VariableElement> paramElts = elt.getParameters();
        List<AnnotatedTypeMirror> paramTypes = methodType.getParameterTypes();
        for (int i = 0; i < methodType.getParameterTypes().size(); ++i) {
            VariableElement paramElt = paramElts.get(i);
            AnnotatedTypeMirror paramType = paramTypes.get(i);
            Parameter param = (Parameter)params.get(i);
            this.annotateDecl(declAnnos, paramElt, param.getAnnotations());
            this.annotateDecl(declAnnos, paramElt, param.getType().getAnnotations());
            param.getType().setAnnotations(param.getAnnotations());
            if (param.isVarArgs()) {
                assert (paramType.getKind() == TypeKind.ARRAY);
                this.annotate(((AnnotatedTypeMirror.AnnotatedArrayType)paramType).getComponentType(), param.getType());
                this.annotate(paramType, param.getVarArgsAnnotations());
                continue;
            }
            this.annotate(paramType, param.getType());
        }
        if (methodType.getReceiverType() == null && decl.getReceiverAnnotations() != null && !decl.getReceiverAnnotations().isEmpty()) {
            this.stubAlwaysWarn(String.format("parseMethod: static methods cannot have receiver annotations%nMethod: %s%nReceiver annotations: %s", methodType, decl.getReceiverAnnotations()), new Object[0]);
        } else {
            this.annotate((AnnotatedTypeMirror)methodType.getReceiverType(), decl.getReceiverAnnotations());
        }
        StubParser.putNew(atypes, elt, methodType);
        this.typeParameters.removeAll(methodType.getTypeVariables());
    }

    private void handleExistingAnnotations(AnnotatedTypeMirror atype, Type typeDef) {
        Set<AnnotationMirror> annos = atype.getAnnotations();
        if (annos != null && !annos.isEmpty() && !"flow.astub".equals(this.filename)) {
            atype.clearAnnotations();
        }
    }

    private void addDeclAnnotations(Map<String, Set<AnnotationMirror>> declAnnos, Element elt) {
        if (this.fromStubFile != null) {
            Set<AnnotationMirror> annos = declAnnos.get(ElementUtils.getVerboseName(elt));
            if (annos == null) {
                annos = AnnotationUtils.createAnnotationSet();
                StubParser.putOrAddToMap(declAnnos, ElementUtils.getVerboseName(elt), annos);
            }
            annos.add(this.fromStubFile);
        }
    }

    private List<AnnotatedTypeMirror> arrayAllComponents(AnnotatedTypeMirror.AnnotatedArrayType atype) {
        LinkedList<AnnotatedTypeMirror> arrays = new LinkedList<AnnotatedTypeMirror>();
        AnnotatedTypeMirror type = atype;
        while (type.getKind() == TypeKind.ARRAY) {
            arrays.addFirst(type);
            type = type.getComponentType();
        }
        arrays.add(type);
        return arrays;
    }

    private void annotateAsArray(AnnotatedTypeMirror.AnnotatedArrayType atype, ReferenceType typeDef) {
        List<AnnotatedTypeMirror> arrayTypes = this.arrayAllComponents(atype);
        assert (typeDef.getArrayLevel() == arrayTypes.size() - 1 || typeDef.getArrayLevel() == 0) : "Mismatched array lengths; typeDef: " + typeDef.getArrayLevel() + " vs. arrayTypes: " + (arrayTypes.size() - 1) + "\n  typedef: " + typeDef + "\n  arraytypes: " + arrayTypes;
        for (int i = 0; i < typeDef.getArrayCount(); ++i) {
            List<AnnotationExpr> annotations = typeDef.getAnnotationsAtLevel(i);
            this.handleExistingAnnotations(arrayTypes.get(i), typeDef);
            if (annotations == null) continue;
            this.annotate(arrayTypes.get(i), annotations);
        }
        this.handleExistingAnnotations(arrayTypes.get(arrayTypes.size() - 1), typeDef);
        this.annotate(arrayTypes.get(arrayTypes.size() - 1), typeDef.getAnnotations());
    }

    private ClassOrInterfaceType unwrapDeclaredType(Type type) {
        if (type instanceof ClassOrInterfaceType) {
            return (ClassOrInterfaceType)type;
        }
        if (type instanceof ReferenceType && type.getArrayLevel() == 0) {
            return this.unwrapDeclaredType(type.getElementType());
        }
        return null;
    }

    private void annotate(AnnotatedTypeMirror atype, Type typeDef) {
        if (atype.getKind() == TypeKind.ARRAY) {
            this.annotateAsArray((AnnotatedTypeMirror.AnnotatedArrayType)atype, (ReferenceType)typeDef);
            return;
        }
        this.handleExistingAnnotations(atype, typeDef);
        ClassOrInterfaceType declType = this.unwrapDeclaredType(typeDef);
        if (atype.getKind() == TypeKind.DECLARED && declType != null) {
            AnnotatedTypeMirror.AnnotatedDeclaredType adeclType = (AnnotatedTypeMirror.AnnotatedDeclaredType)atype;
            if (declType.getTypeArguments().isPresent() && !declType.getTypeArguments().get().isEmpty() && !adeclType.getTypeArguments().isEmpty()) {
                assert (declType.getTypeArguments().get().size() == adeclType.getTypeArguments().size()) : String.format("Mismatch in type argument size between %s (%d) and %s (%d)", declType, declType.getTypeArguments().get().size(), adeclType, adeclType.getTypeArguments().size());
                for (int i = 0; i < declType.getTypeArguments().get().size(); ++i) {
                    this.annotate(adeclType.getTypeArguments().get(i), (Type)declType.getTypeArguments().get().get(i));
                }
            }
        } else if (atype.getKind() == TypeKind.WILDCARD) {
            AnnotatedTypeMirror.AnnotatedWildcardType wildcardType = (AnnotatedTypeMirror.AnnotatedWildcardType)atype;
            WildcardType wildcardDef = (WildcardType)typeDef;
            if (wildcardDef.getExtendedType().isPresent()) {
                this.annotate(wildcardType.getExtendsBound(), wildcardDef.getExtendedType().get());
                this.annotate(wildcardType.getSuperBound(), typeDef.getAnnotations());
            } else if (wildcardDef.getSuperType().isPresent()) {
                this.annotate(wildcardType.getSuperBound(), wildcardDef.getSuperType().get());
                this.annotate(wildcardType.getExtendsBound(), typeDef.getAnnotations());
            } else {
                this.annotate(atype, typeDef.getAnnotations());
            }
        } else if (atype.getKind() == TypeKind.TYPEVAR) {
            AnnotatedTypeMirror.AnnotatedTypeVariable typeVarUse = (AnnotatedTypeMirror.AnnotatedTypeVariable)atype;
            for (AnnotatedTypeMirror.AnnotatedTypeVariable typePar : this.typeParameters) {
                if (typePar.getUnderlyingType() != atype.getUnderlyingType()) continue;
                AnnotatedTypeMerger.merge(typePar.getUpperBound(), typeVarUse.getUpperBound());
                AnnotatedTypeMerger.merge(typePar.getLowerBound(), typeVarUse.getLowerBound());
            }
        }
        if (typeDef.getAnnotations() != null && atype.getKind() != TypeKind.WILDCARD) {
            this.annotate(atype, typeDef.getAnnotations());
        }
    }

    private void parseConstructor(ConstructorDeclaration decl, ExecutableElement elt, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        this.annotateDecl(declAnnos, elt, decl.getAnnotations());
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.atypeFactory.fromElement(elt);
        this.addDeclAnnotations(declAnnos, elt);
        this.annotate(methodType.getReturnType(), decl.getAnnotations());
        for (int i = 0; i < methodType.getParameterTypes().size(); ++i) {
            AnnotatedTypeMirror paramType = methodType.getParameterTypes().get(i);
            Parameter param = (Parameter)decl.getParameters().get(i);
            if (param.getAnnotations() != null) {
                param.getType().setAnnotations(param.getAnnotations());
            }
            this.annotate(paramType, param.getType());
        }
        if (methodType.getReceiverType() == null && decl.getReceiverAnnotations() != null && !decl.getReceiverAnnotations().isEmpty()) {
            this.stubAlwaysWarn(String.format("parseConstructor: constructor of a top-level class cannot have receiver annotations%nConstructor: %s%nReceiver annotations: %s", methodType, decl.getReceiverAnnotations()), new Object[0]);
        } else {
            this.annotate((AnnotatedTypeMirror)methodType.getReceiverType(), decl.getReceiverAnnotations());
        }
        StubParser.putNew(atypes, elt, methodType);
    }

    private void parseField(FieldDeclaration decl, VariableElement elt, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        this.addDeclAnnotations(declAnnos, elt);
        this.annotateDecl(declAnnos, elt, decl.getAnnotations());
        this.annotateDecl(declAnnos, elt, decl.getElementType().getAnnotations());
        AnnotatedTypeMirror fieldType = this.atypeFactory.fromElement(elt);
        VariableDeclarator fieldVarDecl = null;
        for (VariableDeclarator var : decl.getVariables()) {
            if (!var.getName().toString().equals(elt.getSimpleName().toString())) continue;
            fieldVarDecl = var;
        }
        assert (fieldVarDecl != null);
        this.annotate(fieldType, fieldVarDecl.getType());
        if (fieldType.getKind() == TypeKind.ARRAY) {
            this.annotateInnerMostComponentType((AnnotatedTypeMirror.AnnotatedArrayType)fieldType, decl.getAnnotations());
        } else {
            this.annotate(fieldType, decl.getAnnotations());
        }
        StubParser.putNew(atypes, elt, fieldType);
    }

    private void annotateInnerMostComponentType(AnnotatedTypeMirror.AnnotatedArrayType type, List<AnnotationExpr> annotations) {
        AnnotatedTypeMirror componentType = type;
        while (componentType.getKind() == TypeKind.ARRAY) {
            componentType = componentType.getComponentType();
        }
        this.annotate(componentType, annotations);
    }

    private void annotate(AnnotatedTypeMirror type, List<AnnotationExpr> annotations) {
        if (annotations == null) {
            return;
        }
        for (AnnotationExpr annotation : annotations) {
            AnnotationMirror annoMirror = this.getAnnotation(annotation, this.supportedAnnotations);
            if (annoMirror == null) continue;
            type.replaceAnnotation(annoMirror);
        }
    }

    private void annotateDecl(Map<String, Set<AnnotationMirror>> declAnnos, Element elt, List<AnnotationExpr> annotations) {
        if (annotations == null) {
            return;
        }
        Set<AnnotationMirror> annos = AnnotationUtils.createAnnotationSet();
        for (AnnotationExpr annotation : annotations) {
            AnnotationMirror annoMirror = this.getAnnotation(annotation, this.supportedAnnotations);
            if (annoMirror == null) continue;
            annos.add(annoMirror);
        }
        String key = ElementUtils.getVerboseName(elt);
        StubParser.putOrAddToMap(declAnnos, key, annos);
    }

    private void annotateTypeParameters(BodyDeclaration<?> decl, Object elt, Map<Element, AnnotatedTypeMirror> atypes, List<? extends AnnotatedTypeMirror> typeArguments, List<TypeParameter> typeParameters) {
        if (typeParameters == null) {
            return;
        }
        if (typeParameters.size() != typeArguments.size()) {
            this.stubAlwaysWarn(String.format("annotateTypeParameters: mismatched sizes:  typeParameters (size %d)=%s;  typeArguments (size %d)=%s;  decl=%s;  elt=%s (%s).%n  For more details, run with -AstubDebug", typeParameters.size(), typeParameters, typeArguments.size(), typeArguments, decl.toString().replace(LINE_SEPARATOR, " "), elt.toString().replace(LINE_SEPARATOR, " "), elt.getClass()), new Object[0]);
        }
        for (int i = 0; i < typeParameters.size(); ++i) {
            TypeParameter param = typeParameters.get(i);
            AnnotatedTypeMirror.AnnotatedTypeVariable paramType = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeArguments.get(i);
            if (param.getTypeBound() == null || param.getTypeBound().isEmpty()) {
                this.annotate((AnnotatedTypeMirror)paramType, param.getAnnotations());
            } else if (param.getTypeBound() != null && param.getTypeBound().size() > 0) {
                this.annotate(paramType.getLowerBound(), param.getAnnotations());
                this.annotate(paramType.getUpperBound(), (Type)param.getTypeBound().get(0));
                if (param.getTypeBound().size() > 1) {
                    this.stubWarnIfNotFound("Annotations on intersection types are not yet supported");
                }
            }
            StubParser.putNew(atypes, paramType.getUnderlyingType().asElement(), paramType);
        }
    }

    private Map<Element, BodyDeclaration<?>> getMembers(TypeElement typeElt, TypeDeclaration<?> typeDecl) {
        assert (typeElt.getSimpleName().contentEquals(typeDecl.getNameAsString()) || typeDecl.getNameAsString().endsWith("$" + typeElt.getSimpleName().toString())) : String.format("%s  %s", typeElt.getSimpleName(), typeDecl.getName());
        LinkedHashMap result = new LinkedHashMap();
        for (BodyDeclaration<?> member : typeDecl.getMembers()) {
            this.putNewElement(typeElt, result, member, typeDecl.getNameAsString());
        }
        return result;
    }

    private void putNewElement(TypeElement typeElt, Map<Element, BodyDeclaration<?>> result, BodyDeclaration<?> member, String typeDeclName) {
        if (member instanceof MethodDeclaration) {
            ExecutableElement elt = this.findElement(typeElt, (MethodDeclaration)member);
            if (elt != null) {
                StubParser.putNew(result, elt, member);
            }
        } else if (member instanceof ConstructorDeclaration) {
            ExecutableElement elt = this.findElement(typeElt, (ConstructorDeclaration)member);
            if (elt != null) {
                StubParser.putNew(result, elt, member);
            }
        } else if (member instanceof FieldDeclaration) {
            FieldDeclaration fieldDecl = (FieldDeclaration)member;
            for (VariableDeclarator var : fieldDecl.getVariables()) {
                VariableElement varelt = this.findElement(typeElt, var);
                if (varelt == null) continue;
                StubParser.putNew(result, varelt, fieldDecl);
            }
        } else if (member instanceof ClassOrInterfaceDeclaration) {
            Element elt = this.findElement(typeElt, (ClassOrInterfaceDeclaration)member);
            if (elt != null) {
                StubParser.putNew(result, elt, member);
            }
        } else if (member instanceof EnumDeclaration) {
            Element elt = this.findElement(typeElt, (EnumDeclaration)member);
            if (elt != null) {
                StubParser.putNew(result, elt, member);
            }
        } else {
            this.stubWarnIfNotFound(String.format("Ignoring element of type %s in %s", member.getClass(), typeDeclName));
        }
    }

    private AnnotatedTypeMirror.AnnotatedDeclaredType findType(ClassOrInterfaceType type, List<AnnotatedTypeMirror.AnnotatedDeclaredType> types) {
        String typeString = type.getNameAsString();
        for (AnnotatedTypeMirror.AnnotatedDeclaredType superType : types) {
            if (!superType.getUnderlyingType().asElement().getSimpleName().contentEquals(typeString)) continue;
            return superType;
        }
        this.stubWarnIfNotFound("Type " + typeString + " not found");
        if (this.debugStubParser) {
            for (AnnotatedTypeMirror.AnnotatedDeclaredType superType : types) {
                this.stubDebug(String.format("  %s", superType));
            }
        }
        return null;
    }

    private Element findElement(TypeElement typeElt, ClassOrInterfaceDeclaration ciDecl) {
        String wantedClassOrInterfaceName = ciDecl.getNameAsString();
        for (TypeElement typeElement : ElementUtils.getAllTypeElementsIn(typeElt)) {
            if (!wantedClassOrInterfaceName.equals(typeElement.getSimpleName().toString())) continue;
            return typeElement;
        }
        this.stubWarnIfNotFound("Class/interface " + wantedClassOrInterfaceName + " not found in type " + typeElt);
        if (this.debugStubParser) {
            for (ExecutableElement method : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
                this.stubDebug(String.format("  Here are the type declarations of %s:", typeElt));
                this.stubDebug(String.format("  %s", method));
            }
        }
        return null;
    }

    private Element findElement(TypeElement typeElt, EnumDeclaration enumDecl) {
        String wantedEnumName = enumDecl.getNameAsString();
        for (TypeElement typeElement : ElementUtils.getAllTypeElementsIn(typeElt)) {
            if (!wantedEnumName.equals(typeElement.getSimpleName().toString())) continue;
            return typeElement;
        }
        this.stubWarnIfNotFound("Enum " + wantedEnumName + " not found in type " + typeElt);
        if (this.debugStubParser) {
            for (ExecutableElement method : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
                this.stubDebug(String.format("  Here are the type declarations of %s:", typeElt));
                this.stubDebug(String.format("  %s", method));
            }
        }
        return null;
    }

    private ExecutableElement findElement(TypeElement typeElt, MethodDeclaration methodDecl) {
        String wantedMethodName = methodDecl.getNameAsString();
        int wantedMethodParams = methodDecl.getParameters() == null ? 0 : methodDecl.getParameters().size();
        String wantedMethodString = StubUtil.toString(methodDecl);
        for (ExecutableElement method : ElementUtils.getAllMethodsIn(this.elements, typeElt)) {
            if (wantedMethodParams != method.getParameters().size() || !wantedMethodName.contentEquals(method.getSimpleName().toString()) || !StubUtil.toString(method).equals(wantedMethodString)) continue;
            return method;
        }
        this.stubWarnIfNotFound("Method " + wantedMethodString + " not found in type " + typeElt);
        if (this.debugStubParser) {
            for (ExecutableElement method : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
                this.stubDebug(String.format("  Here are the methods of %s:", typeElt));
                this.stubDebug(String.format("  %s", method));
            }
        }
        return null;
    }

    private ExecutableElement findElement(TypeElement typeElt, ConstructorDeclaration constructorDecl) {
        int wantedMethodParams = constructorDecl.getParameters() == null ? 0 : constructorDecl.getParameters().size();
        String wantedMethodString = StubUtil.toString(constructorDecl);
        for (ExecutableElement method : ElementFilter.constructorsIn(typeElt.getEnclosedElements())) {
            if (wantedMethodParams != method.getParameters().size() || !StubUtil.toString(method).equals(wantedMethodString)) continue;
            return method;
        }
        this.stubWarnIfNotFound("Constructor " + wantedMethodString + " not found in type " + typeElt);
        if (this.debugStubParser) {
            for (ExecutableElement method : ElementFilter.constructorsIn(typeElt.getEnclosedElements())) {
                this.stubDebug(String.format("  %s", method));
            }
        }
        return null;
    }

    private VariableElement findElement(TypeElement typeElt, VariableDeclarator variable) {
        String fieldName = variable.getNameAsString();
        return this.findFieldElement(typeElt, fieldName);
    }

    private VariableElement findFieldElement(TypeElement typeElt, String fieldName) {
        for (VariableElement field : ElementUtils.getAllFieldsIn(this.elements, typeElt)) {
            if (!fieldName.equals(field.getSimpleName().toString())) continue;
            return field;
        }
        this.stubWarnIfNotFound("Field " + fieldName + " not found in type " + typeElt);
        if (this.debugStubParser) {
            for (VariableElement field : ElementFilter.fieldsIn(typeElt.getEnclosedElements())) {
                this.stubDebug(String.format("  %s", field));
            }
        }
        return null;
    }

    private TypeElement findType(String typeName, String ... msg) {
        TypeElement classElement = this.elements.getTypeElement(typeName);
        if (classElement == null) {
            if (msg.length == 0) {
                this.stubWarnIfNotFound("Type not found: " + typeName);
            } else {
                this.stubWarnIfNotFound(msg[0] + ": " + typeName);
            }
        }
        return classElement;
    }

    private PackageElement findPackage(String packageName) {
        PackageElement packageElement = this.elements.getPackageElement(packageName);
        if (packageElement == null) {
            this.stubWarnIfNotFound("Imported package not found: " + packageName);
        }
        return packageElement;
    }

    private static <K, V> void putNew(Map<K, V> m3, K key, V value) {
        if (key == null) {
            ErrorReporter.errorAbort("StubParser: key is null!");
            return;
        }
        if (m3.containsKey(key) && !m3.get(key).equals(value)) {
            return;
        }
        m3.put(key, value);
    }

    private static void putOrAddToMap(Map<String, Set<AnnotationMirror>> map, String key, Set<AnnotationMirror> annos) {
        if (map.containsKey(key)) {
            map.get(key).addAll(annos);
        } else {
            map.put(key, annos);
        }
    }

    private static void putNew(Map<Element, AnnotatedTypeMirror> m3, Element key, AnnotatedTypeMirror value) {
        if (key == null) {
            ErrorReporter.errorAbort("StubParser: key is null!");
            return;
        }
        if (m3.containsKey(key)) {
            AnnotatedTypeMirror value2 = m3.get(key);
            AnnotatedTypeMerger.merge(value, value2);
            m3.put(key, value2);
        } else {
            m3.put(key, value);
        }
    }

    private static <K, V> void putAllNew(Map<K, V> m3, Map<K, V> m22) {
        for (Map.Entry<K, V> e2 : m22.entrySet()) {
            StubParser.putNew(m3, e2.getKey(), e2.getValue());
        }
    }

    private void stubWarnIfNotFound(String warning) {
        if (warnings.add(warning) && (this.warnIfNotFound || this.debugStubParser)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "StubParser: " + warning);
        }
    }

    private void stubWarnIfOverwritesBytecode(String warning) {
        if (warnings.add(warning) && (this.warnIfStubOverwritesBytecode || this.debugStubParser)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "StubParser: " + warning);
        }
    }

    private void stubAlwaysWarn(String warning, Object ... args) {
        if (warnings.add(warning = String.format(warning, args))) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "StubParser: " + warning);
        }
    }

    private void stubDebug(String warning) {
        if (warnings.add(warning) && this.debugStubParser) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "StubParser: " + warning);
        }
    }

    private AnnotationMirror getAnnotation(AnnotationExpr annotation, Map<String, AnnotationMirror> supportedAnnotations) {
        AnnotationMirror annoMirror;
        if (annotation instanceof MarkerAnnotationExpr) {
            String annoName = ((MarkerAnnotationExpr)annotation).getNameAsString();
            annoMirror = supportedAnnotations.get(annoName);
        } else {
            if (annotation instanceof NormalAnnotationExpr) {
                NormalAnnotationExpr nrmanno = (NormalAnnotationExpr)annotation;
                String annoName = nrmanno.getNameAsString();
                AnnotationMirror annoMirror2 = supportedAnnotations.get(annoName);
                if (annoMirror2 == null) {
                    return null;
                }
                AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, annoMirror2);
                NodeList<MemberValuePair> pairs = nrmanno.getPairs();
                if (pairs != null) {
                    for (MemberValuePair mvp : pairs) {
                        Expression exp;
                        String member = mvp.getNameAsString();
                        boolean success = this.handleExpr(builder, member, exp = mvp.getValue());
                        if (success) continue;
                        this.stubAlwaysWarn("Annotation expression, %s, could not be processed for annotation: %s. ", exp, annotation);
                        return null;
                    }
                }
                return builder.build();
            }
            if (annotation instanceof SingleMemberAnnotationExpr) {
                SingleMemberAnnotationExpr sglanno = (SingleMemberAnnotationExpr)annotation;
                String annoName = sglanno.getNameAsString();
                AnnotationMirror annoMirror3 = supportedAnnotations.get(annoName);
                if (annoMirror3 == null) {
                    return null;
                }
                AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, annoMirror3);
                Expression valexpr = sglanno.getMemberValue();
                boolean success = this.handleExpr(builder, "value", valexpr);
                if (!success) {
                    this.stubAlwaysWarn("Annotation expression, %s, could not be processed for annotation: %s. ", valexpr, annotation);
                    return null;
                }
                return builder.build();
            }
            ErrorReporter.errorAbort("StubParser: unknown annotation type: " + annotation);
            annoMirror = null;
        }
        return annoMirror;
    }

    private Object getValueOfExpressionInAnnotation(String name, Expression expr, TypeKind valueKind) {
        if (expr instanceof FieldAccessExpr || expr instanceof NameExpr) {
            Object value;
            VariableElement elem = expr instanceof NameExpr ? this.findVariableElement((NameExpr)expr) : this.findVariableElement((FieldAccessExpr)expr);
            if (elem == null) {
                this.stubAlwaysWarn("Field not found: " + expr, new Object[0]);
                return null;
            }
            Object object = value = elem.getConstantValue() != null ? elem.getConstantValue() : elem;
            if (value instanceof Number) {
                return this.convert((Number)value, valueKind);
            }
            return value;
        }
        if (expr instanceof StringLiteralExpr) {
            return ((StringLiteralExpr)expr).asString();
        }
        if (expr instanceof BooleanLiteralExpr) {
            return ((BooleanLiteralExpr)expr).getValue();
        }
        if (expr instanceof CharLiteralExpr) {
            return this.convert((int)((CharLiteralExpr)expr).asChar(), valueKind);
        }
        if (expr instanceof DoubleLiteralExpr) {
            return ((DoubleLiteralExpr)expr).asDouble();
        }
        if (expr instanceof IntegerLiteralExpr) {
            return this.convert(((IntegerLiteralExpr)expr).asInt(), valueKind);
        }
        if (expr instanceof LongLiteralExpr) {
            return this.convert(((LongLiteralExpr)expr).asLong(), valueKind);
        }
        if (expr instanceof ClassExpr) {
            TypeElement typeElement;
            ClassExpr classExpr = (ClassExpr)expr;
            String className = classExpr.getType().toString();
            if (this.importedTypes.containsKey(className)) {
                return this.importedTypes.get(className).asType();
            }
            String packageName = "";
            if (this.theCompilationUnit.getPackageDeclaration().isPresent()) {
                packageName = this.theCompilationUnit.getPackageDeclaration().get().getNameAsString();
            }
            if ((typeElement = this.findTypeOfName(packageName, this.currentClass, className)) == null) {
                this.stubAlwaysWarn("StubParser: unknown class name " + className, new Object[0]);
                return null;
            }
            return typeElement.asType();
        }
        if (expr instanceof NullLiteralExpr) {
            this.stubAlwaysWarn("Null found as value for %s. Null isn't allowed as an annotation value", name);
            return null;
        }
        this.stubAlwaysWarn("Unexpected annotation expression: " + expr, new Object[0]);
        return null;
    }

    private TypeElement checkCandidate(String name) {
        TypeElement typeElement = this.elements.getTypeElement(name);
        if (typeElement != null) {
            this.importedTypes.put(name, typeElement);
        }
        return typeElement;
    }

    private @Nullable TypeElement findTypeOfName(String packageName, String enclosingClass, String name) {
        TypeElement typeElement = this.checkCandidate(name);
        while (typeElement == null && !enclosingClass.equals(packageName)) {
            typeElement = this.checkCandidate(enclosingClass + "." + name);
            int lastDot = enclosingClass.lastIndexOf(46);
            if (lastDot == -1) break;
            enclosingClass = enclosingClass.substring(0, lastDot);
        }
        if (typeElement == null && !packageName.isEmpty()) {
            typeElement = this.checkCandidate(packageName + "." + name);
        }
        if (typeElement == null && !packageName.equals("java.lang")) {
            typeElement = this.checkCandidate("java.lang." + name);
        }
        return typeElement;
    }

    private Object convert(Number number, TypeKind expectedKind) {
        switch (expectedKind) {
            case BYTE: {
                return number.byteValue();
            }
            case SHORT: {
                return number.shortValue();
            }
            case INT: {
                return number.intValue();
            }
            case LONG: {
                return number.longValue();
            }
            case CHAR: {
                return Character.valueOf((char)number.intValue());
            }
            case FLOAT: {
                return Float.valueOf(number.floatValue());
            }
            case DOUBLE: {
                return number.doubleValue();
            }
        }
        ErrorReporter.errorAbort("Unexpected expectedKind: " + (Object)((Object)expectedKind));
        return null;
    }

    private boolean handleExpr(AnnotationBuilder builder, String name, Expression expr) {
        ExecutableElement var = builder.findElement(name);
        TypeMirror expected = var.getReturnType();
        TypeKind valueKind = expected.getKind() == TypeKind.ARRAY ? ((ArrayType)expected).getComponentType().getKind() : expected.getKind();
        if (expr instanceof ArrayInitializerExpr) {
            if (expected.getKind() != TypeKind.ARRAY) {
                this.stubAlwaysWarn("unhandled annotation attribute type: " + expr + " and expected: " + expected, new Object[0]);
                return false;
            }
            NodeList<Expression> arrayExpressions = ((ArrayInitializerExpr)expr).getValues();
            Object[] values = new Object[arrayExpressions.size()];
            for (int i = 0; i < arrayExpressions.size(); ++i) {
                values[i] = this.getValueOfExpressionInAnnotation(name, (Expression)arrayExpressions.get(i), valueKind);
                if (values[i] != null) continue;
                return false;
            }
            builder.setValue((CharSequence)name, values);
        } else {
            Object value = this.getValueOfExpressionInAnnotation(name, expr, valueKind);
            if (value == null) {
                return false;
            }
            if (expected.getKind() == TypeKind.ARRAY) {
                Object[] valueArray = new Object[]{value};
                builder.setValue((CharSequence)name, valueArray);
            } else {
                this.builderSetValue(builder, name, value);
            }
        }
        return true;
    }

    private void builderSetValue(AnnotationBuilder builder, String name, Object value) {
        if (value instanceof Boolean) {
            builder.setValue((CharSequence)name, (Boolean)value);
        } else if (value instanceof Character) {
            builder.setValue((CharSequence)name, (Character)value);
        } else if (value instanceof Class) {
            builder.setValue((CharSequence)name, (Class)value);
        } else if (value instanceof Double) {
            builder.setValue((CharSequence)name, (Double)value);
        } else if (value instanceof Enum) {
            builder.setValue((CharSequence)name, (Enum)value);
        } else if (value instanceof Float) {
            builder.setValue((CharSequence)name, (Float)value);
        } else if (value instanceof Integer) {
            builder.setValue((CharSequence)name, (Integer)value);
        } else if (value instanceof Long) {
            builder.setValue((CharSequence)name, (Long)value);
        } else if (value instanceof Short) {
            builder.setValue((CharSequence)name, (Short)value);
        } else if (value instanceof String) {
            builder.setValue((CharSequence)name, (String)value);
        } else if (value instanceof TypeMirror) {
            builder.setValue((CharSequence)name, (TypeMirror)value);
        } else if (value instanceof VariableElement) {
            builder.setValue((CharSequence)name, (VariableElement)value);
        } else {
            ErrorReporter.errorAbort("Unexpected builder value: %s", value);
        }
    }

    private @Nullable VariableElement findVariableElement(NameExpr nexpr) {
        if (this.nexprcache.containsKey(nexpr)) {
            return this.nexprcache.get(nexpr);
        }
        VariableElement res = null;
        boolean importFound = false;
        for (String imp : this.importedConstants) {
            Pair<String, String> partitionedName = StubUtil.partitionQualifiedName(imp);
            String typeName = (String)partitionedName.first;
            String fieldName = (String)partitionedName.second;
            if (!fieldName.equals(nexpr.getNameAsString())) continue;
            TypeElement enclType = this.findType(typeName, String.format("Enclosing type of static import %s not found", fieldName));
            if (enclType == null) {
                return null;
            }
            importFound = true;
            res = this.findFieldElement(enclType, fieldName);
            break;
        }
        if (res == null && !importFound) {
            this.stubWarnIfNotFound("Static field " + nexpr.getName() + " is not imported");
        }
        this.nexprcache.put(nexpr, res);
        return res;
    }

    private @Nullable VariableElement findVariableElement(FieldAccessExpr faexpr) {
        if (this.faexprcache.containsKey(faexpr)) {
            return this.faexprcache.get(faexpr);
        }
        TypeElement rcvElt = this.elements.getTypeElement(faexpr.getScope().toString());
        if (rcvElt == null) {
            for (String imp : this.importedConstants) {
                String[] import_delimited = imp.split("\\.");
                if (!import_delimited[import_delimited.length - 1].equals(faexpr.getScope().toString())) continue;
                StringBuilder full_annotation = new StringBuilder();
                for (int i = 0; i < import_delimited.length - 1; ++i) {
                    full_annotation.append(import_delimited[i]);
                    full_annotation.append('.');
                }
                full_annotation.append(faexpr.getScope().toString());
                rcvElt = this.elements.getTypeElement(full_annotation);
                break;
            }
            if (rcvElt == null) {
                this.stubWarnIfNotFound("Type " + faexpr.getScope().toString() + " not found");
                return null;
            }
        }
        VariableElement res = this.findFieldElement(rcvElt, faexpr.getNameAsString());
        this.faexprcache.put(faexpr, res);
        return res;
    }
}

