/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.dependenttypes;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.qual.JavaExpression;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.AnnotatedTypeParameterBounds;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.type.visitor.AnnotatedTypeComparer;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.framework.util.BaseContext;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.framework.util.dependenttypes.DependentTypesError;
import org.checkerframework.framework.util.dependenttypes.DependentTypesTreeAnnotator;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;

public class DependentTypesHelper {
    protected final AnnotatedTypeFactory factory;
    private Map<Class<? extends Annotation>, List<String>> annoToElements;

    public DependentTypesHelper(AnnotatedTypeFactory factory) {
        this.factory = factory;
        this.annoToElements = new HashMap<Class<? extends Annotation>, List<String>>();
        for (Class<? extends Annotation> expressionAnno : factory.getSupportedTypeQualifiers()) {
            List<String> elementList = DependentTypesHelper.getExpressionElementNames(expressionAnno);
            if (elementList == null || elementList.isEmpty()) continue;
            this.annoToElements.put(expressionAnno, elementList);
        }
    }

    private static List<String> getExpressionElementNames(Class<? extends Annotation> clazz) {
        Method[] methods = clazz.getMethods();
        if (methods == null) {
            return Collections.emptyList();
        }
        ArrayList<String> elements = new ArrayList<String>();
        for (Method method : methods) {
            JavaExpression javaExpression = method.getAnnotation(JavaExpression.class);
            if (javaExpression == null) continue;
            elements.add(method.getName());
        }
        return elements;
    }

    public TreeAnnotator createDependentTypesTreeAnnotator(AnnotatedTypeFactory factory) {
        return new DependentTypesTreeAnnotator(factory, this);
    }

    public void viewpointAdaptTypeVariableBounds(TypeElement classDecl, List<AnnotatedTypeParameterBounds> bounds, TreePath pathToUse) {
        FlowExpressions.Receiver r = FlowExpressions.internalRepOfImplicitReceiver(classDecl);
        FlowExpressionParseUtil.FlowExpressionContext context = new FlowExpressionParseUtil.FlowExpressionContext(r, null, this.factory.getContext());
        for (AnnotatedTypeParameterBounds bound : bounds) {
            this.standardizeDoNotUseLocals(context, pathToUse, bound.getUpperBound());
            this.standardizeDoNotUseLocals(context, pathToUse, bound.getLowerBound());
        }
    }

    public void viewpointAdaptMethod(MethodInvocationTree methodInvocationTree, AnnotatedTypeMirror.AnnotatedExecutableType methodDeclType) {
        ExpressionTree receiverTree = TreeUtils.getReceiverTree(methodInvocationTree);
        List<? extends ExpressionTree> args = methodInvocationTree.getArguments();
        this.viewpointAdaptExecutable(methodInvocationTree, receiverTree, methodDeclType, args);
    }

    public void viewpointAdaptConstructor(NewClassTree newClassTree, AnnotatedTypeMirror.AnnotatedExecutableType constructorType) {
        ExpressionTree receiverTree = newClassTree.getEnclosingExpression();
        List<? extends ExpressionTree> args = newClassTree.getArguments();
        this.viewpointAdaptExecutable(newClassTree, receiverTree, constructorType, args);
    }

    private void viewpointAdaptExecutable(ExpressionTree tree, ExpressionTree receiverTree, AnnotatedTypeMirror.AnnotatedExecutableType typeFromUse, List<? extends ExpressionTree> args) {
        Element element = TreeUtils.elementFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType viewpointAdaptedType = (AnnotatedTypeMirror.AnnotatedExecutableType)this.factory.getAnnotatedType(element);
        if (!this.hasDependentType(viewpointAdaptedType)) {
            return;
        }
        FlowExpressions.Receiver receiver = receiverTree == null ? FlowExpressions.internalRepOfImplicitReceiver(TreeUtils.elementFromUse(tree)) : FlowExpressions.internalReprOf((AnnotationProvider)this.factory, receiverTree);
        ArrayList<FlowExpressions.Receiver> argReceivers = new ArrayList<FlowExpressions.Receiver>(args.size());
        for (ExpressionTree expressionTree : args) {
            argReceivers.add(FlowExpressions.internalReprOf((AnnotationProvider)this.factory, expressionTree));
        }
        TreePath currentPath = this.factory.getPath(tree);
        FlowExpressionParseUtil.FlowExpressionContext flowExpressionContext = new FlowExpressionParseUtil.FlowExpressionContext(receiver, argReceivers, this.factory.getContext());
        this.standardizeDoNotUseLocals(flowExpressionContext, currentPath, viewpointAdaptedType);
        new ViewpointAdaptedCopier().visit(viewpointAdaptedType, typeFromUse);
    }

    public void standardizeNewClassTree(NewClassTree tree, AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        if (!this.hasDependentType(type)) {
            return;
        }
        TreePath path = this.factory.getPath(tree);
        FlowExpressions.Receiver r = FlowExpressions.internalRepOfImplicitReceiver(TreeUtils.elementFromUse(tree));
        FlowExpressionParseUtil.FlowExpressionContext context = new FlowExpressionParseUtil.FlowExpressionContext(r, FlowExpressions.getParametersOfEnclosingMethod(this.factory, path), this.factory.getContext());
        this.standardizeUseLocals(context, path, type);
    }

    public void standardizeReturnType(MethodTree m3, AnnotatedTypeMirror atm) {
        if (atm.getKind() == TypeKind.NONE) {
            return;
        }
        if (!this.hasDependentType(atm)) {
            return;
        }
        ExecutableElement ele = TreeUtils.elementFromDeclaration(m3);
        TypeMirror enclosingType = ElementUtils.enclosingClass(ele).asType();
        FlowExpressionParseUtil.FlowExpressionContext context = FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodDeclaration(m3, enclosingType, (BaseContext)this.factory.getContext());
        this.standardizeDoNotUseLocals(context, this.factory.getPath(m3), atm);
    }

    public void standardizeVariable(Tree node, AnnotatedTypeMirror type, Element ele) {
        if (!this.hasDependentType(type)) {
            return;
        }
        TreePath path = this.factory.getPath(node);
        if (path == null) {
            return;
        }
        switch (ele.getKind()) {
            case PARAMETER: {
                Tree enclTree = TreeUtils.enclosingOfKind(path, new HashSet<Tree.Kind>(Arrays.asList(Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION)));
                if (enclTree.getKind() == Tree.Kind.METHOD) {
                    MethodTree methodTree = (MethodTree)enclTree;
                    TypeMirror enclosingType = ElementUtils.enclosingClass(ele).asType();
                    FlowExpressionParseUtil.FlowExpressionContext parameterContext = FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodDeclaration(methodTree, enclosingType, (BaseContext)this.factory.getContext());
                    this.standardizeDoNotUseLocals(parameterContext, path, type);
                    break;
                }
                LambdaExpressionTree lambdaTree = (LambdaExpressionTree)enclTree;
                FlowExpressionParseUtil.FlowExpressionContext parameterContext = FlowExpressionParseUtil.FlowExpressionContext.buildContextForLambda(lambdaTree, path, this.factory.getContext());
                this.standardizeUseLocals(parameterContext, path.getParentPath(), type);
                break;
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: 
            case EXCEPTION_PARAMETER: {
                TypeMirror enclosingType = ElementUtils.enclosingClass(ele).asType();
                FlowExpressions.Receiver receiver = FlowExpressions.internalRepOfPseudoReceiver(path, enclosingType);
                List<FlowExpressions.Receiver> params = FlowExpressions.getParametersOfEnclosingMethod(this.factory, path);
                FlowExpressionParseUtil.FlowExpressionContext localContext = new FlowExpressionParseUtil.FlowExpressionContext(receiver, params, this.factory.getContext());
                this.standardizeUseLocals(localContext, path, type);
                break;
            }
            case FIELD: {
                FlowExpressions.Receiver r;
                FlowExpressions.Receiver receiverF = node.getKind() == Tree.Kind.IDENTIFIER ? ((r = FlowExpressions.internalReprOf((AnnotationProvider)this.factory, (IdentifierTree)node)) instanceof FlowExpressions.FieldAccess ? ((FlowExpressions.FieldAccess)r).getReceiver() : r) : FlowExpressions.internalRepOfImplicitReceiver(ele);
                FlowExpressionParseUtil.FlowExpressionContext fieldContext = new FlowExpressionParseUtil.FlowExpressionContext(receiverF, null, this.factory.getContext());
                this.standardizeDoNotUseLocals(fieldContext, path, type);
                break;
            }
        }
    }

    public void standardizeFieldAccess(MemberSelectTree node, AnnotatedTypeMirror type) {
        if (!this.hasDependentType(type)) {
            return;
        }
        if (TreeUtils.isClassLiteral(node)) {
            return;
        }
        Element ele = TreeUtils.elementFromUse(node);
        if (ele.getKind() != ElementKind.FIELD) {
            return;
        }
        FlowExpressions.Receiver receiver = FlowExpressions.internalReprOf((AnnotationProvider)this.factory, node.getExpression());
        FlowExpressionParseUtil.FlowExpressionContext context = new FlowExpressionParseUtil.FlowExpressionContext(receiver, null, this.factory.getContext());
        this.standardizeDoNotUseLocals(context, this.factory.getPath(node), type);
    }

    public void standardizeExpression(ExpressionTree tree, AnnotatedTypeMirror annotatedType) {
        if (!this.hasDependentType(annotatedType)) {
            return;
        }
        TreePath path = this.factory.getPath(tree);
        if (path == null) {
            return;
        }
        ClassTree enclosingClass = TreeUtils.enclosingClass(path);
        if (enclosingClass == null) {
            return;
        }
        TypeMirror enclosingType = InternalUtils.typeOf(enclosingClass);
        FlowExpressions.Receiver receiver = FlowExpressions.internalRepOfPseudoReceiver(path, enclosingType);
        FlowExpressionParseUtil.FlowExpressionContext localContext = new FlowExpressionParseUtil.FlowExpressionContext(receiver, FlowExpressions.getParametersOfEnclosingMethod(this.factory, path), this.factory.getContext());
        this.standardizeUseLocals(localContext, path, annotatedType);
    }

    public void standardizeVariable(AnnotatedTypeMirror type, Element elt) {
        if (!this.hasDependentType(type)) {
            return;
        }
        switch (elt.getKind()) {
            case PARAMETER: 
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: 
            case EXCEPTION_PARAMETER: {
                Tree tree = this.factory.declarationFromElement(elt);
                if (tree == null) {
                    if (elt.getKind() == ElementKind.PARAMETER) {
                        return;
                    }
                    ErrorReporter.errorAbort(this.getClass() + ": tree not found");
                } else if (InternalUtils.typeOf(tree) == null) {
                    return;
                }
                this.standardizeVariable(tree, type, elt);
                break;
            }
        }
    }

    private void standardizeUseLocals(FlowExpressionParseUtil.FlowExpressionContext context, TreePath localScope, AnnotatedTypeMirror type) {
        this.standardizeAtm(context, localScope, type, true);
    }

    private void standardizeDoNotUseLocals(FlowExpressionParseUtil.FlowExpressionContext context, TreePath localScope, AnnotatedTypeMirror type) {
        this.standardizeAtm(context, localScope, type, false);
    }

    private void standardizeAtm(FlowExpressionParseUtil.FlowExpressionContext context, TreePath localScope, AnnotatedTypeMirror type, boolean useLocalScope) {
        if (localScope != null) {
            new StandardizeTypeAnnotator(context, localScope, useLocalScope).visit(type);
        }
    }

    protected String standardizeString(String expression, FlowExpressionParseUtil.FlowExpressionContext context, TreePath localScope, boolean useLocalScope) {
        if (DependentTypesError.isExpressionError(expression)) {
            return expression;
        }
        try {
            FlowExpressions.Receiver result = FlowExpressionParseUtil.parse(expression, context, localScope, useLocalScope);
            if (result == null) {
                return new DependentTypesError(expression, " ").toString();
            }
            return result.toString();
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
            return new DependentTypesError(expression, e).toString();
        }
    }

    public boolean hasDependentAnnotations() {
        return !this.annoToElements.isEmpty();
    }

    public void checkType(AnnotatedTypeMirror atm, Tree errorTree) {
        List errors = (List)new ExpressionErrorChecker().visit(atm);
        if (errors == null || errors.isEmpty()) {
            return;
        }
        if (errorTree.getKind() == Tree.Kind.VARIABLE) {
            ModifiersTree modifiers = ((VariableTree)errorTree).getModifiers();
            errorTree = ((VariableTree)errorTree).getType();
            block0: for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
                for (Class<? extends Annotation> annoClazz : this.annoToElements.keySet()) {
                    if (!annotationTree.toString().contains(annoClazz.getSimpleName())) continue;
                    errorTree = annotationTree;
                    continue block0;
                }
            }
        }
        this.reportErrors(errorTree, errors);
    }

    protected void reportErrors(Tree errorTree, List<DependentTypesError> errors) {
        if (errors.isEmpty()) {
            return;
        }
        SourceChecker checker = this.factory.getContext().getChecker();
        String error = PluginUtil.join("\n", errors);
        checker.report(Result.failure("expression.unparsable.type.invalid", error), errorTree);
    }

    public void checkMethod(MethodTree methodTree, AnnotatedTypeMirror.AnnotatedExecutableType type) {
        this.checkTypeVariables(methodTree, type);
        if (type.getReturnType().getKind() != TypeKind.VOID) {
            AnnotatedTypeMirror returnType = this.factory.getMethodReturnType(methodTree);
            this.checkType(returnType, methodTree.getReturnType());
        }
    }

    private void checkTypeVariables(MethodTree node, AnnotatedTypeMirror.AnnotatedExecutableType methodType) {
        ExecutableElement ele = TreeUtils.elementFromDeclaration(node);
        TypeMirror enclosingType = ElementUtils.enclosingClass(ele).asType();
        FlowExpressionParseUtil.FlowExpressionContext context = FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodDeclaration(node, enclosingType, (BaseContext)this.factory.getContext());
        for (int i = 0; i < methodType.getTypeVariables().size(); ++i) {
            AnnotatedTypeMirror atm = methodType.getTypeVariables().get(i);
            this.standardizeDoNotUseLocals(context, this.factory.getPath(node), atm);
            this.checkType(atm, node.getTypeParameters().get(i));
        }
    }

    private boolean isExpressionAnno(AnnotationMirror am) {
        for (Class<? extends Annotation> clazz : this.annoToElements.keySet()) {
            if (!AnnotationUtils.areSameByClass(am, clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDependentType(AnnotatedTypeMirror atm) {
        if (atm == null) {
            return false;
        }
        Boolean b = (Boolean)new ContainsDependentType().visit(atm);
        if (b == null) {
            return false;
        }
        return b;
    }

    private List<String> getListOfExpressionElements(AnnotationMirror am) {
        for (Class<? extends Annotation> clazz : this.annoToElements.keySet()) {
            if (!AnnotationUtils.areSameByClass(am, clazz)) continue;
            return this.annoToElements.get(clazz);
        }
        return Collections.emptyList();
    }

    private class ContainsDependentType
    extends AnnotatedTypeScanner<Boolean, Void> {
        private ContainsDependentType() {
        }

        @Override
        protected Boolean scan(AnnotatedTypeMirror type, Void aVoid) {
            for (AnnotationMirror am : type.getAnnotations()) {
                if (!DependentTypesHelper.this.isExpressionAnno(am)) continue;
                return true;
            }
            return (Boolean)super.scan(type, aVoid);
        }

        @Override
        protected Boolean reduce(Boolean r1, Boolean r2) {
            if (r1 != null && r2 != null) {
                return r1 != false || r2 != false;
            }
            if (r1 != null) {
                return r1;
            }
            if (r2 != null) {
                return r2;
            }
            return false;
        }
    }

    private class ViewpointAdaptedCopier
    extends AnnotatedTypeComparer<Void> {
        private ViewpointAdaptedCopier() {
        }

        @Override
        protected Void scan(AnnotatedTypeMirror type, AnnotatedTypeMirror p) {
            if (type == null || p == null) {
                return null;
            }
            Set<AnnotationMirror> replacement = AnnotationUtils.createAnnotationSet();
            for (Class vpa : DependentTypesHelper.this.annoToElements.keySet()) {
                AnnotationMirror anno = type.getAnnotation(vpa);
                if (anno == null) continue;
                replacement.add(anno);
            }
            p.replaceAnnotations(replacement);
            if (type.getKind() != p.getKind()) {
                return null;
            }
            return (Void)super.scan(type, p);
        }

        @Override
        protected Void compare(AnnotatedTypeMirror type, AnnotatedTypeMirror p) {
            if (type == null || p == null) {
                return null;
            }
            if (type.getKind() != p.getKind()) {
                ErrorReporter.errorAbort("Should be the same. type: %s p: %s ", type, p);
            }
            return null;
        }

        @Override
        protected Void combineRs(Void r1, Void r2) {
            return null;
        }
    }

    private class ExpressionErrorChecker
    extends AnnotatedTypeScanner<List<DependentTypesError>, Void> {
        private ExpressionErrorChecker() {
        }

        @Override
        protected List<DependentTypesError> scan(AnnotatedTypeMirror type, Void aVoid) {
            ArrayList<DependentTypesError> errors = new ArrayList<DependentTypesError>();
            for (AnnotationMirror am : type.getAnnotations()) {
                if (!DependentTypesHelper.this.isExpressionAnno(am)) continue;
                errors.addAll(this.checkForError(am));
            }
            List superList = (List)super.scan(type, aVoid);
            if (superList != null) {
                errors.addAll(superList);
            }
            return errors;
        }

        @Override
        protected List<DependentTypesError> reduce(List<DependentTypesError> r1, List<DependentTypesError> r2) {
            if (r1 != null && r2 != null) {
                r1.addAll(r2);
                return r1;
            }
            if (r1 != null) {
                return r1;
            }
            if (r2 != null) {
                return r2;
            }
            return null;
        }

        private List<DependentTypesError> checkForError(AnnotationMirror am) {
            ArrayList<DependentTypesError> errors = new ArrayList<DependentTypesError>();
            for (String element : DependentTypesHelper.this.getListOfExpressionElements(am)) {
                List<String> value = AnnotationUtils.getElementValueArray(am, element, String.class, true);
                for (String v : value) {
                    if (!DependentTypesError.isExpressionError(v)) continue;
                    errors.add(new DependentTypesError(v));
                }
            }
            return errors;
        }
    }

    private class StandardizeTypeAnnotator
    extends AnnotatedTypeScanner<Void, Void> {
        private final FlowExpressionParseUtil.FlowExpressionContext context;
        private final TreePath localScope;
        private final boolean useLocalScope;

        private StandardizeTypeAnnotator(FlowExpressionParseUtil.FlowExpressionContext context, TreePath localScope, boolean useLocalScope) {
            this.context = context;
            this.localScope = localScope;
            this.useLocalScope = useLocalScope;
        }

        private AnnotationMirror standardizeAnnotation(FlowExpressionParseUtil.FlowExpressionContext context, TreePath localScope, AnnotationMirror anno, boolean useLocalScope) {
            if (!DependentTypesHelper.this.isExpressionAnno(anno)) {
                return null;
            }
            AnnotationBuilder builder = new AnnotationBuilder(DependentTypesHelper.this.factory.getProcessingEnv(), AnnotationUtils.annotationName(anno));
            for (String value : DependentTypesHelper.this.getListOfExpressionElements(anno)) {
                List<String> expressionStrings = AnnotationUtils.getElementValueArray(anno, value, String.class, true);
                ArrayList<String> standardizedStrings = new ArrayList<String>();
                for (String expression : expressionStrings) {
                    standardizedStrings.add(DependentTypesHelper.this.standardizeString(expression, context, localScope, useLocalScope));
                }
                builder.setValue((CharSequence)value, standardizedStrings);
            }
            return builder.build();
        }

        @Override
        public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, Void aVoid) {
            if (this.visitedNodes.containsKey(type)) {
                return (Void)this.visitedNodes.get(type);
            }
            this.visitedNodes.put(type, null);
            Set<AnnotationMirror> primarys = type.getAnnotations();
            type.getLowerBound().removeAnnotations(primarys);
            Void r = this.scan(type.getLowerBound(), aVoid);
            type.getLowerBound().addAnnotations(primarys);
            this.visitedNodes.put(type, r);
            type.getUpperBound().removeAnnotations(primarys);
            r = this.scanAndReduce(type.getUpperBound(), aVoid, r);
            type.getUpperBound().addAnnotations(primarys);
            this.visitedNodes.put(type, r);
            return r;
        }

        @Override
        protected Void scan(AnnotatedTypeMirror type, Void aVoid) {
            ArrayList<AnnotationMirror> newAnnos = new ArrayList<AnnotationMirror>();
            for (AnnotationMirror anno : type.getAnnotations()) {
                AnnotationMirror annotationMirror = this.standardizeAnnotation(this.context, this.localScope, anno, this.useLocalScope);
                if (annotationMirror == null) continue;
                newAnnos.add(annotationMirror);
            }
            for (AnnotationMirror anno : newAnnos) {
                if (!type.removeAnnotation(anno)) continue;
                type.removeAnnotation(anno);
            }
            type.addAnnotations(newAnnos);
            return (Void)super.scan(type, aVoid);
        }
    }
}

