/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GeneralAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.AnnotationMirrorSet;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.framework.util.typeinference.TypeArgInferenceUtil;
import org.checkerframework.framework.util.typeinference.TypeArgumentInference;
import org.checkerframework.framework.util.typeinference.constraint.A2F;
import org.checkerframework.framework.util.typeinference.constraint.A2FReducer;
import org.checkerframework.framework.util.typeinference.constraint.AFConstraint;
import org.checkerframework.framework.util.typeinference.constraint.AFReducer;
import org.checkerframework.framework.util.typeinference.constraint.F2A;
import org.checkerframework.framework.util.typeinference.constraint.F2AReducer;
import org.checkerframework.framework.util.typeinference.constraint.FIsA;
import org.checkerframework.framework.util.typeinference.constraint.FIsAReducer;
import org.checkerframework.framework.util.typeinference.constraint.TSubU;
import org.checkerframework.framework.util.typeinference.constraint.TSuperU;
import org.checkerframework.framework.util.typeinference.constraint.TUConstraint;
import org.checkerframework.framework.util.typeinference.solver.ConstraintMap;
import org.checkerframework.framework.util.typeinference.solver.ConstraintMapBuilder;
import org.checkerframework.framework.util.typeinference.solver.EqualitiesSolver;
import org.checkerframework.framework.util.typeinference.solver.InferenceResult;
import org.checkerframework.framework.util.typeinference.solver.InferredValue;
import org.checkerframework.framework.util.typeinference.solver.SubtypesSolver;
import org.checkerframework.framework.util.typeinference.solver.SupertypesSolver;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypeAnnotationUtils;
import org.checkerframework.javacutil.TypesUtils;

public class DefaultTypeArgumentInference
implements TypeArgumentInference {
    private final EqualitiesSolver equalitiesSolver = new EqualitiesSolver();
    private final SupertypesSolver supertypesSolver = new SupertypesSolver();
    private final SubtypesSolver subtypesSolver = new SubtypesSolver();
    private final ConstraintMapBuilder constraintMapBuilder = new ConstraintMapBuilder();
    private final boolean showInferenceSteps;

    public DefaultTypeArgumentInference(AnnotatedTypeFactory typeFactory) {
        this.showInferenceSteps = typeFactory.getContext().getChecker().hasOption("showInferenceSteps");
    }

    @Override
    public Map<TypeVariable, AnnotatedTypeMirror> inferTypeArgs(AnnotatedTypeFactory typeFactory, ExpressionTree expressionTree, ExecutableElement methodElem, AnnotatedTypeMirror.AnnotatedExecutableType methodType) {
        LinkedHashMap<TypeVariable, AnnotatedTypeMirror> inferredArgs;
        Set<TypeVariable> targets;
        SourceChecker checker;
        block8: {
            if (typeFactory instanceof GeneralAnnotatedTypeFactory) {
                return new HashMap<TypeVariable, AnnotatedTypeMirror>();
            }
            List<AnnotatedTypeMirror> argTypes = TypeArgInferenceUtil.getArgumentTypes(expressionTree, typeFactory);
            TreePath pathToExpression = typeFactory.getPath(expressionTree);
            AnnotatedTypeMirror assignedTo = TypeArgInferenceUtil.assignedTo(typeFactory, pathToExpression);
            checker = typeFactory.getContext().getChecker();
            if (this.showInferenceSteps) {
                checker.message(Diagnostic.Kind.NOTE, "DTAI: expression: %s\n  argTypes: %s\n  assignedTo: %s\n", expressionTree.toString().replace("\n", " "), argTypes, assignedTo);
            }
            targets = TypeArgInferenceUtil.methodTypeToTargets(methodType);
            if (assignedTo == null && TreeUtils.getAssignmentContext(pathToExpression) != null) {
                LinkedHashMap<TypeVariable, AnnotatedTypeMirror> inferredArgs2 = new LinkedHashMap<TypeVariable, AnnotatedTypeMirror>();
                this.handleUninferredTypeVariables(typeFactory, methodType, targets, inferredArgs2);
                return inferredArgs2;
            }
            try {
                inferredArgs = this.infer(typeFactory, argTypes, assignedTo, methodElem, methodType, targets, true);
                if (this.showInferenceSteps) {
                    checker.message(Diagnostic.Kind.NOTE, "  after infer: %s\n", inferredArgs);
                }
                this.handleNullTypeArguments(typeFactory, methodElem, methodType, argTypes, assignedTo, targets, inferredArgs);
                if (this.showInferenceSteps) {
                    checker.message(Diagnostic.Kind.NOTE, "  after handleNull: %s\n", inferredArgs);
                }
            }
            catch (Exception ex) {
                inferredArgs = new LinkedHashMap();
                if (!this.showInferenceSteps) break block8;
                checker.message(Diagnostic.Kind.NOTE, "  exception: %s\n", ex.getLocalizedMessage());
            }
        }
        this.handleUninferredTypeVariables(typeFactory, methodType, targets, inferredArgs);
        if (this.showInferenceSteps) {
            checker.message(Diagnostic.Kind.NOTE, "  results: %s\n", inferredArgs);
        }
        return inferredArgs;
    }

    private void handleNullTypeArguments(AnnotatedTypeFactory typeFactory, ExecutableElement methodElem, AnnotatedTypeMirror.AnnotatedExecutableType methodType, List<AnnotatedTypeMirror> argTypes, AnnotatedTypeMirror assignedTo, Set<TypeVariable> targets, Map<TypeVariable, AnnotatedTypeMirror> inferredArgs) {
        if (!this.hasNullType(inferredArgs)) {
            return;
        }
        Map<TypeVariable, AnnotatedTypeMirror> inferredArgsWithOutNull = this.infer(typeFactory, argTypes, assignedTo, methodElem, methodType, targets, false);
        for (AnnotatedTypeMirror.AnnotatedTypeVariable atv : methodType.getTypeVariables()) {
            AnnotatedTypeMirror withoutNullResult;
            TypeVariable typeVar = atv.getUnderlyingType();
            AnnotatedTypeMirror result = inferredArgs.get(typeVar);
            if (result == null) {
                withoutNullResult = inferredArgsWithOutNull.get(typeVar);
                if (withoutNullResult == null) continue;
                inferredArgs.put(typeVar, withoutNullResult);
                continue;
            }
            if (result.getKind() != TypeKind.NULL) continue;
            withoutNullResult = inferredArgsWithOutNull.get(typeVar);
            if (withoutNullResult == null) {
                withoutNullResult = typeFactory.getUninferredWildcardType(atv);
            }
            AnnotatedTypeMirror lub = AnnotatedTypes.leastUpperBound(typeFactory, withoutNullResult, result);
            inferredArgs.put(typeVar, lub);
        }
    }

    private boolean hasNullType(Map<TypeVariable, AnnotatedTypeMirror> inferredArgs) {
        for (AnnotatedTypeMirror atm : inferredArgs.values()) {
            if (atm.getKind() != TypeKind.NULL) continue;
            return true;
        }
        return false;
    }

    private Map<TypeVariable, AnnotatedTypeMirror> infer(AnnotatedTypeFactory typeFactory, List<AnnotatedTypeMirror> argumentTypes, AnnotatedTypeMirror assignedTo, ExecutableElement methodElem, AnnotatedTypeMirror.AnnotatedExecutableType methodType, Set<TypeVariable> targets, boolean useNullArguments) {
        Set<AFConstraint> afArgumentConstraints = this.createArgumentAFConstraints(typeFactory, argumentTypes, methodType, targets, useNullArguments);
        Pair<InferenceResult, InferenceResult> argInference = this.inferFromArguments(typeFactory, afArgumentConstraints, targets);
        InferenceResult fromArgEqualities = (InferenceResult)argInference.first;
        InferenceResult fromArgSubandSupers = (InferenceResult)argInference.second;
        this.clampToLowerBound(fromArgSubandSupers, methodType.getTypeVariables(), typeFactory);
        if (assignedTo == null) {
            fromArgEqualities.mergeSubordinate(fromArgSubandSupers);
            return fromArgEqualities.toAtmMap();
        }
        AnnotatedTypeMirror declaredReturnType = methodType.getReturnType();
        AnnotatedTypeMirror boxedReturnType = declaredReturnType == null ? null : (declaredReturnType.getKind().isPrimitive() ? typeFactory.getBoxedType((AnnotatedTypeMirror.AnnotatedPrimitiveType)declaredReturnType) : declaredReturnType);
        InferenceResult fromArguments = fromArgEqualities;
        if (!((Symbol.MethodSymbol)methodElem).isConstructor()) {
            InferenceResult fromAssignmentEqualities = this.inferFromAssignmentEqualities(assignedTo, boxedReturnType, targets, typeFactory);
            InferenceResult combinedSupertypesAndAssignment = this.combineSupertypeAndAssignmentResults(targets, typeFactory, fromAssignmentEqualities, fromArgSubandSupers);
            fromArgEqualities.mergeSubordinate(combinedSupertypesAndAssignment);
            if (!fromArguments.isComplete(targets)) {
                InferenceResult fromAssignment = this.inferFromAssignment(assignedTo, boxedReturnType, methodType, afArgumentConstraints, fromArguments, targets, typeFactory);
                fromArguments.mergeSubordinate(fromAssignment);
            }
        } else {
            fromArguments.mergeSubordinate(fromArgSubandSupers);
        }
        return fromArguments.toAtmMap();
    }

    private void clampToLowerBound(InferenceResult fromArgSupertypes, List<AnnotatedTypeMirror.AnnotatedTypeVariable> targetDeclarations, AnnotatedTypeFactory typeFactory) {
        QualifierHierarchy qualifierHierarchy = typeFactory.getQualifierHierarchy();
        AnnotationMirrorSet tops = new AnnotationMirrorSet(qualifierHierarchy.getTopAnnotations());
        for (AnnotatedTypeMirror.AnnotatedTypeVariable targetDecl : targetDeclarations) {
            InferredValue inferred = (InferredValue)fromArgSupertypes.get(targetDecl.getUnderlyingType());
            if (inferred == null || !(inferred instanceof InferredValue.InferredType)) continue;
            AnnotatedTypeMirror lowerBoundAsArgument = targetDecl.getLowerBound();
            for (AnnotationMirror top : tops) {
                AnnotationMirror lowerBoundAnno = lowerBoundAsArgument.getEffectiveAnnotationInHierarchy(top);
                AnnotationMirror argAnno = ((InferredValue.InferredType)inferred).type.getEffectiveAnnotationInHierarchy(top);
                if (!qualifierHierarchy.isSubtype(argAnno, lowerBoundAnno)) continue;
                ((InferredValue.InferredType)inferred).type.replaceAnnotation(lowerBoundAnno);
            }
        }
    }

    protected Set<AFConstraint> createArgumentAFConstraints(AnnotatedTypeFactory typeFactory, List<AnnotatedTypeMirror> argTypes, AnnotatedTypeMirror.AnnotatedExecutableType methodType, Set<TypeVariable> targets, boolean useNullArguments) {
        List<AnnotatedTypeMirror> paramTypes = AnnotatedTypes.expandVarArgsFromTypes(methodType, argTypes);
        if (argTypes.size() != paramTypes.size()) {
            ErrorReporter.errorAbort("Mismatch between formal parameter count and argument count!\nparamTypes=" + PluginUtil.join(",", paramTypes) + "\nargTypes=" + PluginUtil.join(",", argTypes));
        }
        int numberOfParams = paramTypes.size();
        LinkedList<AFConstraint> afConstraints = new LinkedList<AFConstraint>();
        for (int i = 0; i < numberOfParams; ++i) {
            if (!useNullArguments && argTypes.get(i).getKind() == TypeKind.NULL) continue;
            afConstraints.add(new A2F(argTypes.get(i), paramTypes.get(i)));
        }
        LinkedHashSet<AFConstraint> reducedConstraints = new LinkedHashSet<AFConstraint>();
        this.reduceAfConstraints(typeFactory, reducedConstraints, afConstraints, targets);
        return reducedConstraints;
    }

    private Pair<InferenceResult, InferenceResult> inferFromArguments(AnnotatedTypeFactory typeFactory, Set<AFConstraint> afArgumentConstraints, Set<TypeVariable> targets) {
        Set<TUConstraint> tuArgConstraints = this.afToTuConstraints(afArgumentConstraints, targets);
        this.addConstraintsBetweenTargets(tuArgConstraints, targets, false, typeFactory);
        ConstraintMap argConstraints = this.constraintMapBuilder.build(targets, tuArgConstraints, typeFactory);
        InferenceResult inferredFromArgEqualities = this.equalitiesSolver.solveEqualities(targets, argConstraints, typeFactory);
        Set<TypeVariable> remainingTargets = inferredFromArgEqualities.getRemainingTargets(targets, true);
        InferenceResult fromSupertypes = this.supertypesSolver.solveFromSupertypes(remainingTargets, argConstraints, typeFactory);
        InferenceResult fromSubtypes = this.subtypesSolver.solveFromSubtypes(remainingTargets, argConstraints, typeFactory);
        fromSupertypes.mergeSubordinate(fromSubtypes);
        return Pair.of(inferredFromArgEqualities, fromSupertypes);
    }

    private InferenceResult inferFromAssignmentEqualities(AnnotatedTypeMirror assignedTo, AnnotatedTypeMirror boxedReturnType, Set<TypeVariable> targets, AnnotatedTypeFactory typeFactory) {
        Set<FIsA> afInitialAssignmentConstraints = this.createInitialAssignmentConstraints(assignedTo, boxedReturnType, typeFactory, targets);
        Set<TUConstraint> tuInitialAssignmentConstraints = this.afToTuConstraints(afInitialAssignmentConstraints, targets);
        ConstraintMap initialAssignmentConstraints = this.constraintMapBuilder.build(targets, tuInitialAssignmentConstraints, typeFactory);
        return this.equalitiesSolver.solveEqualities(targets, initialAssignmentConstraints, typeFactory);
    }

    protected Set<FIsA> createInitialAssignmentConstraints(AnnotatedTypeMirror assignedTo, AnnotatedTypeMirror boxedReturnType, AnnotatedTypeFactory typeFactory, Set<TypeVariable> targets) {
        LinkedHashSet<FIsA> result = new LinkedHashSet<FIsA>();
        if (assignedTo != null) {
            LinkedHashSet<AFConstraint> reducedConstraints = new LinkedHashSet<AFConstraint>();
            LinkedList<AFConstraint> constraints = new LinkedList<AFConstraint>();
            constraints.add(new F2A(boxedReturnType, assignedTo));
            this.reduceAfConstraints(typeFactory, reducedConstraints, constraints, targets);
            for (AFConstraint reducedConstraint : reducedConstraints) {
                if (!(reducedConstraint instanceof FIsA)) continue;
                result.add((FIsA)reducedConstraint);
            }
        }
        return result;
    }

    public ConstraintMap createAssignmentConstraints(AnnotatedTypeMirror assignedTo, AnnotatedTypeMirror boxedReturnType, AnnotatedTypeMirror.AnnotatedExecutableType methodType, Set<AFConstraint> afArgumentConstraints, Map<TypeVariable, AnnotatedTypeMirror> inferredArgs, Set<TypeVariable> targets, AnnotatedTypeFactory typeFactory) {
        LinkedList<AFConstraint> assignmentAfs = new LinkedList<AFConstraint>();
        for (AnnotatedTypeMirror.AnnotatedTypeVariable annotatedTypeVariable : methodType.getTypeVariables()) {
            TypeVariable typeVariable = annotatedTypeVariable.getUnderlyingType();
            AnnotatedTypeMirror inferredType = inferredArgs.get(typeVariable);
            if (inferredType != null) {
                assignmentAfs.add(new A2F(inferredType, annotatedTypeVariable.getUpperBound()));
                assignmentAfs.add(new F2A(annotatedTypeVariable.getLowerBound(), inferredType));
                continue;
            }
            assignmentAfs.add(new F2A(annotatedTypeVariable, annotatedTypeVariable.getUpperBound()));
            assignmentAfs.add(new A2F(annotatedTypeVariable.getLowerBound(), annotatedTypeVariable));
        }
        for (AFConstraint aFConstraint : afArgumentConstraints) {
            if (!(aFConstraint instanceof F2A)) continue;
            assignmentAfs.add(aFConstraint);
        }
        LinkedList<AFConstraint> substitutedAssignmentConstraints = new LinkedList<AFConstraint>();
        for (AFConstraint aFConstraint : assignmentAfs) {
            substitutedAssignmentConstraints.add(aFConstraint.substitute(inferredArgs));
        }
        AnnotatedTypeMirror annotatedTypeMirror = TypeArgInferenceUtil.substitute(inferredArgs, boxedReturnType);
        substitutedAssignmentConstraints.add(new F2A(annotatedTypeMirror, assignedTo));
        LinkedHashSet<AFConstraint> linkedHashSet = new LinkedHashSet<AFConstraint>();
        this.reduceAfConstraints(typeFactory, linkedHashSet, substitutedAssignmentConstraints, targets);
        Set<TUConstraint> tuAssignmentConstraints = this.afToTuConstraints(linkedHashSet, targets);
        this.addConstraintsBetweenTargets(tuAssignmentConstraints, targets, true, typeFactory);
        return this.constraintMapBuilder.build(targets, tuAssignmentConstraints, typeFactory);
    }

    private InferenceResult inferFromAssignment(AnnotatedTypeMirror assignedTo, AnnotatedTypeMirror boxedReturnType, AnnotatedTypeMirror.AnnotatedExecutableType methodType, Set<AFConstraint> afArgumentConstraints, InferenceResult inferredArgs, Set<TypeVariable> targets, AnnotatedTypeFactory typeFactory) {
        ConstraintMap assignmentConstraints = this.createAssignmentConstraints(assignedTo, boxedReturnType, methodType, afArgumentConstraints, inferredArgs.toAtmMap(), targets, typeFactory);
        InferenceResult equalitiesResult = this.equalitiesSolver.solveEqualities(targets, assignmentConstraints, typeFactory);
        Set<TypeVariable> remainingTargets = equalitiesResult.getRemainingTargets(targets, true);
        InferenceResult subtypesResult = this.subtypesSolver.solveFromSubtypes(remainingTargets, assignmentConstraints, typeFactory);
        equalitiesResult.mergeSubordinate(subtypesResult);
        return equalitiesResult;
    }

    private InferenceResult combineSupertypeAndAssignmentResults(Set<TypeVariable> targets, AnnotatedTypeFactory typeFactory, InferenceResult equalityResult, InferenceResult supertypeResult) {
        TypeHierarchy typeHierarchy = typeFactory.getTypeHierarchy();
        InferenceResult result = new InferenceResult();
        for (TypeVariable target : targets) {
            InferredValue outputValue;
            InferredValue equalityInferred = (InferredValue)equalityResult.get(target);
            InferredValue supertypeInferred = (InferredValue)supertypeResult.get(target);
            if (equalityInferred != null && equalityInferred instanceof InferredValue.InferredType) {
                if (supertypeInferred != null && supertypeInferred instanceof InferredValue.InferredType) {
                    AnnotatedTypeMirror superATM = ((InferredValue.InferredType)supertypeInferred).type;
                    AnnotatedTypeMirror equalityATM = ((InferredValue.InferredType)equalityInferred).type;
                    if (TypesUtils.isErasedSubtype(typeFactory.getContext().getTypeUtils(), equalityATM.getUnderlyingType(), superATM.getUnderlyingType())) {
                        equalityATM = AnnotatedTypes.asSuper(typeFactory, equalityATM, superATM);
                    }
                    outputValue = typeHierarchy.isSubtype(superATM, equalityATM) ? equalityInferred : supertypeInferred;
                } else {
                    outputValue = equalityInferred;
                }
            } else {
                outputValue = supertypeInferred != null ? supertypeInferred : null;
            }
            if (outputValue == null) continue;
            result.put(target, outputValue);
        }
        return result;
    }

    private void handleUninferredTypeVariables(AnnotatedTypeFactory typeFactory, AnnotatedTypeMirror.AnnotatedExecutableType methodType, Set<TypeVariable> targets, Map<TypeVariable, AnnotatedTypeMirror> inferredArgs) {
        for (AnnotatedTypeMirror.AnnotatedTypeVariable atv : methodType.getTypeVariables()) {
            AnnotatedTypeMirror inferredType;
            TypeVariable typeVar = atv.getUnderlyingType();
            if (!targets.contains(TypeAnnotationUtils.unannotatedType(typeVar)) || (inferredType = inferredArgs.get(typeVar)) != null && !TypeArgInferenceUtil.containsTypeParameter(inferredType, targets)) continue;
            AnnotatedTypeMirror.AnnotatedWildcardType dummy = typeFactory.getUninferredWildcardType(atv);
            inferredArgs.put(atv.getUnderlyingType(), dummy);
        }
    }

    protected void reduceAfConstraints(AnnotatedTypeFactory typeFactory, Set<AFConstraint> outgoing, Queue<AFConstraint> toProcess, Set<TypeVariable> targets) {
        HashSet<AFConstraint> visited = new HashSet<AFConstraint>();
        ArrayList<AFReducer> reducers = new ArrayList<AFReducer>();
        reducers.add(new A2FReducer(typeFactory));
        reducers.add(new F2AReducer(typeFactory));
        reducers.add(new FIsAReducer(typeFactory));
        HashSet<AFConstraint> newConstraints = new HashSet<AFConstraint>(10);
        while (!toProcess.isEmpty()) {
            newConstraints.clear();
            AFConstraint constraint = toProcess.remove();
            if (visited.contains(constraint)) continue;
            if (constraint.isIrreducible(targets)) {
                outgoing.add(constraint);
            } else {
                Iterator reducerIterator = reducers.iterator();
                boolean handled = false;
                while (!handled && reducerIterator.hasNext()) {
                    handled = ((AFReducer)reducerIterator.next()).reduce(constraint, newConstraints);
                }
                if (!handled) {
                    ErrorReporter.errorAbort("Unhandled constraint type: " + constraint.toString());
                }
                toProcess.addAll(newConstraints);
            }
            visited.add(constraint);
        }
    }

    protected Set<TUConstraint> afToTuConstraints(Set<? extends AFConstraint> afConstraints, Set<TypeVariable> targets) {
        LinkedHashSet<TUConstraint> outgoing = new LinkedHashSet<TUConstraint>();
        for (AFConstraint aFConstraint : afConstraints) {
            if (!aFConstraint.isIrreducible(targets)) {
                ErrorReporter.errorAbort("All afConstraints should be irreducible before conversion.\nafConstraints=[ " + PluginUtil.join(", ", afConstraints) + " ]\ntargets=[ " + PluginUtil.join(", ", targets) + "]");
            }
            outgoing.add(aFConstraint.toTUConstraint());
        }
        return outgoing;
    }

    public void addConstraintsBetweenTargets(Set<TUConstraint> constraints, Set<TypeVariable> targets, boolean asSubtype, AnnotatedTypeFactory typeFactory) {
        Types types = typeFactory.getProcessingEnv().getTypeUtils();
        LinkedList<TypeVariable> targetList = new LinkedList<TypeVariable>(targets);
        HashMap<TypeVariable, AnnotatedTypeMirror.AnnotatedTypeVariable> paramDeclarations = new HashMap<TypeVariable, AnnotatedTypeMirror.AnnotatedTypeVariable>();
        for (int i = 0; i < targetList.size(); ++i) {
            TypeVariable earlierTarget = (TypeVariable)targetList.get(i);
            for (int j = i + 1; j < targetList.size(); ++j) {
                AnnotatedTypeMirror.AnnotatedTypeVariable nextDecl;
                AnnotatedTypeMirror.AnnotatedTypeVariable headDecl;
                TypeVariable laterTarget = (TypeVariable)targetList.get(j);
                if (types.isSameType(earlierTarget.getUpperBound(), laterTarget)) {
                    headDecl = this.addOrGetDeclarations(earlierTarget, typeFactory, paramDeclarations);
                    nextDecl = this.addOrGetDeclarations(laterTarget, typeFactory, paramDeclarations);
                    if (asSubtype) {
                        constraints.add(new TSubU(headDecl, nextDecl));
                        continue;
                    }
                    constraints.add(new TSuperU(nextDecl, headDecl));
                    continue;
                }
                if (!types.isSameType(laterTarget.getUpperBound(), earlierTarget)) continue;
                headDecl = this.addOrGetDeclarations(earlierTarget, typeFactory, paramDeclarations);
                nextDecl = this.addOrGetDeclarations(laterTarget, typeFactory, paramDeclarations);
                if (asSubtype) {
                    constraints.add(new TSubU(nextDecl, headDecl));
                    continue;
                }
                constraints.add(new TSuperU(headDecl, nextDecl));
            }
        }
    }

    public AnnotatedTypeMirror.AnnotatedTypeVariable addOrGetDeclarations(TypeVariable target, AnnotatedTypeFactory typeFactory, Map<TypeVariable, AnnotatedTypeMirror.AnnotatedTypeVariable> declarations) {
        AnnotatedTypeMirror.AnnotatedTypeVariable atv = declarations.get(target);
        if (atv == null) {
            atv = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeFactory.getAnnotatedType(target.asElement());
            declarations.put(target, atv);
        }
        return atv;
    }
}

