/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util.attrs;

import java.util.List;
import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Label;
import org.objectweb.asm.attrs.StackMapAttribute;
import org.objectweb.asm.attrs.StackMapFrame;
import org.objectweb.asm.attrs.StackMapType;
import org.objectweb.asm.util.attrs.ASMifiable;
import org.objectweb.asm.util.attrs.Traceable;

public class ASMStackMapAttribute
extends StackMapAttribute
implements ASMifiable,
Traceable {
    private int len;

    public ASMStackMapAttribute() {
    }

    public ASMStackMapAttribute(List frames, int len) {
        super(frames);
        this.len = len;
    }

    @Override
    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        StackMapAttribute attr = (StackMapAttribute)super.read(cr, off, len, buf, codeOff, labels);
        return new ASMStackMapAttribute(attr.getFrames(), len);
    }

    @Override
    public void asmify(StringBuffer buf, String varName, Map labelNames) {
        List frames = this.getFrames();
        buf.append("{\n");
        buf.append("StackMapAttribute ").append(varName).append("Attr");
        buf.append(" = new StackMapAttribute();\n");
        if (frames.size() > 0) {
            for (int i = 0; i < frames.size(); ++i) {
                this.asmify((StackMapFrame)frames.get(i), buf, varName + "frame" + i, labelNames);
            }
        }
        buf.append(varName).append(".visitAttribute(").append(varName);
        buf.append("Attr);\n}\n");
    }

    void asmify(StackMapFrame f, StringBuffer buf, String varName, Map labelNames) {
        ASMStackMapAttribute.declareLabel(buf, labelNames, f.label);
        buf.append("{\n");
        buf.append("StackMapFrame ").append(varName).append(" = new StackMapFrame();\n");
        buf.append(varName).append(".label = ").append(labelNames.get(f.label)).append(";\n");
        this.asmifyTypeInfo(buf, varName, labelNames, f.locals, "locals");
        this.asmifyTypeInfo(buf, varName, labelNames, f.stack, "stack");
        buf.append("cvAttr.frames.add(").append(varName).append(");\n");
        buf.append("}\n");
    }

    void asmifyTypeInfo(StringBuffer buf, String varName, Map labelNames, List infos, String field) {
        if (infos.size() > 0) {
            buf.append("{\n");
            for (int i = 0; i < infos.size(); ++i) {
                StackMapType typeInfo = (StackMapType)infos.get(i);
                String localName = varName + "Info" + i;
                int type = typeInfo.getType();
                buf.append("StackMapType ").append(localName).append(" = StackMapType.getTypeInfo( StackMapType.ITEM_").append(StackMapType.ITEM_NAMES[type]).append(");\n");
                switch (type) {
                    case 7: {
                        buf.append(localName).append(".setObject(\"").append(typeInfo.getObject()).append("\");\n");
                        break;
                    }
                    case 8: {
                        ASMStackMapAttribute.declareLabel(buf, labelNames, typeInfo.getLabel());
                        buf.append(localName).append(".setLabel(").append(labelNames.get(typeInfo.getLabel())).append(");\n");
                    }
                }
                buf.append(varName).append(".").append(field).append(".add(").append(localName).append(");\n");
            }
            buf.append("}\n");
        }
    }

    static void declareLabel(StringBuffer buf, Map labelNames, Label l) {
        String name = (String)labelNames.get(l);
        if (name == null) {
            name = "l" + labelNames.size();
            labelNames.put(l, name);
            buf.append("Label ").append(name).append(" = new Label();\n");
        }
    }

    @Override
    public void trace(StringBuffer buf, Map labelNames) {
        List frames = this.getFrames();
        buf.append("[\n");
        for (int i = 0; i < frames.size(); ++i) {
            StackMapFrame f = (StackMapFrame)frames.get(i);
            buf.append("    Frame:");
            this.appendLabel(buf, labelNames, f.label);
            buf.append(" locals[");
            this.traceTypeInfo(buf, labelNames, f.locals);
            buf.append("]");
            buf.append(" stack[");
            this.traceTypeInfo(buf, labelNames, f.stack);
            buf.append("]\n");
        }
        buf.append("  ] length:").append(this.len).append("\n");
    }

    private void traceTypeInfo(StringBuffer buf, Map labelNames, List infos) {
        String sep = "";
        for (int i = 0; i < infos.size(); ++i) {
            StackMapType t = (StackMapType)infos.get(i);
            buf.append(sep).append(StackMapType.ITEM_NAMES[t.getType()]);
            sep = ", ";
            if (t.getType() == 7) {
                buf.append(":").append(t.getObject());
            }
            if (t.getType() != 8) continue;
            buf.append(":");
            this.appendLabel(buf, labelNames, t.getLabel());
        }
    }

    protected void appendLabel(StringBuffer buf, Map labelNames, Label l) {
        String name = (String)labelNames.get(l);
        if (name == null) {
            name = "L" + labelNames.size();
            labelNames.put(l, name);
        }
        buf.append(name);
    }
}

