/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import plume.EntryReader;
import plume.UtilMDE;

public final class BibtexClean {
    private static Pattern entry_end = Pattern.compile("^[ \t]*(?i)(year[ \t]*=[ \t]*[12][0-9][0-9][0-9][ \t]*)?[)}]");
    private static Pattern stringDef = Pattern.compile("^@(?i)string(\\{.*\\}|\\(.*\\))$");

    private BibtexClean() {
        throw new Error("do not instantiate");
    }

    public static void main(String[] args) {
        for (String filename : args) {
            File in = new File(filename);
            try (PrintWriter out = new PrintWriter(UtilMDE.bufferedFileWriter(in.getName()));
                 EntryReader er = new EntryReader(filename);){
                block21: for (String line : er) {
                    if (line.equals("") || line.startsWith("%")) {
                        out.println(line);
                        continue;
                    }
                    if (!line.startsWith("@")) continue;
                    if (stringDef.matcher(line).matches()) {
                        out.println(line);
                        continue;
                    }
                    out.println(line);
                    while (er.hasNext() && (line = er.next()) != null) {
                        out.println(line);
                        if (entry_end.matcher(line).lookingAt()) continue block21;
                        if (!line.equals("")) continue;
                        System.err.printf("%s:%d: unterminated entry%n", er.getFileName(), er.getLineNumber());
                        continue block21;
                    }
                }
            }
            catch (IOException e) {
                System.err.println("Problem reading or writing " + in + ": " + e.getMessage());
                System.exit(2);
            }
        }
    }
}

