/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index;

import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.javacutil.ErrorReporter;

public class IndexRefinementInfo {
    public Node left;
    public Node right;
    public AnnotationMirror leftAnno;
    public AnnotationMirror rightAnno;
    public CFStore thenStore;
    public CFStore elseStore;
    public ConditionalTransferResult<CFValue, CFStore> newResult;

    public IndexRefinementInfo(TransferResult<CFValue, CFStore> result, CFAbstractAnalysis<?, ?, ?> analysis, Node r, Node l) {
        this.right = r;
        this.left = l;
        if (analysis.getValue(this.right) == null || analysis.getValue(this.left) == null) {
            this.leftAnno = null;
            this.rightAnno = null;
            this.newResult = new ConditionalTransferResult<CFValue, CFStore>(result.getResultValue(), this.thenStore, this.elseStore);
        } else {
            QualifierHierarchy hierarchy = analysis.getTypeFactory().getQualifierHierarchy();
            this.rightAnno = IndexRefinementInfo.getAnno(((CFAbstractValue)analysis.getValue(this.right)).getAnnotations(), hierarchy);
            this.leftAnno = IndexRefinementInfo.getAnno(((CFAbstractValue)analysis.getValue(this.left)).getAnnotations(), hierarchy);
            this.thenStore = result.getThenStore();
            this.elseStore = result.getElseStore();
            this.newResult = new ConditionalTransferResult<CFValue, CFStore>(result.getResultValue(), this.thenStore, this.elseStore);
        }
    }

    public IndexRefinementInfo(TransferResult<CFValue, CFStore> result, CFAbstractAnalysis<?, ?, ?> analysis, BinaryOperationNode node) {
        this(result, analysis, node.getRightOperand(), node.getLeftOperand());
    }

    private static AnnotationMirror getAnno(Set<AnnotationMirror> set, QualifierHierarchy hierarchy) {
        if (set.size() == 1) {
            return set.iterator().next();
        }
        if (set.size() == 0) {
            return null;
        }
        Set<? extends AnnotationMirror> tops = hierarchy.getTopAnnotations();
        if (tops.size() != 1) {
            ErrorReporter.errorAbort(IndexRefinementInfo.class + ": Found multiple tops, but expected one. \nFound: %s", tops.toString());
            return null;
        }
        return hierarchy.findAnnotationInSameHierarchy(set, tops.iterator().next());
    }
}

