/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.lowerbound;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.checkerframework.checker.index.IndexMethodIdentifier;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.qual.GTENegativeOne;
import org.checkerframework.checker.index.qual.IndexFor;
import org.checkerframework.checker.index.qual.IndexOrHigh;
import org.checkerframework.checker.index.qual.IndexOrLow;
import org.checkerframework.checker.index.qual.LengthOf;
import org.checkerframework.checker.index.qual.LowerBoundBottom;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.NegativeIndexFor;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.PolyIndex;
import org.checkerframework.checker.index.qual.PolyLowerBound;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.index.qual.SubstringIndexFor;
import org.checkerframework.checker.index.searchindex.SearchIndexAnnotatedTypeFactory;
import org.checkerframework.checker.index.searchindex.SearchIndexChecker;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.util.Range;
import org.checkerframework.dataflow.cfg.node.NumericalMultiplicationNode;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class LowerBoundAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public final AnnotationMirror GTEN1;
    public final AnnotationMirror NN;
    public final AnnotationMirror POS;
    public final AnnotationMirror BOTTOM;
    public final AnnotationMirror UNKNOWN;
    public final AnnotationMirror POLY;
    private final IndexMethodIdentifier imf;

    public LowerBoundAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.GTEN1 = AnnotationBuilder.fromClass(this.elements, GTENegativeOne.class);
        this.NN = AnnotationBuilder.fromClass(this.elements, NonNegative.class);
        this.POS = AnnotationBuilder.fromClass(this.elements, Positive.class);
        this.BOTTOM = AnnotationBuilder.fromClass(this.elements, LowerBoundBottom.class);
        this.UNKNOWN = AnnotationBuilder.fromClass(this.elements, LowerBoundUnknown.class);
        this.POLY = AnnotationBuilder.fromClass(this.elements, PolyLowerBound.class);
        this.addAliasedAnnotation(IndexFor.class, this.NN);
        this.addAliasedAnnotation(IndexOrLow.class, this.GTEN1);
        this.addAliasedAnnotation(IndexOrHigh.class, this.NN);
        this.addAliasedAnnotation(LengthOf.class, this.NN);
        this.addAliasedAnnotation(PolyAll.class, this.POLY);
        this.addAliasedAnnotation(PolyIndex.class, this.POLY);
        this.addAliasedAnnotation(SubstringIndexFor.class, this.GTEN1);
        this.imf = new IndexMethodIdentifier(this);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(Positive.class, NonNegative.class, GTENegativeOne.class, LowerBoundUnknown.class, PolyLowerBound.class, LowerBoundBottom.class));
    }

    private void addLowerBoundTypeFromValueType(AnnotatedTypeMirror valueType, AnnotatedTypeMirror type) {
        AnnotationMirror anm = this.getLowerBoundAnnotationFromValueType(valueType);
        if (!type.isAnnotatedInHierarchy(this.UNKNOWN)) {
            if (!AnnotationUtils.areSameByClass(anm, LowerBoundUnknown.class)) {
                type.addAnnotation(anm);
            }
            return;
        }
        if (this.qualHierarchy.isSubtype(anm, type.getAnnotationInHierarchy(this.UNKNOWN))) {
            type.replaceAnnotation(anm);
        }
    }

    @Override
    public void addComputedTypeAnnotations(Element element, AnnotatedTypeMirror type) {
        super.addComputedTypeAnnotations(element, type);
        if (element != null) {
            AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(element);
            this.addLowerBoundTypeFromValueType(valueType, type);
        }
    }

    @Override
    public void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        super.addComputedTypeAnnotations(tree, type, iUseFlow);
        if (iUseFlow && tree != null && TreeUtils.isExpressionTree(tree)) {
            AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(tree);
            this.addLowerBoundTypeFromValueType(valueType, type);
        }
    }

    public ValueAnnotatedTypeFactory getValueAnnotatedTypeFactory() {
        return (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
    }

    public SearchIndexAnnotatedTypeFactory getSearchIndexAnnotatedTypeFactory() {
        return (SearchIndexAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(SearchIndexChecker.class);
    }

    private AnnotationMirror getLowerBoundAnnotationFromValueType(AnnotatedTypeMirror valueType) {
        Range possibleValues = IndexUtil.getPossibleValues(valueType, this.getValueAnnotatedTypeFactory());
        if (possibleValues == null) {
            if (AnnotationUtils.containsSameByClass(valueType.getAnnotations(), BottomVal.class)) {
                return this.BOTTOM;
            }
            return this.UNKNOWN;
        }
        long lvalMin = possibleValues.from;
        int valMin = (int)Math.max(Math.min(Integer.MAX_VALUE, lvalMin), Integer.MIN_VALUE);
        return this.anmFromVal(valMin);
    }

    AnnotationMirror anmFromVal(long val) {
        if (val >= 1L) {
            return this.POS;
        }
        if (val >= 0L) {
            return this.NN;
        }
        if (val >= -1L) {
            return this.GTEN1;
        }
        return this.UNKNOWN;
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new LowerBoundTreeAnnotator(this), super.createTreeAnnotator());
    }

    Integer getMinLenFromMemberSelectTree(MemberSelectTree tree) {
        if (TreeUtils.isArrayLengthAccess(tree)) {
            return IndexUtil.getMinLenFromTree(tree, this.getValueAnnotatedTypeFactory());
        }
        return null;
    }

    Integer getMinLenFromMethodInvocationTree(MethodInvocationTree tree) {
        if (this.imf.isLengthOfMethodInvocation(tree)) {
            return IndexUtil.getMinLenFromTree(tree, this.getValueAnnotatedTypeFactory());
        }
        return null;
    }

    AnnotationMirror checkForMathRandomSpecialCase(NumericalMultiplicationNode node) {
        AnnotationMirror forwardRes = this.checkForMathRandomSpecialCase(node.getLeftOperand().getTree(), node.getRightOperand().getTree());
        if (forwardRes != null) {
            return forwardRes;
        }
        AnnotationMirror backwardsRes = this.checkForMathRandomSpecialCase(node.getRightOperand().getTree(), node.getLeftOperand().getTree());
        if (backwardsRes != null) {
            return backwardsRes;
        }
        return null;
    }

    private AnnotationMirror checkForMathRandomSpecialCase(Tree randTree, Tree arrLenTree) {
        if (randTree.getKind() == Tree.Kind.METHOD_INVOCATION && TreeUtils.isArrayLengthAccess(arrLenTree)) {
            MethodInvocationTree miTree = (MethodInvocationTree)randTree;
            if (this.imf.isMathRandom(miTree, this.processingEnv)) {
                return this.NN;
            }
            if (this.imf.isRandomNextDouble(miTree, this.processingEnv)) {
                return this.NN;
            }
        }
        return null;
    }

    public boolean isNonNegative(Tree tree) {
        AnnotatedTypeMirror treeType = this.getAnnotatedType(tree);
        return treeType.hasAnnotation(NonNegative.class) || treeType.hasAnnotation(Positive.class);
    }

    private class LowerBoundTreeAnnotator
    extends TreeAnnotator {
        public LowerBoundTreeAnnotator(AnnotatedTypeFactory annotatedTypeFactory) {
            super(annotatedTypeFactory);
        }

        private void promoteType(AnnotatedTypeMirror typeSrc, AnnotatedTypeMirror typeDst) {
            if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
            } else if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
            } else if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            } else {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
        }

        private void demoteType(AnnotatedTypeMirror typeSrc, AnnotatedTypeMirror typeDst) {
            if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            } else if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1);
            } else {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
        }

        @Override
        public Void visitUnary(UnaryTree tree, AnnotatedTypeMirror typeDst) {
            AnnotatedTypeMirror typeSrc = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getExpression());
            switch (tree.getKind()) {
                case PREFIX_INCREMENT: {
                    this.promoteType(typeSrc, typeDst);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.demoteType(typeSrc, typeDst);
                    break;
                }
                case POSTFIX_INCREMENT: 
                case POSTFIX_DECREMENT: {
                    break;
                }
                case BITWISE_COMPLEMENT: {
                    this.handleBitWiseComplement(LowerBoundAnnotatedTypeFactory.this.getSearchIndexAnnotatedTypeFactory().getAnnotatedType(tree.getExpression()), typeDst);
                    break;
                }
            }
            return (Void)super.visitUnary(tree, typeDst);
        }

        private void handleBitWiseComplement(AnnotatedTypeMirror searchIndexType, AnnotatedTypeMirror typeDst) {
            if (AnnotationUtils.containsSameByClass(searchIndexType.getAnnotations(), NegativeIndexFor.class)) {
                typeDst.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            }
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            if (LowerBoundAnnotatedTypeFactory.this.imf.isMathMax(tree)) {
                ExpressionTree left = tree.getArguments().get(0);
                ExpressionTree right = tree.getArguments().get(1);
                type.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.qualHierarchy.greatestLowerBound(LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(left).getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS), LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(right).getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS)));
            }
            return (Void)super.visitMethodInvocation(tree, type);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
            Integer minLen = LowerBoundAnnotatedTypeFactory.this.getMinLenFromMemberSelectTree(tree);
            if (minLen != null) {
                type.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.anmFromVal(minLen.intValue()));
            }
            return (Void)super.visitMemberSelect(tree, type);
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
            return super.visitBinary(tree, type);
        }
    }
}

