/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.lock;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.lock.LockAnalysis;
import org.checkerframework.checker.lock.LockChecker;
import org.checkerframework.checker.lock.LockStore;
import org.checkerframework.checker.lock.LockTransfer;
import org.checkerframework.checker.lock.LockTreeAnnotator;
import org.checkerframework.checker.lock.LockVisitor;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.GuardedByUnknown;
import org.checkerframework.checker.lock.qual.LockHeld;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.lock.qual.LockingFree;
import org.checkerframework.checker.lock.qual.MayReleaseLocks;
import org.checkerframework.checker.lock.qual.ReleasesNoLocks;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.dataflow.util.PurityUtils;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.dependenttypes.DependentTypesError;
import org.checkerframework.framework.util.dependenttypes.DependentTypesHelper;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

public class LockAnnotatedTypeFactory
extends GenericAnnotatedTypeFactory<CFValue, LockStore, LockTransfer, LockAnalysis> {
    public static final String NOT_EFFECTIVELY_FINAL = "lock expression is not effectively final";
    protected final AnnotationMirror LOCKHELD;
    protected final AnnotationMirror LOCKPOSSIBLYHELD;
    protected final AnnotationMirror SIDEEFFECTFREE;
    protected final AnnotationMirror GUARDEDBYUNKNOWN;
    protected final AnnotationMirror GUARDEDBY;
    protected final AnnotationMirror GUARDEDBYBOTTOM;
    protected final AnnotationMirror GUARDSATISFIED;

    public LockAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker, true);
        this.LOCKHELD = AnnotationBuilder.fromClass(this.elements, LockHeld.class);
        this.LOCKPOSSIBLYHELD = AnnotationBuilder.fromClass(this.elements, LockPossiblyHeld.class);
        this.SIDEEFFECTFREE = AnnotationBuilder.fromClass(this.elements, SideEffectFree.class);
        this.GUARDEDBYUNKNOWN = AnnotationBuilder.fromClass(this.elements, GuardedByUnknown.class);
        this.GUARDEDBY = AnnotationBuilder.fromClass(this.elements, GuardedBy.class);
        this.GUARDEDBYBOTTOM = AnnotationBuilder.fromClass(this.elements, GuardedByBottom.class);
        this.GUARDSATISFIED = AnnotationBuilder.fromClass(this.elements, GuardSatisfied.class);
        this.addAliasedDeclAnnotation(LockingFree.class, SideEffectFree.class, this.SIDEEFFECTFREE);
        this.addAliasedDeclAnnotation(ReleasesNoLocks.class, SideEffectFree.class, this.SIDEEFFECTFREE);
        this.postInit();
    }

    @Override
    protected DependentTypesHelper createDependentTypesHelper() {
        return new DependentTypesHelper(this){

            @Override
            protected void reportErrors(Tree errorTree, List<DependentTypesError> errors) {
                ArrayList<DependentTypesError> superErrors = new ArrayList<DependentTypesError>();
                for (DependentTypesError error : errors) {
                    if (error.error.equals(LockAnnotatedTypeFactory.NOT_EFFECTIVELY_FINAL)) {
                        LockAnnotatedTypeFactory.this.checker.report(Result.failure("lock.expression.not.final", error.expression), errorTree);
                        continue;
                    }
                    superErrors.add(error);
                }
                super.reportErrors(errorTree, superErrors);
            }

            @Override
            protected String standardizeString(String expression, FlowExpressionParseUtil.FlowExpressionContext context, TreePath localScope, boolean useLocalScope) {
                if (DependentTypesError.isExpressionError(expression)) {
                    return expression;
                }
                if (LockVisitor.selfReceiverPattern.matcher(expression).matches()) {
                    return expression;
                }
                try {
                    FlowExpressions.Receiver result = FlowExpressionParseUtil.parse(expression, context, localScope, useLocalScope);
                    if (result == null) {
                        return new DependentTypesError(expression, " ").toString();
                    }
                    if (!LockAnnotatedTypeFactory.this.isExpressionEffectivelyFinal(result)) {
                        return new DependentTypesError(expression, LockAnnotatedTypeFactory.NOT_EFFECTIVELY_FINAL).toString();
                    }
                    return result.toString();
                }
                catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                    return new DependentTypesError(expression, e).toString();
                }
            }
        };
    }

    boolean isExpressionEffectivelyFinal(FlowExpressions.Receiver expr) {
        if (expr instanceof FlowExpressions.FieldAccess) {
            FlowExpressions.FieldAccess fieldAccess = (FlowExpressions.FieldAccess)expr;
            FlowExpressions.Receiver recv = fieldAccess.getReceiver();
            return fieldAccess.isFinal() && this.isExpressionEffectivelyFinal(recv);
        }
        if (expr instanceof FlowExpressions.LocalVariable) {
            return ElementUtils.isEffectivelyFinal(((FlowExpressions.LocalVariable)expr).getElement());
        }
        if (expr instanceof FlowExpressions.MethodCall) {
            FlowExpressions.MethodCall methodCall = (FlowExpressions.MethodCall)expr;
            for (FlowExpressions.Receiver param : methodCall.getParameters()) {
                if (this.isExpressionEffectivelyFinal(param)) continue;
                return false;
            }
            return PurityUtils.isDeterministic((AnnotationProvider)this, methodCall.getElement()) && this.isExpressionEffectivelyFinal(methodCall.getReceiver());
        }
        return expr instanceof FlowExpressions.ThisReference || expr instanceof FlowExpressions.ClassName;
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(LockHeld.class, LockPossiblyHeld.class, GuardedBy.class, GuardedByUnknown.class, GuardSatisfied.class, GuardedByBottom.class));
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new LockQualifierHierarchy(factory);
    }

    @Override
    protected LockAnalysis createFlowAnalysis(List<Pair<VariableElement, CFValue>> fieldValues) {
        return new LockAnalysis(this.checker, this, fieldValues);
    }

    @Override
    public LockTransfer createFlowTransferFunction(CFAbstractAnalysis<CFValue, LockStore, LockTransfer> analysis) {
        return new LockTransfer((LockAnalysis)analysis, (LockChecker)this.checker);
    }

    SideEffectAnnotation methodSideEffectAnnotation(Element element, boolean issueErrorIfMoreThanOnePresent) {
        if (element != null) {
            ArrayList<SideEffectAnnotation> sideEffectAnnotationPresent = new ArrayList<SideEffectAnnotation>();
            for (SideEffectAnnotation sea : SideEffectAnnotation.values()) {
                if (this.getDeclAnnotationNoAliases(element, sea.getAnnotationClass()) == null) continue;
                sideEffectAnnotationPresent.add(sea);
            }
            int count = sideEffectAnnotationPresent.size();
            if (count == 0) {
                return this.defaults.applyUncheckedCodeDefaults(element) ? SideEffectAnnotation.MAYRELEASELOCKS : SideEffectAnnotation.RELEASESNOLOCKS;
            }
            if (count <= 1 || issueErrorIfMoreThanOnePresent) {
                // empty if block
            }
            SideEffectAnnotation weakest = (SideEffectAnnotation)((Object)sideEffectAnnotationPresent.get(0));
            for (SideEffectAnnotation sea : sideEffectAnnotationPresent) {
                if (!sea.isWeakerThan(weakest)) continue;
                weakest = sea;
            }
            return weakest;
        }
        return SideEffectAnnotation.weakest();
    }

    int getGuardSatisfiedIndex(AnnotatedTypeMirror atm) {
        return this.getGuardSatisfiedIndex(atm.getAnnotation(GuardSatisfied.class));
    }

    int getGuardSatisfiedIndex(AnnotationMirror am) {
        return AnnotationUtils.getElementValue(am, "value", Integer.class, true);
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(ExpressionTree tree, ExecutableElement methodElt, AnnotatedTypeMirror receiverType) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.methodFromUse(tree, methodElt, receiverType);
        if (tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return mfuPair;
        }
        AnnotatedTypeMirror.AnnotatedExecutableType invokedMethod = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        if (invokedMethod.getElement().getKind() == ElementKind.CONSTRUCTOR) {
            return mfuPair;
        }
        AnnotatedTypeMirror methodDefinitionReturn = invokedMethod.getReturnType();
        if (methodDefinitionReturn == null || !methodDefinitionReturn.hasAnnotation(GuardSatisfied.class)) {
            return mfuPair;
        }
        int returnGuardSatisfiedIndex = this.getGuardSatisfiedIndex(methodDefinitionReturn);
        if (returnGuardSatisfiedIndex == -1) {
            return mfuPair;
        }
        if (!ElementUtils.isStatic(invokedMethod.getElement()) && this.replaceAnnotationInGuardedByHierarchyIfGuardSatisfiedIndexMatches(methodDefinitionReturn, invokedMethod.getReceiverType(), returnGuardSatisfiedIndex, receiverType.getAnnotationInHierarchy(this.GUARDEDBYUNKNOWN))) {
            return mfuPair;
        }
        List<? extends ExpressionTree> methodInvocationTreeArguments = ((MethodInvocationTree)tree).getArguments();
        List<AnnotatedTypeMirror> requiredArgs = AnnotatedTypes.expandVarArgs(this, invokedMethod, methodInvocationTreeArguments);
        for (int i = 0; i < requiredArgs.size(); ++i) {
            if (!this.replaceAnnotationInGuardedByHierarchyIfGuardSatisfiedIndexMatches(methodDefinitionReturn, requiredArgs.get(i), returnGuardSatisfiedIndex, this.getAnnotatedType(methodInvocationTreeArguments.get(i)).getEffectiveAnnotationInHierarchy(this.GUARDEDBYUNKNOWN))) continue;
            return mfuPair;
        }
        return mfuPair;
    }

    private boolean replaceAnnotationInGuardedByHierarchyIfGuardSatisfiedIndexMatches(AnnotatedTypeMirror methodReturnAtm, AnnotatedTypeMirror atm, int matchingGuardSatisfiedIndex, AnnotationMirror annotationInGuardedByHierarchy) {
        if (atm == null || !atm.hasAnnotation(GuardSatisfied.class) || this.getGuardSatisfiedIndex(atm) != matchingGuardSatisfiedIndex) {
            return false;
        }
        methodReturnAtm.replaceAnnotation(annotationInGuardedByHierarchy);
        return true;
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new LockTreeAnnotator(this), super.createTreeAnnotator());
    }

    @Override
    public void addComputedTypeAnnotations(Element elt, AnnotatedTypeMirror type) {
        this.translateJcipAndJavaxAnnotations(elt, type);
        super.addComputedTypeAnnotations(elt, type);
    }

    @Override
    public void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean useFlow) {
        if (tree.getKind() == Tree.Kind.VARIABLE) {
            this.translateJcipAndJavaxAnnotations(TreeUtils.elementFromTree((VariableTree)tree), type);
        }
        super.addComputedTypeAnnotations(tree, type, useFlow);
    }

    private void translateJcipAndJavaxAnnotations(Element element, AnnotatedTypeMirror atm) {
        List<String> lockExpressions;
        if (!element.getKind().isField()) {
            return;
        }
        AnnotationMirror anno = this.getDeclAnnotation(element, net.jcip.annotations.GuardedBy.class);
        if (anno == null) {
            anno = this.getDeclAnnotation(element, javax.annotation.concurrent.GuardedBy.class);
        }
        if (anno == null) {
            return;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> valmap = anno.getElementValues();
        Object value = null;
        for (ExecutableElement executableElement : valmap.keySet()) {
            if (!executableElement.getSimpleName().contentEquals("value")) continue;
            value = valmap.get(executableElement).getValue();
            break;
        }
        if (value instanceof List) {
            lockExpressions = AnnotationUtils.getElementValueArray(anno, "value", String.class, true);
        } else if (value instanceof String) {
            lockExpressions = Collections.singletonList((String)value);
        } else {
            return;
        }
        if (lockExpressions.isEmpty()) {
            atm.addAnnotation(this.GUARDEDBY);
        } else {
            atm.addAnnotation(this.createGuardedByAnnotationMirror(lockExpressions));
        }
    }

    private AnnotationMirror createGuardedByAnnotationMirror(List<String> values) {
        AnnotationBuilder builder = new AnnotationBuilder(this.getProcessingEnv(), GuardedBy.class);
        builder.setValue((CharSequence)"value", values.toArray());
        return builder.build();
    }

    static enum SideEffectAnnotation {
        MAYRELEASELOCKS("@MayReleaseLocks", MayReleaseLocks.class),
        RELEASESNOLOCKS("@ReleasesNoLocks", ReleasesNoLocks.class),
        LOCKINGFREE("@LockingFree", LockingFree.class),
        SIDEEFFECTFREE("@SideEffectFree", SideEffectFree.class),
        PURE("@Pure", Pure.class);

        final String annotation;
        final Class<? extends Annotation> annotationClass;
        static SideEffectAnnotation weakest;

        private SideEffectAnnotation(String annotation, Class<? extends Annotation> annotationClass) {
            this.annotation = annotation;
            this.annotationClass = annotationClass;
        }

        public String getNameOfSideEffectAnnotation() {
            return this.annotation;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }

        boolean isWeakerThan(SideEffectAnnotation other) {
            boolean weaker = false;
            block0 : switch (other) {
                case MAYRELEASELOCKS: {
                    break;
                }
                case RELEASESNOLOCKS: {
                    if (this != MAYRELEASELOCKS) break;
                    weaker = true;
                    break;
                }
                case LOCKINGFREE: {
                    switch (this) {
                        case MAYRELEASELOCKS: 
                        case RELEASESNOLOCKS: {
                            weaker = true;
                            break block0;
                        }
                    }
                    break;
                }
                case SIDEEFFECTFREE: {
                    switch (this) {
                        case MAYRELEASELOCKS: 
                        case RELEASESNOLOCKS: 
                        case LOCKINGFREE: {
                            weaker = true;
                            break block0;
                        }
                    }
                    break;
                }
                case PURE: {
                    switch (this) {
                        case MAYRELEASELOCKS: 
                        case RELEASESNOLOCKS: 
                        case LOCKINGFREE: 
                        case SIDEEFFECTFREE: {
                            weaker = true;
                            break block0;
                        }
                    }
                }
            }
            return weaker;
        }

        public static SideEffectAnnotation weakest() {
            if (weakest == null) {
                for (SideEffectAnnotation sea : SideEffectAnnotation.values()) {
                    if (weakest == null) {
                        weakest = sea;
                    }
                    if (!sea.isWeakerThan(weakest)) continue;
                    weakest = sea;
                }
            }
            return weakest;
        }

        static {
            weakest = null;
        }
    }

    class LockQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public LockQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
            super(f, LockAnnotatedTypeFactory.this.LOCKHELD);
        }

        boolean isGuardedBy(AnnotationMirror am) {
            return AnnotationUtils.areSameIgnoringValues(am, LockAnnotatedTypeFactory.this.GUARDEDBY);
        }

        boolean isGuardSatisfied(AnnotationMirror am) {
            return AnnotationUtils.areSameIgnoringValues(am, LockAnnotatedTypeFactory.this.GUARDSATISFIED);
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            boolean lhsIsGuardedBy = this.isGuardedBy(superAnno);
            boolean rhsIsGuardedBy = this.isGuardedBy(subAnno);
            if (lhsIsGuardedBy && rhsIsGuardedBy) {
                List<String> lhsValues = AnnotationUtils.getElementValueArray(superAnno, "value", String.class, true);
                List<String> rhsValues = AnnotationUtils.getElementValueArray(subAnno, "value", String.class, true);
                return rhsValues.containsAll(lhsValues) && lhsValues.containsAll(rhsValues);
            }
            boolean lhsIsGuardSatisfied = this.isGuardSatisfied(superAnno);
            boolean rhsIsGuardSatisfied = this.isGuardSatisfied(subAnno);
            if (lhsIsGuardSatisfied && rhsIsGuardSatisfied) {
                return AnnotationUtils.areSame(superAnno, subAnno);
            }
            if (lhsIsGuardedBy) {
                superAnno = LockAnnotatedTypeFactory.this.GUARDEDBY;
            } else if (lhsIsGuardSatisfied) {
                superAnno = LockAnnotatedTypeFactory.this.GUARDSATISFIED;
            }
            if (rhsIsGuardedBy) {
                subAnno = LockAnnotatedTypeFactory.this.GUARDEDBY;
            } else if (rhsIsGuardSatisfied) {
                subAnno = LockAnnotatedTypeFactory.this.GUARDSATISFIED;
            }
            return super.isSubtype(subAnno, superAnno);
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            AnnotationMirror a1top = this.getTopAnnotation(a1);
            AnnotationMirror a2top = this.getTopAnnotation(a2);
            if (AnnotationUtils.areSame(a1top, LockAnnotatedTypeFactory.this.LOCKPOSSIBLYHELD) && AnnotationUtils.areSame(a2top, LockAnnotatedTypeFactory.this.LOCKPOSSIBLYHELD)) {
                return this.greatestLowerBoundInLockPossiblyHeldHierarchy(a1, a2);
            }
            if (AnnotationUtils.areSame(a1top, LockAnnotatedTypeFactory.this.GUARDEDBYUNKNOWN) && AnnotationUtils.areSame(a2top, LockAnnotatedTypeFactory.this.GUARDEDBYUNKNOWN)) {
                return this.greatestLowerBoundInGuardedByUnknownHierarchy(a1, a2);
            }
            return null;
        }

        private AnnotationMirror greatestLowerBoundInGuardedByUnknownHierarchy(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.areSame(a1, LockAnnotatedTypeFactory.this.GUARDEDBYUNKNOWN)) {
                return a2;
            }
            if (AnnotationUtils.areSame(a2, LockAnnotatedTypeFactory.this.GUARDEDBYUNKNOWN)) {
                return a1;
            }
            if ((this.isGuardedBy(a1) && this.isGuardedBy(a2) || this.isGuardSatisfied(a1) && this.isGuardSatisfied(a2)) && this.isSubtype(a1, a2)) {
                return a1;
            }
            return LockAnnotatedTypeFactory.this.GUARDEDBYBOTTOM;
        }

        private AnnotationMirror greatestLowerBoundInLockPossiblyHeldHierarchy(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.areSame(a1, LockAnnotatedTypeFactory.this.LOCKPOSSIBLYHELD)) {
                return a2;
            }
            if (AnnotationUtils.areSame(a2, LockAnnotatedTypeFactory.this.LOCKPOSSIBLYHELD)) {
                return a1;
            }
            return LockAnnotatedTypeFactory.this.LOCKHELD;
        }
    }
}

