/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CastScanner;
import annotator.scanner.InstanceOfScanner;
import annotator.scanner.LambdaScanner;
import annotator.scanner.LocalVariableScanner;
import annotator.scanner.MethodCallScanner;
import annotator.scanner.NewScanner;
import com.sun.tools.javac.util.Pair;
import org.checkerframework.org.objectweb.asm.ClassReader;
import org.checkerframework.org.objectweb.asm.ClassWriter;
import org.checkerframework.org.objectweb.asm.Handle;
import org.checkerframework.org.objectweb.asm.Label;
import org.checkerframework.org.objectweb.asm.MethodAdapter;
import org.checkerframework.org.objectweb.asm.MethodVisitor;
import scenelib.annotations.io.classfile.CodeOffsetAdapter;

public class MethodOffsetClassVisitor
extends ClassWriter {
    CodeOffsetAdapter coa;
    MethodVisitor mcoa;
    private String methodName = "LocalVariableVisitor: DEFAULT_METHOD";

    public MethodOffsetClassVisitor(ClassReader cr) {
        super(true, false);
        this.coa = new CodeOffsetAdapter(cr);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.methodName = name + desc.substring(0, desc.indexOf(")") + 1);
        this.mcoa = this.coa.visitMethod(access, name, desc, signature, exceptions);
        return new MethodOffsetMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions));
    }

    private class MethodOffsetMethodVisitor
    extends MethodAdapter {
        private Label lastLabel;

        public MethodOffsetMethodVisitor(MethodVisitor mv) {
            super(mv);
            this.lastLabel = null;
        }

        private int labelOffset() {
            try {
                return this.lastLabel.getOffset();
            }
            catch (Exception ex) {
                return 0;
            }
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            super.visitLocalVariable(name, desc, signature, start, end, index);
            LocalVariableScanner.addToMethodNameIndexMap(Pair.of(MethodOffsetClassVisitor.this.methodName, Pair.of(index, start.getOffset())), name);
            LocalVariableScanner.addToMethodNameCounter(MethodOffsetClassVisitor.this.methodName, name, start.getOffset());
            MethodOffsetClassVisitor.this.mcoa.visitLocalVariable(name, desc, signature, start, end, index);
        }

        @Override
        public void visitLabel(Label label) {
            super.visitLabel(label);
            this.lastLabel = label;
            MethodOffsetClassVisitor.this.mcoa.visitLabel(label);
        }

        @Override
        public void visitTypeInsn(int opcode, String desc) {
            super.visitTypeInsn(opcode, desc);
            switch (opcode) {
                case 192: {
                    CastScanner.addCastToMethod(MethodOffsetClassVisitor.this.methodName, MethodOffsetClassVisitor.this.coa.getMethodCodeOffset());
                    break;
                }
                case 187: 
                case 189: {
                    NewScanner.addNewToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
                    break;
                }
                case 193: {
                    InstanceOfScanner.addInstanceOfToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset() + 1);
                }
            }
            MethodOffsetClassVisitor.this.mcoa.visitTypeInsn(opcode, desc);
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            super.visitMultiANewArrayInsn(desc, dims);
            NewScanner.addNewToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
            MethodOffsetClassVisitor.this.mcoa.visitMultiANewArrayInsn(desc, dims);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            super.visitIntInsn(opcode, operand);
            if (opcode == 188) {
                NewScanner.addNewToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
            }
            MethodOffsetClassVisitor.this.mcoa.visitIntInsn(opcode, operand);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            switch (opcode) {
                case 182: 
                case 184: 
                case 185: {
                    MethodCallScanner.addMethodCallToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
                    break;
                }
            }
            MethodOffsetClassVisitor.this.mcoa.visitMethodInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
            LambdaScanner.addLambdaExpressionToMethod(MethodOffsetClassVisitor.this.methodName, this.labelOffset());
            MethodOffsetClassVisitor.this.mcoa.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }

        @Override
        public void visitCode() {
            super.visitCode();
            MethodOffsetClassVisitor.this.mcoa.visitCode();
        }

        @Override
        public void visitInsn(int opcode) {
            super.visitInsn(opcode);
            MethodOffsetClassVisitor.this.mcoa.visitInsn(opcode);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var);
            MethodOffsetClassVisitor.this.mcoa.visitVarInsn(opcode, var);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            super.visitFieldInsn(opcode, owner, name, desc);
            MethodOffsetClassVisitor.this.mcoa.visitFieldInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            MethodOffsetClassVisitor.this.mcoa.visitJumpInsn(opcode, label);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            super.visitLdcInsn(cst);
            MethodOffsetClassVisitor.this.mcoa.visitLdcInsn(cst);
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            super.visitIincInsn(var, increment);
            MethodOffsetClassVisitor.this.mcoa.visitIincInsn(var, increment);
        }

        @Override
        public void visitTableSwitchInsn(int min2, int max, Label dflt, Label[] labels) {
            super.visitTableSwitchInsn(min2, max, dflt, labels);
            MethodOffsetClassVisitor.this.mcoa.visitTableSwitchInsn(min2, max, dflt, labels);
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            super.visitLookupSwitchInsn(dflt, keys, labels);
            MethodOffsetClassVisitor.this.mcoa.visitLookupSwitchInsn(dflt, keys, labels);
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            MethodOffsetClassVisitor.this.mcoa.visitEnd();
        }
    }
}

