/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.annotation;

import com.sun.istack.internal.tools.APTTypeVisitor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.Types;
import com.sun.tools.internal.ws.processor.modeler.annotation.TypeModeler;
import com.sun.tools.internal.ws.processor.modeler.annotation.WebServiceConstants;
import java.util.Collection;

public class MakeSafeTypeVisitor
extends APTTypeVisitor<TypeMirror, Types>
implements WebServiceConstants {
    TypeDeclaration collectionDecl;
    TypeDeclaration mapDecl;

    public MakeSafeTypeVisitor(AnnotationProcessorEnvironment apEnv) {
        this.collectionDecl = apEnv.getTypeDeclaration(COLLECTION_CLASSNAME);
        this.mapDecl = apEnv.getTypeDeclaration(MAP_CLASSNAME);
    }

    @Override
    protected TypeMirror onArrayType(ArrayType type, Types apTypes) {
        return apTypes.getErasure(type);
    }

    @Override
    protected TypeMirror onPrimitiveType(PrimitiveType type, Types apTypes) {
        return apTypes.getErasure(type);
    }

    @Override
    protected TypeMirror onClassType(ClassType type, Types apTypes) {
        return this.processDeclaredType(type, apTypes);
    }

    @Override
    protected TypeMirror onInterfaceType(InterfaceType type, Types apTypes) {
        return this.processDeclaredType(type, apTypes);
    }

    private TypeMirror processDeclaredType(DeclaredType type, Types apTypes) {
        if (TypeModeler.isSubtype(type.getDeclaration(), this.collectionDecl) || TypeModeler.isSubtype(type.getDeclaration(), this.mapDecl)) {
            Collection<TypeMirror> args = type.getActualTypeArguments();
            TypeMirror[] safeArgs = new TypeMirror[args.size()];
            int i = 0;
            for (TypeMirror arg : args) {
                safeArgs[i++] = (TypeMirror)this.apply(arg, apTypes);
            }
            return apTypes.getDeclaredType(type.getDeclaration(), safeArgs);
        }
        return apTypes.getErasure(type);
    }

    @Override
    protected TypeMirror onTypeVariable(TypeVariable type, Types apTypes) {
        return apTypes.getErasure(type);
    }

    @Override
    protected TypeMirror onVoidType(VoidType type, Types apTypes) {
        return type;
    }

    @Override
    protected TypeMirror onWildcard(WildcardType type, Types apTypes) {
        return apTypes.getErasure(type);
    }
}

