/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.inequality;

import com.sun.source.tree.Tree;
import java.util.List;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.index.inequality.LessThanAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.type.AnnotatedTypeMirror;

public class LessThanVisitor
extends BaseTypeVisitor<LessThanAnnotatedTypeFactory> {
    public LessThanVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey) {
        List<String> expressions = LessThanAnnotatedTypeFactory.getLessThanExpressions(varType.getEffectiveAnnotationInHierarchy(((LessThanAnnotatedTypeFactory)this.atypeFactory).UNKNOWN));
        if (expressions != null) {
            boolean isLessThan = true;
            for (String expression : expressions) {
                if (((LessThanAnnotatedTypeFactory)this.atypeFactory).isLessThanByValue(valueTree, expression, this.getCurrentPath())) continue;
                isLessThan = false;
            }
            if (isLessThan) {
                if (this.checker.hasOption("showchecks")) {
                    long valuePos = this.positions.getStartPosition(this.root, valueTree);
                    System.out.printf(" %s (line %3d): %s %s%n     actual: %s %s%n   expected: %s %s%n", new Object[]{"success: actual is subtype of expected", this.root.getLineMap() != null ? this.root.getLineMap().getLineNumber(valuePos) : -1L, valueTree.getKind(), valueTree, valueType.getKind(), valueType.toString(), varType.getKind(), varType.toString()});
                }
                return;
            }
        }
        super.commonAssignmentCheck(varType, valueType, valueTree, errorKey);
    }
}

