/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mirror.util;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.Modifier;
import java.util.ArrayList;
import java.util.Collection;

@Deprecated
public class DeclarationFilter {
    public static final DeclarationFilter FILTER_PUBLIC = new AccessFilter(Modifier.PUBLIC);
    public static final DeclarationFilter FILTER_PROTECTED = new AccessFilter(Modifier.PROTECTED);
    public static final DeclarationFilter FILTER_PUBLIC_OR_PROTECTED = new AccessFilter(Modifier.PUBLIC, Modifier.PROTECTED);
    public static final DeclarationFilter FILTER_PACKAGE = new AccessFilter();
    public static final DeclarationFilter FILTER_PRIVATE = new AccessFilter(Modifier.PRIVATE);

    public static DeclarationFilter getFilter(final Collection<Modifier> collection) {
        return new DeclarationFilter(){

            @Override
            public boolean matches(Declaration declaration) {
                return declaration.getModifiers().containsAll(collection);
            }
        };
    }

    public static DeclarationFilter getFilter(final Class<? extends Declaration> clazz) {
        return new DeclarationFilter(){

            @Override
            public boolean matches(Declaration declaration) {
                return clazz.isInstance(declaration);
            }
        };
    }

    public DeclarationFilter and(DeclarationFilter declarationFilter) {
        final DeclarationFilter declarationFilter2 = this;
        final DeclarationFilter declarationFilter3 = declarationFilter;
        return new DeclarationFilter(){

            @Override
            public boolean matches(Declaration declaration) {
                return declarationFilter2.matches(declaration) && declarationFilter3.matches(declaration);
            }
        };
    }

    public DeclarationFilter or(DeclarationFilter declarationFilter) {
        final DeclarationFilter declarationFilter2 = this;
        final DeclarationFilter declarationFilter3 = declarationFilter;
        return new DeclarationFilter(){

            @Override
            public boolean matches(Declaration declaration) {
                return declarationFilter2.matches(declaration) || declarationFilter3.matches(declaration);
            }
        };
    }

    public DeclarationFilter not() {
        return new DeclarationFilter(){

            @Override
            public boolean matches(Declaration declaration) {
                return !DeclarationFilter.this.matches(declaration);
            }
        };
    }

    public boolean matches(Declaration declaration) {
        return true;
    }

    public <D extends Declaration> Collection<D> filter(Collection<D> collection) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>(collection.size());
        for (Declaration declaration : collection) {
            if (!this.matches(declaration)) continue;
            arrayList.add(declaration);
        }
        return arrayList;
    }

    public <D extends Declaration> Collection<D> filter(Collection<? extends Declaration> collection, Class<D> clazz) {
        ArrayList<D> arrayList = new ArrayList<D>(collection.size());
        for (Declaration declaration : collection) {
            if (!clazz.isInstance(declaration) || !this.matches(declaration)) continue;
            arrayList.add(clazz.cast(declaration));
        }
        return arrayList;
    }

    private static class AccessFilter
    extends DeclarationFilter {
        private Modifier mod1 = null;
        private Modifier mod2 = null;

        AccessFilter() {
        }

        AccessFilter(Modifier modifier) {
            this.mod1 = modifier;
        }

        AccessFilter(Modifier modifier, Modifier modifier2) {
            this.mod1 = modifier;
            this.mod2 = modifier2;
        }

        @Override
        public boolean matches(Declaration declaration) {
            Collection<Modifier> collection = declaration.getModifiers();
            if (this.mod1 == null) {
                return !collection.contains((Object)Modifier.PUBLIC) && !collection.contains((Object)Modifier.PROTECTED) && !collection.contains((Object)Modifier.PRIVATE);
            }
            return collection.contains((Object)this.mod1) && (this.mod2 == null || collection.contains((Object)this.mod2));
        }
    }
}

