/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.formats.html.AbstractTreeWriter;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;

public class PackageTreeWriter
extends AbstractTreeWriter {
    protected PackageDoc packagedoc;
    protected PackageDoc prev;
    protected PackageDoc next;

    public PackageTreeWriter(ConfigurationImpl configurationImpl, String string, String string2, PackageDoc packageDoc, PackageDoc packageDoc2, PackageDoc packageDoc3) throws IOException {
        super(configurationImpl, string, string2, new ClassTree(configurationImpl.classDocCatalog.allClasses(packageDoc), (Configuration)configurationImpl), packageDoc);
        this.packagedoc = packageDoc;
        this.prev = packageDoc2;
        this.next = packageDoc3;
    }

    public static void generate(ConfigurationImpl configurationImpl, PackageDoc packageDoc, PackageDoc packageDoc2, PackageDoc packageDoc3, boolean bl) {
        String string = DirectoryManager.getDirectoryPath(packageDoc);
        String string2 = "package-tree.html";
        try {
            PackageTreeWriter packageTreeWriter = new PackageTreeWriter(configurationImpl, string, string2, packageDoc, packageDoc2, packageDoc3);
            packageTreeWriter.generatePackageTreeFile();
            packageTreeWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string2);
            throw new DocletAbortException();
        }
    }

    protected void generatePackageTreeFile() throws IOException {
        Content content = this.getPackageTreeHeader();
        Content content2 = this.getResource("doclet.Hierarchy_For_Package", Util.getPackageName(this.packagedoc));
        HtmlTree htmlTree = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, false, HtmlStyle.title, content2);
        HtmlTree htmlTree2 = HtmlTree.DIV(HtmlStyle.header, htmlTree);
        if (this.configuration.packages.length > 1) {
            this.addLinkToMainTree(htmlTree2);
        }
        content.addContent(htmlTree2);
        HtmlTree htmlTree3 = new HtmlTree(HtmlTag.DIV);
        htmlTree3.addStyle(HtmlStyle.contentContainer);
        this.addTree(this.classtree.baseclasses(), "doclet.Class_Hierarchy", htmlTree3);
        this.addTree(this.classtree.baseinterfaces(), "doclet.Interface_Hierarchy", htmlTree3);
        this.addTree(this.classtree.baseAnnotationTypes(), "doclet.Annotation_Type_Hierarchy", htmlTree3);
        this.addTree(this.classtree.baseEnums(), "doclet.Enum_Hierarchy", htmlTree3);
        content.addContent(htmlTree3);
        this.addNavLinks(false, content);
        this.addBottom(content);
        this.printHtmlDocument(null, true, content);
    }

    protected Content getPackageTreeHeader() {
        String string = this.packagedoc.name() + " " + this.configuration.getText("doclet.Window_Class_Hierarchy");
        HtmlTree htmlTree = this.getBody(true, this.getWindowTitle(string));
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        return htmlTree;
    }

    protected void addLinkToMainTree(Content content) {
        HtmlTree htmlTree = HtmlTree.SPAN(HtmlStyle.strong, this.getResource("doclet.Package_Hierarchies"));
        content.addContent(htmlTree);
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.UL);
        htmlTree2.addStyle(HtmlStyle.horizontal);
        htmlTree2.addContent(this.getNavLinkMainTree(this.configuration.getText("doclet.All_Packages")));
        content.addContent(htmlTree2);
    }

    @Override
    protected Content getNavLinkPrevious() {
        if (this.prev == null) {
            return this.getNavLinkPrevious(null);
        }
        String string = DirectoryManager.getRelativePath(this.packagedoc.name(), this.prev.name());
        return this.getNavLinkPrevious(string + "package-tree.html");
    }

    @Override
    protected Content getNavLinkNext() {
        if (this.next == null) {
            return this.getNavLinkNext(null);
        }
        String string = DirectoryManager.getRelativePath(this.packagedoc.name(), this.next.name());
        return this.getNavLinkNext(string + "package-tree.html");
    }

    @Override
    protected Content getNavLinkPackage() {
        Content content = this.getHyperLink("package-summary.html", "", this.packageLabel);
        HtmlTree htmlTree = HtmlTree.LI(content);
        return htmlTree;
    }
}

