/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html.markup;

import com.sun.tools.doclets.formats.html.markup.HtmlAttr;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HtmlTree
extends Content {
    private HtmlTag htmlTag;
    private Map<HtmlAttr, String> attrs = Collections.emptyMap();
    private List<Content> content = Collections.emptyList();
    public static final Content EMPTY;
    public static final BitSet NONENCODING_CHARS;

    public HtmlTree(HtmlTag htmlTag) {
        this.htmlTag = HtmlTree.nullCheck(htmlTag);
    }

    public HtmlTree(HtmlTag htmlTag, Content ... contentArray) {
        this(htmlTag);
        for (Content content : contentArray) {
            this.addContent(content);
        }
    }

    public void addAttr(HtmlAttr htmlAttr, String string) {
        if (this.attrs.isEmpty()) {
            this.attrs = new LinkedHashMap<HtmlAttr, String>();
        }
        this.attrs.put(HtmlTree.nullCheck(htmlAttr), HtmlTree.nullCheck(string));
    }

    public void addStyle(HtmlStyle htmlStyle) {
        this.addAttr(HtmlAttr.CLASS, htmlStyle.toString());
    }

    @Override
    public void addContent(Content content) {
        if (content == EMPTY || content.isValid()) {
            if (this.content.isEmpty()) {
                this.content = new ArrayList<Content>();
            }
            this.content.add(content);
        }
    }

    @Override
    public void addContent(String string) {
        if (!this.content.isEmpty()) {
            Content content = this.content.get(this.content.size() - 1);
            if (content instanceof StringContent) {
                content.addContent(string);
            } else {
                this.addContent(new StringContent(string));
            }
        } else {
            this.addContent(new StringContent(string));
        }
    }

    protected static String encodeURL(String string) {
        byte[] byArray = string.getBytes(Charset.forName("UTF-8"));
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (NONENCODING_CHARS.get(by & 0xFF)) {
                stringBuilder.append((char)by);
                continue;
            }
            stringBuilder.append(String.format("%%%02X", by & 0xFF));
        }
        return stringBuilder.toString();
    }

    public static HtmlTree A(String string, Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.A, HtmlTree.nullCheck(content));
        htmlTree.addAttr(HtmlAttr.HREF, HtmlTree.encodeURL(string));
        return htmlTree;
    }

    public static HtmlTree A_NAME(String string, Content content) {
        HtmlTree htmlTree = HtmlTree.A_NAME(string);
        htmlTree.addContent(HtmlTree.nullCheck(content));
        return htmlTree;
    }

    public static HtmlTree A_NAME(String string) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.A);
        htmlTree.addAttr(HtmlAttr.NAME, HtmlTree.nullCheck(string));
        return htmlTree;
    }

    public static HtmlTree CAPTION(Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.CAPTION, HtmlTree.nullCheck(content));
        return htmlTree;
    }

    public static HtmlTree CODE(Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.CODE, HtmlTree.nullCheck(content));
        return htmlTree;
    }

    public static HtmlTree DD(Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.DD, HtmlTree.nullCheck(content));
        return htmlTree;
    }

    public static HtmlTree DL(Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.DL, HtmlTree.nullCheck(content));
        return htmlTree;
    }

    public static HtmlTree DIV(HtmlStyle htmlStyle, Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.DIV, HtmlTree.nullCheck(content));
        if (htmlStyle != null) {
            htmlTree.addStyle(htmlStyle);
        }
        return htmlTree;
    }

    public static HtmlTree DIV(Content content) {
        return HtmlTree.DIV(null, content);
    }

    public static HtmlTree DT(Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.DT, HtmlTree.nullCheck(content));
        return htmlTree;
    }

    public static HtmlTree EM(Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.EM, HtmlTree.nullCheck(content));
        return htmlTree;
    }

    public static HtmlTree FRAME(String string, String string2, String string3, String string4) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.FRAME);
        htmlTree.addAttr(HtmlAttr.SRC, HtmlTree.nullCheck(string));
        htmlTree.addAttr(HtmlAttr.NAME, HtmlTree.nullCheck(string2));
        htmlTree.addAttr(HtmlAttr.TITLE, HtmlTree.nullCheck(string3));
        if (string4 != null) {
            htmlTree.addAttr(HtmlAttr.SCROLLING, string4);
        }
        return htmlTree;
    }

    public static HtmlTree FRAME(String string, String string2, String string3) {
        return HtmlTree.FRAME(string, string2, string3, null);
    }

    public static HtmlTree FRAMESET(String string, String string2, String string3, String string4) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.FRAMESET);
        if (string != null) {
            htmlTree.addAttr(HtmlAttr.COLS, string);
        }
        if (string2 != null) {
            htmlTree.addAttr(HtmlAttr.ROWS, string2);
        }
        htmlTree.addAttr(HtmlAttr.TITLE, HtmlTree.nullCheck(string3));
        htmlTree.addAttr(HtmlAttr.ONLOAD, HtmlTree.nullCheck(string4));
        return htmlTree;
    }

    public static HtmlTree HEADING(HtmlTag htmlTag, boolean bl, HtmlStyle htmlStyle, Content content) {
        HtmlTree htmlTree = new HtmlTree(htmlTag, HtmlTree.nullCheck(content));
        if (bl) {
            htmlTree.addAttr(HtmlAttr.TITLE, Util.stripHtml(content.toString()));
        }
        if (htmlStyle != null) {
            htmlTree.addStyle(htmlStyle);
        }
        return htmlTree;
    }

    public static HtmlTree HEADING(HtmlTag htmlTag, HtmlStyle htmlStyle, Content content) {
        return HtmlTree.HEADING(htmlTag, false, htmlStyle, content);
    }

    public static HtmlTree HEADING(HtmlTag htmlTag, boolean bl, Content content) {
        return HtmlTree.HEADING(htmlTag, bl, null, content);
    }

    public static HtmlTree HEADING(HtmlTag htmlTag, Content content) {
        return HtmlTree.HEADING(htmlTag, false, null, content);
    }

    public static HtmlTree HTML(String string, Content content, Content content2) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.HTML, HtmlTree.nullCheck(content), HtmlTree.nullCheck(content2));
        htmlTree.addAttr(HtmlAttr.LANG, HtmlTree.nullCheck(string));
        return htmlTree;
    }

    public static HtmlTree I(Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.I, HtmlTree.nullCheck(content));
        return htmlTree;
    }

    public static HtmlTree LI(Content content) {
        return HtmlTree.LI(null, content);
    }

    public static HtmlTree LI(HtmlStyle htmlStyle, Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.LI, HtmlTree.nullCheck(content));
        if (htmlStyle != null) {
            htmlTree.addStyle(htmlStyle);
        }
        return htmlTree;
    }

    public static HtmlTree LINK(String string, String string2, String string3, String string4) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.LINK);
        htmlTree.addAttr(HtmlAttr.REL, HtmlTree.nullCheck(string));
        htmlTree.addAttr(HtmlAttr.TYPE, HtmlTree.nullCheck(string2));
        htmlTree.addAttr(HtmlAttr.HREF, HtmlTree.nullCheck(string3));
        htmlTree.addAttr(HtmlAttr.TITLE, HtmlTree.nullCheck(string4));
        return htmlTree;
    }

    public static HtmlTree META(String string, String string2, String string3) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.META);
        String string4 = string2 + "; charset=" + string3;
        htmlTree.addAttr(HtmlAttr.HTTP_EQUIV, HtmlTree.nullCheck(string));
        htmlTree.addAttr(HtmlAttr.CONTENT, string4);
        return htmlTree;
    }

    public static HtmlTree META(String string, String string2) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.META);
        htmlTree.addAttr(HtmlAttr.NAME, HtmlTree.nullCheck(string));
        htmlTree.addAttr(HtmlAttr.CONTENT, HtmlTree.nullCheck(string2));
        return htmlTree;
    }

    public static HtmlTree NOSCRIPT(Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.NOSCRIPT, HtmlTree.nullCheck(content));
        return htmlTree;
    }

    public static HtmlTree P(Content content) {
        return HtmlTree.P(null, content);
    }

    public static HtmlTree P(HtmlStyle htmlStyle, Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.P, HtmlTree.nullCheck(content));
        if (htmlStyle != null) {
            htmlTree.addStyle(htmlStyle);
        }
        return htmlTree;
    }

    public static HtmlTree SMALL(Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.SMALL, HtmlTree.nullCheck(content));
        return htmlTree;
    }

    public static HtmlTree STRONG(Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.STRONG, HtmlTree.nullCheck(content));
        return htmlTree;
    }

    public static HtmlTree SPAN(Content content) {
        return HtmlTree.SPAN(null, content);
    }

    public static HtmlTree SPAN(HtmlStyle htmlStyle, Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.SPAN, HtmlTree.nullCheck(content));
        if (htmlStyle != null) {
            htmlTree.addStyle(htmlStyle);
        }
        return htmlTree;
    }

    public static HtmlTree TABLE(int n, int n2, String string, Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.TABLE, HtmlTree.nullCheck(content));
        htmlTree.addAttr(HtmlAttr.BORDER, Integer.toString(n));
        htmlTree.addAttr(HtmlAttr.WIDTH, Integer.toString(n2));
        htmlTree.addAttr(HtmlAttr.SUMMARY, HtmlTree.nullCheck(string));
        return htmlTree;
    }

    public static HtmlTree TABLE(HtmlStyle htmlStyle, int n, int n2, int n3, String string, Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.TABLE, HtmlTree.nullCheck(content));
        if (htmlStyle != null) {
            htmlTree.addStyle(htmlStyle);
        }
        htmlTree.addAttr(HtmlAttr.BORDER, Integer.toString(n));
        htmlTree.addAttr(HtmlAttr.CELLPADDING, Integer.toString(n2));
        htmlTree.addAttr(HtmlAttr.CELLSPACING, Integer.toString(n3));
        htmlTree.addAttr(HtmlAttr.SUMMARY, HtmlTree.nullCheck(string));
        return htmlTree;
    }

    public static HtmlTree TABLE(int n, int n2, int n3, String string, Content content) {
        return HtmlTree.TABLE(null, n, n2, n3, string, content);
    }

    public static HtmlTree TD(HtmlStyle htmlStyle, Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.TD, HtmlTree.nullCheck(content));
        if (htmlStyle != null) {
            htmlTree.addStyle(htmlStyle);
        }
        return htmlTree;
    }

    public static HtmlTree TD(Content content) {
        return HtmlTree.TD(null, content);
    }

    public static HtmlTree TH(HtmlStyle htmlStyle, String string, Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.TH, HtmlTree.nullCheck(content));
        if (htmlStyle != null) {
            htmlTree.addStyle(htmlStyle);
        }
        htmlTree.addAttr(HtmlAttr.SCOPE, HtmlTree.nullCheck(string));
        return htmlTree;
    }

    public static HtmlTree TH(String string, Content content) {
        return HtmlTree.TH(null, string, content);
    }

    public static HtmlTree TITLE(Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.TITLE, HtmlTree.nullCheck(content));
        return htmlTree;
    }

    public static HtmlTree TR(Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.TR, HtmlTree.nullCheck(content));
        return htmlTree;
    }

    public static HtmlTree UL(HtmlStyle htmlStyle, Content content) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.UL, HtmlTree.nullCheck(content));
        htmlTree.addStyle(HtmlTree.nullCheck(htmlStyle));
        return htmlTree;
    }

    @Override
    public boolean isEmpty() {
        return !this.hasContent() && !this.hasAttrs();
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    public boolean hasAttrs() {
        return !this.attrs.isEmpty();
    }

    public boolean hasAttr(HtmlAttr htmlAttr) {
        return this.attrs.containsKey((Object)htmlAttr);
    }

    @Override
    public boolean isValid() {
        switch (this.htmlTag) {
            case A: {
                return this.hasAttr(HtmlAttr.NAME) || this.hasAttr(HtmlAttr.HREF) && this.hasContent();
            }
            case BR: {
                return !this.hasContent() && (!this.hasAttrs() || this.hasAttr(HtmlAttr.CLEAR));
            }
            case FRAME: {
                return this.hasAttr(HtmlAttr.SRC) && !this.hasContent();
            }
            case HR: {
                return !this.hasContent();
            }
            case IMG: {
                return this.hasAttr(HtmlAttr.SRC) && this.hasAttr(HtmlAttr.ALT) && !this.hasContent();
            }
            case LINK: {
                return this.hasAttr(HtmlAttr.HREF) && !this.hasContent();
            }
            case META: {
                return this.hasAttr(HtmlAttr.CONTENT) && !this.hasContent();
            }
        }
        return this.hasContent();
    }

    public boolean isInline() {
        return this.htmlTag.blockType == HtmlTag.BlockType.INLINE;
    }

    @Override
    public void write(StringBuilder stringBuilder) {
        if (!this.isInline() && !this.endsWithNewLine(stringBuilder)) {
            stringBuilder.append(DocletConstants.NL);
        }
        String string = this.htmlTag.toString();
        stringBuilder.append("<");
        stringBuilder.append(string);
        Iterator<HtmlAttr> iterator = this.attrs.keySet().iterator();
        String string2 = "";
        while (iterator.hasNext()) {
            HtmlAttr htmlAttr = iterator.next();
            string2 = this.attrs.get((Object)htmlAttr);
            stringBuilder.append(" ");
            stringBuilder.append(htmlAttr.toString());
            if (string2.isEmpty()) continue;
            stringBuilder.append("=\"");
            stringBuilder.append(string2);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        for (Content content : this.content) {
            content.write(stringBuilder);
        }
        if (this.htmlTag.endTagRequired()) {
            stringBuilder.append("</");
            stringBuilder.append(string);
            stringBuilder.append(">");
        }
        if (!this.isInline()) {
            stringBuilder.append(DocletConstants.NL);
        }
    }

    static {
        int n;
        EMPTY = new StringContent("");
        NONENCODING_CHARS = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            NONENCODING_CHARS.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            NONENCODING_CHARS.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            NONENCODING_CHARS.set(n);
        }
        String string = ":/?#[]@!$&'()*+,;=";
        string = string + "-._~";
        for (int i = 0; i < string.length(); ++i) {
            NONENCODING_CHARS.set(string.charAt(i));
        }
    }
}

