/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveValueImpl;

public class IntegerValueImpl
extends PrimitiveValueImpl
implements IntegerValue {
    private int value;

    IntegerValueImpl(VirtualMachine virtualMachine, int n) {
        super(virtualMachine);
        this.value = n;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof IntegerValue) {
            return this.value == ((IntegerValue)object).value() && super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.intValue();
    }

    @Override
    public int compareTo(IntegerValue integerValue) {
        int n = integerValue.value();
        return this.value() < n ? -1 : (this.value() == n ? 0 : 1);
    }

    @Override
    public Type type() {
        return this.vm.theIntegerType();
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127 || this.value < -128) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    @Override
    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535 || this.value < 0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    @Override
    short checkedShortValue() throws InvalidTypeException {
        if (this.value > Short.MAX_VALUE || this.value < Short.MIN_VALUE) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    byte typeValueKey() {
        return 73;
    }
}

