/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.JDIPermission;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.connect.spi.TransportService;
import com.sun.tools.jdi.GenericAttachingConnector;
import com.sun.tools.jdi.GenericListeningConnector;
import com.sun.tools.jdi.VirtualMachineImpl;
import com.sun.tools.jdi.VirtualMachineManagerService;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.ServiceLoader;

public class VirtualMachineManagerImpl
implements VirtualMachineManagerService {
    private List<Connector> connectors = new ArrayList<Connector>();
    private LaunchingConnector defaultConnector = null;
    private List<VirtualMachine> targets = new ArrayList<VirtualMachine>();
    private final ThreadGroup mainGroupForJDI;
    private ResourceBundle messages = null;
    private int vmSequenceNumber = 0;
    private static final int majorVersion = 1;
    private static final int minorVersion = 6;
    private static final Object lock = new Object();
    private static VirtualMachineManagerImpl vmm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VirtualMachineManager virtualMachineManager() {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new JDIPermission("virtualMachineManager");
            securityManager.checkPermission((Permission)object);
        }
        object = lock;
        synchronized (object) {
            if (vmm == null) {
                vmm = new VirtualMachineManagerImpl();
            }
        }
        return vmm;
    }

    protected VirtualMachineManagerImpl() {
        Object object;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup2 = null;
        while ((threadGroup2 = threadGroup.getParent()) != null) {
            threadGroup = threadGroup2;
        }
        this.mainGroupForJDI = new ThreadGroup(threadGroup, "JDI main");
        ServiceLoader<Connector> serviceLoader = ServiceLoader.load(Connector.class, Connector.class.getClassLoader());
        Iterator<Connector> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                object = iterator.next();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Exception exception) {
                System.err.println(exception);
                continue;
            }
            catch (Error error) {
                System.err.println(error);
                continue;
            }
            this.addConnector((Connector)object);
        }
        object = ServiceLoader.load(TransportService.class, TransportService.class.getClassLoader());
        Iterator iterator2 = ((ServiceLoader)object).iterator();
        while (iterator2.hasNext()) {
            TransportService transportService;
            try {
                transportService = (TransportService)iterator2.next();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Exception exception) {
                System.err.println(exception);
                continue;
            }
            catch (Error error) {
                System.err.println(error);
                continue;
            }
            this.addConnector(GenericAttachingConnector.create(transportService));
            this.addConnector(GenericListeningConnector.create(transportService));
        }
        if (this.allConnectors().size() == 0) {
            throw new Error("no Connectors loaded");
        }
        boolean bl = false;
        List<LaunchingConnector> list = this.launchingConnectors();
        for (LaunchingConnector launchingConnector : list) {
            if (!launchingConnector.name().equals("com.sun.jdi.CommandLineLaunch")) continue;
            this.setDefaultConnector(launchingConnector);
            bl = true;
            break;
        }
        if (!bl && list.size() > 0) {
            this.setDefaultConnector(list.get(0));
        }
    }

    @Override
    public LaunchingConnector defaultConnector() {
        if (this.defaultConnector == null) {
            throw new Error("no default LaunchingConnector");
        }
        return this.defaultConnector;
    }

    @Override
    public void setDefaultConnector(LaunchingConnector launchingConnector) {
        this.defaultConnector = launchingConnector;
    }

    @Override
    public List<LaunchingConnector> launchingConnectors() {
        ArrayList<LaunchingConnector> arrayList = new ArrayList<LaunchingConnector>(this.connectors.size());
        for (Connector connector : this.connectors) {
            if (!(connector instanceof LaunchingConnector)) continue;
            arrayList.add((LaunchingConnector)connector);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<AttachingConnector> attachingConnectors() {
        ArrayList<AttachingConnector> arrayList = new ArrayList<AttachingConnector>(this.connectors.size());
        for (Connector connector : this.connectors) {
            if (!(connector instanceof AttachingConnector)) continue;
            arrayList.add((AttachingConnector)connector);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<ListeningConnector> listeningConnectors() {
        ArrayList<ListeningConnector> arrayList = new ArrayList<ListeningConnector>(this.connectors.size());
        for (Connector connector : this.connectors) {
            if (!(connector instanceof ListeningConnector)) continue;
            arrayList.add((ListeningConnector)connector);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<Connector> allConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    @Override
    public List<VirtualMachine> connectedVirtualMachines() {
        return Collections.unmodifiableList(this.targets);
    }

    @Override
    public void addConnector(Connector connector) {
        this.connectors.add(connector);
    }

    @Override
    public void removeConnector(Connector connector) {
        this.connectors.remove(connector);
    }

    @Override
    public synchronized VirtualMachine createVirtualMachine(Connection connection, Process process) throws IOException {
        VirtualMachineImpl virtualMachineImpl;
        if (!connection.isOpen()) {
            throw new IllegalStateException("connection is not open");
        }
        try {
            virtualMachineImpl = new VirtualMachineImpl(this, connection, process, ++this.vmSequenceNumber);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new IOException(vMDisconnectedException.getMessage());
        }
        this.targets.add(virtualMachineImpl);
        return virtualMachineImpl;
    }

    @Override
    public VirtualMachine createVirtualMachine(Connection connection) throws IOException {
        return this.createVirtualMachine(connection, null);
    }

    public void addVirtualMachine(VirtualMachine virtualMachine) {
        this.targets.add(virtualMachine);
    }

    void disposeVirtualMachine(VirtualMachine virtualMachine) {
        this.targets.remove(virtualMachine);
    }

    @Override
    public int majorInterfaceVersion() {
        return 1;
    }

    @Override
    public int minorInterfaceVersion() {
        return 6;
    }

    ThreadGroup mainGroupForJDI() {
        return this.mainGroupForJDI;
    }

    String getString(String string) {
        if (this.messages == null) {
            this.messages = ResourceBundle.getBundle("com.sun.tools.jdi.resources.jdi");
        }
        return this.messages.getString(string);
    }
}

