/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.binary;

import com.sun.xml.internal.rngom.binary.Alphabet;
import com.sun.xml.internal.rngom.binary.BinaryPattern;
import com.sun.xml.internal.rngom.binary.DuplicateAttributeDetector;
import com.sun.xml.internal.rngom.binary.Pattern;
import com.sun.xml.internal.rngom.binary.RestrictionViolationException;
import com.sun.xml.internal.rngom.binary.SchemaPatternBuilder;
import com.sun.xml.internal.rngom.binary.visitor.PatternFunction;
import com.sun.xml.internal.rngom.binary.visitor.PatternVisitor;

public class InterleavePattern
extends BinaryPattern {
    InterleavePattern(Pattern p1, Pattern p2) {
        super(p1.isNullable() && p2.isNullable(), InterleavePattern.combineHashCode(17, p1.hashCode(), p2.hashCode()), p1, p2);
    }

    @Override
    Pattern expand(SchemaPatternBuilder b) {
        Pattern ep1 = this.p1.expand(b);
        Pattern ep2 = this.p2.expand(b);
        if (ep1 != this.p1 || ep2 != this.p2) {
            return b.makeInterleave(ep1, ep2);
        }
        return this;
    }

    @Override
    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        switch (context) {
            case 0: {
                throw new RestrictionViolationException("start_contains_interleave");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_interleave");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_interleave");
            }
        }
        if (context == 2) {
            context = 4;
        }
        Alphabet a1 = alpha != null && alpha.isEmpty() ? alpha : new Alphabet();
        this.p1.checkRestrictions(context, dad, a1);
        if (a1.isEmpty()) {
            this.p2.checkRestrictions(context, dad, a1);
        } else {
            Alphabet a2 = new Alphabet();
            this.p2.checkRestrictions(context, dad, a2);
            a1.checkOverlap(a2);
            if (alpha != null) {
                if (alpha != a1) {
                    alpha.addAlphabet(a1);
                }
                alpha.addAlphabet(a2);
            }
        }
        if (context != 6 && !InterleavePattern.contentTypeGroupable(this.p1.getContentType(), this.p2.getContentType())) {
            throw new RestrictionViolationException("interleave_string");
        }
        if (this.p1.getContentType() == 2 && this.p2.getContentType() == 2) {
            throw new RestrictionViolationException("interleave_text_overlap");
        }
    }

    @Override
    public void accept(PatternVisitor visitor) {
        visitor.visitInterleave(this.p1, this.p2);
    }

    @Override
    public Object apply(PatternFunction f) {
        return f.caseInterleave(this);
    }
}

