/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.binary;

import com.sun.xml.internal.rngom.binary.Pattern;

final class PatternInterner {
    private static final int INIT_SIZE = 256;
    private static final float LOAD_FACTOR = 0.3f;
    private Pattern[] table;
    private int used;
    private int usedLimit;

    PatternInterner() {
        this.table = null;
        this.used = 0;
        this.usedLimit = 0;
    }

    PatternInterner(PatternInterner parent) {
        this.table = parent.table;
        if (this.table != null) {
            this.table = (Pattern[])this.table.clone();
        }
        this.used = parent.used;
        this.usedLimit = parent.usedLimit;
    }

    Pattern intern(Pattern p) {
        int h2;
        if (this.table == null) {
            this.table = new Pattern[256];
            this.usedLimit = 76;
            h2 = this.firstIndex(p);
        } else {
            h2 = this.firstIndex(p);
            while (this.table[h2] != null) {
                if (p.samePattern(this.table[h2])) {
                    return this.table[h2];
                }
                h2 = this.nextIndex(h2);
            }
        }
        if (this.used >= this.usedLimit) {
            Pattern[] oldTable = this.table;
            this.table = new Pattern[this.table.length << 1];
            int i = oldTable.length;
            while (i > 0) {
                if (oldTable[--i] == null) continue;
                int j = this.firstIndex(oldTable[i]);
                while (this.table[j] != null) {
                    j = this.nextIndex(j);
                }
                this.table[j] = oldTable[i];
            }
            h2 = this.firstIndex(p);
            while (this.table[h2] != null) {
                h2 = this.nextIndex(h2);
            }
            this.usedLimit = (int)((float)this.table.length * 0.3f);
        }
        ++this.used;
        this.table[h2] = p;
        return p;
    }

    private int firstIndex(Pattern p) {
        return p.patternHashCode() & this.table.length - 1;
    }

    private int nextIndex(int i) {
        return i == 0 ? this.table.length - 1 : i - 1;
    }
}

