/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.VariableTree;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.nullness.KeyForAnnotatedTypeFactory;
import org.checkerframework.checker.nullness.KeyForPropagator;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.javacutil.TreeUtils;

public class KeyForPropagationTreeAnnotator
extends TreeAnnotator {
    private final KeyForPropagator keyForPropagator;
    private final ExecutableElement keySetMethod;

    public KeyForPropagationTreeAnnotator(AnnotatedTypeFactory atypeFactory, KeyForPropagator propagationTreeAnnotator) {
        super(atypeFactory);
        this.keyForPropagator = propagationTreeAnnotator;
        this.keySetMethod = TreeUtils.getMethod(Map.class.getName(), "keySet", 0, atypeFactory.getProcessingEnv());
    }

    public boolean isCallToKeyset(ExpressionTree expression) {
        if (expression instanceof MethodInvocationTree) {
            return TreeUtils.isMethodInvocation(expression, this.keySetMethod, this.atypeFactory.getProcessingEnv());
        }
        return false;
    }

    @Override
    public Void visitVariable(VariableTree variableTree, AnnotatedTypeMirror type) {
        ExpressionTree initializer;
        super.visitVariable(variableTree, type);
        if (type.getKind() == TypeKind.DECLARED && this.isCallToKeyset(initializer = variableTree.getInitializer())) {
            AnnotatedTypeMirror.AnnotatedDeclaredType variableType = (AnnotatedTypeMirror.AnnotatedDeclaredType)type;
            AnnotatedTypeMirror initializerType = this.atypeFactory.getAnnotatedType(initializer);
            if (variableType.getKind() == TypeKind.DECLARED) {
                this.keyForPropagator.propagate((AnnotatedTypeMirror.AnnotatedDeclaredType)initializerType, variableType, KeyForPropagator.PropagationDirection.TO_SUPERTYPE, this.atypeFactory);
            }
        }
        return null;
    }

    @Override
    public Void visitNewClass(NewClassTree node, AnnotatedTypeMirror type) {
        this.keyForPropagator.propagateNewClassTree(node, type, (KeyForAnnotatedTypeFactory)this.atypeFactory);
        return (Void)super.visitNewClass(node, type);
    }
}

