/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.type.AnnotatedTypeFormatter;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.AnnotatedTypeVisitor;
import org.checkerframework.framework.util.AnnotationFormatter;
import org.checkerframework.framework.util.DefaultAnnotationFormatter;
import org.checkerframework.javacutil.PluginUtil;
import org.checkerframework.javacutil.TypeAnnotationUtils;

public class DefaultAnnotatedTypeFormatter
implements AnnotatedTypeFormatter {
    protected final FormattingVisitor formattingVisitor;

    public DefaultAnnotatedTypeFormatter() {
        this(new DefaultAnnotationFormatter(), true, false);
    }

    public DefaultAnnotatedTypeFormatter(boolean printVerboseGenerics, boolean defaultPrintInvisibleAnnos) {
        this(new DefaultAnnotationFormatter(), printVerboseGenerics, defaultPrintInvisibleAnnos);
    }

    public DefaultAnnotatedTypeFormatter(AnnotationFormatter formatter, boolean printVerboseGenerics, boolean defaultPrintInvisibleAnnos) {
        this(new FormattingVisitor(formatter, printVerboseGenerics, defaultPrintInvisibleAnnos));
    }

    protected DefaultAnnotatedTypeFormatter(FormattingVisitor visitor) {
        this.formattingVisitor = visitor;
    }

    @Override
    public String format(AnnotatedTypeMirror type) {
        this.formattingVisitor.resetPrintVerboseSettings();
        return this.formattingVisitor.visit(type);
    }

    @Override
    public String format(AnnotatedTypeMirror type, boolean printVerbose) {
        this.formattingVisitor.setVerboseSettings(printVerbose);
        return this.formattingVisitor.visit(type);
    }

    protected static class FormattingVisitor
    implements AnnotatedTypeVisitor<String, Set<AnnotatedTypeMirror>> {
        protected final AnnotationFormatter annoFormatter;
        protected final boolean defaultInvisiblesSetting;
        protected boolean currentPrintInvisibleSetting;
        protected final boolean defaultPrintVerboseGenerics;
        protected boolean currentPrintVerboseGenerics;

        public FormattingVisitor(AnnotationFormatter annoFormatter, boolean printVerboseGenerics, boolean defaultInvisiblesSetting) {
            this.annoFormatter = annoFormatter;
            this.defaultPrintVerboseGenerics = printVerboseGenerics;
            this.currentPrintVerboseGenerics = printVerboseGenerics;
            this.defaultInvisiblesSetting = defaultInvisiblesSetting;
            this.currentPrintInvisibleSetting = false;
        }

        protected void setVerboseSettings(boolean printVerbose) {
            this.currentPrintInvisibleSetting = printVerbose;
            this.currentPrintVerboseGenerics = printVerbose;
        }

        protected void resetPrintVerboseSettings() {
            this.currentPrintInvisibleSetting = this.defaultInvisiblesSetting;
            this.currentPrintVerboseGenerics = this.defaultPrintVerboseGenerics;
        }

        @SideEffectFree
        protected void printBound(String keyWord, AnnotatedTypeMirror field, Set<AnnotatedTypeMirror> visiting, StringBuilder sb) {
            if (!(this.currentPrintVerboseGenerics || field != null && field.getKind() != TypeKind.NULL)) {
                return;
            }
            sb.append(" ");
            sb.append(keyWord);
            sb.append(" ");
            if (field == null) {
                sb.append("<null>");
            } else if (field.getKind() != TypeKind.NULL) {
                sb.append(this.visit(field, visiting));
            } else {
                sb.append(this.annoFormatter.formatAnnotationString(field.getAnnotations(), this.currentPrintInvisibleSetting));
                sb.append("Void");
            }
        }

        @Override
        @SideEffectFree
        public String visit(AnnotatedTypeMirror type) {
            return type.accept(this, Collections.newSetFromMap(new IdentityHashMap()));
        }

        @Override
        public String visit(AnnotatedTypeMirror type, Set<AnnotatedTypeMirror> annotatedTypeVariables) {
            return type.accept(this, annotatedTypeVariables);
        }

        @Override
        public String visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Set<AnnotatedTypeMirror> visiting) {
            List<AnnotatedTypeMirror> typeArgs;
            Element typeElt;
            String smpl;
            StringBuilder sb = new StringBuilder();
            if (type.isDeclaration() && this.currentPrintInvisibleSetting) {
                sb.append("/*DECL*/ ");
            }
            if (type.getEnclosingType() != null) {
                sb.append(this.visit((AnnotatedTypeMirror)type.getEnclosingType(), visiting));
                sb.append('.');
            }
            if ((smpl = (typeElt = type.getUnderlyingType().asElement()).getSimpleName().toString()).isEmpty()) {
                smpl = typeElt.toString();
            }
            sb.append(this.annoFormatter.formatAnnotationString(type.getAnnotations(), this.currentPrintInvisibleSetting));
            sb.append(smpl);
            if (type.typeArgs != null && !(typeArgs = type.typeArgs).isEmpty()) {
                sb.append("<");
                boolean isFirst = true;
                for (AnnotatedTypeMirror typeArg : typeArgs) {
                    if (!isFirst) {
                        sb.append(", ");
                    }
                    sb.append(this.visit(typeArg, visiting));
                    isFirst = false;
                }
                sb.append(">");
            }
            return sb.toString();
        }

        @Override
        public String visitIntersection(AnnotatedTypeMirror.AnnotatedIntersectionType type, Set<AnnotatedTypeMirror> visiting) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (AnnotatedTypeMirror.AnnotatedDeclaredType adt : type.directSuperTypes()) {
                if (!isFirst) {
                    sb.append(" & ");
                }
                sb.append(this.visit((AnnotatedTypeMirror)adt, visiting));
                isFirst = false;
            }
            return sb.toString();
        }

        @Override
        public String visitUnion(AnnotatedTypeMirror.AnnotatedUnionType type, Set<AnnotatedTypeMirror> visiting) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (AnnotatedTypeMirror.AnnotatedDeclaredType adt : type.getAlternatives()) {
                if (!isFirst) {
                    sb.append(" | ");
                }
                sb.append(this.visit((AnnotatedTypeMirror)adt, visiting));
                isFirst = false;
            }
            return sb.toString();
        }

        @Override
        public String visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, Set<AnnotatedTypeMirror> visiting) {
            StringBuilder sb = new StringBuilder();
            if (!type.getTypeVariables().isEmpty()) {
                sb.append('<');
                ArrayList<String> typeVars = new ArrayList<String>(type.getTypeVariables().size());
                for (AnnotatedTypeMirror.AnnotatedTypeVariable annotatedTypeVariable : type.getTypeVariables()) {
                    typeVars.add(this.visit((AnnotatedTypeMirror)annotatedTypeVariable, visiting));
                }
                sb.append(PluginUtil.join(", ", typeVars));
                sb.append("> ");
            }
            if (type.getReturnType() != null) {
                sb.append(this.visit(type.getReturnType(), visiting));
            } else {
                sb.append("<UNKNOWNRETURN>");
            }
            sb.append(' ');
            if (type.getElement() != null) {
                sb.append(type.getElement().getSimpleName());
            } else {
                sb.append("METHOD");
            }
            sb.append('(');
            AnnotatedTypeMirror.AnnotatedDeclaredType rcv = type.getReceiverType();
            if (rcv != null) {
                sb.append(this.visit((AnnotatedTypeMirror)rcv, visiting));
                sb.append(" this");
            }
            if (!type.getParameterTypes().isEmpty()) {
                int p = 0;
                for (AnnotatedTypeMirror atm : type.getParameterTypes()) {
                    if (rcv != null || p > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.visit(atm, visiting));
                    sb.append(" p");
                    sb.append(p++);
                }
            }
            sb.append(')');
            if (!type.getThrownTypes().isEmpty()) {
                sb.append(" throws ");
                for (AnnotatedTypeMirror annotatedTypeMirror : type.getThrownTypes()) {
                    sb.append(this.visit(annotatedTypeMirror, visiting));
                }
            }
            return sb.toString();
        }

        @Override
        public String visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, Set<AnnotatedTypeMirror> visiting) {
            AnnotatedTypeMirror component;
            StringBuilder sb = new StringBuilder();
            AnnotatedTypeMirror.AnnotatedArrayType array = type;
            while (true) {
                component = array.getComponentType();
                if (array.getAnnotations().size() > 0) {
                    sb.append(' ');
                    sb.append(this.annoFormatter.formatAnnotationString(array.getAnnotations(), this.currentPrintInvisibleSetting));
                }
                sb.append("[]");
                if (!(component instanceof AnnotatedTypeMirror.AnnotatedArrayType)) break;
                array = (AnnotatedTypeMirror.AnnotatedArrayType)component;
            }
            sb.insert(0, this.visit(component, visiting));
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, Set<AnnotatedTypeMirror> visiting) {
            StringBuilder sb = new StringBuilder();
            sb.append(type.actualType);
            if (!visiting.contains(type)) {
                if (type.isDeclaration() && this.currentPrintInvisibleSetting) {
                    sb.append("/*DECL*/ ");
                }
                try {
                    visiting.add(type);
                    if (this.currentPrintVerboseGenerics) {
                        sb.append("[");
                    }
                    this.printBound("extends", type.getUpperBoundField(), visiting, sb);
                    this.printBound("super", type.getLowerBoundField(), visiting, sb);
                    if (this.currentPrintVerboseGenerics) {
                        sb.append("]");
                    }
                }
                finally {
                    visiting.remove(type);
                }
            }
            return sb.toString();
        }

        @Override
        @SideEffectFree
        public String visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, Set<AnnotatedTypeMirror> visiting) {
            return this.formatFlatType(type);
        }

        @Override
        @SideEffectFree
        public String visitNoType(AnnotatedTypeMirror.AnnotatedNoType type, Set<AnnotatedTypeMirror> visiting) {
            return this.formatFlatType(type);
        }

        @Override
        @SideEffectFree
        public String visitNull(AnnotatedTypeMirror.AnnotatedNullType type, Set<AnnotatedTypeMirror> visiting) {
            return this.annoFormatter.formatAnnotationString(type.getAnnotations(), this.currentPrintInvisibleSetting) + " null";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, Set<AnnotatedTypeMirror> visiting) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.annoFormatter.formatAnnotationString(type.getAnnotationsField(), this.currentPrintInvisibleSetting));
            sb.append("?");
            if (!visiting.contains(type)) {
                try {
                    visiting.add(type);
                    if (this.currentPrintVerboseGenerics) {
                        sb.append("[");
                    }
                    this.printBound("extends", type.getExtendsBoundField(), visiting, sb);
                    this.printBound("super", type.getSuperBoundField(), visiting, sb);
                    if (this.currentPrintVerboseGenerics) {
                        sb.append("]");
                    }
                }
                finally {
                    visiting.remove(type);
                }
            }
            return sb.toString();
        }

        @SideEffectFree
        protected String formatFlatType(AnnotatedTypeMirror flatType) {
            return this.annoFormatter.formatAnnotationString(flatType.getAnnotations(), this.currentPrintInvisibleSetting) + TypeAnnotationUtils.unannotatedType((Type)flatType.getUnderlyingType());
        }
    }
}

