/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.ASTPathCriterion;
import annotator.find.BoundLocationCriterion;
import annotator.find.CallCriterion;
import annotator.find.CastCriterion;
import annotator.find.ClassBoundCriterion;
import annotator.find.Criterion;
import annotator.find.EnclosedByCriterion;
import annotator.find.ExtImplsLocationCriterion;
import annotator.find.FieldCriterion;
import annotator.find.GenericArrayLocationCriterion;
import annotator.find.InClassCriterion;
import annotator.find.InFieldInitCriterion;
import annotator.find.InInitBlockCriterion;
import annotator.find.InMethodCriterion;
import annotator.find.InPackageCriterion;
import annotator.find.InstanceOfCriterion;
import annotator.find.IsCriterion;
import annotator.find.IsSigMethodCriterion;
import annotator.find.LambdaCriterion;
import annotator.find.LocalVariableCriterion;
import annotator.find.MemberReferenceCriterion;
import annotator.find.MethodBoundCriterion;
import annotator.find.NewCriterion;
import annotator.find.NotInMethodCriterion;
import annotator.find.PackageCriterion;
import annotator.find.ParamCriterion;
import annotator.find.ReceiverCriterion;
import annotator.find.ReturnTypeCriterion;
import annotator.find.TypeArgumentCriterion;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.LinkedHashMap;
import java.util.Map;
import scenelib.annotations.el.BoundLocation;
import scenelib.annotations.el.InnerTypeLocation;
import scenelib.annotations.el.LocalLocation;
import scenelib.annotations.el.RelativeLocation;
import scenelib.annotations.el.TypeIndexLocation;
import scenelib.annotations.io.ASTPath;
import scenelib.annotations.io.DebugWriter;

public final class Criteria {
    public static DebugWriter dbug = new DebugWriter();
    private final Map<Criterion.Kind, Criterion> criteria = new LinkedHashMap<Criterion.Kind, Criterion>();

    public void add(Criterion c) {
        this.criteria.put(c.getKind(), c);
    }

    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        for (Criterion c : this.criteria.values()) {
            if (!c.isSatisfiedBy(path, leaf)) {
                dbug.debug("UNsatisfied criterion of type %s:%n    leaf=%s (%s)%n", c, c.getClass(), Main.leafString(path));
                return false;
            }
            dbug.debug("satisfied criterion of type %s:%n    leaf=%s (%s)%n", c, c.getClass(), Main.leafString(path));
        }
        return true;
    }

    public boolean isSatisfiedBy(TreePath path) {
        for (Criterion c : this.criteria.values()) {
            if (!c.isSatisfiedBy(path)) {
                dbug.debug("UNsatisfied criterion: %s%n", c);
                return false;
            }
            dbug.debug("satisfied criterion: %s%n", c);
        }
        return true;
    }

    public boolean isOnReceiver() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.RECEIVER) continue;
            return true;
        }
        return false;
    }

    public boolean isOnPackage() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.PACKAGE) continue;
            return true;
        }
        return false;
    }

    public boolean isOnReturnType() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.RETURN_TYPE) continue;
            return true;
        }
        return false;
    }

    public boolean isOnLocalVariable() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.LOCAL_VARIABLE) continue;
            return true;
        }
        return false;
    }

    public boolean isOnInstanceof() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.INSTANCE_OF) continue;
            return true;
        }
        return false;
    }

    public boolean isOnNew() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.NEW) continue;
            return true;
        }
        return false;
    }

    public boolean isOnTypeDeclarationExtendsClause() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.EXTIMPLS_LOCATION) continue;
            return ((ExtImplsLocationCriterion)c).getIndex() == -1;
        }
        return false;
    }

    public boolean isOnMethod(String methodname) {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.IN_METHOD || !((InMethodCriterion)c).name.equals(methodname)) continue;
            return true;
        }
        return false;
    }

    public boolean isOnFieldDeclaration() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.FIELD || !((FieldCriterion)c).isDeclaration) continue;
            return true;
        }
        return false;
    }

    public boolean isOnVariableDeclaration() {
        return this.isOnLocalVariable() || this.isOnFieldDeclaration();
    }

    public ASTPath getASTPath() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.AST_PATH) continue;
            return ((ASTPathCriterion)c).astPath;
        }
        return null;
    }

    public String getClassName() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.IN_CLASS) continue;
            return ((InClassCriterion)c).className;
        }
        return null;
    }

    public String getMethodName() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.IN_METHOD) continue;
            return ((InMethodCriterion)c).name;
        }
        return null;
    }

    public String getFieldName() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.FIELD) continue;
            return ((FieldCriterion)c).varName;
        }
        return null;
    }

    public GenericArrayLocationCriterion getGenericArrayLocation() {
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.GENERIC_ARRAY_LOCATION) continue;
            return (GenericArrayLocationCriterion)c;
        }
        return null;
    }

    public RelativeLocation getCastRelativeLocation() {
        RelativeLocation result = null;
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.CAST) continue;
            result = ((CastCriterion)c).getLocation();
        }
        return result;
    }

    public InClassCriterion getInClass() {
        InClassCriterion result = null;
        for (Criterion c : this.criteria.values()) {
            if (c.getKind() != Criterion.Kind.IN_CLASS) continue;
            result = (InClassCriterion)c;
        }
        return result;
    }

    public boolean onBoundZero() {
        block5: for (Criterion c : this.criteria.values()) {
            switch (c.getKind()) {
                case CLASS_BOUND: {
                    if (((ClassBoundCriterion)c).boundLoc.boundIndex != 0) break;
                    return true;
                }
                case METHOD_BOUND: {
                    if (((MethodBoundCriterion)c).boundLoc.boundIndex != 0) break;
                    return true;
                }
                case AST_PATH: {
                    ASTPath astPath = ((ASTPathCriterion)c).astPath;
                    if (astPath.isEmpty()) break;
                    ASTPath.ASTEntry entry = astPath.getLast();
                    if (!entry.childSelectorIs("bound") || entry.getArgument() != 0) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.criteria.toString();
    }

    public static final Criterion is(Tree.Kind kind, String name) {
        return new IsCriterion(kind, name);
    }

    public static final Criterion enclosedBy(Tree.Kind kind) {
        return new EnclosedByCriterion(kind);
    }

    public static final Criterion inPackage(String name) {
        return new InPackageCriterion(name);
    }

    public static final Criterion inClass(String name, boolean exact) {
        return new InClassCriterion(name, true);
    }

    public static final Criterion inMethod(String name) {
        return new InMethodCriterion(name);
    }

    public static final Criterion notInMethod() {
        return new NotInMethodCriterion();
    }

    public static final Criterion packageDecl(String packageName) {
        return new PackageCriterion(packageName);
    }

    public static final Criterion atLocation() {
        return new GenericArrayLocationCriterion();
    }

    public static final Criterion atLocation(InnerTypeLocation loc) {
        return new GenericArrayLocationCriterion(loc);
    }

    @Deprecated
    public static final Criterion field(String varName) {
        return new FieldCriterion(varName);
    }

    public static final Criterion field(String varName, boolean isOnDeclaration) {
        return new FieldCriterion(varName, isOnDeclaration);
    }

    public static final Criterion inStaticInit(int blockID) {
        return new InInitBlockCriterion(blockID, true);
    }

    public static final Criterion inInstanceInit(int blockID) {
        return new InInitBlockCriterion(blockID, false);
    }

    public static final Criterion inFieldInit(String varName) {
        return new InFieldInitCriterion(varName);
    }

    public static final Criterion receiver(String methodName) {
        return new ReceiverCriterion(methodName);
    }

    public static final Criterion returnType(String className, String methodName) {
        return new ReturnTypeCriterion(className, methodName);
    }

    public static final Criterion isSigMethod(String methodName) {
        return new IsSigMethodCriterion(methodName);
    }

    public static final Criterion param(String methodName, Integer pos) {
        return new ParamCriterion(methodName, pos);
    }

    public static final Criterion local(String methodName, LocalLocation loc) {
        return new LocalVariableCriterion(methodName, loc);
    }

    public static final Criterion cast(String methodName, RelativeLocation loc) {
        return new CastCriterion(methodName, loc);
    }

    public static final Criterion newObject(String methodName, RelativeLocation loc) {
        return new NewCriterion(methodName, loc);
    }

    public static final Criterion instanceOf(String methodName, RelativeLocation loc) {
        return new InstanceOfCriterion(methodName, loc);
    }

    public static Criterion memberReference(String methodName, RelativeLocation loc) {
        return new MemberReferenceCriterion(methodName, loc);
    }

    public static Criterion methodCall(String methodName, RelativeLocation loc) {
        return new CallCriterion(methodName, loc);
    }

    public static final Criterion typeArgument(String methodName, RelativeLocation loc) {
        return new TypeArgumentCriterion(methodName, loc);
    }

    public static final Criterion lambda(String methodName, RelativeLocation loc) {
        return new LambdaCriterion(methodName, loc);
    }

    public static final Criterion atBoundLocation(BoundLocation loc) {
        return new BoundLocationCriterion(loc);
    }

    public static final Criterion atExtImplsLocation(String className, TypeIndexLocation loc) {
        return new ExtImplsLocationCriterion(className, loc);
    }

    public static final Criterion methodBound(String methodName, BoundLocation boundLoc) {
        return new MethodBoundCriterion(methodName, boundLoc);
    }

    public static final Criterion classBound(String className, BoundLocation boundLoc) {
        return new ClassBoundCriterion(className, boundLoc);
    }

    public static final Criterion astPath(ASTPath astPath) {
        return new ASTPathCriterion(astPath);
    }
}

