/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.util;

import com.sun.tools.hat.internal.util.Comparer;

public class ArraySorter {
    public static void sort(Object[] objectArray, Comparer comparer) {
        ArraySorter.quickSort(objectArray, comparer, 0, objectArray.length - 1);
    }

    public static void sortArrayOfStrings(Object[] objectArray) {
        ArraySorter.sort(objectArray, new Comparer(){

            @Override
            public int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        });
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    private static void quickSort(Object[] objectArray, Comparer comparer, int n, int n2) {
        if (n2 <= n) {
            return;
        }
        int n3 = (n + n2) / 2;
        if (n3 != n) {
            ArraySorter.swap(objectArray, n3, n);
        }
        Object object = objectArray[n];
        int n4 = n - 1;
        int n5 = n + 1;
        int n6 = n2;
        while (n5 <= n6) {
            int n7;
            int n8 = comparer.compare(objectArray[n5], object);
            if (n8 <= 0) {
                if (n8 < 0) {
                    n4 = n5;
                }
                ++n5;
                continue;
            }
            while ((n7 = comparer.compare(objectArray[n6], object)) > 0 && n5 <= --n6) {
            }
            if (n5 > n6) continue;
            ArraySorter.swap(objectArray, n5, n6);
            if (n7 < 0) {
                n4 = n5;
            }
            ++n5;
            --n6;
        }
        if (n4 > n) {
            ArraySorter.swap(objectArray, n, n4);
            ArraySorter.quickSort(objectArray, comparer, n, n4 - 1);
        }
        ArraySorter.quickSort(objectArray, comparer, n6 + 1, n2);
    }
}

