/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.tools.internal.ws.api.wsdl.TWSDLExtensible;
import com.sun.tools.internal.ws.api.wsdl.TWSDLExtensionHandler;
import com.sun.tools.internal.ws.resources.WsdlMessages;
import com.sun.tools.internal.ws.util.xml.XmlUtil;
import com.sun.tools.internal.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import com.sun.tools.internal.ws.wsdl.document.Binding;
import com.sun.tools.internal.ws.wsdl.document.BindingFault;
import com.sun.tools.internal.ws.wsdl.document.BindingInput;
import com.sun.tools.internal.ws.wsdl.document.BindingOperation;
import com.sun.tools.internal.ws.wsdl.document.BindingOutput;
import com.sun.tools.internal.ws.wsdl.document.Definitions;
import com.sun.tools.internal.ws.wsdl.document.Documentation;
import com.sun.tools.internal.ws.wsdl.document.Fault;
import com.sun.tools.internal.ws.wsdl.document.Import;
import com.sun.tools.internal.ws.wsdl.document.Input;
import com.sun.tools.internal.ws.wsdl.document.Message;
import com.sun.tools.internal.ws.wsdl.document.MessagePart;
import com.sun.tools.internal.ws.wsdl.document.Operation;
import com.sun.tools.internal.ws.wsdl.document.OperationStyle;
import com.sun.tools.internal.ws.wsdl.document.Output;
import com.sun.tools.internal.ws.wsdl.document.Port;
import com.sun.tools.internal.ws.wsdl.document.PortType;
import com.sun.tools.internal.ws.wsdl.document.Service;
import com.sun.tools.internal.ws.wsdl.document.WSDLConstants;
import com.sun.tools.internal.ws.wsdl.document.WSDLDocument;
import com.sun.tools.internal.ws.wsdl.document.schema.SchemaConstants;
import com.sun.tools.internal.ws.wsdl.document.schema.SchemaKinds;
import com.sun.tools.internal.ws.wsdl.framework.Entity;
import com.sun.tools.internal.ws.wsdl.framework.ParserListener;
import com.sun.tools.internal.ws.wsdl.framework.TWSDLParserContextImpl;
import com.sun.tools.internal.ws.wsdl.parser.HTTPExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.Internalizer;
import com.sun.tools.internal.ws.wsdl.parser.JAXWSBindingExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.MIMEExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.MemberSubmissionAddressingExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.MetadataFinder;
import com.sun.tools.internal.ws.wsdl.parser.Policy12ExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.Policy15ExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.SOAP12ExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.SOAPExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.Util;
import com.sun.tools.internal.ws.wsdl.parser.W3CAddressingExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.W3CAddressingMetadataExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.WSDLInternalizationLogic;
import com.sun.xml.internal.ws.util.ServiceFinder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class WSDLParser {
    private final ErrorReceiverFilter errReceiver;
    private WsimportOptions options;
    private final Map extensionHandlers = new HashMap();
    private MetadataFinder forest;
    private ArrayList<ParserListener> listeners;

    public WSDLParser(WsimportOptions options, ErrorReceiverFilter errReceiver, MetadataFinder forest) {
        this.options = options;
        this.errReceiver = errReceiver;
        if (forest == null) {
            forest = new MetadataFinder(new WSDLInternalizationLogic(), options, errReceiver);
            forest.parseWSDL();
            if (forest.isMexMetadata) {
                errReceiver.reset();
            }
        }
        this.forest = forest;
        this.register(new SOAPExtensionHandler(this.extensionHandlers));
        this.register(new HTTPExtensionHandler(this.extensionHandlers));
        this.register(new MIMEExtensionHandler(this.extensionHandlers));
        this.register(new JAXWSBindingExtensionHandler(this.extensionHandlers));
        this.register(new SOAP12ExtensionHandler(this.extensionHandlers));
        this.register(new MemberSubmissionAddressingExtensionHandler(this.extensionHandlers, errReceiver));
        this.register(new W3CAddressingExtensionHandler(this.extensionHandlers, errReceiver));
        this.register(new W3CAddressingMetadataExtensionHandler(this.extensionHandlers, errReceiver));
        this.register(new Policy12ExtensionHandler());
        this.register(new Policy15ExtensionHandler());
        for (TWSDLExtensionHandler te : ServiceFinder.find(TWSDLExtensionHandler.class)) {
            this.register(te);
        }
    }

    WSDLParser(WsimportOptions options, ErrorReceiverFilter errReceiver) {
        this(options, errReceiver, null);
    }

    private void register(TWSDLExtensionHandler h2) {
        this.extensionHandlers.put(h2.getNamespaceURI(), h2);
    }

    public void addParserListener(ParserListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public WSDLDocument parse() throws SAXException, IOException {
        for (InputSource value : this.options.getWSDLBindings()) {
            this.errReceiver.pollAbort();
            Document root = this.forest.parse(value, false);
            if (root == null) continue;
            Element binding = root.getDocumentElement();
            if (!this.fixNull(binding.getNamespaceURI()).equals("http://java.sun.com/xml/ns/jaxws") || !binding.getLocalName().equals("bindings")) {
                this.errReceiver.error(this.forest.locatorTable.getStartLocation(binding), WsdlMessages.PARSER_NOT_A_BINDING_FILE(binding.getNamespaceURI(), binding.getLocalName()));
                continue;
            }
            NodeList nl = binding.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "handler-chains");
            for (int i = 0; i < nl.getLength(); ++i) {
                this.options.addHandlerChainConfiguration((Element)nl.item(i));
            }
        }
        return this.buildWSDLDocument();
    }

    private String fixNull(String s2) {
        if (s2 == null) {
            return "";
        }
        return s2;
    }

    public MetadataFinder getDOMForest() {
        return this.forest;
    }

    private WSDLDocument buildWSDLDocument() {
        String location = this.forest.getRootWSDL();
        if (location == null) {
            return null;
        }
        Document root = this.forest.get(location);
        if (root == null) {
            return null;
        }
        WSDLDocument document = new WSDLDocument(this.forest, this.errReceiver);
        document.setSystemId(location);
        TWSDLParserContextImpl context = new TWSDLParserContextImpl(this.forest, document, this.listeners, this.errReceiver);
        Definitions definitions = this.parseDefinitions(context, root);
        document.setDefinitions(definitions);
        return document;
    }

    private Definitions parseDefinitions(TWSDLParserContextImpl context, Document root) {
        context.pushWSDLLocation();
        context.setWSDLLocation(context.getDocument().getSystemId());
        new Internalizer(this.forest, this.options, this.errReceiver).transform();
        Definitions definitions = this.parseDefinitionsNoImport(context, root);
        if (definitions == null) {
            Locator locator = this.forest.locatorTable.getStartLocation(root.getDocumentElement());
            this.errReceiver.error(locator, WsdlMessages.PARSING_NOT_AWSDL(locator.getSystemId()));
        }
        this.processImports(context);
        context.popWSDLLocation();
        return definitions;
    }

    private void processMexDocs(TWSDLParserContextImpl context) {
        for (String location : this.forest.listSystemIDs()) {
            Definitions importedDefinitions;
            Document doc;
            if (context.getDocument().isImportedDocument(location) || (doc = this.forest.get(location)) == null || (importedDefinitions = this.parseDefinitionsNoImport(context, doc)) == null) continue;
            context.getDocument().addImportedEntity(importedDefinitions);
            context.getDocument().addImportedDocument(location);
        }
    }

    private void processImports(TWSDLParserContextImpl context) {
        for (String location : this.forest.getExternalReferences()) {
            Definitions importedDefinitions;
            Document doc;
            if (context.getDocument().isImportedDocument(location) || (doc = this.forest.get(location)) == null || (importedDefinitions = this.parseDefinitionsNoImport(context, doc)) == null) continue;
            context.getDocument().addImportedEntity(importedDefinitions);
            context.getDocument().addImportedDocument(location);
        }
    }

    private Definitions parseDefinitionsNoImport(TWSDLParserContextImpl context, Document doc) {
        Element e2;
        Element e = doc.getDocumentElement();
        if (e.getNamespaceURI() == null || !e.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || !e.getLocalName().equals("definitions")) {
            return null;
        }
        context.push();
        context.registerNamespaces(e);
        Definitions definitions = new Definitions(context.getDocument(), this.forest.locatorTable.getStartLocation(e));
        String name = XmlUtil.getAttributeOrNull((Element)e, (String)"name");
        definitions.setName(name);
        String targetNamespaceURI = XmlUtil.getAttributeOrNull((Element)e, (String)"targetNamespace");
        definitions.setTargetNamespaceURI(targetNamespaceURI);
        boolean gotDocumentation = false;
        boolean gotTypes = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e2), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                    return null;
                }
                gotDocumentation = true;
                if (definitions.getDocumentation() != null) continue;
                definitions.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_TYPES)) {
                if (gotTypes && !this.options.isExtensionMode()) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e2), WsdlMessages.PARSING_ONLY_ONE_TYPES_ALLOWED("definitions"));
                    return null;
                }
                gotTypes = true;
                if (this.options.isExtensionMode()) continue;
                this.validateSchemaImports(e2);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_MESSAGE)) {
                Message message = this.parseMessage(context, definitions, e2);
                definitions.add(message);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_PORT_TYPE)) {
                PortType portType = this.parsePortType(context, definitions, e2);
                definitions.add(portType);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_BINDING)) {
                Binding binding = this.parseBinding(context, definitions, e2);
                definitions.add(binding);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_SERVICE)) {
                Service service = this.parseService(context, definitions, e2);
                definitions.add(service);
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_IMPORT)) {
                definitions.add(this.parseImport(context, definitions, e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, SchemaConstants.QNAME_IMPORT)) {
                this.errReceiver.warning(this.forest.locatorTable.getStartLocation(e2), WsdlMessages.WARNING_WSI_R_2003());
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, definitions, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_DEFINITIONS, definitions);
        return definitions;
    }

    private Message parseMessage(TWSDLParserContextImpl context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Message message = new Message(definitions, this.forest.locatorTable.getStartLocation(e), this.errReceiver);
        String name = Util.getRequiredAttribute(e, "name");
        message.setName(name);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    Util.fail("parsing.onlyOneDocumentationAllowed", e.getLocalName());
                }
                gotDocumentation = true;
                message.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (!XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_PART)) continue;
            MessagePart part = this.parseMessagePart(context, e2);
            message.add(part);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_MESSAGE, message);
        return message;
    }

    private MessagePart parseMessagePart(TWSDLParserContextImpl context, Element e) {
        context.push();
        context.registerNamespaces(e);
        MessagePart part = new MessagePart(this.forest.locatorTable.getStartLocation(e));
        String partName = Util.getRequiredAttribute(e, "name");
        part.setName(partName);
        String elementAttr = XmlUtil.getAttributeOrNull((Element)e, (String)"element");
        String typeAttr = XmlUtil.getAttributeOrNull((Element)e, (String)"type");
        if (elementAttr != null) {
            if (typeAttr != null) {
                this.errReceiver.error(context.getLocation(e), WsdlMessages.PARSING_ONLY_ONE_OF_ELEMENT_OR_TYPE_REQUIRED(partName));
            }
            part.setDescriptor(context.translateQualifiedName(context.getLocation(e), elementAttr));
            part.setDescriptorKind(SchemaKinds.XSD_ELEMENT);
        } else if (typeAttr != null) {
            part.setDescriptor(context.translateQualifiedName(context.getLocation(e), typeAttr));
            part.setDescriptorKind(SchemaKinds.XSD_TYPE);
        } else {
            this.errReceiver.warning(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_ELEMENT_OR_TYPE_REQUIRED(partName));
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_PART, part);
        return part;
    }

    private PortType parsePortType(TWSDLParserContextImpl context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        PortType portType = new PortType(definitions, this.forest.locatorTable.getStartLocation(e), this.errReceiver);
        String name = Util.getRequiredAttribute(e, "name");
        portType.setName(name);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                }
                gotDocumentation = true;
                if (portType.getDocumentation() != null) continue;
                portType.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OPERATION)) {
                Operation op = this.parsePortTypeOperation(context, e2);
                op.setParent(portType);
                portType.add(op);
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, portType, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_PORT_TYPE, portType);
        return portType;
    }

    private Operation parsePortTypeOperation(TWSDLParserContextImpl context, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Operation operation = new Operation(this.forest.locatorTable.getStartLocation(e));
        String name = Util.getRequiredAttribute(e, "name");
        operation.setName(name);
        String parameterOrderAttr = XmlUtil.getAttributeOrNull((Element)e, (String)"parameterOrder");
        operation.setParameterOrder(parameterOrderAttr);
        boolean gotDocumentation = false;
        boolean gotInput = false;
        boolean gotOutput = false;
        boolean gotFault = false;
        boolean inputBeforeOutput = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            Element e3;
            Iterator iter2;
            boolean gotDocumentation2;
            Attr e32;
            String nameAttr;
            String messageAttr;
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e2), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e2.getLocalName()));
                }
                gotDocumentation = true;
                if (operation.getDocumentation() != null) continue;
                operation.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_INPUT)) {
                if (gotInput) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_TOO_MANY_ELEMENTS("input", "operation", name));
                }
                context.push();
                context.registerNamespaces(e2);
                Input input = new Input(this.forest.locatorTable.getStartLocation(e2), this.errReceiver);
                input.setParent(operation);
                messageAttr = Util.getRequiredAttribute(e2, "message");
                input.setMessage(context.translateQualifiedName(context.getLocation(e2), messageAttr));
                nameAttr = XmlUtil.getAttributeOrNull((Element)e2, (String)"name");
                input.setName(nameAttr);
                operation.setInput(input);
                gotInput = true;
                if (gotOutput) {
                    inputBeforeOutput = false;
                }
                Iterator iter22 = XmlUtil.getAllAttributes((Element)e2);
                while (iter22.hasNext()) {
                    e32 = (Attr)iter22.next();
                    if (e32.getLocalName().equals("message") || e32.getLocalName().equals("name")) continue;
                    this.checkNotWsdlAttribute(e32);
                    if (this.handleExtension(context, input, e32, e2)) continue;
                }
                gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren((Element)e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                        }
                        gotDocumentation2 = true;
                        input.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e3), WsdlMessages.PARSING_INVALID_ELEMENT(e3.getTagName(), e3.getNamespaceURI()));
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OUTPUT)) {
                if (gotOutput) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_TOO_MANY_ELEMENTS("input", "operation", name));
                }
                context.push();
                context.registerNamespaces(e2);
                Output output = new Output(this.forest.locatorTable.getStartLocation(e2), this.errReceiver);
                output.setParent(operation);
                messageAttr = Util.getRequiredAttribute(e2, "message");
                output.setMessage(context.translateQualifiedName(context.getLocation(e2), messageAttr));
                nameAttr = XmlUtil.getAttributeOrNull((Element)e2, (String)"name");
                output.setName(nameAttr);
                operation.setOutput(output);
                gotOutput = true;
                if (gotInput) {
                    inputBeforeOutput = true;
                }
                Iterator iter23 = XmlUtil.getAllAttributes((Element)e2);
                while (iter23.hasNext()) {
                    e32 = (Attr)iter23.next();
                    if (e32.getLocalName().equals("message") || e32.getLocalName().equals("name")) continue;
                    this.checkNotWsdlAttribute(e32);
                    if (this.handleExtension(context, output, e32, e2)) continue;
                }
                gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren((Element)e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                        }
                        gotDocumentation2 = true;
                        output.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e3), WsdlMessages.PARSING_INVALID_ELEMENT(e3.getTagName(), e3.getNamespaceURI()));
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_FAULT)) {
                context.push();
                context.registerNamespaces(e2);
                Fault fault = new Fault(this.forest.locatorTable.getStartLocation(e2));
                fault.setParent(operation);
                messageAttr = Util.getRequiredAttribute(e2, "message");
                fault.setMessage(context.translateQualifiedName(context.getLocation(e2), messageAttr));
                nameAttr = XmlUtil.getAttributeOrNull((Element)e2, (String)"name");
                fault.setName(nameAttr);
                operation.addFault(fault);
                gotFault = true;
                Iterator iter24 = XmlUtil.getAllAttributes((Element)e2);
                while (iter24.hasNext()) {
                    e32 = (Attr)iter24.next();
                    if (e32.getLocalName().equals("message") || e32.getLocalName().equals("name")) continue;
                    this.checkNotWsdlAttribute(e32);
                    if (this.handleExtension(context, fault, e32, e2)) continue;
                }
                gotDocumentation2 = false;
                iter2 = XmlUtil.getAllChildren((Element)e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                        }
                        gotDocumentation2 = true;
                        if (fault.getDocumentation() != null) continue;
                        fault.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, fault, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, operation, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        if (gotInput && !gotOutput && !gotFault) {
            operation.setStyle(OperationStyle.ONE_WAY);
        } else if (gotInput && gotOutput && inputBeforeOutput) {
            operation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (gotInput && gotOutput && !inputBeforeOutput) {
            operation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (gotOutput && !gotInput && !gotFault) {
            operation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_INVALID_OPERATION_STYLE(name));
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, operation);
        return operation;
    }

    private Binding parseBinding(TWSDLParserContextImpl context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Binding binding = new Binding(definitions, this.forest.locatorTable.getStartLocation(e), this.errReceiver);
        String name = Util.getRequiredAttribute(e, "name");
        binding.setName(name);
        String typeAttr = Util.getRequiredAttribute(e, "type");
        binding.setPortType(context.translateQualifiedName(context.getLocation(e), typeAttr));
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                }
                gotDocumentation = true;
                binding.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OPERATION)) {
                BindingOperation op = this.parseBindingOperation(context, e2);
                binding.add(op);
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, binding, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_BINDING, binding);
        return binding;
    }

    private BindingOperation parseBindingOperation(TWSDLParserContextImpl context, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        BindingOperation operation = new BindingOperation(this.forest.locatorTable.getStartLocation(e));
        String name = Util.getRequiredAttribute(e, "name");
        operation.setName(name);
        boolean gotDocumentation = false;
        boolean gotInput = false;
        boolean gotOutput = false;
        boolean gotFault = false;
        boolean inputBeforeOutput = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            Element e3;
            String nameAttr;
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                }
                gotDocumentation = true;
                operation.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_INPUT)) {
                Element e32;
                if (gotInput) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_TOO_MANY_ELEMENTS("input", "operation", name));
                }
                Iterator itere2 = XmlUtil.getAllChildren((Element)e2);
                context.push();
                context.registerNamespaces(e2);
                BindingInput input = new BindingInput(this.forest.locatorTable.getStartLocation(e2));
                String nameAttr2 = XmlUtil.getAttributeOrNull((Element)e2, (String)"name");
                input.setName(nameAttr2);
                operation.setInput(input);
                gotInput = true;
                if (gotOutput) {
                    inputBeforeOutput = false;
                }
                boolean gotDocumentation2 = false;
                Iterator iter2 = XmlUtil.getAllChildren((Element)e2);
                while (iter2.hasNext() && (e32 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e32, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                        }
                        gotDocumentation2 = true;
                        input.setDocumentation(this.getDocumentationFor(e32));
                        continue;
                    }
                    this.checkNotWsdlElement(e32);
                    if (this.handleExtension(context, input, e32)) continue;
                    this.checkNotWsdlRequired(e32);
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_OUTPUT)) {
                if (gotOutput) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_TOO_MANY_ELEMENTS("input", "operation", name));
                }
                context.push();
                context.registerNamespaces(e2);
                BindingOutput output = new BindingOutput(this.forest.locatorTable.getStartLocation(e2));
                nameAttr = XmlUtil.getAttributeOrNull((Element)e2, (String)"name");
                output.setName(nameAttr);
                operation.setOutput(output);
                gotOutput = true;
                if (gotInput) {
                    inputBeforeOutput = true;
                }
                boolean gotDocumentation2 = false;
                Iterator iter2 = XmlUtil.getAllChildren((Element)e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                        }
                        gotDocumentation2 = true;
                        output.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, output, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_FAULT)) {
                context.push();
                context.registerNamespaces(e2);
                BindingFault fault = new BindingFault(this.forest.locatorTable.getStartLocation(e2));
                nameAttr = Util.getRequiredAttribute(e2, "name");
                fault.setName(nameAttr);
                operation.addFault(fault);
                gotFault = true;
                boolean gotDocumentation2 = false;
                Iterator iter2 = XmlUtil.getAllChildren((Element)e2);
                while (iter2.hasNext() && (e3 = Util.nextElement(iter2)) != null) {
                    if (XmlUtil.matchesTagNS(e3, WSDLConstants.QNAME_DOCUMENTATION)) {
                        if (gotDocumentation2) {
                            this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                        }
                        gotDocumentation2 = true;
                        if (fault.getDocumentation() != null) continue;
                        fault.setDocumentation(this.getDocumentationFor(e3));
                        continue;
                    }
                    this.checkNotWsdlElement(e3);
                    if (this.handleExtension(context, fault, e3)) continue;
                    this.checkNotWsdlRequired(e3);
                }
                context.pop();
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, operation, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        if (gotInput && !gotOutput && !gotFault) {
            operation.setStyle(OperationStyle.ONE_WAY);
        } else if (gotInput && gotOutput && inputBeforeOutput) {
            operation.setStyle(OperationStyle.REQUEST_RESPONSE);
        } else if (gotInput && gotOutput && !inputBeforeOutput) {
            operation.setStyle(OperationStyle.SOLICIT_RESPONSE);
        } else if (gotOutput && !gotInput && !gotFault) {
            operation.setStyle(OperationStyle.NOTIFICATION);
        } else {
            this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_INVALID_OPERATION_STYLE(name));
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_OPERATION, operation);
        return operation;
    }

    private Import parseImport(TWSDLParserContextImpl context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Import anImport = new Import(this.forest.locatorTable.getStartLocation(e));
        String namespace = Util.getRequiredAttribute(e, "namespace");
        anImport.setNamespace(namespace);
        String location = Util.getRequiredAttribute(e, "location");
        anImport.setLocation(location);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                }
                gotDocumentation = true;
                anImport.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            this.errReceiver.error(this.forest.locatorTable.getStartLocation(e2), WsdlMessages.PARSING_INVALID_ELEMENT(e2.getTagName(), e2.getNamespaceURI()));
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_IMPORT, anImport);
        return anImport;
    }

    private Service parseService(TWSDLParserContextImpl context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Service service = new Service(definitions, this.forest.locatorTable.getStartLocation(e), this.errReceiver);
        String name = Util.getRequiredAttribute(e, "name");
        service.setName(name);
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                }
                gotDocumentation = true;
                if (service.getDocumentation() != null) continue;
                service.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_PORT)) {
                Port port = this.parsePort(context, definitions, e2);
                service.add(port);
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, service, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_SERVICE, service);
        return service;
    }

    private Port parsePort(TWSDLParserContextImpl context, Definitions definitions, Element e) {
        Element e2;
        context.push();
        context.registerNamespaces(e);
        Port port = new Port(definitions, this.forest.locatorTable.getStartLocation(e), this.errReceiver);
        String name = Util.getRequiredAttribute(e, "name");
        port.setName(name);
        String bindingAttr = Util.getRequiredAttribute(e, "binding");
        port.setBinding(context.translateQualifiedName(context.getLocation(e), bindingAttr));
        boolean gotDocumentation = false;
        Iterator iter = XmlUtil.getAllChildren((Element)e);
        while (iter.hasNext() && (e2 = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e2, WSDLConstants.QNAME_DOCUMENTATION)) {
                if (gotDocumentation) {
                    this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_ONLY_ONE_DOCUMENTATION_ALLOWED(e.getLocalName()));
                }
                gotDocumentation = true;
                if (port.getDocumentation() != null) continue;
                port.setDocumentation(this.getDocumentationFor(e2));
                continue;
            }
            this.checkNotWsdlElement(e2);
            if (this.handleExtension(context, port, e2)) continue;
            this.checkNotWsdlRequired(e2);
        }
        context.pop();
        context.fireDoneParsingEntity(WSDLConstants.QNAME_PORT, port);
        return port;
    }

    private void validateSchemaImports(Element typesElement) {
        Element e;
        Iterator iter = XmlUtil.getAllChildren((Element)typesElement);
        while (iter.hasNext() && (e = Util.nextElement(iter)) != null) {
            if (XmlUtil.matchesTagNS(e, SchemaConstants.QNAME_IMPORT)) {
                this.errReceiver.warning(this.forest.locatorTable.getStartLocation(e), WsdlMessages.WARNING_WSI_R_2003());
                continue;
            }
            this.checkNotWsdlElement(e);
        }
    }

    private boolean handleExtension(TWSDLParserContextImpl context, TWSDLExtensible entity, Element e) {
        TWSDLExtensionHandler h2 = (TWSDLExtensionHandler)this.extensionHandlers.get(e.getNamespaceURI());
        if (h2 == null) {
            context.fireIgnoringExtension(e, (Entity)((Object)entity));
            return false;
        }
        return h2.doHandleExtension(context, entity, e);
    }

    private boolean handleExtension(TWSDLParserContextImpl context, TWSDLExtensible entity, Node n, Element e) {
        TWSDLExtensionHandler h2 = (TWSDLExtensionHandler)this.extensionHandlers.get(n.getNamespaceURI());
        if (h2 == null) {
            context.fireIgnoringExtension(e, (Entity)((Object)entity));
            return false;
        }
        return h2.doHandleExtension(context, entity, e);
    }

    private void checkNotWsdlElement(Element e) {
        if (e.getNamespaceURI() != null && e.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_INVALID_WSDL_ELEMENT(e.getTagName()));
        }
    }

    private void checkNotWsdlAttribute(Attr a) {
        if (a.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            this.errReceiver.error(this.forest.locatorTable.getStartLocation(a.getOwnerElement()), WsdlMessages.PARSING_INVALID_WSDL_ELEMENT(a.getLocalName()));
        }
    }

    private void checkNotWsdlRequired(Element e) {
        String required = XmlUtil.getAttributeNSOrNull((Element)e, (String)"required", (String)"http://schemas.xmlsoap.org/wsdl/");
        if (required != null && required.equals("true") && !this.options.isExtensionMode()) {
            this.errReceiver.error(this.forest.locatorTable.getStartLocation(e), WsdlMessages.PARSING_REQUIRED_EXTENSIBILITY_ELEMENT(e.getTagName(), e.getNamespaceURI()));
        }
    }

    private Documentation getDocumentationFor(Element e) {
        String s2 = XmlUtil.getTextForNode((Node)e);
        if (s2 == null) {
            return null;
        }
        return new Documentation(s2);
    }
}

