/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.xmlschema;

import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.fmt.JTextFile;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.Options;
import com.sun.tools.internal.xjc.Plugin;
import com.sun.tools.internal.xjc.generator.bean.field.FieldRendererFactory;
import com.sun.tools.internal.xjc.model.CClassInfoParent;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.reader.ModelChecker;
import com.sun.tools.internal.xjc.reader.Ring;
import com.sun.tools.internal.xjc.reader.xmlschema.BindGreen;
import com.sun.tools.internal.xjc.reader.xmlschema.BindPurple;
import com.sun.tools.internal.xjc.reader.xmlschema.BindingComponent;
import com.sun.tools.internal.xjc.reader.xmlschema.ClassSelector;
import com.sun.tools.internal.xjc.reader.xmlschema.DefaultParticleBinder;
import com.sun.tools.internal.xjc.reader.xmlschema.ExpressionParticleBinder;
import com.sun.tools.internal.xjc.reader.xmlschema.ParticleBinder;
import com.sun.tools.internal.xjc.reader.xmlschema.RefererFinder;
import com.sun.tools.internal.xjc.reader.xmlschema.SimpleTypeBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.UnusedCustomizationChecker;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIDeclaration;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIDom;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIGlobalBinding;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BISchemaBinding;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BISerializable;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.tools.internal.xjc.util.CodeModelClassFactory;
import com.sun.tools.internal.xjc.util.ErrorReceiverFilter;
import com.sun.xml.internal.bind.api.impl.NameConverter;
import com.sun.xml.internal.xsom.XSAnnotation;
import com.sun.xml.internal.xsom.XSAttributeUse;
import com.sun.xml.internal.xsom.XSComponent;
import com.sun.xml.internal.xsom.XSDeclaration;
import com.sun.xml.internal.xsom.XSParticle;
import com.sun.xml.internal.xsom.XSSchema;
import com.sun.xml.internal.xsom.XSSchemaSet;
import com.sun.xml.internal.xsom.XSSimpleType;
import com.sun.xml.internal.xsom.XSTerm;
import com.sun.xml.internal.xsom.XSType;
import com.sun.xml.internal.xsom.XSWildcard;
import com.sun.xml.internal.xsom.util.XSFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.xml.sax.Locator;

public class BGMBuilder
extends BindingComponent {
    public final boolean inExtensionMode;
    public final String defaultPackage1;
    public final String defaultPackage2;
    private final BindGreen green = Ring.get(BindGreen.class);
    private final BindPurple purple = Ring.get(BindPurple.class);
    public final Model model = Ring.get(Model.class);
    public final FieldRendererFactory fieldRendererFactory;
    private RefererFinder refFinder;
    private List<Plugin> activePlugins;
    private BIGlobalBinding globalBinding;
    private ParticleBinder particleBinder;
    private final BindInfo emptyBindInfo = new BindInfo();
    private final Map<XSComponent, BindInfo> externalBindInfos = new HashMap<XSComponent, BindInfo>();
    private final XSFinder toPurple = new XSFinder(){

        @Override
        public Boolean attributeUse(XSAttributeUse use) {
            return true;
        }

        @Override
        public Boolean simpleType(XSSimpleType xsSimpleType) {
            return true;
        }

        @Override
        public Boolean wildcard(XSWildcard xsWildcard) {
            return true;
        }
    };
    private Transformer identityTransformer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model build(XSSchemaSet _schemas, JCodeModel codeModel, ErrorReceiver _errorReceiver, Options opts) {
        Ring old = Ring.begin();
        try {
            ErrorReceiverFilter ef = new ErrorReceiverFilter(_errorReceiver);
            Ring.add(XSSchemaSet.class, _schemas);
            Ring.add(codeModel);
            Model model = new Model(opts, codeModel, null, opts.classNameAllocator, _schemas);
            Ring.add(model);
            Ring.add(ErrorReceiver.class, ef);
            Ring.add(CodeModelClassFactory.class, new CodeModelClassFactory(ef));
            BGMBuilder builder = new BGMBuilder(opts.defaultPackage, opts.defaultPackage2, opts.isExtensionMode(), opts.getFieldRendererFactory(), opts.activePlugins);
            builder._build();
            if (ef.hadError()) {
                Model model2 = null;
                return model2;
            }
            Model model3 = model;
            return model3;
        }
        finally {
            Ring.end(old);
        }
    }

    protected BGMBuilder(String defaultPackage1, String defaultPackage2, boolean _inExtensionMode, FieldRendererFactory fieldRendererFactory, List<Plugin> activePlugins) {
        this.inExtensionMode = _inExtensionMode;
        this.defaultPackage1 = defaultPackage1;
        this.defaultPackage2 = defaultPackage2;
        this.fieldRendererFactory = fieldRendererFactory;
        this.activePlugins = activePlugins;
        this.promoteGlobalBindings();
    }

    private void _build() {
        this.buildContents();
        this.getClassSelector().executeTasks();
        Ring.get(UnusedCustomizationChecker.class).run();
        Ring.get(ModelChecker.class).check();
        for (Plugin ma : this.activePlugins) {
            ma.postProcessModel(this.model, Ring.get(ErrorReceiver.class));
        }
    }

    private void promoteGlobalBindings() {
        XSSchemaSet schemas = Ring.get(XSSchemaSet.class);
        for (XSSchema s2 : schemas.getSchemas()) {
            BindInfo bi = this.getBindInfo(s2);
            this.model.getCustomizations().addAll(bi.toCustomizationList());
            BIGlobalBinding gb = bi.get(BIGlobalBinding.class);
            if (gb == null) continue;
            gb.markAsAcknowledged();
            if (this.globalBinding == null) {
                this.globalBinding = gb;
                continue;
            }
            if (this.globalBinding.isEqual(gb)) continue;
            this.getErrorReporter().error(gb.getLocation(), "ERR_MULTIPLE_GLOBAL_BINDINGS", new Object[0]);
            this.getErrorReporter().error(this.globalBinding.getLocation(), "ERR_MULTIPLE_GLOBAL_BINDINGS_OTHER", new Object[0]);
        }
        if (this.globalBinding == null) {
            this.globalBinding = new BIGlobalBinding();
            BindInfo big = new BindInfo();
            big.addDecl(this.globalBinding);
            big.setOwner(this, null);
        }
        this.model.strategy = this.globalBinding.getCodeGenerationStrategy();
        this.model.rootClass = this.globalBinding.getSuperClass();
        this.model.rootInterface = this.globalBinding.getSuperInterface();
        this.particleBinder = this.globalBinding.isSimpleMode() ? new ExpressionParticleBinder() : new DefaultParticleBinder();
        BISerializable serial = this.globalBinding.getSerializable();
        if (serial != null) {
            this.model.serializable = true;
            this.model.serialVersionUID = serial.uid;
        }
        if (this.globalBinding.nameConverter != null) {
            this.model.setNameConverter(this.globalBinding.nameConverter);
        }
        this.globalBinding.dispatchGlobalConversions(schemas);
        this.globalBinding.errorCheck();
    }

    @NotNull
    public BIGlobalBinding getGlobalBinding() {
        return this.globalBinding;
    }

    @NotNull
    public ParticleBinder getParticleBinder() {
        return this.particleBinder;
    }

    public NameConverter getNameConverter() {
        return this.model.getNameConverter();
    }

    private void buildContents() {
        ClassSelector cs = this.getClassSelector();
        SimpleTypeBuilder stb = Ring.get(SimpleTypeBuilder.class);
        for (XSSchema s2 : Ring.get(XSSchemaSet.class).getSchemas()) {
            BISchemaBinding sb = this.getBindInfo(s2).get(BISchemaBinding.class);
            if (sb != null && !sb.map) {
                sb.markAsAcknowledged();
                continue;
            }
            this.getClassSelector().pushClassScope(new CClassInfoParent.Package(this.getClassSelector().getPackage(s2.getTargetNamespace())));
            this.checkMultipleSchemaBindings(s2);
            this.processPackageJavadoc(s2);
            this.populate(s2.getAttGroupDecls(), s2);
            this.populate(s2.getAttributeDecls(), s2);
            this.populate(s2.getElementDecls(), s2);
            this.populate(s2.getModelGroupDecls(), s2);
            for (XSType t : s2.getTypes().values()) {
                stb.refererStack.push(t);
                this.model.typeUses().put(BGMBuilder.getName(t), cs.bindToType(t, (XSComponent)s2));
                stb.refererStack.pop();
            }
            this.getClassSelector().popClassScope();
        }
    }

    private void checkMultipleSchemaBindings(XSSchema schema) {
        ArrayList<Locator> locations = new ArrayList<Locator>();
        BindInfo bi = this.getBindInfo(schema);
        for (BIDeclaration bid : bi) {
            if (bid.getName() != BISchemaBinding.NAME) continue;
            locations.add(bid.getLocation());
        }
        if (locations.size() <= 1) {
            return;
        }
        this.getErrorReporter().error((Locator)locations.get(0), "BGMBuilder.MultipleSchemaBindings", schema.getTargetNamespace());
        for (int i = 1; i < locations.size(); ++i) {
            this.getErrorReporter().error((Locator)locations.get(i), "BGMBuilder.MultipleSchemaBindings.Location", new Object[0]);
        }
    }

    private void populate(Map<String, ? extends XSComponent> col, XSSchema schema) {
        ClassSelector cs = this.getClassSelector();
        for (XSComponent xSComponent : col.values()) {
            cs.bindToType(xSComponent, (XSComponent)schema);
        }
    }

    private void processPackageJavadoc(XSSchema s2) {
        BISchemaBinding cust = this.getBindInfo(s2).get(BISchemaBinding.class);
        if (cust == null) {
            return;
        }
        cust.markAsAcknowledged();
        if (cust.getJavadoc() == null) {
            return;
        }
        JTextFile html = new JTextFile("package.html");
        html.setContents(cust.getJavadoc());
        this.getClassSelector().getPackage(s2.getTargetNamespace()).addResourceFile(html);
    }

    public BindInfo getOrCreateBindInfo(XSComponent schemaComponent) {
        BindInfo bi = this._getBindInfoReadOnly(schemaComponent);
        if (bi != null) {
            return bi;
        }
        bi = new BindInfo();
        bi.setOwner(this, schemaComponent);
        this.externalBindInfos.put(schemaComponent, bi);
        return bi;
    }

    public BindInfo getBindInfo(XSComponent schemaComponent) {
        BindInfo bi = this._getBindInfoReadOnly(schemaComponent);
        if (bi != null) {
            return bi;
        }
        return this.emptyBindInfo;
    }

    private BindInfo _getBindInfoReadOnly(XSComponent schemaComponent) {
        BindInfo bi = this.externalBindInfos.get(schemaComponent);
        if (bi != null) {
            return bi;
        }
        XSAnnotation annon = schemaComponent.getAnnotation();
        if (annon != null && (bi = (BindInfo)annon.getAnnotation()) != null) {
            if (bi.getOwner() == null) {
                bi.setOwner(this, schemaComponent);
            }
            return bi;
        }
        return null;
    }

    protected final BIDom getLocalDomCustomization(XSParticle p) {
        if (p == null) {
            return null;
        }
        BIDom dom = this.getBindInfo(p).get(BIDom.class);
        if (dom != null) {
            return dom;
        }
        dom = this.getBindInfo(p.getTerm()).get(BIDom.class);
        if (dom != null) {
            return dom;
        }
        XSTerm t = p.getTerm();
        if (t.isElementDecl()) {
            return this.getBindInfo(t.asElementDecl().getType()).get(BIDom.class);
        }
        if (t.isModelGroupDecl()) {
            return this.getBindInfo(t.asModelGroupDecl().getModelGroup()).get(BIDom.class);
        }
        return null;
    }

    public void ying(XSComponent sc, @Nullable XSComponent referer) {
        if (sc.apply(this.toPurple).booleanValue() || this.getClassSelector().bindToType(sc, referer) != null) {
            sc.visit(this.purple);
        } else {
            sc.visit(this.green);
        }
    }

    public Transformer getIdentityTransformer() {
        try {
            if (this.identityTransformer == null) {
                this.identityTransformer = TransformerFactory.newInstance().newTransformer();
            }
            return this.identityTransformer;
        }
        catch (TransformerConfigurationException e) {
            throw new Error(e);
        }
    }

    public Set<XSComponent> getReferer(XSType c) {
        if (this.refFinder == null) {
            this.refFinder = new RefererFinder();
            this.refFinder.schemaSet(Ring.get(XSSchemaSet.class));
        }
        return this.refFinder.getReferer(c);
    }

    public static QName getName(XSDeclaration decl) {
        String local = decl.getName();
        if (local == null) {
            return null;
        }
        return new QName(decl.getTargetNamespace(), local);
    }

    public String deriveName(String name, XSComponent comp) {
        BISchemaBinding sb;
        XSSchema owner = comp.getOwnerSchema();
        name = this.getNameConverter().toClassName(name);
        if (owner != null && (sb = this.getBindInfo(owner).get(BISchemaBinding.class)) != null) {
            name = sb.mangleClassName(name, comp);
        }
        return name;
    }

    public boolean isGenerateMixedExtensions() {
        if (this.globalBinding != null) {
            return this.globalBinding.isGenerateMixedExtensions();
        }
        return false;
    }
}

