/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.source.util.JavacTask;
import com.sun.source.util.Plugin;
import com.sun.tools.doclint.DocLint;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import com.sun.tools.javac.util.ServiceLoader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class Main {
    String ownName;
    PrintWriter out;
    public Log log;
    boolean apiMode;
    private Option[] recognizedOptions = Option.getJavaCompilerOptions().toArray(new Option[0]);
    private OptionHelper optionHelper = new OptionHelper(){

        @Override
        public String get(Option option) {
            return Main.this.options.get(option);
        }

        @Override
        public void put(String name, String value) {
            Main.this.options.put(name, value);
        }

        @Override
        public void remove(String name) {
            Main.this.options.remove(name);
        }

        @Override
        public Log getLog() {
            return Main.this.log;
        }

        @Override
        public String getOwnName() {
            return Main.this.ownName;
        }

        @Override
        public void error(String key, Object ... args) {
            Main.this.error(key, args);
        }

        @Override
        public void addFile(File f) {
            Main.this.filenames.add(f);
        }

        @Override
        public void addClassName(String s2) {
            Main.this.classnames.append(s2);
        }
    };
    private Options options = null;
    public Set<File> filenames = null;
    public ListBuffer<String> classnames = null;
    private JavaFileManager fileManager;
    public static final String javacBundleName = "com.sun.tools.javac.resources.javac";

    public Main(String name) {
        this(name, new PrintWriter(System.err, true));
    }

    public Main(String name, PrintWriter out) {
        this.ownName = name;
        this.out = out;
    }

    void error(String key, Object ... args) {
        if (this.apiMode) {
            String msg = this.log.localize(Log.PrefixKind.JAVAC, key, args);
            throw new PropagatedException(new IllegalStateException(msg));
        }
        this.warning(key, args);
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.usage", this.ownName);
    }

    void warning(String key, Object ... args) {
        this.log.printRawLines(this.ownName + ": " + this.log.localize(Log.PrefixKind.JAVAC, key, args));
    }

    public Option getOption(String flag) {
        for (Option option : this.recognizedOptions) {
            if (!option.matches(flag)) continue;
            return option;
        }
        return null;
    }

    public void setOptions(Options options) {
        if (options == null) {
            throw new NullPointerException();
        }
        this.options = options;
    }

    public void setAPIMode(boolean apiMode) {
        this.apiMode = apiMode;
    }

    public Collection<File> processArgs(String[] flags) {
        return this.processArgs(flags, null);
    }

    public Collection<File> processArgs(String[] flags, String[] classNames) {
        Profile profile;
        String profileString;
        Target target;
        int ac = 0;
        while (ac < flags.length) {
            String flag = flags[ac];
            ++ac;
            Option option = null;
            if (flag.length() > 0) {
                int firstOptionToCheck;
                for (int j = firstOptionToCheck = flag.charAt(0) == '-' ? 0 : this.recognizedOptions.length - 1; j < this.recognizedOptions.length; ++j) {
                    if (!this.recognizedOptions[j].matches(flag)) continue;
                    option = this.recognizedOptions[j];
                    break;
                }
            }
            if (option == null) {
                this.error("err.invalid.flag", flag);
                return null;
            }
            if (option.hasArg()) {
                if (ac == flags.length) {
                    this.error("err.req.arg", flag);
                    return null;
                }
                String operand = flags[ac];
                ++ac;
                if (!option.process(this.optionHelper, flag, operand)) continue;
                return null;
            }
            if (!option.process(this.optionHelper, flag)) continue;
            return null;
        }
        if (this.options.get(Option.PROFILE) != null && this.options.get(Option.BOOTCLASSPATH) != null) {
            this.error("err.profile.bootclasspath.conflict", new Object[0]);
            return null;
        }
        if (this.classnames != null && classNames != null) {
            this.classnames.addAll((Collection<String>)Arrays.asList(classNames));
        }
        if (!this.checkDirectory(Option.D)) {
            return null;
        }
        if (!this.checkDirectory(Option.S)) {
            return null;
        }
        String sourceString = this.options.get(Option.SOURCE);
        Source source = sourceString != null ? Source.lookup(sourceString) : Source.DEFAULT;
        String targetString = this.options.get(Option.TARGET);
        Target target2 = target = targetString != null ? Target.lookup(targetString) : Target.DEFAULT;
        if (Character.isDigit(target.name.charAt(0))) {
            if (target.compareTo(source.requiredTarget()) < 0) {
                if (targetString != null) {
                    if (sourceString == null) {
                        this.warning("warn.target.default.source.conflict", targetString, source.requiredTarget().name);
                    } else {
                        this.warning("warn.source.target.conflict", sourceString, source.requiredTarget().name);
                    }
                    return null;
                }
                target = source.requiredTarget();
                this.options.put("-target", target.name);
            } else if (targetString == null && !source.allowGenerics()) {
                target = Target.JDK1_4;
                this.options.put("-target", target.name);
            }
        }
        if ((profileString = this.options.get(Option.PROFILE)) != null && !(profile = Profile.lookup(profileString)).isValid(target)) {
            this.warning("warn.profile.target.conflict", profileString, target.name);
            return null;
        }
        String showClass = this.options.get("showClass");
        if (showClass != null) {
            if (showClass.equals("showClass")) {
                showClass = "com.sun.tools.javac.Main";
            }
            this.showClass(showClass);
        }
        this.options.notifyListeners();
        return this.filenames;
    }

    private boolean checkDirectory(Option option) {
        String value = this.options.get(option);
        if (value == null) {
            return true;
        }
        File file = new File(value);
        if (!file.exists()) {
            this.error("err.dir.not.found", value);
            return false;
        }
        if (!file.isDirectory()) {
            this.error("err.file.not.directory", value);
            return false;
        }
        return true;
    }

    public Result compile(String[] args) {
        Context context = new Context();
        JavacFileManager.preRegister(context);
        Result result = this.compile(args, context);
        if (this.fileManager instanceof JavacFileManager) {
            ((JavacFileManager)this.fileManager).close();
        }
        return result;
    }

    public Result compile(String[] args, Context context) {
        return this.compile(args, context, List.nil(), null);
    }

    public Result compile(String[] args, Context context, List<JavaFileObject> fileObjects, Iterable<? extends Processor> processors) {
        return this.compile(args, null, context, fileObjects, processors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Result compile(String[] args, String[] classNames, Context context, List<JavaFileObject> fileObjects, Iterable<? extends Processor> processors) {
        context.put(Log.outKey, this.out);
        this.log = Log.instance(context);
        if (this.options == null) {
            this.options = Options.instance(context);
        }
        this.filenames = new LinkedHashSet<File>();
        this.classnames = new ListBuffer();
        JavaCompiler comp = null;
        try {
            Result result;
            String[] pluginsToCall;
            String plugins;
            boolean batchMode;
            if (args.length == 0 && (classNames == null || classNames.length == 0) && fileObjects.isEmpty()) {
                Option.HELP.process(this.optionHelper, "-help");
                Result result2 = Result.CMDERR;
                return result2;
            }
            Collection<File> files = this.processArgs(CommandLine.parse(args), classNames);
            if (files == null) {
                Result ex = Result.CMDERR;
                return ex;
            }
            if (files.isEmpty() && fileObjects.isEmpty() && this.classnames.isEmpty()) {
                if (this.options.isSet(Option.HELP) || this.options.isSet(Option.X) || this.options.isSet(Option.VERSION) || this.options.isSet(Option.FULLVERSION)) {
                    Result ex = Result.OK;
                    return ex;
                }
                if (JavaCompiler.explicitAnnotationProcessingRequested(this.options)) {
                    this.error("err.no.source.files.classes", new Object[0]);
                } else {
                    this.error("err.no.source.files", new Object[0]);
                }
                Result ex = Result.CMDERR;
                return ex;
            }
            boolean forceStdOut = this.options.isSet("stdout");
            if (forceStdOut) {
                this.log.flush();
                this.log.setWriters(new PrintWriter(System.out, true));
            }
            boolean bl = batchMode = this.options.isUnset("nonBatchMode") && System.getProperty("nonBatchMode") == null;
            if (batchMode) {
                CacheFSInfo.preRegister(context);
            }
            if ((plugins = this.options.get(Option.PLUGIN)) != null) {
                JavacProcessingEnvironment pEnv = JavacProcessingEnvironment.instance(context);
                ClassLoader cl = pEnv.getProcessorClassLoader();
                ServiceLoader<Plugin> sl = ServiceLoader.load(Plugin.class, cl);
                pluginsToCall = new LinkedHashSet();
                for (String string : plugins.split("\\x00")) {
                    pluginsToCall.add(List.from(string.split("\\s+")));
                }
                JavacTask task = null;
                for (Plugin plugin : sl) {
                    for (List list : pluginsToCall) {
                        if (!plugin.getName().equals(list.head)) continue;
                        pluginsToCall.remove(list);
                        try {
                            if (task == null) {
                                task = JavacTask.instance(pEnv);
                            }
                            plugin.init(task, list.tail.toArray(new String[list.tail.size()]));
                        }
                        catch (Throwable ex) {
                            if (this.apiMode) {
                                throw new RuntimeException(ex);
                            }
                            this.pluginMessage(ex);
                            Result result2 = Result.SYSERR;
                            if (comp != null) {
                                try {
                                    comp.close();
                                }
                                catch (ClientCodeException ex2) {
                                    throw new RuntimeException(ex2.getCause());
                                }
                            }
                            this.filenames = null;
                            this.options = null;
                            return result2;
                        }
                    }
                }
                for (List list : pluginsToCall) {
                    this.log.printLines(Log.PrefixKind.JAVAC, "msg.plugin.not.found", list.head);
                }
            }
            comp = JavaCompiler.instance(context);
            String xdoclint = this.options.get(Option.XDOCLINT);
            String xdoclintCustom = this.options.get(Option.XDOCLINT_CUSTOM);
            if (xdoclint != null || xdoclintCustom != null) {
                LinkedHashSet<String> doclintOpts = new LinkedHashSet<String>();
                if (xdoclint != null) {
                    doclintOpts.add("-Xmsgs");
                }
                if (xdoclintCustom != null) {
                    void var16_56;
                    pluginsToCall = xdoclintCustom.split("\\s+");
                    int n = pluginsToCall.length;
                    boolean bl2 = false;
                    while (var16_56 < n) {
                        String s2 = pluginsToCall[var16_56];
                        if (!s2.isEmpty()) {
                            doclintOpts.add(s2.replace(Option.XDOCLINT_CUSTOM.text, "-Xmsgs:"));
                        }
                        ++var16_56;
                    }
                }
                if (doclintOpts.size() != 1 || !((String)doclintOpts.iterator().next()).equals("-Xmsgs:none")) {
                    JavacTask t = BasicJavacTask.instance(context);
                    doclintOpts.add("-XimplicitHeaders:2");
                    new DocLint().init(t, doclintOpts.toArray(new String[doclintOpts.size()]));
                    comp.keepComments = true;
                }
            }
            this.fileManager = context.get(JavaFileManager.class);
            if (!files.isEmpty()) {
                comp = JavaCompiler.instance(context);
                List<JavaFileObject> otherFiles = List.nil();
                JavacFileManager dfm = (JavacFileManager)this.fileManager;
                for (JavaFileObject javaFileObject : dfm.getJavaFileObjectsFromFiles(files)) {
                    otherFiles = otherFiles.prepend(javaFileObject);
                }
                for (JavaFileObject javaFileObject : otherFiles) {
                    fileObjects = fileObjects.prepend(javaFileObject);
                }
            }
            comp.compile(fileObjects, this.classnames.toList(), processors);
            if (this.log.expectDiagKeys != null) {
                if (this.log.expectDiagKeys.isEmpty()) {
                    this.log.printRawLines("all expected diagnostics found");
                    result = Result.OK;
                    return result;
                }
                this.log.printRawLines("expected diagnostic keys not found: " + this.log.expectDiagKeys);
                result = Result.ERROR;
                return result;
            }
            if (comp.errorCount() != 0) {
                result = Result.ERROR;
                return result;
            }
        }
        catch (IOException ex) {
            this.ioMessage(ex);
            Result result = Result.SYSERR;
            return result;
        }
        catch (OutOfMemoryError ex) {
            this.resourceMessage(ex);
            Result result = Result.SYSERR;
            return result;
        }
        catch (StackOverflowError ex) {
            this.resourceMessage(ex);
            Result result = Result.SYSERR;
            return result;
        }
        catch (FatalError ex) {
            this.feMessage(ex);
            Result result = Result.SYSERR;
            return result;
        }
        catch (AnnotationProcessingError ex) {
            if (this.apiMode) {
                throw new RuntimeException(ex.getCause());
            }
            this.apMessage(ex);
            Result result = Result.SYSERR;
            return result;
        }
        catch (ClientCodeException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (PropagatedException ex) {
            throw ex.getCause();
        }
        catch (Throwable ex) {
            if (comp == null || comp.errorCount() == 0 || this.options == null || this.options.isSet("dev")) {
                this.bugMessage(ex);
            }
            Result result = Result.ABNORMAL;
            return result;
        }
        finally {
            if (comp != null) {
                try {
                    comp.close();
                }
                catch (ClientCodeException ex) {
                    throw new RuntimeException(ex.getCause());
                }
            }
            this.filenames = null;
            this.options = null;
        }
        return Result.OK;
    }

    void bugMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.bug", JavaCompiler.version());
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void feMessage(Throwable ex) {
        this.log.printRawLines(ex.getMessage());
        if (ex.getCause() != null && this.options.isSet("dev")) {
            ex.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
        }
    }

    void ioMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void resourceMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.resource", new Object[0]);
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void apMessage(AnnotationProcessingError ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.proc.annotation.uncaught.exception", new Object[0]);
        ex.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void pluginMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.plugin.uncaught.exception", new Object[0]);
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showClass(String className) {
        PrintWriter pw = this.log.getWriter(Log.WriterKind.NOTICE);
        pw.println("javac: show class: " + className);
        URL url = this.getClass().getResource('/' + className.replace('.', '/') + ".class");
        if (url == null) {
            pw.println("  class not found");
        } else {
            pw.println("  " + url);
            try {
                byte[] digest;
                String algorithm = "MD5";
                MessageDigest md = MessageDigest.getInstance("MD5");
                try (DigestInputStream in = new DigestInputStream(url.openStream(), md);){
                    int n;
                    byte[] buf = new byte[8192];
                    while ((n = in.read(buf)) > 0) {
                    }
                    digest = md.digest();
                }
                StringBuilder sb = new StringBuilder();
                for (byte b : digest) {
                    sb.append(String.format("%02x", b));
                }
                pw.println("  MD5 checksum: " + sb);
            }
            catch (Exception e) {
                pw.println("  cannot compute digest: " + e);
            }
        }
    }

    public static enum Result {
        OK(0),
        ERROR(1),
        CMDERR(2),
        SYSERR(3),
        ABNORMAL(4);

        public final int exitCode;

        private Result(int exitCode) {
            this.exitCode = exitCode;
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }
    }
}

