/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveTypeImpl;
import com.sun.tools.jdi.ValueContainer;
import com.sun.tools.jdi.ValueImpl;

public abstract class PrimitiveValueImpl
extends ValueImpl
implements PrimitiveValue {
    PrimitiveValueImpl(VirtualMachine virtualMachine) {
        super(virtualMachine);
    }

    @Override
    public abstract boolean booleanValue();

    @Override
    public abstract byte byteValue();

    @Override
    public abstract char charValue();

    @Override
    public abstract short shortValue();

    @Override
    public abstract int intValue();

    @Override
    public abstract long longValue();

    @Override
    public abstract float floatValue();

    @Override
    public abstract double doubleValue();

    byte checkedByteValue() throws InvalidTypeException {
        return this.byteValue();
    }

    char checkedCharValue() throws InvalidTypeException {
        return this.charValue();
    }

    short checkedShortValue() throws InvalidTypeException {
        return this.shortValue();
    }

    int checkedIntValue() throws InvalidTypeException {
        return this.intValue();
    }

    long checkedLongValue() throws InvalidTypeException {
        return this.longValue();
    }

    float checkedFloatValue() throws InvalidTypeException {
        return this.floatValue();
    }

    final boolean checkedBooleanValue() throws InvalidTypeException {
        if (this instanceof BooleanValue) {
            return this.booleanValue();
        }
        throw new InvalidTypeException("Can't convert non-boolean value to boolean");
    }

    final double checkedDoubleValue() throws InvalidTypeException {
        return this.doubleValue();
    }

    @Override
    ValueImpl prepareForAssignmentTo(ValueContainer valueContainer) throws InvalidTypeException {
        return this.convertForAssignmentTo(valueContainer);
    }

    ValueImpl convertForAssignmentTo(ValueContainer valueContainer) throws InvalidTypeException {
        if (valueContainer.signature().length() > 1) {
            throw new InvalidTypeException("Can't assign primitive value to object");
        }
        if (valueContainer.signature().charAt(0) == 'Z' && this.type().signature().charAt(0) != 'Z') {
            throw new InvalidTypeException("Can't assign non-boolean value to a boolean");
        }
        if (valueContainer.signature().charAt(0) != 'Z' && this.type().signature().charAt(0) == 'Z') {
            throw new InvalidTypeException("Can't assign boolean value to an non-boolean");
        }
        if ("void".equals(valueContainer.typeName())) {
            throw new InvalidTypeException("Can't assign primitive value to a void");
        }
        try {
            PrimitiveTypeImpl primitiveTypeImpl = (PrimitiveTypeImpl)valueContainer.type();
            return (ValueImpl)((Object)primitiveTypeImpl.convert(this));
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InternalException("Signature and type inconsistent for: " + valueContainer.typeName());
        }
    }
}

