/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.guieffect;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.guieffect.Effect;
import org.checkerframework.checker.guieffect.GuiEffectTypeFactory;
import org.checkerframework.checker.guieffect.qual.AlwaysSafe;
import org.checkerframework.checker.guieffect.qual.PolyUI;
import org.checkerframework.checker.guieffect.qual.PolyUIEffect;
import org.checkerframework.checker.guieffect.qual.PolyUIType;
import org.checkerframework.checker.guieffect.qual.SafeEffect;
import org.checkerframework.checker.guieffect.qual.UI;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

public class GuiEffectVisitor
extends BaseTypeVisitor<GuiEffectTypeFactory> {
    protected final boolean debugSpew;
    protected final ArrayDeque<Effect> effStack;
    protected final ArrayDeque<MethodTree> currentMethods;

    public GuiEffectVisitor(BaseTypeChecker checker) {
        super(checker);
        this.debugSpew = checker.getLintOption("debugSpew", false);
        if (this.debugSpew) {
            System.err.println("Running GuiEffectVisitor");
        }
        this.effStack = new ArrayDeque();
        this.currentMethods = new ArrayDeque();
    }

    @Override
    protected GuiEffectTypeFactory createTypeFactory() {
        return new GuiEffectTypeFactory(this.checker, this.debugSpew);
    }

    @Override
    protected void checkMethodInvocability(AnnotatedTypeMirror.AnnotatedExecutableType method, MethodInvocationTree node) {
    }

    @Override
    protected BaseTypeVisitor.OverrideChecker createOverrideChecker(Tree overriderTree, AnnotatedTypeMirror.AnnotatedExecutableType overrider, AnnotatedTypeMirror overridingType, AnnotatedTypeMirror overridingReturnType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, AnnotatedTypeMirror overriddenReturnType) {
        return new GuiEffectOverrideChecker(overriderTree, overrider, overridingType, overridingReturnType, overridden, overriddenType, overriddenReturnType);
    }

    @Override
    protected Set<? extends AnnotationMirror> getExceptionParameterLowerBoundAnnotations() {
        return Collections.singleton(AnnotationBuilder.fromClass(this.elements, AlwaysSafe.class));
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        boolean ret;
        boolean bl = ret = useType.hasAnnotation(AlwaysSafe.class) || useType.hasAnnotation(PolyAll.class) || useType.hasAnnotation(PolyUI.class) || ((GuiEffectTypeFactory)this.atypeFactory).isPolymorphicType((TypeElement)declarationType.getUnderlyingType().asElement()) || useType.hasAnnotation(UI.class) && declarationType.hasAnnotation(UI.class);
        if (this.debugSpew && !ret) {
            System.err.println("use: " + useType);
            System.err.println("use safe: " + useType.hasAnnotation(AlwaysSafe.class));
            System.err.println("use poly: " + useType.hasAnnotation(PolyUI.class));
            System.err.println("use ui: " + useType.hasAnnotation(UI.class));
            System.err.println("declaration safe: " + declarationType.hasAnnotation(AlwaysSafe.class));
            System.err.println("declaration poly: " + ((GuiEffectTypeFactory)this.atypeFactory).isPolymorphicType((TypeElement)declarationType.getUnderlyingType().asElement()));
            System.err.println("declaration ui: " + declarationType.hasAnnotation(UI.class));
            System.err.println("declaration: " + declarationType);
        }
        return ret;
    }

    private void lambdaAssignmentCheck(AnnotatedTypeMirror varType, LambdaExpressionTree lambdaExp, @CompilerMessageKey String errorKey) {
        AnnotatedTypeMirror lambdaType = ((GuiEffectTypeFactory)this.atypeFactory).getAnnotatedType(lambdaExp);
        assert (lambdaType != null) : "null type for expression: " + lambdaExp;
        this.commonAssignmentCheck(varType, lambdaType, lambdaExp, errorKey);
    }

    @Override
    public Void visitVariable(VariableTree node, Void p) {
        Void result = super.visitVariable(node, p);
        if (node.getInitializer() != null && node.getInitializer().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            this.lambdaAssignmentCheck(((GuiEffectTypeFactory)this.atypeFactory).getAnnotatedType(node), (LambdaExpressionTree)node.getInitializer(), "assignment.type.incompatible");
        }
        return result;
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Void p) {
        Void result = super.visitAssignment(node, p);
        if (node.getExpression().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            this.lambdaAssignmentCheck(((GuiEffectTypeFactory)this.atypeFactory).getAnnotatedType(node.getVariable()), (LambdaExpressionTree)node.getExpression(), "assignment.type.incompatible");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitReturn(ReturnTree node, Void p) {
        Void result = super.visitReturn(node, p);
        if (node.getExpression() != null && node.getExpression().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
            try {
                Tree enclosing = TreeUtils.enclosingMethodOrLambda(this.getCurrentPath());
                AnnotatedTypeMirror ret = null;
                if (enclosing.getKind() == Tree.Kind.METHOD) {
                    MethodTree enclosingMethod = (MethodTree)enclosing;
                    boolean valid = this.validateTypeOf(enclosing);
                    if (valid) {
                        ret = ((GuiEffectTypeFactory)this.atypeFactory).getMethodReturnType(enclosingMethod, node);
                    }
                } else {
                    ret = ((AnnotatedTypeMirror.AnnotatedExecutableType)((GuiEffectTypeFactory)this.atypeFactory).getFnInterfaceFromTree((LambdaExpressionTree)((LambdaExpressionTree)enclosing)).second).getReturnType();
                }
                if (ret != null) {
                    this.visitorState.setAssignmentContext(Pair.of(node, ret));
                    this.lambdaAssignmentCheck(ret, (LambdaExpressionTree)node.getExpression(), "return.type.incompatible");
                }
            }
            finally {
                this.visitorState.setAssignmentContext(preAssCtxt);
            }
        }
        return result;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        Tree callerTree;
        if (this.debugSpew) {
            System.err.println("For invocation " + node + " in " + this.currentMethods.peek().getName());
        }
        ExecutableElement methodElt = TreeUtils.elementFromUse(node);
        if (this.debugSpew) {
            System.err.println("methodElt found");
        }
        if ((callerTree = TreeUtils.enclosingMethodOrLambda(this.getCurrentPath())) == null) {
            if (this.debugSpew) {
                System.err.println("No enclosing method: likely static initializer");
            }
            return super.visitMethodInvocation(node, p);
        }
        if (this.debugSpew) {
            System.err.println("callerTree found: " + (Object)((Object)callerTree.getKind()));
        }
        Effect targetEffect = ((GuiEffectTypeFactory)this.atypeFactory).getComputedEffectAtCallsite(node, this.visitorState.getMethodReceiver(), methodElt);
        Effect callerEffect = null;
        if (callerTree.getKind() == Tree.Kind.METHOD) {
            ExecutableElement callerElt = TreeUtils.elementFromDeclaration((MethodTree)callerTree);
            if (this.debugSpew) {
                System.err.println("callerElt found");
            }
            callerEffect = ((GuiEffectTypeFactory)this.atypeFactory).getDeclaredEffect(callerElt);
            assert (this.currentMethods.peek() == null || callerEffect.equals(this.effStack.peek()));
        } else if (callerTree.getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            callerEffect = ((GuiEffectTypeFactory)this.atypeFactory).getInferedEffectForLambdaExpression((LambdaExpressionTree)callerTree);
            if (targetEffect.isUI() && callerEffect.isPoly()) {
                ((GuiEffectTypeFactory)this.atypeFactory).constrainLambdaToUI((LambdaExpressionTree)callerTree);
                callerEffect = new Effect(UIEffect.class);
            }
        }
        assert (callerEffect != null);
        if (!Effect.LE(targetEffect, callerEffect)) {
            this.checker.report(Result.failure("call.invalid.ui", targetEffect, callerEffect), node);
            if (this.debugSpew) {
                System.err.println("Issuing error for node: " + node);
            }
        }
        if (this.debugSpew) {
            System.err.println("Successfully finished main non-recursive checkinv of invocation " + node);
        }
        Void result = super.visitMethodInvocation(node, p);
        List<? extends ExpressionTree> args = node.getArguments();
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = ((GuiEffectTypeFactory)this.atypeFactory).methodFromUse(node);
        AnnotatedTypeMirror.AnnotatedExecutableType invokedMethod = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        List<AnnotatedTypeMirror> argsTypes = AnnotatedTypes.expandVarArgs(this.atypeFactory, invokedMethod, node.getArguments());
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i).getKind() != Tree.Kind.LAMBDA_EXPRESSION) continue;
            this.lambdaAssignmentCheck(argsTypes.get(i), (LambdaExpressionTree)args.get(i), "argument.type.incompatible");
        }
        return result;
    }

    @Override
    public Void visitMethod(MethodTree node, Void p) {
        ExecutableElement methElt = TreeUtils.elementFromDeclaration(node);
        if (this.debugSpew) {
            System.err.println("\nVisiting method " + methElt);
        }
        assert (methElt != null);
        AnnotationMirror targetUIP = ((GuiEffectTypeFactory)this.atypeFactory).getDeclAnnotation(methElt, UIEffect.class);
        AnnotationMirror targetSafeP = ((GuiEffectTypeFactory)this.atypeFactory).getDeclAnnotation(methElt, SafeEffect.class);
        AnnotationMirror targetPolyP = ((GuiEffectTypeFactory)this.atypeFactory).getDeclAnnotation(methElt, PolyUIEffect.class);
        TypeElement targetClassElt = (TypeElement)methElt.getEnclosingElement();
        if (targetUIP != null && (targetSafeP != null || targetPolyP != null) || targetSafeP != null && targetPolyP != null) {
            this.checker.report(Result.failure("annotations.conflicts", new Object[0]), node);
        }
        if (targetPolyP != null && !((GuiEffectTypeFactory)this.atypeFactory).isPolymorphicType(targetClassElt)) {
            this.checker.report(Result.failure("polymorphism.invalid", new Object[0]), node);
        }
        if (targetUIP != null && ((GuiEffectTypeFactory)this.atypeFactory).isUIType(targetClassElt)) {
            this.checker.report(Result.warning("effects.redundant.uitype", new Object[0]), node);
        }
        Effect.EffectRange range = ((GuiEffectTypeFactory)this.atypeFactory).findInheritedEffectRange((TypeElement)methElt.getEnclosingElement(), methElt, true, node);
        this.currentMethods.addFirst(node);
        this.effStack.addFirst(((GuiEffectTypeFactory)this.atypeFactory).getDeclaredEffect(methElt));
        if (this.debugSpew) {
            System.err.println("Pushing " + this.effStack.peek() + " onto the stack when checking " + methElt);
        }
        Void ret = super.visitMethod(node, p);
        this.currentMethods.removeFirst();
        this.effStack.removeFirst();
        return ret;
    }

    protected class GuiEffectOverrideChecker
    extends BaseTypeVisitor.OverrideChecker {
        @Override
        protected boolean checkReceiverOverride() {
            AnnotatedTypeMirror.AnnotatedDeclaredType overriddenReceiver = this.overrider.getReceiverType().getErased().shallowCopy(false);
            overriddenReceiver.addAnnotations(this.overridden.getReceiverType().getAnnotations());
            if (!((GuiEffectTypeFactory)GuiEffectVisitor.this.atypeFactory).getTypeHierarchy().isSubtype(overriddenReceiver, this.overrider.getReceiverType().getErased())) {
                boolean safeReceiverOverride;
                boolean safeParent = this.overriddenType.getAnnotation(AlwaysSafe.class) != null;
                boolean polyParentDecl = ((GuiEffectTypeFactory)GuiEffectVisitor.this.atypeFactory).getDeclAnnotation(this.overriddenType.getUnderlyingType().asElement(), PolyUIType.class) != null;
                boolean bl = safeReceiverOverride = this.overrider.getReceiverType().getAnnotation(AlwaysSafe.class) != null;
                if (safeParent && polyParentDecl && safeReceiverOverride) {
                    return true;
                }
                GuiEffectVisitor.this.checker.report(Result.failure("override.receiver.invalid", this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, this.overrider.getReceiverType(), this.overridden.getReceiverType()), this.overriderTree);
                return false;
            }
            return true;
        }

        public GuiEffectOverrideChecker(Tree overriderTree, AnnotatedTypeMirror.AnnotatedExecutableType overrider, AnnotatedTypeMirror overridingType, AnnotatedTypeMirror overridingReturnType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, AnnotatedTypeMirror overriddenReturnType) {
            super(GuiEffectVisitor.this, overriderTree, overrider, overridingType, overridingReturnType, overridden, overriddenType, overriddenReturnType);
        }
    }
}

