/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.io.classfile;

import org.checkerframework.org.objectweb.asm.ClassReader;
import org.checkerframework.org.objectweb.asm.Handle;
import org.checkerframework.org.objectweb.asm.Label;
import org.checkerframework.org.objectweb.asm.MethodAdapter;
import org.checkerframework.org.objectweb.asm.MethodVisitor;

class MethodCodeOffsetAdapter
extends MethodAdapter {
    private final ClassReader cr;
    private final int methodStart;
    private int offset = 0;
    private int codeStart = 0;
    private int attrCount = 0;

    public MethodCodeOffsetAdapter(ClassReader classReader, MethodVisitor methodVisitor, int start) {
        super(methodVisitor);
        String attrName;
        char[] buf = new char[classReader.header];
        this.methodStart = start;
        this.cr = classReader;
        this.codeStart = start;
        this.attrCount = classReader.readUnsignedShort(this.codeStart + 6);
        this.codeStart += 8;
        while (this.attrCount > 0 && !"Code".equals(attrName = classReader.readUTF8(this.codeStart, buf))) {
            this.codeStart += 6 + classReader.readInt(this.codeStart + 2);
            --this.attrCount;
        }
    }

    private int readInt(int i) {
        return this.cr.readInt(this.codeStart + i);
    }

    public int getMethodCodeStart() {
        return this.methodStart;
    }

    public int getMethodCodeOffset() {
        return this.offset;
    }

    public int getClassCodeOffset() {
        return this.codeStart + this.offset;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
        this.offset += 3;
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.offset += 3;
    }

    @Override
    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        ++this.offset;
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        this.offset += opcode == 17 ? 3 : 2;
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        this.offset += 5;
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        this.offset += 3;
    }

    @Override
    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(cst);
        this.offset += 2;
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.offset += 8 - (this.offset - this.codeStart & 3);
        this.offset += 4 + 8 * this.readInt(this.offset);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        super.visitMethodInsn(opcode, owner, name, desc);
        this.offset += opcode == 185 ? 5 : 3;
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(desc, dims);
        this.offset += 4;
    }

    @Override
    public void visitTableSwitchInsn(int min2, int max, Label dflt, Label[] labels) {
        super.visitTableSwitchInsn(min2, max, dflt, labels);
        this.offset += 8 - (this.offset - this.codeStart & 3);
        this.offset += 4 * (this.readInt(this.offset + 4) - this.readInt(this.offset) + 3);
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        super.visitTypeInsn(opcode, desc);
        this.offset += 3;
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.offset += var < 4 ? 1 : 2;
    }

    @Override
    public void visitEnd() {
        this.offset = -1;
    }
}

