/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Descriptor;
import com.sun.tools.classfile.Type;
import java.util.ArrayList;
import java.util.List;

public class Signature
extends Descriptor {
    private String sig;
    private int sigp;
    private Type type;

    public Signature(int n) {
        super(n);
    }

    public Type getType(ConstantPool constantPool) throws ConstantPoolException {
        if (this.type == null) {
            this.type = this.parse(this.getValue(constantPool));
        }
        return this.type;
    }

    @Override
    public int getParameterCount(ConstantPool constantPool) throws ConstantPoolException {
        Type.MethodType methodType = (Type.MethodType)this.getType(constantPool);
        return methodType.paramTypes.size();
    }

    @Override
    public String getParameterTypes(ConstantPool constantPool) throws ConstantPoolException {
        Type.MethodType methodType = (Type.MethodType)this.getType(constantPool);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        String string = "";
        for (Type type : methodType.paramTypes) {
            stringBuilder.append(string);
            stringBuilder.append(type);
            string = ", ";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String getReturnType(ConstantPool constantPool) throws ConstantPoolException {
        Type.MethodType methodType = (Type.MethodType)this.getType(constantPool);
        return methodType.returnType.toString();
    }

    @Override
    public String getFieldType(ConstantPool constantPool) throws ConstantPoolException {
        return this.getType(constantPool).toString();
    }

    private Type parse(String string) {
        this.sig = string;
        this.sigp = 0;
        List<Type.TypeParamType> list = null;
        if (string.charAt(this.sigp) == '<') {
            list = this.parseTypeParamTypes();
        }
        if (string.charAt(this.sigp) == '(') {
            List<Type> list2 = this.parseTypeSignatures(')');
            Type type = this.parseTypeSignature();
            ArrayList<Type> arrayList = null;
            while (this.sigp < string.length() && string.charAt(this.sigp) == '^') {
                ++this.sigp;
                if (arrayList == null) {
                    arrayList = new ArrayList<Type>();
                }
                arrayList.add(this.parseTypeSignature());
            }
            return new Type.MethodType(list, list2, type, arrayList);
        }
        Type type = this.parseTypeSignature();
        if (list == null && this.sigp == string.length()) {
            return type;
        }
        Type type2 = type;
        ArrayList<Type> arrayList = null;
        while (this.sigp < string.length()) {
            if (arrayList == null) {
                arrayList = new ArrayList<Type>();
            }
            arrayList.add(this.parseTypeSignature());
        }
        return new Type.ClassSigType(list, type2, arrayList);
    }

    private Type parseTypeSignature() {
        switch (this.sig.charAt(this.sigp)) {
            case 'B': {
                ++this.sigp;
                return new Type.SimpleType("byte");
            }
            case 'C': {
                ++this.sigp;
                return new Type.SimpleType("char");
            }
            case 'D': {
                ++this.sigp;
                return new Type.SimpleType("double");
            }
            case 'F': {
                ++this.sigp;
                return new Type.SimpleType("float");
            }
            case 'I': {
                ++this.sigp;
                return new Type.SimpleType("int");
            }
            case 'J': {
                ++this.sigp;
                return new Type.SimpleType("long");
            }
            case 'L': {
                return this.parseClassTypeSignature();
            }
            case 'S': {
                ++this.sigp;
                return new Type.SimpleType("short");
            }
            case 'T': {
                return this.parseTypeVariableSignature();
            }
            case 'V': {
                ++this.sigp;
                return new Type.SimpleType("void");
            }
            case 'Z': {
                ++this.sigp;
                return new Type.SimpleType("boolean");
            }
            case '[': {
                ++this.sigp;
                return new Type.ArrayType(this.parseTypeSignature());
            }
            case '*': {
                ++this.sigp;
                return new Type.WildcardType();
            }
            case '+': {
                ++this.sigp;
                return new Type.WildcardType(Type.WildcardType.Kind.EXTENDS, this.parseTypeSignature());
            }
            case '-': {
                ++this.sigp;
                return new Type.WildcardType(Type.WildcardType.Kind.SUPER, this.parseTypeSignature());
            }
        }
        throw new IllegalStateException(this.debugInfo());
    }

    private List<Type> parseTypeSignatures(char c) {
        ++this.sigp;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        while (this.sig.charAt(this.sigp) != c) {
            arrayList.add(this.parseTypeSignature());
        }
        ++this.sigp;
        return arrayList;
    }

    private Type parseClassTypeSignature() {
        assert (this.sig.charAt(this.sigp) == 'L');
        ++this.sigp;
        return this.parseClassTypeSignatureRest();
    }

    private Type parseClassTypeSignatureRest() {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        List<Type> list = null;
        Type.ClassType classType = null;
        do {
            c = this.sig.charAt(this.sigp);
            switch (c) {
                case '<': {
                    list = this.parseTypeSignatures('>');
                    break;
                }
                case '.': 
                case ';': {
                    ++this.sigp;
                    classType = new Type.ClassType(classType, stringBuilder.toString(), list);
                    stringBuilder.setLength(0);
                    list = null;
                    break;
                }
                default: {
                    ++this.sigp;
                    stringBuilder.append(c);
                }
            }
        } while (c != ';');
        return classType;
    }

    private List<Type.TypeParamType> parseTypeParamTypes() {
        assert (this.sig.charAt(this.sigp) == '<');
        ++this.sigp;
        ArrayList<Type.TypeParamType> arrayList = new ArrayList<Type.TypeParamType>();
        while (this.sig.charAt(this.sigp) != '>') {
            arrayList.add(this.parseTypeParamType());
        }
        ++this.sigp;
        return arrayList;
    }

    private Type.TypeParamType parseTypeParamType() {
        int n = this.sig.indexOf(":", this.sigp);
        String string = this.sig.substring(this.sigp, n);
        Type type = null;
        ArrayList<Type> arrayList = null;
        this.sigp = n + 1;
        if (this.sig.charAt(this.sigp) != ':') {
            type = this.parseTypeSignature();
        }
        while (this.sig.charAt(this.sigp) == ':') {
            ++this.sigp;
            if (arrayList == null) {
                arrayList = new ArrayList<Type>();
            }
            arrayList.add(this.parseTypeSignature());
        }
        return new Type.TypeParamType(string, type, arrayList);
    }

    private Type parseTypeVariableSignature() {
        ++this.sigp;
        int n = this.sig.indexOf(59, this.sigp);
        Type.SimpleType simpleType2 = new Type.SimpleType(this.sig.substring(this.sigp, n));
        this.sigp = n + 1;
        return simpleType2;
    }

    private String debugInfo() {
        return this.sig.substring(0, this.sigp) + "!" + this.sig.charAt(this.sigp) + "!" + this.sig.substring(this.sigp + 1);
    }
}

