/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ByteValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveValueImpl;

public class ByteValueImpl
extends PrimitiveValueImpl
implements ByteValue {
    private byte value;

    ByteValueImpl(VirtualMachine virtualMachine, byte by) {
        super(virtualMachine);
        this.value = by;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof ByteValue) {
            return this.value == ((ByteValue)object).value() && super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.intValue();
    }

    @Override
    public int compareTo(ByteValue byteValue) {
        byte by = byteValue.value();
        return this.value() - by;
    }

    @Override
    public Type type() {
        return this.vm.theByteType();
    }

    @Override
    public byte value() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535 || this.value < 0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    byte typeValueKey() {
        return 66;
    }
}

