/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.github.javaparser.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.com.github.javaparser.ParseResult;
import org.checkerframework.com.github.javaparser.ParserConfiguration;
import org.checkerframework.com.github.javaparser.ast.Node;

public class PostProcessors
implements ParseResult.PostProcessor {
    private final List<ParseResult.PostProcessor> postProcessors = new ArrayList<ParseResult.PostProcessor>();

    public PostProcessors(ParseResult.PostProcessor ... postProcessors) {
        this.postProcessors.addAll(Arrays.asList(postProcessors));
    }

    public List<ParseResult.PostProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public PostProcessors remove(ParseResult.PostProcessor postProcessor) {
        if (!this.postProcessors.remove(postProcessor)) {
            throw new AssertionError((Object)"Trying to remove a post processor that isn't there.");
        }
        return this;
    }

    public PostProcessors replace(ParseResult.PostProcessor oldProcessor, ParseResult.PostProcessor newProcessor) {
        this.remove(oldProcessor);
        this.add(newProcessor);
        return this;
    }

    public PostProcessors add(ParseResult.PostProcessor newProcessor) {
        this.postProcessors.add(newProcessor);
        return this;
    }

    @Override
    public void process(ParseResult<? extends Node> result, ParserConfiguration configuration) {
        this.postProcessors.forEach(pp -> pp.process(result, configuration));
    }
}

