/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.subtyping;

import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.subtyping.SubtypingAnnotationClassLoader;
import org.checkerframework.framework.qual.SubtypeOf;
import org.checkerframework.framework.type.AnnotationClassLoader;

public class SubtypingAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public SubtypingAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.postInit();
    }

    @Override
    protected AnnotationClassLoader createAnnotationClassLoader() {
        return new SubtypingAnnotationClassLoader(this.checker);
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        this.loader = this.createAnnotationClassLoader();
        LinkedHashSet<Class<? extends Annotation>> qualSet = new LinkedHashSet<Class<? extends Annotation>>();
        String qualNames = this.checker.getOption("quals");
        String qualDirectories = this.checker.getOption("qualDirs");
        if (qualNames == null && qualDirectories == null) {
            this.checker.userErrorAbort("SubtypingChecker: missing required option. Use -Aquals or -AqualDirs");
            throw new Error("This can't happen");
        }
        if (qualNames != null) {
            for (String qualName : qualNames.split(",")) {
                qualSet.add(this.loader.loadExternalAnnotationClass(qualName));
            }
        }
        if (qualDirectories != null) {
            for (String dirName : qualDirectories.split(":")) {
                qualSet.addAll(this.loader.loadExternalAnnotationClassesFromDirectory(dirName));
            }
        }
        for (Class clazz : qualSet) {
            SubtypeOf subtypeOfAnnotation = clazz.getAnnotation(SubtypeOf.class);
            if (subtypeOfAnnotation == null) continue;
            for (Class<? extends Annotation> superqual : clazz.getAnnotation(SubtypeOf.class).value()) {
                if (qualSet.contains(superqual)) continue;
                this.checker.userErrorAbort("SubtypingChecker: qualifier " + clazz + " was specified via -Aquals but its super-qualifier " + superqual + " was not");
            }
        }
        return qualSet;
    }
}

