/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Criterion;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

public class ReceiverCriterion
implements Criterion {
    private final String methodName;
    private final Criterion isSigMethodCriterion;

    public ReceiverCriterion(String string) {
        this.methodName = string;
        this.isSigMethodCriterion = Criteria.isSigMethod(string);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        MethodTree methodTree;
        TreePath treePath2;
        if (treePath == null) {
            return false;
        }
        if (treePath.getLeaf().getKind() == Tree.Kind.METHOD) {
            if (this.isSigMethodCriterion.isSatisfiedBy(treePath)) {
                MethodTree methodTree2 = (MethodTree)treePath.getLeaf();
                return methodTree2.getReceiverParameter() == null;
            }
            return false;
        }
        Tree tree = null;
        for (treePath2 = treePath; treePath2 != null && treePath2.getLeaf().getKind() != Tree.Kind.METHOD; treePath2 = treePath2.getParentPath()) {
            if (treePath2.getLeaf().getKind() != Tree.Kind.VARIABLE) continue;
            if (tree == null) {
                tree = treePath2.getLeaf();
                continue;
            }
            return false;
        }
        if (treePath2 != null && tree != null && tree == (methodTree = (MethodTree)treePath2.getLeaf()).getReceiverParameter()) {
            return this.isSigMethodCriterion.isSatisfiedBy(treePath2);
        }
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.RECEIVER;
    }

    public String toString() {
        return "ReceiverCriterion for method: " + this.methodName;
    }
}

