/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.initialization.InitializationAnnotatedTypeFactory;
import org.checkerframework.checker.initialization.qual.FBCBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.AbstractNullnessChecker;
import org.checkerframework.checker.nullness.CollectionToArrayHeuristics;
import org.checkerframework.checker.nullness.NullnessAnalysis;
import org.checkerframework.checker.nullness.NullnessAnnotatedTypeFormatter;
import org.checkerframework.checker.nullness.NullnessStore;
import org.checkerframework.checker.nullness.NullnessTransfer;
import org.checkerframework.checker.nullness.NullnessValue;
import org.checkerframework.checker.nullness.SystemGetPropertyHandler;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.Raw;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeFormatter;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ImplicitsTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.type.typeannotator.ImplicitsTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.ListTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.PropagationTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class NullnessAnnotatedTypeFactory
extends InitializationAnnotatedTypeFactory<NullnessValue, NullnessStore, NullnessTransfer, NullnessAnalysis> {
    protected final AnnotationMirror NONNULL;
    protected final AnnotationMirror NULLABLE;
    protected final AnnotationMirror POLYNULL;
    protected final AnnotationMirror MONOTONIC_NONNULL;
    protected final SystemGetPropertyHandler systemGetPropertyHandler;
    protected final CollectionToArrayHeuristics collectionToArrayHeuristics;
    protected final Set<Class<? extends Annotation>> nullnessAnnos;
    private static final List<String> NONNULL_ALIASES = Arrays.asList("android.annotation.NonNull", "android.support.annotation.NonNull", "com.sun.istack.internal.NotNull", "edu.umd.cs.findbugs.annotations.NonNull", "javax.annotation.Nonnull", "javax.validation.constraints.NotNull", "lombok.NonNull", "org.eclipse.jdt.annotation.NonNull", "org.eclipse.jgit.annotations.NonNull", "org.jetbrains.annotations.NotNull", "org.jmlspecs.annotation.NonNull", "org.netbeans.api.annotations.common.NonNull", "org.springframework.lang.NonNull", "org.checkerframework.checker.nullness.compatqual.NonNullDecl", "org.checkerframework.checker.nullness.compatqual.NonNullType");
    private static final List<String> NULLABLE_ALIASES = Arrays.asList("android.annotation.Nullable", "android.support.annotation.Nullable", "com.sun.istack.internal.Nullable", "edu.umd.cs.findbugs.annotations.CheckForNull", "edu.umd.cs.findbugs.annotations.Nullable", "edu.umd.cs.findbugs.annotations.PossiblyNull", "edu.umd.cs.findbugs.annotations.UnknownNullness", "javax.annotation.CheckForNull", "javax.annotation.Nullable", "org.eclipse.jdt.annotation.Nullable", "org.eclipse.jgit.annotations.Nullable", "org.jetbrains.annotations.Nullable", "org.jmlspecs.annotation.Nullable", "org.netbeans.api.annotations.common.CheckForNull", "org.netbeans.api.annotations.common.NullAllowed", "org.netbeans.api.annotations.common.NullUnknown", "org.springframework.lang.Nullable", "org.checkerframework.checker.nullness.compatqual.NullableDecl", "org.checkerframework.checker.nullness.compatqual.NullableType");

    public NullnessAnnotatedTypeFactory(BaseTypeChecker checker, boolean useFbc) {
        super(checker, useFbc);
        this.NONNULL = AnnotationBuilder.fromClass(this.elements, NonNull.class);
        this.NULLABLE = AnnotationBuilder.fromClass(this.elements, Nullable.class);
        this.POLYNULL = AnnotationBuilder.fromClass(this.elements, PolyNull.class);
        this.MONOTONIC_NONNULL = AnnotationBuilder.fromClass(this.elements, MonotonicNonNull.class);
        LinkedHashSet<Class<PolyAll>> tempNullnessAnnos = new LinkedHashSet<Class<PolyAll>>();
        tempNullnessAnnos.add(NonNull.class);
        tempNullnessAnnos.add(MonotonicNonNull.class);
        tempNullnessAnnos.add(Nullable.class);
        tempNullnessAnnos.add(PolyNull.class);
        tempNullnessAnnos.add(PolyAll.class);
        this.nullnessAnnos = Collections.unmodifiableSet(tempNullnessAnnos);
        NONNULL_ALIASES.forEach(annotation -> this.addAliasedAnnotation((String)annotation, this.NONNULL));
        NULLABLE_ALIASES.forEach(annotation -> this.addAliasedAnnotation((String)annotation, this.NULLABLE));
        this.addAliasedAnnotation("org.checkerframework.checker.nullness.compatqual.PolyNullDecl", this.POLYNULL);
        this.addAliasedAnnotation("org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl", this.MONOTONIC_NONNULL);
        this.addAliasedAnnotation("org.checkerframework.checker.nullness.compatqual.PolyNullType", this.POLYNULL);
        this.addAliasedAnnotation("org.checkerframework.checker.nullness.compatqual.MonotonicNonNullType", this.MONOTONIC_NONNULL);
        this.systemGetPropertyHandler = new SystemGetPropertyHandler(this.processingEnv, this);
        this.postInit();
        this.collectionToArrayHeuristics = new CollectionToArrayHeuristics(this.processingEnv, this);
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        AbstractNullnessChecker ckr = (AbstractNullnessChecker)this.checker;
        if (ckr.useFbc) {
            return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(Nullable.class, MonotonicNonNull.class, NonNull.class, UnderInitialization.class, Initialized.class, UnknownInitialization.class, FBCBottom.class, PolyNull.class, PolyAll.class));
        }
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(Nullable.class, MonotonicNonNull.class, NonNull.class, NonRaw.class, Raw.class, PolyNull.class, PolyAll.class));
    }

    protected void replacePolyQualifier(AnnotatedTypeMirror lhsType, Tree context) {
        NullnessValue inferred;
        if ((lhsType.hasAnnotation(PolyNull.class) || lhsType.hasAnnotation(PolyAll.class)) && (inferred = (NullnessValue)this.getInferredValueFor(context)) != null && inferred.isPolyNullNull) {
            lhsType.replaceAnnotation(this.NULLABLE);
        }
    }

    @Override
    public List<VariableTree> getUninitializedInvariantFields(NullnessStore store, TreePath path, boolean isStatic, List<? extends AnnotationMirror> receiverAnnotations) {
        List<VariableTree> candidates = super.getUninitializedInvariantFields(store, path, isStatic, receiverAnnotations);
        ArrayList<VariableTree> result = new ArrayList<VariableTree>();
        for (VariableTree c : candidates) {
            AnnotatedTypeMirror type = this.getAnnotatedType(c);
            boolean isPrimitive = TypesUtils.isPrimitive(type.getUnderlyingType());
            if (isPrimitive) continue;
            result.add(c);
        }
        return result;
    }

    @Override
    protected NullnessAnalysis createFlowAnalysis(List<Pair<VariableElement, NullnessValue>> fieldValues) {
        return new NullnessAnalysis(this.checker, this, fieldValues);
    }

    @Override
    public NullnessTransfer createFlowTransferFunction(CFAbstractAnalysis<NullnessValue, NullnessStore, NullnessTransfer> analysis) {
        return new NullnessTransfer((NullnessAnalysis)analysis);
    }

    @Override
    protected AnnotatedTypeFormatter createAnnotatedTypeFormatter() {
        boolean printVerboseGenerics;
        return new NullnessAnnotatedTypeFormatter(printVerboseGenerics, (printVerboseGenerics = this.checker.hasOption("printVerboseGenerics")) || this.checker.hasOption("printAllQualifiers"));
    }

    @Override
    public AnnotatedTypeFactory.ParameterizedMethodType methodFromUse(MethodInvocationTree tree) {
        AnnotatedTypeFactory.ParameterizedMethodType mType = super.methodFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType method = mType.methodType;
        this.systemGetPropertyHandler.handle(tree, method);
        this.collectionToArrayHeuristics.handle(tree, method);
        return mType;
    }

    @Override
    public void adaptGetClassReturnTypeToReceiver(AnnotatedTypeMirror.AnnotatedExecutableType getClassType, AnnotatedTypeMirror receiverType) {
        super.adaptGetClassReturnTypeToReceiver(getClassType, receiverType);
        AnnotatedTypeMirror.AnnotatedDeclaredType returnAdt = (AnnotatedTypeMirror.AnnotatedDeclaredType)getClassType.getReturnType();
        List<AnnotatedTypeMirror> typeArgs = returnAdt.getTypeArguments();
        AnnotatedTypeMirror.AnnotatedWildcardType classWildcardArg = (AnnotatedTypeMirror.AnnotatedWildcardType)typeArgs.get(0);
        classWildcardArg.getExtendsBoundField().replaceAnnotation(this.NONNULL);
    }

    @Override
    public AnnotatedTypeMirror getMethodReturnType(MethodTree m3, ReturnTree r) {
        AnnotatedTypeMirror result = super.getMethodReturnType(m3, r);
        this.replacePolyQualifier(result, r);
        return result;
    }

    @Override
    protected TypeAnnotator createTypeAnnotator() {
        ImplicitsTypeAnnotator implicitsTypeAnnotator = new ImplicitsTypeAnnotator(this);
        implicitsTypeAnnotator.addTypeClass(AnnotatedTypeMirror.AnnotatedNoType.class, this.NONNULL);
        implicitsTypeAnnotator.addTypeClass(AnnotatedTypeMirror.AnnotatedPrimitiveType.class, this.NONNULL);
        return new ListTypeAnnotator(new PropagationTypeAnnotator(this), implicitsTypeAnnotator, new NullnessTypeAnnotator(this), new InitializationAnnotatedTypeFactory.CommitmentTypeAnnotator(this, this));
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        ImplicitsTreeAnnotator implicitsTreeAnnotator = new ImplicitsTreeAnnotator(this);
        implicitsTreeAnnotator.addTreeKind(Tree.Kind.NEW_CLASS, this.NONNULL);
        implicitsTreeAnnotator.addTreeKind(Tree.Kind.NEW_ARRAY, this.NONNULL);
        return new ListTreeAnnotator(new NullnessPropagationAnnotator(this), implicitsTreeAnnotator, new NullnessTreeAnnotator(this), new InitializationAnnotatedTypeFactory.CommitmentTreeAnnotator(this, this));
    }

    private void annotateIfStatic(Element elt, AnnotatedTypeMirror type) {
        if (elt == null) {
            return;
        }
        if (elt.getKind().isClass() || elt.getKind().isInterface() || NullnessAnnotatedTypeFactory.isSystemField(elt)) {
            type.replaceAnnotation(this.NONNULL);
        }
    }

    private static boolean isSystemField(Element elt) {
        if (!elt.getKind().isField()) {
            return false;
        }
        if (!ElementUtils.isStatic(elt) || !ElementUtils.isFinal(elt)) {
            return false;
        }
        VariableElement var = (VariableElement)elt;
        boolean inJavaPackage = ElementUtils.getQualifiedClassName(var).toString().startsWith("java.");
        return var.getConstantValue() != null || var.getSimpleName().contentEquals("class") || inJavaPackage;
    }

    public Set<Class<? extends Annotation>> getNullnessAnnotations() {
        return this.nullnessAnnos;
    }

    @Override
    public Set<Class<? extends Annotation>> getInvalidConstructorReturnTypeAnnotations() {
        HashSet<Class<? extends Annotation>> l = new HashSet<Class<? extends Annotation>>(super.getInvalidConstructorReturnTypeAnnotations());
        l.addAll(this.getNullnessAnnotations());
        return l;
    }

    @Override
    public AnnotationMirror getFieldInvariantAnnotation() {
        return this.NONNULL;
    }

    @Override
    protected boolean hasFieldInvariantAnnotation(AnnotatedTypeMirror type) {
        AnnotationMirror invariant = this.getFieldInvariantAnnotation();
        Set<AnnotationMirror> lowerBounds = AnnotatedTypes.findEffectiveLowerBoundAnnotations(this.qualHierarchy, type);
        return AnnotationUtils.containsSame(lowerBounds, invariant);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new NullnessQualifierHierarchy(factory, null);
    }

    protected class NullnessQualifierHierarchy
    extends InitializationAnnotatedTypeFactory.InitializationQualifierHierarchy {
        public NullnessQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f, Object[] arg) {
            super(NullnessAnnotatedTypeFactory.this, f, arg);
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            if (NullnessAnnotatedTypeFactory.this.isInitializationAnnotation(subAnno) || NullnessAnnotatedTypeFactory.this.isInitializationAnnotation(superAnno)) {
                return this.isSubtypeInitialization(subAnno, superAnno);
            }
            return super.isSubtype(subAnno, superAnno);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (NullnessAnnotatedTypeFactory.this.isInitializationAnnotation(a1) || NullnessAnnotatedTypeFactory.this.isInitializationAnnotation(a2)) {
                return this.leastUpperBoundInitialization(a1, a2);
            }
            return super.leastUpperBound(a1, a2);
        }
    }

    protected class NullnessTypeAnnotator
    extends InitializationAnnotatedTypeFactory.CommitmentTypeAnnotator {
        public NullnessTypeAnnotator(InitializationAnnotatedTypeFactory<?, ?, ?, ?> atypeFactory) {
            super(NullnessAnnotatedTypeFactory.this, atypeFactory);
        }
    }

    protected class NullnessTreeAnnotator
    extends TreeAnnotator {
        public NullnessTreeAnnotator(NullnessAnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, AnnotatedTypeMirror type) {
            Element elt = TreeUtils.elementFromUse(node);
            assert (elt != null);
            NullnessAnnotatedTypeFactory.this.annotateIfStatic(elt, type);
            return null;
        }

        @Override
        public Void visitVariable(VariableTree node, AnnotatedTypeMirror type) {
            Element elt = TreeUtils.elementFromTree(node);
            if (elt.getKind() == ElementKind.EXCEPTION_PARAMETER && !type.isAnnotatedInHierarchy(NullnessAnnotatedTypeFactory.this.NONNULL)) {
                type.addAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            }
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, AnnotatedTypeMirror type) {
            Element elt = TreeUtils.elementFromUse(node);
            assert (elt != null);
            NullnessAnnotatedTypeFactory.this.annotateIfStatic(elt, type);
            if (elt.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                type.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            }
            return null;
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
            type.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            type.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            return null;
        }

        @Override
        public Void visitUnary(UnaryTree node, AnnotatedTypeMirror type) {
            type.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree node, AnnotatedTypeMirror type) {
            type.replaceAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            return null;
        }
    }

    protected static class NullnessPropagationAnnotator
    extends PropagationTreeAnnotator {
        public NullnessPropagationAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
            return null;
        }

        @Override
        public Void visitUnary(UnaryTree node, AnnotatedTypeMirror type) {
            return null;
        }
    }
}

