/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.analysis;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ExplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.SuperNode;
import org.checkerframework.dataflow.cfg.node.ThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.ValueLiteralNode;
import org.checkerframework.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.dataflow.util.PurityUtils;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypeAnnotationUtils;
import org.checkerframework.javacutil.TypesUtils;

public class FlowExpressions {
    public static FieldAccess internalReprOfFieldAccess(AnnotationProvider provider, FieldAccessNode node) {
        Node receiverNode = node.getReceiver();
        Receiver receiver = node.isStatic() ? new ClassName(receiverNode.getType()) : FlowExpressions.internalReprOf(provider, receiverNode);
        return new FieldAccess(receiver, node);
    }

    public static ArrayAccess internalReprOfArrayAccess(AnnotationProvider provider, ArrayAccessNode node) {
        Receiver receiver = FlowExpressions.internalReprOf(provider, node.getArray());
        Receiver index = FlowExpressions.internalReprOf(provider, node.getIndex());
        return new ArrayAccess(node.getType(), receiver, index);
    }

    public static Receiver internalReprOf(AnnotationProvider provider, Node receiverNode) {
        return FlowExpressions.internalReprOf(provider, receiverNode, false);
    }

    public static Receiver internalReprOf(AnnotationProvider provider, Node receiverNode, boolean allowNonDeterministic) {
        Receiver receiver = null;
        if (receiverNode instanceof FieldAccessNode) {
            FieldAccessNode fan = (FieldAccessNode)receiverNode;
            receiver = fan.getFieldName().equals("this") ? new ThisReference(fan.getReceiver().getType()) : (fan.getFieldName().equals("class") ? new ClassName(fan.getReceiver().getType()) : FlowExpressions.internalReprOfFieldAccess(provider, fan));
        } else if (receiverNode instanceof ExplicitThisLiteralNode) {
            receiver = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof ThisLiteralNode) {
            receiver = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof SuperNode) {
            receiver = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof LocalVariableNode) {
            LocalVariableNode lv = (LocalVariableNode)receiverNode;
            receiver = new LocalVariable(lv);
        } else if (receiverNode instanceof ArrayAccessNode) {
            ArrayAccessNode a = (ArrayAccessNode)receiverNode;
            receiver = FlowExpressions.internalReprOfArrayAccess(provider, a);
        } else {
            if (receiverNode instanceof StringConversionNode) {
                return FlowExpressions.internalReprOf(provider, ((StringConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof WideningConversionNode) {
                return FlowExpressions.internalReprOf(provider, ((WideningConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof NarrowingConversionNode) {
                return FlowExpressions.internalReprOf(provider, ((NarrowingConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof ClassNameNode) {
                ClassNameNode cn = (ClassNameNode)receiverNode;
                receiver = new ClassName(cn.getType());
            } else if (receiverNode instanceof ValueLiteralNode) {
                ValueLiteralNode vn = (ValueLiteralNode)receiverNode;
                receiver = new ValueLiteral(vn.getType(), vn);
            } else if (receiverNode instanceof ArrayCreationNode) {
                ArrayCreationNode an = (ArrayCreationNode)receiverNode;
                ArrayList<Receiver> dimensions = new ArrayList<Receiver>();
                for (Node node : an.getDimensions()) {
                    dimensions.add(FlowExpressions.internalReprOf(provider, node, allowNonDeterministic));
                }
                ArrayList<Receiver> initializers = new ArrayList<Receiver>();
                for (Node initializer : an.getInitializers()) {
                    initializers.add(FlowExpressions.internalReprOf(provider, initializer, allowNonDeterministic));
                }
                receiver = new ArrayCreation(an.getType(), dimensions, initializers);
            } else if (receiverNode instanceof MethodInvocationNode) {
                Node node;
                MethodInvocationNode mn = (MethodInvocationNode)receiverNode;
                ExecutableElement invokedMethod = TreeUtils.elementFromUse(mn.getTree());
                boolean considerDeterministic = false;
                if (FlowExpressions.isLongValueOf(mn, invokedMethod) && (node = mn.getArgument(0)) instanceof ValueLiteralNode) {
                    considerDeterministic = true;
                }
                if (PurityUtils.isDeterministic(provider, invokedMethod) || allowNonDeterministic || considerDeterministic) {
                    ArrayList<Receiver> arrayList = new ArrayList<Receiver>();
                    for (Node p : mn.getArguments()) {
                        arrayList.add(FlowExpressions.internalReprOf(provider, p));
                    }
                    Receiver methodReceiver = ElementUtils.isStatic(invokedMethod) ? new ClassName(mn.getTarget().getReceiver().getType()) : FlowExpressions.internalReprOf(provider, mn.getTarget().getReceiver());
                    receiver = new MethodCall(mn.getType(), invokedMethod, methodReceiver, arrayList);
                }
            }
        }
        if (receiver == null) {
            receiver = new Unknown(receiverNode.getType());
        }
        return receiver;
    }

    private static boolean isLongValueOf(MethodInvocationNode mn, ExecutableElement method) {
        if (mn.getTarget().getReceiver() == null || !mn.getTarget().getReceiver().toString().equals("Long")) {
            return false;
        }
        if (!method.getSimpleName().contentEquals("valueOf")) {
            return false;
        }
        List<? extends VariableElement> params = method.getParameters();
        if (params.size() != 1) {
            return false;
        }
        VariableElement param = params.get(0);
        TypeMirror paramType = param.asType();
        return paramType.getKind() == TypeKind.LONG;
    }

    public static Receiver internalReprOf(AnnotationProvider provider, ExpressionTree receiverTree) {
        return FlowExpressions.internalReprOf(provider, receiverTree, true);
    }

    public static Receiver internalReprOf(AnnotationProvider provider, ExpressionTree receiverTree, boolean allowNonDeterministic) {
        Receiver receiver;
        block0 : switch (receiverTree.getKind()) {
            case ARRAY_ACCESS: {
                ArrayAccessTree a = (ArrayAccessTree)receiverTree;
                Receiver arrayAccessExpression = FlowExpressions.internalReprOf(provider, a.getExpression());
                Receiver index = FlowExpressions.internalReprOf(provider, a.getIndex());
                receiver = new ArrayAccess(TreeUtils.typeOf(a), arrayAccessExpression, index);
                break;
            }
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case DOUBLE_LITERAL: 
            case FLOAT_LITERAL: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case NULL_LITERAL: 
            case STRING_LITERAL: {
                LiteralTree vn = (LiteralTree)receiverTree;
                receiver = new ValueLiteral(TreeUtils.typeOf(receiverTree), vn.getValue());
                break;
            }
            case NEW_ARRAY: {
                NewArrayTree newArrayTree = (NewArrayTree)receiverTree;
                ArrayList<Receiver> dimensions = new ArrayList<Receiver>();
                if (newArrayTree.getDimensions() != null) {
                    for (ExpressionTree expressionTree : newArrayTree.getDimensions()) {
                        dimensions.add(FlowExpressions.internalReprOf(provider, expressionTree, allowNonDeterministic));
                    }
                }
                ArrayList<Receiver> initializers = new ArrayList<Receiver>();
                if (newArrayTree.getInitializers() != null) {
                    for (ExpressionTree expressionTree : newArrayTree.getInitializers()) {
                        initializers.add(FlowExpressions.internalReprOf(provider, expressionTree, allowNonDeterministic));
                    }
                }
                receiver = new ArrayCreation(TreeUtils.typeOf(receiverTree), dimensions, initializers);
                break;
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)receiverTree;
                ExecutableElement executableElement = TreeUtils.elementFromUse(methodInvocationTree);
                if (PurityUtils.isDeterministic(provider, executableElement) || allowNonDeterministic) {
                    ExpressionTree expressionTree;
                    ArrayList<Receiver> parameters = new ArrayList<Receiver>();
                    for (ExpressionTree expressionTree2 : methodInvocationTree.getArguments()) {
                        parameters.add(FlowExpressions.internalReprOf(provider, expressionTree2));
                    }
                    Receiver methodReceiver = ElementUtils.isStatic(executableElement) ? new ClassName(TreeUtils.typeOf(methodInvocationTree.getMethodSelect())) : ((expressionTree = TreeUtils.getReceiverTree(methodInvocationTree)) != null ? FlowExpressions.internalReprOf(provider, expressionTree) : FlowExpressions.internalReprOfImplicitReceiver(executableElement));
                    TypeMirror typeMirror = TreeUtils.typeOf(methodInvocationTree);
                    receiver = new MethodCall(typeMirror, executableElement, methodReceiver, parameters);
                    break;
                }
                receiver = null;
                break;
            }
            case MEMBER_SELECT: {
                receiver = FlowExpressions.internalReprOfMemberSelect(provider, (MemberSelectTree)receiverTree);
                break;
            }
            case IDENTIFIER: {
                IdentifierTree identifierTree = (IdentifierTree)receiverTree;
                TypeMirror typeOfId = TreeUtils.typeOf(identifierTree);
                if (identifierTree.getName().contentEquals("this") || identifierTree.getName().contentEquals("super")) {
                    receiver = new ThisReference(typeOfId);
                    break;
                }
                Element element = TreeUtils.elementFromUse(identifierTree);
                switch (element.getKind()) {
                    case LOCAL_VARIABLE: 
                    case RESOURCE_VARIABLE: 
                    case EXCEPTION_PARAMETER: 
                    case PARAMETER: {
                        receiver = new LocalVariable(element);
                        break block0;
                    }
                    case FIELD: {
                        TypeMirror enclosingType = ElementUtils.enclosingClass(element).asType();
                        Receiver fieldAccessExpression = ElementUtils.isStatic(element) ? new ClassName(enclosingType) : new ThisReference(enclosingType);
                        receiver = new FieldAccess(fieldAccessExpression, typeOfId, (VariableElement)element);
                        break block0;
                    }
                    case CLASS: 
                    case ENUM: 
                    case ANNOTATION_TYPE: 
                    case INTERFACE: {
                        receiver = new ClassName(element.asType());
                        break block0;
                    }
                }
                receiver = null;
                break;
            }
            default: {
                receiver = null;
            }
        }
        if (receiver == null) {
            receiver = new Unknown(TreeUtils.typeOf(receiverTree));
        }
        return receiver;
    }

    public static Receiver internalReprOfImplicitReceiver(Element ele) {
        TypeMirror enclosingType = ElementUtils.enclosingClass(ele).asType();
        if (ElementUtils.isStatic(ele)) {
            return new ClassName(enclosingType);
        }
        return new ThisReference(enclosingType);
    }

    public static Receiver internalReprOfPseudoReceiver(TreePath path, TypeMirror enclosingType) {
        if (TreeUtils.isTreeInStaticScope(path)) {
            return new ClassName(enclosingType);
        }
        return new ThisReference(enclosingType);
    }

    private static Receiver internalReprOfMemberSelect(AnnotationProvider provider, MemberSelectTree memberSelectTree) {
        TypeMirror expressionType = TreeUtils.typeOf(memberSelectTree.getExpression());
        if (TreeUtils.isClassLiteral(memberSelectTree)) {
            return new ClassName(expressionType);
        }
        Element ele = TreeUtils.elementFromUse(memberSelectTree);
        switch (ele.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                return FlowExpressions.internalReprOf(provider, memberSelectTree.getExpression());
            }
            case CLASS: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                TypeMirror selectType = TreeUtils.typeOf(memberSelectTree);
                return new ClassName(selectType);
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                TypeMirror fieldType = TreeUtils.typeOf(memberSelectTree);
                Receiver r = FlowExpressions.internalReprOf(provider, memberSelectTree.getExpression());
                return new FieldAccess(r, fieldType, (VariableElement)ele);
            }
        }
        throw new BugInCF("Unexpected element kind: %s element: %s", new Object[]{ele.getKind(), ele});
    }

    public static List<Receiver> getParametersOfEnclosingMethod(AnnotationProvider annotationProvider, TreePath path) {
        MethodTree methodTree = TreeUtils.enclosingMethod(path);
        if (methodTree == null) {
            return null;
        }
        ArrayList<Receiver> internalArguments = new ArrayList<Receiver>();
        for (VariableTree variableTree : methodTree.getParameters()) {
            internalArguments.add(FlowExpressions.internalReprOf(annotationProvider, new LocalVariableNode(variableTree)));
        }
        return internalArguments;
    }

    public static class ArrayCreation
    extends Receiver {
        protected final List<Receiver> dimensions;
        protected final List<Receiver> initializers;

        public ArrayCreation(TypeMirror type, List<Receiver> dimensions, List<Receiver> initializers) {
            super(type);
            this.dimensions = dimensions;
            this.initializers = initializers;
        }

        public List<Receiver> getDimensions() {
            return this.dimensions;
        }

        public List<Receiver> getInitializers() {
            return this.initializers;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            for (Receiver n : this.dimensions) {
                if (!n.getClass().equals(clazz)) continue;
                return true;
            }
            for (Receiver n : this.initializers) {
                if (!n.getClass().equals(clazz)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dimensions == null ? 0 : this.dimensions.hashCode());
            result = 31 * result + (this.initializers == null ? 0 : this.initializers.hashCode());
            result = 31 * result + HashCodeUtils.hash((Object)this.getType().toString());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ArrayCreation)) {
                return false;
            }
            ArrayCreation other = (ArrayCreation)obj;
            return this.dimensions.equals(other.getDimensions()) && this.initializers.equals(other.getInitializers()) && this.getType().toString().equals(other.getType().toString());
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            return this.equals(other);
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other);
        }

        public String toString() {
            boolean needComma;
            StringBuilder sb = new StringBuilder();
            sb.append("new " + this.type);
            if (!this.dimensions.isEmpty()) {
                needComma = false;
                sb.append(" (");
                for (Receiver dim : this.dimensions) {
                    if (needComma) {
                        sb.append(", ");
                    }
                    sb.append(dim);
                    needComma = true;
                }
                sb.append(")");
            }
            if (!this.initializers.isEmpty()) {
                needComma = false;
                sb.append(" = {");
                for (Receiver init : this.initializers) {
                    if (needComma) {
                        sb.append(", ");
                    }
                    sb.append(init);
                    needComma = true;
                }
                sb.append("}");
            }
            return sb.toString();
        }
    }

    public static class ArrayAccess
    extends Receiver {
        protected final Receiver receiver;
        protected final Receiver index;

        public ArrayAccess(TypeMirror type, Receiver receiver, Receiver index) {
            super(type);
            this.receiver = receiver;
            this.index = index;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            if (this.getClass().equals(clazz)) {
                return true;
            }
            if (this.receiver.containsOfClass(clazz)) {
                return true;
            }
            return this.index.containsOfClass(clazz);
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public Receiver getIndex() {
            return this.index;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return false;
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other) || this.receiver.syntacticEquals(other) || this.index.syntacticEquals(other);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            if (!(other instanceof ArrayAccess)) {
                return false;
            }
            ArrayAccess otherArrayAccess = (ArrayAccess)other;
            if (!this.receiver.syntacticEquals(otherArrayAccess.receiver)) {
                return false;
            }
            return this.index.syntacticEquals(otherArrayAccess.index);
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            if (this.receiver.containsModifiableAliasOf(store, other)) {
                return true;
            }
            return this.index.containsModifiableAliasOf(store, other);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ArrayAccess)) {
                return false;
            }
            ArrayAccess other = (ArrayAccess)obj;
            return this.receiver.equals(other.receiver) && this.index.equals(other.index);
        }

        public int hashCode() {
            return HashCodeUtils.hash(this.receiver, this.index);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.receiver.toString());
            result.append("[");
            result.append(this.index.toString());
            result.append("]");
            return result.toString();
        }
    }

    public static class MethodCall
    extends Receiver {
        protected final Receiver receiver;
        protected final List<Receiver> parameters;
        protected final ExecutableElement method;

        public MethodCall(TypeMirror type, ExecutableElement method, Receiver receiver, List<Receiver> parameters) {
            super(type);
            this.receiver = receiver;
            this.parameters = parameters;
            this.method = method;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            if (this.getClass().equals(clazz)) {
                return true;
            }
            if (this.receiver.containsOfClass(clazz)) {
                return true;
            }
            for (Receiver p : this.parameters) {
                if (!p.containsOfClass(clazz)) continue;
                return true;
            }
            return false;
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public List<Receiver> getParameters() {
            return Collections.unmodifiableList(this.parameters);
        }

        public ExecutableElement getElement() {
            return this.method;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return false;
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other) || this.receiver.syntacticEquals(other);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            if (!(other instanceof MethodCall)) {
                return false;
            }
            MethodCall otherMethod = (MethodCall)other;
            if (!this.receiver.syntacticEquals(otherMethod.receiver)) {
                return false;
            }
            if (this.parameters.size() != otherMethod.parameters.size()) {
                return false;
            }
            int i = 0;
            for (Receiver p : this.parameters) {
                if (!p.syntacticEquals(otherMethod.parameters.get(i))) {
                    return false;
                }
                ++i;
            }
            return this.method.equals(otherMethod.method);
        }

        public boolean containsSyntacticEqualParameter(LocalVariable var) {
            for (Receiver p : this.parameters) {
                if (!p.containsSyntacticEqualReceiver(var)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            if (this.receiver.containsModifiableAliasOf(store, other)) {
                return true;
            }
            for (Receiver p : this.parameters) {
                if (!p.containsModifiableAliasOf(store, other)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof MethodCall)) {
                return false;
            }
            MethodCall other = (MethodCall)obj;
            int i = 0;
            for (Receiver p : this.parameters) {
                if (!p.equals(other.parameters.get(i))) {
                    return false;
                }
                ++i;
            }
            return this.receiver.equals(other.receiver) && this.method.equals(other.method);
        }

        public int hashCode() {
            int hash = HashCodeUtils.hash(this.method, this.receiver);
            for (Receiver p : this.parameters) {
                hash = HashCodeUtils.hash(hash, (Object)p);
            }
            return hash;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (this.receiver instanceof ClassName) {
                result.append(this.receiver.getType());
            } else {
                result.append(this.receiver);
            }
            result.append(".");
            String methodName = this.method.getSimpleName().toString();
            result.append(methodName);
            result.append("(");
            boolean first = true;
            for (Receiver p : this.parameters) {
                if (!first) {
                    result.append(", ");
                }
                result.append(p.toString());
                first = false;
            }
            result.append(")");
            return result.toString();
        }
    }

    public static class ValueLiteral
    extends Receiver {
        protected final Object value;

        public ValueLiteral(TypeMirror type, ValueLiteralNode node) {
            super(type);
            this.value = node.getValue();
        }

        public ValueLiteral(TypeMirror type, Object value) {
            super(type);
            this.value = value;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass().equals(clazz);
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return true;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ValueLiteral)) {
                return false;
            }
            ValueLiteral other = (ValueLiteral)obj;
            return this.type.toString().equals(other.type.toString()) && Objects.equals(this.value, other.value);
        }

        public String toString() {
            if (TypesUtils.isString(this.type)) {
                return "\"" + this.value + "\"";
            }
            if (this.type.getKind() == TypeKind.LONG) {
                return this.value.toString() + "L";
            }
            return this.value == null ? "null" : this.value.toString();
        }

        public int hashCode() {
            return HashCodeUtils.hash(this.value, this.type.toString());
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            return this.equals(other);
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return false;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class LocalVariable
    extends Receiver {
        protected final Element element;

        public LocalVariable(LocalVariableNode localVar) {
            super(localVar.getType());
            this.element = localVar.getElement();
        }

        public LocalVariable(Element elem) {
            super(ElementUtils.getType(elem));
            this.element = elem;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof LocalVariable)) {
                return false;
            }
            LocalVariable other = (LocalVariable)obj;
            Symbol.VarSymbol vs = (Symbol.VarSymbol)this.element;
            Symbol.VarSymbol vsother = (Symbol.VarSymbol)other.element;
            return vs.pos == vsother.pos && vsother.name.contentEquals(vs.name) && vsother.owner.toString().equals(vs.owner.toString());
        }

        public Element getElement() {
            return this.element;
        }

        public int hashCode() {
            Symbol.VarSymbol vs = (Symbol.VarSymbol)this.element;
            return HashCodeUtils.hash(vs.name.toString(), TypeAnnotationUtils.unannotatedType(vs.type).toString(), vs.owner.toString());
        }

        public String toString() {
            return this.element.toString();
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass().equals(clazz);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            if (!(other instanceof LocalVariable)) {
                return false;
            }
            LocalVariable l = (LocalVariable)other;
            return l.equals(this);
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other);
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return true;
        }
    }

    public static class Unknown
    extends Receiver {
        public Unknown(TypeMirror type) {
            super(type);
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public String toString() {
            return "?";
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return true;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass().equals(clazz);
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return false;
        }
    }

    public static class ClassName
    extends Receiver {
        private final String typeString;

        public ClassName(TypeMirror type) {
            super(type);
            this.typeString = type.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ClassName)) {
                return false;
            }
            ClassName other = (ClassName)obj;
            return this.typeString.equals(other.typeString);
        }

        public int hashCode() {
            return HashCodeUtils.hash((Object)this.typeString);
        }

        public String toString() {
            return this.typeString + ".class";
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass().equals(clazz);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            return this.equals(other);
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return true;
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return false;
        }
    }

    public static class ThisReference
    extends Receiver {
        public ThisReference(TypeMirror type) {
            super(type);
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof ThisReference;
        }

        public int hashCode() {
            return HashCodeUtils.hash(0);
        }

        public String toString() {
            return "this";
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass().equals(clazz);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            return other instanceof ThisReference;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return true;
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return false;
        }
    }

    public static class FieldAccess
    extends Receiver {
        protected final Receiver receiver;
        protected final VariableElement field;

        public Receiver getReceiver() {
            return this.receiver;
        }

        public VariableElement getField() {
            return this.field;
        }

        public FieldAccess(Receiver receiver, FieldAccessNode node) {
            super(node.getType());
            this.receiver = receiver;
            this.field = node.getElement();
        }

        public FieldAccess(Receiver receiver, TypeMirror type, VariableElement fieldElement) {
            super(type);
            this.receiver = receiver;
            this.field = fieldElement;
        }

        public boolean isFinal() {
            return ElementUtils.isFinal(this.field);
        }

        public boolean isStatic() {
            return ElementUtils.isStatic(this.field);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof FieldAccess)) {
                return false;
            }
            FieldAccess fa = (FieldAccess)obj;
            return fa.getField().equals(this.getField()) && fa.getReceiver().equals(this.getReceiver());
        }

        public int hashCode() {
            return HashCodeUtils.hash(this.getField(), this.getReceiver());
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return super.containsModifiableAliasOf(store, other) || this.receiver.containsModifiableAliasOf(store, other);
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other) || this.receiver.containsSyntacticEqualReceiver(other);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            if (!(other instanceof FieldAccess)) {
                return false;
            }
            FieldAccess fa = (FieldAccess)other;
            return super.syntacticEquals(other) || fa.getField().equals(this.getField()) && fa.getReceiver().syntacticEquals(this.getReceiver());
        }

        public String toString() {
            if (this.receiver instanceof ClassName) {
                return this.receiver.getType() + "." + this.field;
            }
            return this.receiver + "." + this.field;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass().equals(clazz) || this.receiver.containsOfClass(clazz);
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return this.isFinal() && this.getReceiver().isUnmodifiableByOtherCode();
        }
    }

    public static abstract class Receiver {
        protected final TypeMirror type;

        public Receiver(TypeMirror type) {
            assert (type != null);
            this.type = type;
        }

        public TypeMirror getType() {
            return this.type;
        }

        public abstract boolean containsOfClass(Class<? extends Receiver> var1);

        public boolean containsUnknown() {
            return this.containsOfClass(Unknown.class);
        }

        public abstract boolean isUnmodifiableByOtherCode();

        public boolean syntacticEquals(Receiver other) {
            return other == this;
        }

        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other);
        }

        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return this.equals(other) || store.canAlias(this, other);
        }
    }
}

