/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.stub;

import java.io.InputStream;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.com.github.javaparser.JavaParser;
import org.checkerframework.com.github.javaparser.ParseProblemException;
import org.checkerframework.com.github.javaparser.Problem;
import org.checkerframework.com.github.javaparser.ast.CompilationUnit;
import org.checkerframework.com.github.javaparser.ast.ImportDeclaration;
import org.checkerframework.com.github.javaparser.ast.NodeList;
import org.checkerframework.com.github.javaparser.ast.PackageDeclaration;
import org.checkerframework.com.github.javaparser.ast.StubUnit;
import org.checkerframework.com.github.javaparser.ast.body.BodyDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.CallableDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.ConstructorDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.EnumDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.FieldDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.MethodDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.Parameter;
import org.checkerframework.com.github.javaparser.ast.body.TypeDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.VariableDeclarator;
import org.checkerframework.com.github.javaparser.ast.expr.AnnotationExpr;
import org.checkerframework.com.github.javaparser.ast.expr.ArrayInitializerExpr;
import org.checkerframework.com.github.javaparser.ast.expr.BooleanLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.expr.CharLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.expr.ClassExpr;
import org.checkerframework.com.github.javaparser.ast.expr.DoubleLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.expr.Expression;
import org.checkerframework.com.github.javaparser.ast.expr.FieldAccessExpr;
import org.checkerframework.com.github.javaparser.ast.expr.IntegerLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.expr.LongLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import org.checkerframework.com.github.javaparser.ast.expr.MemberValuePair;
import org.checkerframework.com.github.javaparser.ast.expr.NameExpr;
import org.checkerframework.com.github.javaparser.ast.expr.NormalAnnotationExpr;
import org.checkerframework.com.github.javaparser.ast.expr.NullLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import org.checkerframework.com.github.javaparser.ast.expr.StringLiteralExpr;
import org.checkerframework.com.github.javaparser.ast.expr.UnaryExpr;
import org.checkerframework.com.github.javaparser.ast.type.ClassOrInterfaceType;
import org.checkerframework.com.github.javaparser.ast.type.ReferenceType;
import org.checkerframework.com.github.javaparser.ast.type.Type;
import org.checkerframework.com.github.javaparser.ast.type.TypeParameter;
import org.checkerframework.com.github.javaparser.ast.type.WildcardType;
import org.checkerframework.framework.qual.FromStubFile;
import org.checkerframework.framework.stub.StubUtil;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.AnnotatedTypeMerger;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.Pair;

public class StubParser {
    private final boolean warnIfNotFound;
    private final boolean warnIfNotFoundIgnoresClasses;
    private final boolean warnIfStubOverwritesBytecode;
    private final boolean debugStubParser;
    private final String filename;
    private StubUnit stubUnit;
    private final ProcessingEnvironment processingEnv;
    private final AnnotatedTypeFactory atypeFactory;
    private final Elements elements;
    private Map<String, AnnotationMirror> allStubAnnotations;
    private final List<String> importedConstants = new ArrayList<String>();
    private final Map<String, TypeElement> importedTypes = new HashMap<String, TypeElement>();
    private final AnnotationMirror fromStubFile;
    private final List<AnnotatedTypeMirror.AnnotatedTypeVariable> typeParameters = new ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable>();
    FqName parseState;
    Map<Element, AnnotatedTypeMirror> atypes;
    Map<String, Set<AnnotationMirror>> declAnnos;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator").intern();
    private final Map<NameExpr, VariableElement> findVariableElementNameCache = new HashMap<NameExpr, VariableElement>();
    private final Map<FieldAccessExpr, VariableElement> findVariableElementFieldCache = new HashMap<FieldAccessExpr, VariableElement>();
    private static final Set<String> warnings = new HashSet<String>();

    public StubParser(String filename, AnnotatedTypeFactory atypeFactory, ProcessingEnvironment processingEnv, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        this.filename = filename;
        this.atypeFactory = atypeFactory;
        this.processingEnv = processingEnv;
        this.elements = processingEnv.getElementUtils();
        Map<String, String> options = processingEnv.getOptions();
        this.warnIfNotFound = options.containsKey("stubWarnIfNotFound");
        this.warnIfNotFoundIgnoresClasses = options.containsKey("stubWarnIfNotFoundIgnoresClasses");
        this.warnIfStubOverwritesBytecode = options.containsKey("stubWarnIfOverwritesBytecode");
        this.debugStubParser = options.containsKey("stubDebug");
        this.fromStubFile = AnnotationBuilder.fromClass(this.elements, FromStubFile.class);
        this.atypes = atypes;
        this.declAnnos = declAnnos;
    }

    private Map<String, AnnotationMirror> annosInPackage(PackageElement packageElement) {
        return this.createImportedAnnotationsMap(ElementFilter.typesIn(packageElement.getEnclosedElements()));
    }

    private Map<String, AnnotationMirror> annosInType(TypeElement typeElement) {
        return this.createImportedAnnotationsMap(ElementFilter.typesIn(typeElement.getEnclosedElements()));
    }

    private Map<String, AnnotationMirror> createImportedAnnotationsMap(List<TypeElement> typeElements) {
        HashMap<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
        for (TypeElement typeElm : typeElements) {
            if (typeElm.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            AnnotationMirror anno = AnnotationBuilder.fromName(this.elements, typeElm.getQualifiedName());
            StubParser.putNoOverride(result, typeElm.getSimpleName().toString(), anno);
        }
        return result;
    }

    private static List<String> getImportableMembers(TypeElement typeElement) {
        ArrayList<String> result = new ArrayList<String>();
        List<VariableElement> memberElements = ElementFilter.fieldsIn(typeElement.getEnclosedElements());
        for (VariableElement varElement : memberElements) {
            if (varElement.getConstantValue() == null && varElement.getKind() != ElementKind.ENUM_CONSTANT) continue;
            result.add(String.format("%s.%s", typeElement.getQualifiedName().toString(), varElement.getSimpleName().toString()));
        }
        return result;
    }

    private Map<String, AnnotationMirror> getAllStubAnnotations() {
        HashMap<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
        assert (!this.stubUnit.getCompilationUnits().isEmpty());
        CompilationUnit cu = this.stubUnit.getCompilationUnits().get(0);
        if (cu.getImports() == null) {
            return result;
        }
        for (ImportDeclaration importDecl : cu.getImports()) {
            String imported = importDecl.getNameAsString();
            try {
                if (importDecl.isAsterisk()) {
                    QualifiedNameable element;
                    if (importDecl.isStatic()) {
                        element = this.getTypeElement(imported, "Imported type not found");
                        if (element == null) continue;
                        StubParser.putAllNew(result, this.annosInType((TypeElement)element));
                        this.importedConstants.addAll(StubParser.getImportableMembers((TypeElement)element));
                        this.addEnclosingTypesToImportedTypes(element);
                        continue;
                    }
                    element = this.findPackage(imported);
                    if (element == null) continue;
                    StubParser.putAllNew(result, this.annosInPackage((PackageElement)element));
                    this.addEnclosingTypesToImportedTypes(element);
                    continue;
                }
                TypeElement importType = this.elements.getTypeElement(imported);
                if (importType == null && !importDecl.isStatic()) {
                    this.stubWarnNotFound("Imported type not found: " + imported);
                    continue;
                }
                if (importType == null) {
                    Pair<String, String> typeParts = StubUtil.partitionQualifiedName(imported);
                    String type = (String)typeParts.first;
                    String fieldName = (String)typeParts.second;
                    TypeElement enclType = this.getTypeElement(type, String.format("Enclosing type of static field %s not found", fieldName));
                    if (enclType == null || this.findFieldElement(enclType, fieldName) == null) continue;
                    this.importedConstants.add(imported);
                    continue;
                }
                if (importType.getKind() == ElementKind.ANNOTATION_TYPE) {
                    AnnotationMirror anno = AnnotationBuilder.fromName(this.elements, imported);
                    if (anno != null) {
                        Element annoElt = anno.getAnnotationType().asElement();
                        StubParser.putNoOverride(result, annoElt.getSimpleName().toString(), anno);
                        this.importedTypes.put(annoElt.getSimpleName().toString(), (TypeElement)annoElt);
                        continue;
                    }
                    this.stubWarnNotFound("Could not load import: " + imported);
                    continue;
                }
                this.importedConstants.add(imported);
                TypeElement element = this.getTypeElement(imported, "Imported type not found");
                this.importedTypes.put(element.getSimpleName().toString(), element);
            }
            catch (AssertionError error) {
                this.stubWarnNotFound("" + error);
            }
        }
        return result;
    }

    private void addEnclosingTypesToImportedTypes(Element element) {
        for (Element element2 : element.getEnclosedElements()) {
            if (!element2.getKind().isClass()) continue;
            this.importedTypes.put(element2.getSimpleName().toString(), (TypeElement)element2);
        }
    }

    public static void parse(String filename, InputStream inputStream, AnnotatedTypeFactory atypeFactory, ProcessingEnvironment processingEnv, Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        StubParser sp = new StubParser(filename, atypeFactory, processingEnv, atypes, declAnnos);
        try {
            sp.parseStubUnit(inputStream);
            sp.process(atypes, declAnnos);
        }
        catch (ParseProblemException e) {
            StringBuilder message = new StringBuilder("exception while parsing stub file " + filename + ". Encountered problems: ");
            for (Problem p : e.getProblems()) {
                message.append(p.getVerboseMessage());
                message.append(LINE_SEPARATOR);
            }
            sp.stubWarn(message.toString(), new Object[0]);
        }
    }

    private void parseStubUnit(InputStream inputStream) {
        if (this.debugStubParser) {
            this.stubDebug(String.format("parsing stub file %s", this.filename));
        }
        this.stubUnit = JavaParser.parseStubUnit(inputStream);
        this.allStubAnnotations = this.getAllStubAnnotations();
        if (this.allStubAnnotations.isEmpty()) {
            this.stubWarnNotFound(String.format("No supported annotations found! This likely means stub file %s doesn't import them correctly.", this.filename));
        }
    }

    private void process(Map<Element, AnnotatedTypeMirror> atypes, Map<String, Set<AnnotationMirror>> declAnnos) {
        this.processStubUnit(this.stubUnit);
    }

    private void processStubUnit(StubUnit index) {
        for (CompilationUnit cu : index.getCompilationUnits()) {
            this.processCompilationUnit(cu);
        }
    }

    private void processCompilationUnit(CompilationUnit cu) {
        NodeList<AnnotationExpr> packageAnnos;
        if (!cu.getPackageDeclaration().isPresent()) {
            packageAnnos = null;
            this.parseState = new FqName(null, null);
        } else {
            PackageDeclaration pDecl = cu.getPackageDeclaration().get();
            packageAnnos = pDecl.getAnnotations();
            this.processPackage(pDecl);
        }
        if (cu.getTypes() != null) {
            for (TypeDeclaration<?> typeDeclaration : cu.getTypes()) {
                this.processTypeDecl(typeDeclaration, null, packageAnnos);
            }
        }
    }

    private void processPackage(PackageDeclaration packDecl) {
        assert (packDecl != null);
        String packageName = packDecl.getNameAsString();
        this.parseState = new FqName(packageName, null);
        PackageElement elem = this.elements.getPackageElement(packageName);
        if (elem != null) {
            this.annotateDecl(this.declAnnos, elem, packDecl.getAnnotations());
        }
    }

    private void processTypeDecl(TypeDeclaration<?> typeDecl, String outertypeName, List<AnnotationExpr> packageAnnos) {
        assert (this.parseState != null);
        String innerName = (outertypeName == null ? "" : outertypeName + ".") + typeDecl.getNameAsString();
        this.parseState = new FqName(this.parseState.packageName, innerName);
        String fqTypeName = this.parseState.toString();
        TypeElement typeElt = this.elements.getTypeElement(fqTypeName);
        if (typeElt == null) {
            if (this.debugStubParser || !this.hasNoStubParserWarning(typeDecl.getAnnotations()) && !this.hasNoStubParserWarning(packageAnnos) && !this.warnIfNotFoundIgnoresClasses) {
                this.stubWarnNotFound("Type not found: " + fqTypeName);
            }
            return;
        }
        if (typeElt.getKind() == ElementKind.ENUM) {
            this.typeParameters.addAll(this.processEnum((EnumDeclaration)typeDecl, typeElt));
        } else if (typeElt.getKind() == ElementKind.ANNOTATION_TYPE) {
            this.stubWarnNotFound("Skipping annotation type: " + fqTypeName);
        } else if (typeDecl instanceof ClassOrInterfaceDeclaration) {
            this.typeParameters.addAll(this.processType((ClassOrInterfaceDeclaration)typeDecl, typeElt));
        }
        Map<Element, BodyDeclaration<?>> elementsToDecl = this.getMembers(typeElt, typeDecl);
        block6: for (Map.Entry<Element, BodyDeclaration<?>> entry : elementsToDecl.entrySet()) {
            Element elt = entry.getKey();
            BodyDeclaration<?> decl = entry.getValue();
            switch (elt.getKind()) {
                case FIELD: 
                case ENUM_CONSTANT: {
                    this.processField((FieldDeclaration)decl, (VariableElement)elt);
                    continue block6;
                }
                case CONSTRUCTOR: 
                case METHOD: {
                    this.processCallableDeclaration((CallableDeclaration)decl, (ExecutableElement)elt);
                    continue block6;
                }
                case CLASS: 
                case INTERFACE: {
                    this.processTypeDecl((ClassOrInterfaceDeclaration)decl, innerName, packageAnnos);
                    continue block6;
                }
                case ENUM: {
                    this.processTypeDecl((EnumDeclaration)decl, innerName, packageAnnos);
                    continue block6;
                }
            }
            this.stubWarnNotFound("StubParser ignoring: " + elt);
        }
        this.typeParameters.clear();
    }

    private boolean hasNoStubParserWarning(Iterable<AnnotationExpr> aexprs) {
        if (aexprs == null) {
            return false;
        }
        for (AnnotationExpr anno : aexprs) {
            if (!anno.getNameAsString().contentEquals("NoStubParserWarning")) continue;
            return true;
        }
        return false;
    }

    private List<AnnotatedTypeMirror.AnnotatedTypeVariable> processType(ClassOrInterfaceDeclaration decl, TypeElement elt) {
        this.annotateDecl(this.declAnnos, elt, decl.getAnnotations());
        AnnotatedTypeMirror.AnnotatedDeclaredType type = this.atypeFactory.fromElement(elt);
        this.annotate(type, decl.getAnnotations());
        List<AnnotatedTypeMirror> typeArguments = type.getTypeArguments();
        NodeList<TypeParameter> typeParameters = decl.getTypeParameters();
        if (this.debugStubParser) {
            int numArgs;
            int numParams = typeParameters == null ? 0 : typeParameters.size();
            int n = numArgs = typeArguments == null ? 0 : typeArguments.size();
            if (numParams != numArgs) {
                this.stubDebug(String.format("parseType:  mismatched sizes for typeParameters=%s (size %d) and typeArguments=%s (size %d); decl=%s; elt=%s (%s); type=%s (%s); parseState=%s", typeParameters, numParams, typeArguments, numArgs, decl.toString().replace(LINE_SEPARATOR, " "), elt.toString().replace(LINE_SEPARATOR, " "), elt.getClass(), type, type.getClass(), this.parseState));
                this.stubDebug("Proceeding despite mismatched sizes");
            }
        }
        this.annotateTypeParameters(decl, elt, this.atypes, typeArguments, typeParameters);
        this.annotateSupertypes(decl, type);
        StubParser.putNew(this.atypes, elt, type);
        ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable> typeVariables = new ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable>();
        for (AnnotatedTypeMirror typeV : type.getTypeArguments()) {
            if (typeV.getKind() != TypeKind.TYPEVAR) {
                this.stubWarn("expected an AnnotatedTypeVariable but found type kind " + (Object)((Object)typeV.getKind()) + ": " + typeV, new Object[0]);
                continue;
            }
            typeVariables.add((AnnotatedTypeMirror.AnnotatedTypeVariable)typeV);
        }
        return typeVariables;
    }

    private List<AnnotatedTypeMirror.AnnotatedTypeVariable> processEnum(EnumDeclaration decl, TypeElement elt) {
        this.annotateDecl(this.declAnnos, elt, decl.getAnnotations());
        AnnotatedTypeMirror.AnnotatedDeclaredType type = this.atypeFactory.fromElement(elt);
        this.annotate(type, decl.getAnnotations());
        StubParser.putNew(this.atypes, elt, type);
        ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable> typeVariables = new ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable>();
        for (AnnotatedTypeMirror typeV : type.getTypeArguments()) {
            if (typeV.getKind() != TypeKind.TYPEVAR) {
                this.stubWarn("expected an AnnotatedTypeVariable but found type kind " + (Object)((Object)typeV.getKind()) + ": " + typeV, new Object[0]);
                continue;
            }
            typeVariables.add((AnnotatedTypeMirror.AnnotatedTypeVariable)typeV);
        }
        return typeVariables;
    }

    private void annotateSupertypes(ClassOrInterfaceDeclaration typeDecl, AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        AnnotatedTypeMirror.AnnotatedDeclaredType foundType;
        if (typeDecl.getExtendedTypes() != null) {
            for (ClassOrInterfaceType superType : typeDecl.getExtendedTypes()) {
                foundType = this.findType(superType, type.directSuperTypes());
                if (foundType == null) {
                    throw new BugInCF("StubParser: could not find superclass " + superType + " from type " + type + LINE_SEPARATOR + "Stub file does not match bytecode");
                }
                this.annotate(foundType, superType, null);
            }
        }
        if (typeDecl.getImplementedTypes() != null) {
            for (ClassOrInterfaceType superType : typeDecl.getImplementedTypes()) {
                foundType = this.findType(superType, type.directSuperTypes());
                if (foundType == null) {
                    throw new BugInCF("StubParser: could not find superinterface " + superType + " from type " + type + LINE_SEPARATOR + "Stub file does not match bytecode");
                }
                this.annotate(foundType, superType, null);
            }
        }
    }

    private void processCallableDeclaration(CallableDeclaration<?> decl, ExecutableElement elt) {
        this.annotateDecl(this.declAnnos, elt, decl.getAnnotations());
        if (decl.isMethodDeclaration()) {
            this.annotateDecl(this.declAnnos, elt, ((MethodDeclaration)decl).getType().getAnnotations());
        }
        this.addDeclAnnotations(this.declAnnos, elt);
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.atypeFactory.fromElement(elt);
        this.annotateTypeParameters(decl, elt, this.atypes, methodType.getTypeVariables(), decl.getTypeParameters());
        this.typeParameters.addAll(methodType.getTypeVariables());
        if (decl.isMethodDeclaration()) {
            this.annotate(methodType.getReturnType(), ((MethodDeclaration)decl).getType(), decl.getAnnotations());
        } else {
            this.annotate(methodType.getReturnType(), decl.getAnnotations());
        }
        this.processParameters(decl, elt, this.declAnnos, methodType);
        if (decl.getReceiverParameter().isPresent() && !decl.getReceiverParameter().get().getAnnotations().isEmpty()) {
            if (methodType.getReceiverType() == null) {
                if (decl.isConstructorDeclaration()) {
                    this.stubWarn("parseParameter: constructor of a top-level class cannot have receiver annotations%nConstructor: %s%nReceiver annotations: %s", methodType, decl.getReceiverParameter().get().getAnnotations());
                } else {
                    this.stubWarn("parseParameter: static methods cannot have receiver annotations%nMethod: %s%nReceiver annotations: %s", methodType, decl.getReceiverParameter().get().getAnnotations());
                }
            } else {
                this.annotate(methodType.getReceiverType(), decl.getReceiverParameter().get().getAnnotations());
            }
        }
        StubParser.putNew(this.atypes, elt, methodType);
        this.typeParameters.removeAll(methodType.getTypeVariables());
    }

    private void processParameters(CallableDeclaration<?> method, ExecutableElement elt, Map<String, Set<AnnotationMirror>> declAnnos, AnnotatedTypeMirror.AnnotatedExecutableType methodType) {
        NodeList<Parameter> params = method.getParameters();
        List<? extends VariableElement> paramElts = elt.getParameters();
        List<AnnotatedTypeMirror> paramTypes = methodType.getParameterTypes();
        for (int i = 0; i < methodType.getParameterTypes().size(); ++i) {
            VariableElement paramElt = paramElts.get(i);
            AnnotatedTypeMirror paramType = paramTypes.get(i);
            Parameter param = (Parameter)params.get(i);
            this.annotateDecl(declAnnos, paramElt, param.getAnnotations());
            this.annotateDecl(declAnnos, paramElt, param.getType().getAnnotations());
            if (param.isVarArgs()) {
                assert (paramType.getKind() == TypeKind.ARRAY);
                this.annotate(((AnnotatedTypeMirror.AnnotatedArrayType)paramType).getComponentType(), param.getType(), param.getAnnotations());
                this.annotate(paramType, param.getVarArgsAnnotations());
                continue;
            }
            this.annotate(paramType, param.getType(), param.getAnnotations());
        }
    }

    private void clearAnnotations(AnnotatedTypeMirror atype, Type typeDef) {
        Set<AnnotationMirror> annos = atype.getAnnotations();
        if (annos != null && !annos.isEmpty()) {
            atype.clearAnnotations();
        }
    }

    private void addDeclAnnotations(Map<String, Set<AnnotationMirror>> declAnnos, Element elt) {
        Set<AnnotationMirror> annos = declAnnos.get(ElementUtils.getVerboseName(elt));
        if (annos == null) {
            annos = AnnotationUtils.createAnnotationSet();
            StubParser.putOrAddToMap(declAnnos, ElementUtils.getVerboseName(elt), annos);
        }
        annos.add(this.fromStubFile);
    }

    private void annotateAsArray(AnnotatedTypeMirror.AnnotatedArrayType atype, ReferenceType type, NodeList<AnnotationExpr> declAnnos) {
        this.annotateInnermostComponentType(atype, declAnnos);
        Type typeDef = type;
        AnnotatedTypeMirror currentAtype = atype;
        while (typeDef.isArrayType() && currentAtype.getKind() == TypeKind.ARRAY) {
            this.clearAnnotations(currentAtype, typeDef);
            NodeList<AnnotationExpr> annotations = typeDef.getAnnotations();
            if (annotations != null) {
                this.annotate(currentAtype, annotations);
            }
            typeDef = ((org.checkerframework.com.github.javaparser.ast.type.ArrayType)typeDef).getComponentType();
            currentAtype = ((AnnotatedTypeMirror.AnnotatedArrayType)currentAtype).getComponentType();
            if (!(typeDef.isArrayType() ^ currentAtype.getKind() == TypeKind.ARRAY)) continue;
            this.stubWarn("Mismatched array lengths; atype: " + atype + "%n  type: " + type, new Object[0]);
        }
    }

    private ClassOrInterfaceType unwrapDeclaredType(Type type) {
        if (type instanceof ClassOrInterfaceType) {
            return (ClassOrInterfaceType)type;
        }
        if (type instanceof ReferenceType && type.getArrayLevel() == 0) {
            return this.unwrapDeclaredType(type.getElementType());
        }
        return null;
    }

    private void annotate(AnnotatedTypeMirror atype, Type typeDef, NodeList<AnnotationExpr> declAnnos) {
        if (atype.getKind() == TypeKind.ARRAY) {
            this.annotateAsArray((AnnotatedTypeMirror.AnnotatedArrayType)atype, (ReferenceType)typeDef, declAnnos);
            return;
        }
        this.clearAnnotations(atype, typeDef);
        NodeList<AnnotationExpr> primaryAnnotations = typeDef.getAnnotations().isEmpty() && declAnnos != null ? declAnnos : typeDef.getAnnotations();
        if (atype.getKind() != TypeKind.WILDCARD) {
            this.annotate(atype, primaryAnnotations);
        }
        switch (atype.getKind()) {
            case DECLARED: {
                ClassOrInterfaceType declType = this.unwrapDeclaredType(typeDef);
                if (declType == null) break;
                AnnotatedTypeMirror.AnnotatedDeclaredType adeclType = (AnnotatedTypeMirror.AnnotatedDeclaredType)atype;
                if (!declType.getTypeArguments().isPresent() || declType.getTypeArguments().get().isEmpty() || adeclType.getTypeArguments().isEmpty()) break;
                assert (declType.getTypeArguments().get().size() == adeclType.getTypeArguments().size()) : String.format("Mismatch in type argument size between %s (%d) and %s (%d)", declType, declType.getTypeArguments().get().size(), adeclType, adeclType.getTypeArguments().size());
                for (int i = 0; i < declType.getTypeArguments().get().size(); ++i) {
                    this.annotate(adeclType.getTypeArguments().get(i), (Type)declType.getTypeArguments().get().get(i), null);
                }
                break;
            }
            case WILDCARD: {
                AnnotatedTypeMirror.AnnotatedWildcardType wildcardType = (AnnotatedTypeMirror.AnnotatedWildcardType)atype;
                if (!typeDef.isWildcardType()) {
                    throw new Error("StubParser: Wildcard type <" + atype.toString() + "> doesn't match type in stubs file: <" + typeDef.toString() + ">" + LINE_SEPARATOR + "In file " + this.filename + LINE_SEPARATOR + "While parsing " + this.parseState.toString());
                }
                WildcardType wildcardDef = (WildcardType)typeDef;
                if (wildcardDef.getExtendedType().isPresent()) {
                    this.annotate(wildcardType.getExtendsBound(), wildcardDef.getExtendedType().get(), null);
                    this.annotate(wildcardType.getSuperBound(), primaryAnnotations);
                    break;
                }
                if (wildcardDef.getSuperType().isPresent()) {
                    this.annotate(wildcardType.getSuperBound(), wildcardDef.getSuperType().get(), null);
                    this.annotate(wildcardType.getExtendsBound(), primaryAnnotations);
                    break;
                }
                this.annotate(atype, primaryAnnotations);
                break;
            }
            case TYPEVAR: {
                AnnotatedTypeMirror.AnnotatedTypeVariable typeVarUse = (AnnotatedTypeMirror.AnnotatedTypeVariable)atype;
                for (AnnotatedTypeMirror.AnnotatedTypeVariable typePar : this.typeParameters) {
                    if (typePar.getUnderlyingType() != atype.getUnderlyingType()) continue;
                    AnnotatedTypeMerger.merge(typePar.getUpperBound(), typeVarUse.getUpperBound());
                    AnnotatedTypeMerger.merge(typePar.getLowerBound(), typeVarUse.getLowerBound());
                }
                break;
            }
        }
    }

    private void processField(FieldDeclaration decl, VariableElement elt) {
        this.addDeclAnnotations(this.declAnnos, elt);
        this.annotateDecl(this.declAnnos, elt, decl.getAnnotations());
        this.annotateDecl(this.declAnnos, elt, decl.getElementType().getAnnotations());
        AnnotatedTypeMirror fieldType = this.atypeFactory.fromElement(elt);
        VariableDeclarator fieldVarDecl = null;
        String eltName = elt.getSimpleName().toString();
        for (VariableDeclarator var : decl.getVariables()) {
            if (!var.getName().toString().equals(eltName)) continue;
            fieldVarDecl = var;
            break;
        }
        assert (fieldVarDecl != null);
        this.annotate(fieldType, fieldVarDecl.getType(), decl.getAnnotations());
        StubParser.putNew(this.atypes, elt, fieldType);
    }

    private AnnotatedTypeMirror innermostComponentType(AnnotatedTypeMirror.AnnotatedArrayType type) {
        AnnotatedTypeMirror componentType = type;
        while (componentType.getKind() == TypeKind.ARRAY) {
            componentType = componentType.getComponentType();
        }
        return componentType;
    }

    private void annotateInnermostComponentType(AnnotatedTypeMirror.AnnotatedArrayType type, List<AnnotationExpr> annotations) {
        this.annotate(this.innermostComponentType(type), annotations);
    }

    private void annotate(AnnotatedTypeMirror type, List<AnnotationExpr> annotations) {
        if (annotations == null) {
            return;
        }
        for (AnnotationExpr annotation : annotations) {
            AnnotationMirror annoMirror = this.getAnnotation(annotation, this.allStubAnnotations);
            if (annoMirror != null) {
                type.replaceAnnotation(annoMirror);
                continue;
            }
            this.stubWarnNotFound("Unknown annotation: " + annotation);
        }
    }

    private void annotateDecl(Map<String, Set<AnnotationMirror>> declAnnos, Element elt, List<AnnotationExpr> annotations) {
        if (annotations == null) {
            return;
        }
        Set<AnnotationMirror> annos = AnnotationUtils.createAnnotationSet();
        for (AnnotationExpr annotation : annotations) {
            Target target;
            AnnotationMirror annoMirror = this.getAnnotation(annotation, this.allStubAnnotations);
            if (annoMirror == null || !AnnotationUtils.getElementKindsForTarget(target = annoMirror.getAnnotationType().asElement().getAnnotation(Target.class)).contains((Object)elt.getKind())) continue;
            annos.add(annoMirror);
        }
        String key = ElementUtils.getVerboseName(elt);
        StubParser.putOrAddToMap(declAnnos, key, annos);
    }

    private void annotateTypeParameters(BodyDeclaration<?> decl, Object elt, Map<Element, AnnotatedTypeMirror> atypes, List<? extends AnnotatedTypeMirror> typeArguments, List<TypeParameter> typeParameters) {
        if (typeParameters == null) {
            return;
        }
        if (typeParameters.size() != typeArguments.size()) {
            String msg = String.format("annotateTypeParameters: mismatched sizes:  typeParameters (size %d)=%s;  typeArguments (size %d)=%s;  decl=%s;  elt=%s (%s).", typeParameters.size(), typeParameters, typeArguments.size(), typeArguments, decl.toString().replace(LINE_SEPARATOR, " "), elt.toString().replace(LINE_SEPARATOR, " "), elt.getClass());
            if (!this.debugStubParser) {
                msg = msg + "%n  For more details, run with -AstubDebug";
            }
            this.stubWarn(msg, new Object[0]);
        }
        for (int i = 0; i < typeParameters.size(); ++i) {
            TypeParameter param = typeParameters.get(i);
            AnnotatedTypeMirror.AnnotatedTypeVariable paramType = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeArguments.get(i);
            if (param.getTypeBound() == null || param.getTypeBound().isEmpty()) {
                this.annotate(paramType, param.getAnnotations());
            } else if (param.getTypeBound() != null && param.getTypeBound().size() > 0) {
                this.annotate(paramType.getLowerBound(), param.getAnnotations());
                this.annotate(paramType.getUpperBound(), (Type)param.getTypeBound().get(0), null);
                if (param.getTypeBound().size() > 1) {
                    this.stubWarnNotFound("Annotations on intersection types are not yet supported");
                }
            }
            StubParser.putNew(atypes, paramType.getUnderlyingType().asElement(), paramType);
        }
    }

    private Map<Element, BodyDeclaration<?>> getMembers(TypeElement typeElt, TypeDeclaration<?> typeDecl) {
        assert (typeElt.getSimpleName().contentEquals(typeDecl.getNameAsString()) || typeDecl.getNameAsString().endsWith("$" + typeElt.getSimpleName().toString())) : String.format("%s  %s", typeElt.getSimpleName(), typeDecl.getName());
        LinkedHashMap result = new LinkedHashMap();
        for (BodyDeclaration<?> member : typeDecl.getMembers()) {
            this.putNewElement(typeElt, result, member, typeDecl.getNameAsString());
        }
        return result;
    }

    private void putNewElement(TypeElement typeElt, Map<Element, BodyDeclaration<?>> result, BodyDeclaration<?> member, String typeDeclName) {
        if (member instanceof MethodDeclaration) {
            ExecutableElement elt = this.findElement(typeElt, (MethodDeclaration)member);
            if (elt != null) {
                StubParser.putNoOverride(result, elt, member);
            }
        } else if (member instanceof ConstructorDeclaration) {
            ExecutableElement elt = this.findElement(typeElt, (ConstructorDeclaration)member);
            if (elt != null) {
                StubParser.putNoOverride(result, elt, member);
            }
        } else if (member instanceof FieldDeclaration) {
            FieldDeclaration fieldDecl = (FieldDeclaration)member;
            for (VariableDeclarator var : fieldDecl.getVariables()) {
                VariableElement varelt = this.findElement(typeElt, var);
                if (varelt == null) continue;
                StubParser.putNoOverride(result, varelt, fieldDecl);
            }
        } else if (member instanceof ClassOrInterfaceDeclaration) {
            Element elt = this.findElement(typeElt, (ClassOrInterfaceDeclaration)member);
            if (elt != null) {
                StubParser.putNoOverride(result, elt, member);
            }
        } else if (member instanceof EnumDeclaration) {
            Element elt = this.findElement(typeElt, (EnumDeclaration)member);
            if (elt != null) {
                StubParser.putNoOverride(result, elt, member);
            }
        } else {
            this.stubWarnNotFound(String.format("Ignoring element of type %s in %s", member.getClass(), typeDeclName));
        }
    }

    private AnnotatedTypeMirror.AnnotatedDeclaredType findType(ClassOrInterfaceType type, List<AnnotatedTypeMirror.AnnotatedDeclaredType> types) {
        String typeString = type.getNameAsString();
        for (AnnotatedTypeMirror.AnnotatedDeclaredType superType : types) {
            if (!superType.getUnderlyingType().asElement().getSimpleName().contentEquals(typeString)) continue;
            return superType;
        }
        this.stubWarnNotFound("Supertype " + typeString + " not found");
        if (this.debugStubParser) {
            this.stubDebug("Supertypes that were searched:");
            for (AnnotatedTypeMirror.AnnotatedDeclaredType superType : types) {
                this.stubDebug(String.format("  %s", superType));
            }
        }
        return null;
    }

    private Element findElement(TypeElement typeElt, ClassOrInterfaceDeclaration ciDecl) {
        String wantedClassOrInterfaceName = ciDecl.getNameAsString();
        for (TypeElement typeElement : ElementUtils.getAllTypeElementsIn(typeElt)) {
            if (!wantedClassOrInterfaceName.equals(typeElement.getSimpleName().toString())) continue;
            return typeElement;
        }
        this.stubWarnNotFound("Class/interface " + wantedClassOrInterfaceName + " not found in type " + typeElt);
        if (this.debugStubParser) {
            for (ExecutableElement method : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
                this.stubDebug(String.format("  Here are the type declarations of %s:", typeElt));
                this.stubDebug(String.format("  %s", method));
            }
        }
        return null;
    }

    private Element findElement(TypeElement typeElt, EnumDeclaration enumDecl) {
        String wantedEnumName = enumDecl.getNameAsString();
        for (TypeElement typeElement : ElementUtils.getAllTypeElementsIn(typeElt)) {
            if (!wantedEnumName.equals(typeElement.getSimpleName().toString())) continue;
            return typeElement;
        }
        this.stubWarnNotFound("Enum " + wantedEnumName + " not found in type " + typeElt);
        if (this.debugStubParser) {
            for (ExecutableElement method : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
                this.stubDebug(String.format("  Here are the type declarations of %s:", typeElt));
                this.stubDebug(String.format("  %s", method));
            }
        }
        return null;
    }

    private ExecutableElement findElement(TypeElement typeElt, MethodDeclaration methodDecl) {
        String wantedMethodName = methodDecl.getNameAsString();
        int wantedMethodParams = methodDecl.getParameters() == null ? 0 : methodDecl.getParameters().size();
        String wantedMethodString = StubUtil.toString(methodDecl);
        for (ExecutableElement method : ElementUtils.getAllMethodsIn(typeElt, this.elements)) {
            if (wantedMethodParams != method.getParameters().size() || !wantedMethodName.contentEquals(method.getSimpleName().toString()) || !StubUtil.toString(method).equals(wantedMethodString)) continue;
            return method;
        }
        this.stubWarnNotFound("Method " + wantedMethodString + " not found in type " + typeElt);
        if (this.debugStubParser) {
            for (ExecutableElement method : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
                this.stubDebug(String.format("  Here are the methods of %s:", typeElt));
                this.stubDebug(String.format("  %s", method));
            }
        }
        return null;
    }

    private ExecutableElement findElement(TypeElement typeElt, ConstructorDeclaration constructorDecl) {
        int wantedMethodParams = constructorDecl.getParameters() == null ? 0 : constructorDecl.getParameters().size();
        String wantedMethodString = StubUtil.toString(constructorDecl);
        for (ExecutableElement method : ElementFilter.constructorsIn(typeElt.getEnclosedElements())) {
            if (wantedMethodParams != method.getParameters().size() || !StubUtil.toString(method).equals(wantedMethodString)) continue;
            return method;
        }
        this.stubWarnNotFound("Constructor " + wantedMethodString + " not found in type " + typeElt);
        if (this.debugStubParser) {
            for (ExecutableElement method : ElementFilter.constructorsIn(typeElt.getEnclosedElements())) {
                this.stubDebug(String.format("  %s", method));
            }
        }
        return null;
    }

    private VariableElement findElement(TypeElement typeElt, VariableDeclarator variable) {
        String fieldName = variable.getNameAsString();
        return this.findFieldElement(typeElt, fieldName);
    }

    private VariableElement findFieldElement(TypeElement typeElt, String fieldName) {
        for (VariableElement field : ElementUtils.getAllFieldsIn(typeElt, this.elements)) {
            if (!fieldName.equals(field.getSimpleName().toString())) continue;
            return field;
        }
        this.stubWarnNotFound("Field " + fieldName + " not found in type " + typeElt);
        if (this.debugStubParser) {
            for (VariableElement field : ElementFilter.fieldsIn(typeElt.getEnclosedElements())) {
                this.stubDebug(String.format("  %s", field));
            }
        }
        return null;
    }

    private TypeElement getTypeElementOrNull(String name) {
        TypeElement typeElement = this.elements.getTypeElement(name);
        if (typeElement != null) {
            this.importedTypes.put(name, typeElement);
        }
        return typeElement;
    }

    private TypeElement getTypeElement(String typeName, String ... msg) {
        TypeElement classElement = this.elements.getTypeElement(typeName);
        if (classElement == null) {
            if (msg.length == 0) {
                this.stubWarnNotFound("Type not found: " + typeName);
            } else {
                this.stubWarnNotFound(msg[0] + ": " + typeName);
            }
        }
        return classElement;
    }

    private PackageElement findPackage(String packageName) {
        PackageElement packageElement = this.elements.getPackageElement(packageName);
        if (packageElement == null) {
            this.stubWarnNotFound("Imported package not found: " + packageName);
        }
        return packageElement;
    }

    private AnnotationMirror getAnnotation(AnnotationExpr annotation, Map<String, AnnotationMirror> allStubAnnotations) {
        if (!(annotation instanceof MarkerAnnotationExpr)) {
            if (annotation instanceof NormalAnnotationExpr) {
                NormalAnnotationExpr nrmanno = (NormalAnnotationExpr)annotation;
                String annoName = nrmanno.getNameAsString();
                AnnotationMirror annoMirror = allStubAnnotations.get(annoName);
                if (annoMirror == null) {
                    return null;
                }
                AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, annoMirror);
                NodeList<MemberValuePair> pairs = nrmanno.getPairs();
                if (pairs != null) {
                    for (MemberValuePair mvp : pairs) {
                        Expression exp;
                        String member = mvp.getNameAsString();
                        boolean success = this.handleExpr(builder, member, exp = mvp.getValue());
                        if (success) continue;
                        this.stubWarn("Annotation expression, %s, could not be processed for annotation: %s. ", exp, annotation);
                        return null;
                    }
                }
                return builder.build();
            }
            if (annotation instanceof SingleMemberAnnotationExpr) {
                SingleMemberAnnotationExpr sglanno = (SingleMemberAnnotationExpr)annotation;
                String annoName = sglanno.getNameAsString();
                AnnotationMirror annoMirror = allStubAnnotations.get(annoName);
                if (annoMirror == null) {
                    return null;
                }
                AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, annoMirror);
                Expression valexpr = sglanno.getMemberValue();
                boolean success = this.handleExpr(builder, "value", valexpr);
                if (!success) {
                    this.stubWarn("Annotation expression, %s, could not be processed for annotation: %s. ", valexpr, annotation);
                    return null;
                }
                return builder.build();
            }
            throw new BugInCF("StubParser: unknown annotation type: " + annotation);
        }
        String annoName = ((MarkerAnnotationExpr)annotation).getNameAsString();
        AnnotationMirror annoMirror = allStubAnnotations.get(annoName);
        return annoMirror;
    }

    private Object getValueOfExpressionInAnnotation(String name, Expression expr, TypeKind valueKind) {
        if (expr instanceof FieldAccessExpr || expr instanceof NameExpr) {
            Object value;
            VariableElement elem = expr instanceof NameExpr ? this.findVariableElement((NameExpr)expr) : this.findVariableElement((FieldAccessExpr)expr);
            if (elem == null) {
                this.stubWarn("Field not found: " + expr, new Object[0]);
                return null;
            }
            Object object = value = elem.getConstantValue() != null ? elem.getConstantValue() : elem;
            if (value instanceof Number) {
                return this.convert((Number)value, valueKind);
            }
            return value;
        }
        if (expr instanceof StringLiteralExpr) {
            return ((StringLiteralExpr)expr).asString();
        }
        if (expr instanceof BooleanLiteralExpr) {
            return ((BooleanLiteralExpr)expr).getValue();
        }
        if (expr instanceof CharLiteralExpr) {
            return this.convert((int)((CharLiteralExpr)expr).asChar(), valueKind);
        }
        if (expr instanceof DoubleLiteralExpr) {
            return ((DoubleLiteralExpr)expr).asDouble();
        }
        if (expr instanceof IntegerLiteralExpr) {
            return this.convert(((IntegerLiteralExpr)expr).asInt(), valueKind);
        }
        if (expr instanceof LongLiteralExpr) {
            return this.convert(((LongLiteralExpr)expr).asLong(), valueKind);
        }
        if (expr instanceof UnaryExpr) {
            Object value;
            if (((UnaryExpr)expr).getOperator() == UnaryExpr.Operator.MINUS && (value = this.getValueOfExpressionInAnnotation(name, ((UnaryExpr)expr).getExpression(), valueKind)) instanceof Number) {
                return this.convert((Number)value, valueKind, true);
            }
            this.stubWarn("Unexpected Unary annotation expression: " + expr, new Object[0]);
            return null;
        }
        if (expr instanceof ClassExpr) {
            ClassExpr classExpr = (ClassExpr)expr;
            String className = classExpr.getType().toString();
            if (this.importedTypes.containsKey(className)) {
                return this.importedTypes.get(className).asType();
            }
            TypeElement typeElement = this.findTypeOfName(className);
            if (typeElement == null) {
                this.stubWarn("StubParser: unknown class name " + className, new Object[0]);
                return null;
            }
            return typeElement.asType();
        }
        if (expr instanceof NullLiteralExpr) {
            this.stubWarn("Null found as value for %s. Null isn't allowed as an annotation value", name);
            return null;
        }
        this.stubWarn("Unexpected annotation expression: " + expr, new Object[0]);
        return null;
    }

    private @Nullable TypeElement findTypeOfName(String name) {
        int lastDot;
        String packageName = this.parseState.packageName;
        String packagePrefix = packageName == null ? "" : packageName + ".";
        TypeElement typeElement = this.getTypeElementOrNull(name);
        if (typeElement == null && packageName != null) {
            typeElement = this.getTypeElementOrNull(packagePrefix + name);
        }
        for (String enclosingClass = this.parseState.className; typeElement == null && enclosingClass != null; enclosingClass = enclosingClass.substring(0, lastDot)) {
            typeElement = this.getTypeElementOrNull(packagePrefix + enclosingClass + "." + name);
            lastDot = enclosingClass.lastIndexOf(46);
            if (lastDot == -1) break;
        }
        if (typeElement == null && !"java.lang".equals(packageName)) {
            typeElement = this.getTypeElementOrNull("java.lang." + name);
        }
        return typeElement;
    }

    private Object convert(Number number, TypeKind expectedKind) {
        return this.convert(number, expectedKind, false);
    }

    private Object convert(Number number, TypeKind expectedKind, boolean negate) {
        byte scalefactor = (byte)(negate ? -1 : 1);
        switch (expectedKind) {
            case BYTE: {
                return number.byteValue() * scalefactor;
            }
            case SHORT: {
                return number.shortValue() * scalefactor;
            }
            case INT: {
                return number.intValue() * scalefactor;
            }
            case LONG: {
                return number.longValue() * (long)scalefactor;
            }
            case CHAR: {
                return Character.valueOf((char)number.intValue());
            }
            case FLOAT: {
                return Float.valueOf(number.floatValue() * (float)scalefactor);
            }
            case DOUBLE: {
                return number.doubleValue() * (double)scalefactor;
            }
        }
        throw new BugInCF("Unexpected expectedKind: " + (Object)((Object)expectedKind));
    }

    private boolean handleExpr(AnnotationBuilder builder, String name, Expression expr) {
        ExecutableElement var = builder.findElement(name);
        TypeMirror expected = var.getReturnType();
        TypeKind valueKind = expected.getKind() == TypeKind.ARRAY ? ((ArrayType)expected).getComponentType().getKind() : expected.getKind();
        if (expr instanceof ArrayInitializerExpr) {
            if (expected.getKind() != TypeKind.ARRAY) {
                this.stubWarn("unhandled annotation attribute type: " + expr + " and expected: " + expected, new Object[0]);
                return false;
            }
            NodeList<Expression> arrayExpressions = ((ArrayInitializerExpr)expr).getValues();
            Object[] values = new Object[arrayExpressions.size()];
            for (int i = 0; i < arrayExpressions.size(); ++i) {
                values[i] = this.getValueOfExpressionInAnnotation(name, (Expression)arrayExpressions.get(i), valueKind);
                if (values[i] != null) continue;
                return false;
            }
            builder.setValue((CharSequence)name, values);
        } else {
            Object value = this.getValueOfExpressionInAnnotation(name, expr, valueKind);
            if (value == null) {
                return false;
            }
            if (expected.getKind() == TypeKind.ARRAY) {
                Object[] valueArray = new Object[]{value};
                builder.setValue((CharSequence)name, valueArray);
            } else {
                this.builderSetValue(builder, name, value);
            }
        }
        return true;
    }

    private void builderSetValue(AnnotationBuilder builder, String name, Object value) {
        if (value instanceof Boolean) {
            builder.setValue((CharSequence)name, (Boolean)value);
        } else if (value instanceof Character) {
            builder.setValue((CharSequence)name, (Character)value);
        } else if (value instanceof Class) {
            builder.setValue((CharSequence)name, (Class)value);
        } else if (value instanceof Double) {
            builder.setValue((CharSequence)name, (Double)value);
        } else if (value instanceof Enum) {
            builder.setValue((CharSequence)name, (Enum)value);
        } else if (value instanceof Float) {
            builder.setValue((CharSequence)name, (Float)value);
        } else if (value instanceof Integer) {
            builder.setValue((CharSequence)name, (Integer)value);
        } else if (value instanceof Long) {
            builder.setValue((CharSequence)name, (Long)value);
        } else if (value instanceof Short) {
            builder.setValue((CharSequence)name, (Short)value);
        } else if (value instanceof String) {
            builder.setValue((CharSequence)name, (String)value);
        } else if (value instanceof TypeMirror) {
            builder.setValue((CharSequence)name, (TypeMirror)value);
        } else if (value instanceof VariableElement) {
            builder.setValue((CharSequence)name, (VariableElement)value);
        } else {
            throw new BugInCF("Unexpected builder value: %s", value);
        }
    }

    private @Nullable VariableElement findVariableElement(NameExpr nexpr) {
        if (this.findVariableElementNameCache.containsKey(nexpr)) {
            return this.findVariableElementNameCache.get(nexpr);
        }
        VariableElement res = null;
        boolean importFound = false;
        for (String imp : this.importedConstants) {
            Pair<String, String> partitionedName = StubUtil.partitionQualifiedName(imp);
            String typeName = (String)partitionedName.first;
            String fieldName = (String)partitionedName.second;
            if (!fieldName.equals(nexpr.getNameAsString())) continue;
            TypeElement enclType = this.getTypeElement(typeName, String.format("Enclosing type of static import %s not found", fieldName));
            if (enclType == null) {
                return null;
            }
            importFound = true;
            res = this.findFieldElement(enclType, fieldName);
            break;
        }
        if (res == null && !importFound) {
            this.stubWarnNotFound("Static field " + nexpr.getName() + " is not imported");
        }
        this.findVariableElementNameCache.put(nexpr, res);
        return res;
    }

    private @Nullable VariableElement findVariableElement(FieldAccessExpr faexpr) {
        if (this.findVariableElementFieldCache.containsKey(faexpr)) {
            return this.findVariableElementFieldCache.get(faexpr);
        }
        TypeElement rcvElt = this.elements.getTypeElement(faexpr.getScope().toString());
        if (rcvElt == null) {
            for (String imp : this.importedConstants) {
                String[] importDelimited = imp.split("\\.");
                if (!importDelimited[importDelimited.length - 1].equals(faexpr.getScope().toString())) continue;
                StringBuilder fullAnnotation = new StringBuilder();
                for (int i = 0; i < importDelimited.length - 1; ++i) {
                    fullAnnotation.append(importDelimited[i]);
                    fullAnnotation.append('.');
                }
                fullAnnotation.append(faexpr.getScope().toString());
                rcvElt = this.elements.getTypeElement(fullAnnotation);
                break;
            }
            if (rcvElt == null) {
                this.stubWarnNotFound("Type " + faexpr.getScope().toString() + " not found");
                return null;
            }
        }
        VariableElement res = this.findFieldElement(rcvElt, faexpr.getNameAsString());
        this.findVariableElementFieldCache.put(faexpr, res);
        return res;
    }

    private static <K, V> void putNoOverride(Map<K, V> m3, K key, V value) {
        if (key == null) {
            throw new BugInCF("StubParser: key is null");
        }
        if (!m3.containsKey(key)) {
            m3.put(key, value);
        }
    }

    private static void putOrAddToMap(Map<String, Set<AnnotationMirror>> map, String key, Set<AnnotationMirror> annos) {
        if (map.containsKey(key)) {
            map.get(key).addAll(annos);
        } else {
            map.put(key, annos);
        }
    }

    private static void putNew(Map<Element, AnnotatedTypeMirror> m3, Element key, AnnotatedTypeMirror value) {
        if (key == null) {
            throw new BugInCF("StubParser: key is null");
        }
        if (m3.containsKey(key)) {
            AnnotatedTypeMirror value2 = m3.get(key);
            AnnotatedTypeMerger.merge(value, value2);
            m3.put(key, value2);
        } else {
            m3.put(key, value);
        }
    }

    private static <K, V> void putAllNew(Map<K, V> m3, Map<K, V> m22) {
        for (Map.Entry<K, V> e2 : m22.entrySet()) {
            StubParser.putNoOverride(m3, e2.getKey(), e2.getValue());
        }
    }

    private void stubWarnNotFound(String warning) {
        if (warnings.add(warning) && (this.warnIfNotFound || this.debugStubParser)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "StubParser: " + warning);
        }
    }

    private void stubWarnOverwritesBytecode(String warning) {
        if (warnings.add(warning) && (this.warnIfStubOverwritesBytecode || this.debugStubParser)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "StubParser: " + warning);
        }
    }

    private void stubWarn(String warning, Object ... args) {
        if (warnings.add(warning = String.format(warning, args))) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "StubParser: " + warning);
        }
    }

    private void stubDebug(String warning) {
        if (warnings.add(warning) && this.debugStubParser) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "StubParser: " + warning);
        }
    }

    private static class FqName {
        public String packageName;
        public String className;

        public FqName(String packageName, String className) {
            this.packageName = packageName;
            this.className = className;
        }

        public String toString() {
            if (this.packageName == null) {
                return this.className;
            }
            return this.packageName + "." + this.className;
        }
    }
}

