/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.ASTPathCriterion;
import annotator.find.BoundLocationCriterion;
import annotator.find.CallCriterion;
import annotator.find.CastCriterion;
import annotator.find.ClassBoundCriterion;
import annotator.find.Criterion;
import annotator.find.EnclosedByCriterion;
import annotator.find.ExtImplsLocationCriterion;
import annotator.find.FieldCriterion;
import annotator.find.GenericArrayLocationCriterion;
import annotator.find.InClassCriterion;
import annotator.find.InFieldInitCriterion;
import annotator.find.InInitBlockCriterion;
import annotator.find.InMethodCriterion;
import annotator.find.InPackageCriterion;
import annotator.find.InstanceOfCriterion;
import annotator.find.IsCriterion;
import annotator.find.IsSigMethodCriterion;
import annotator.find.LambdaCriterion;
import annotator.find.LocalVariableCriterion;
import annotator.find.MemberReferenceCriterion;
import annotator.find.MethodBoundCriterion;
import annotator.find.NewCriterion;
import annotator.find.NotInMethodCriterion;
import annotator.find.PackageCriterion;
import annotator.find.ParamCriterion;
import annotator.find.ReceiverCriterion;
import annotator.find.ReturnTypeCriterion;
import annotator.find.TypeArgumentCriterion;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.LinkedHashMap;
import java.util.Map;
import scenelib.annotations.el.BoundLocation;
import scenelib.annotations.el.InnerTypeLocation;
import scenelib.annotations.el.LocalLocation;
import scenelib.annotations.el.RelativeLocation;
import scenelib.annotations.el.TypeIndexLocation;
import scenelib.annotations.io.ASTPath;
import scenelib.annotations.io.DebugWriter;

public final class Criteria {
    public static DebugWriter dbug = new DebugWriter();
    private final Map<Criterion.Kind, Criterion> criteria = new LinkedHashMap<Criterion.Kind, Criterion>();

    public void add(Criterion criterion) {
        this.criteria.put(criterion.getKind(), criterion);
    }

    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        for (Criterion criterion : this.criteria.values()) {
            if (!criterion.isSatisfiedBy(treePath, tree)) {
                dbug.debug("UNsatisfied criterion of type %s:%n    leaf=%s (%s)%n", criterion, criterion.getClass(), Main.leafString(treePath));
                return false;
            }
            dbug.debug("satisfied criterion of type %s:%n    leaf=%s (%s)%n", criterion, criterion.getClass(), Main.leafString(treePath));
        }
        return true;
    }

    public boolean isSatisfiedBy(TreePath treePath) {
        for (Criterion criterion : this.criteria.values()) {
            if (!criterion.isSatisfiedBy(treePath)) {
                dbug.debug("UNsatisfied criterion: %s%n", criterion);
                return false;
            }
            dbug.debug("satisfied criterion: %s%n", criterion);
        }
        return true;
    }

    public boolean isOnReceiver() {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.RECEIVER) continue;
            return true;
        }
        return false;
    }

    public boolean isOnPackage() {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.PACKAGE) continue;
            return true;
        }
        return false;
    }

    public boolean isOnReturnType() {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.RETURN_TYPE) continue;
            return true;
        }
        return false;
    }

    public boolean isOnLocalVariable() {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.LOCAL_VARIABLE) continue;
            return true;
        }
        return false;
    }

    public boolean isOnInstanceof() {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.INSTANCE_OF) continue;
            return true;
        }
        return false;
    }

    public boolean isOnNew() {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.NEW) continue;
            return true;
        }
        return false;
    }

    public boolean isOnTypeDeclarationExtendsClause() {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.EXTIMPLS_LOCATION) continue;
            return ((ExtImplsLocationCriterion)criterion).getIndex() == -1;
        }
        return false;
    }

    public boolean isOnMethod(String string) {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.IN_METHOD || !((InMethodCriterion)criterion).name.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isOnFieldDeclaration() {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.FIELD || !((FieldCriterion)criterion).isDeclaration) continue;
            return true;
        }
        return false;
    }

    public boolean isOnVariableDeclaration() {
        return this.isOnLocalVariable() || this.isOnFieldDeclaration();
    }

    public ASTPath getASTPath() {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.AST_PATH) continue;
            return ((ASTPathCriterion)criterion).astPath;
        }
        return null;
    }

    public String getClassName() {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.IN_CLASS) continue;
            return ((InClassCriterion)criterion).className;
        }
        return null;
    }

    public String getMethodName() {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.IN_METHOD) continue;
            return ((InMethodCriterion)criterion).name;
        }
        return null;
    }

    public String getFieldName() {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.FIELD) continue;
            return ((FieldCriterion)criterion).varName;
        }
        return null;
    }

    public GenericArrayLocationCriterion getGenericArrayLocation() {
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.GENERIC_ARRAY_LOCATION) continue;
            return (GenericArrayLocationCriterion)criterion;
        }
        return null;
    }

    public RelativeLocation getCastRelativeLocation() {
        RelativeLocation relativeLocation = null;
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.CAST) continue;
            relativeLocation = ((CastCriterion)criterion).getLocation();
        }
        return relativeLocation;
    }

    public InClassCriterion getInClass() {
        InClassCriterion inClassCriterion = null;
        for (Criterion criterion : this.criteria.values()) {
            if (criterion.getKind() != Criterion.Kind.IN_CLASS) continue;
            inClassCriterion = (InClassCriterion)criterion;
        }
        return inClassCriterion;
    }

    public boolean onBoundZero() {
        block5: for (Criterion criterion : this.criteria.values()) {
            switch (criterion.getKind()) {
                case CLASS_BOUND: {
                    if (((ClassBoundCriterion)criterion).boundLoc.boundIndex != 0) break;
                    return true;
                }
                case METHOD_BOUND: {
                    if (((MethodBoundCriterion)criterion).boundLoc.boundIndex != 0) break;
                    return true;
                }
                case AST_PATH: {
                    ASTPath aSTPath = ((ASTPathCriterion)criterion).astPath;
                    if (aSTPath.isEmpty()) break;
                    ASTPath.ASTEntry aSTEntry = aSTPath.getLast();
                    if (!aSTEntry.childSelectorIs("bound") || aSTEntry.getArgument() != 0) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.criteria.toString();
    }

    public static final Criterion is(Tree.Kind kind, String string) {
        return new IsCriterion(kind, string);
    }

    public static final Criterion enclosedBy(Tree.Kind kind) {
        return new EnclosedByCriterion(kind);
    }

    public static final Criterion inPackage(String string) {
        return new InPackageCriterion(string);
    }

    public static final Criterion inClass(String string, boolean bl) {
        return new InClassCriterion(string, true);
    }

    public static final Criterion inMethod(String string) {
        return new InMethodCriterion(string);
    }

    public static final Criterion notInMethod() {
        return new NotInMethodCriterion();
    }

    public static final Criterion packageDecl(String string) {
        return new PackageCriterion(string);
    }

    public static final Criterion atLocation() {
        return new GenericArrayLocationCriterion();
    }

    public static final Criterion atLocation(InnerTypeLocation innerTypeLocation) {
        return new GenericArrayLocationCriterion(innerTypeLocation);
    }

    @Deprecated
    public static final Criterion field(String string) {
        return new FieldCriterion(string);
    }

    public static final Criterion field(String string, boolean bl) {
        return new FieldCriterion(string, bl);
    }

    public static final Criterion inStaticInit(int n) {
        return new InInitBlockCriterion(n, true);
    }

    public static final Criterion inInstanceInit(int n) {
        return new InInitBlockCriterion(n, false);
    }

    public static final Criterion inFieldInit(String string) {
        return new InFieldInitCriterion(string);
    }

    public static final Criterion receiver(String string) {
        return new ReceiverCriterion(string);
    }

    public static final Criterion returnType(String string, String string2) {
        return new ReturnTypeCriterion(string, string2);
    }

    public static final Criterion isSigMethod(String string) {
        return new IsSigMethodCriterion(string);
    }

    public static final Criterion param(String string, Integer n) {
        return new ParamCriterion(string, n);
    }

    public static final Criterion local(String string, LocalLocation localLocation) {
        return new LocalVariableCriterion(string, localLocation);
    }

    public static final Criterion cast(String string, RelativeLocation relativeLocation) {
        return new CastCriterion(string, relativeLocation);
    }

    public static final Criterion newObject(String string, RelativeLocation relativeLocation) {
        return new NewCriterion(string, relativeLocation);
    }

    public static final Criterion instanceOf(String string, RelativeLocation relativeLocation) {
        return new InstanceOfCriterion(string, relativeLocation);
    }

    public static Criterion memberReference(String string, RelativeLocation relativeLocation) {
        return new MemberReferenceCriterion(string, relativeLocation);
    }

    public static Criterion methodCall(String string, RelativeLocation relativeLocation) {
        return new CallCriterion(string, relativeLocation);
    }

    public static final Criterion typeArgument(String string, RelativeLocation relativeLocation) {
        return new TypeArgumentCriterion(string, relativeLocation);
    }

    public static final Criterion lambda(String string, RelativeLocation relativeLocation) {
        return new LambdaCriterion(string, relativeLocation);
    }

    public static final Criterion atBoundLocation(BoundLocation boundLocation) {
        return new BoundLocationCriterion(boundLocation);
    }

    public static final Criterion atExtImplsLocation(String string, TypeIndexLocation typeIndexLocation) {
        return new ExtImplsLocationCriterion(string, typeIndexLocation);
    }

    public static final Criterion methodBound(String string, BoundLocation boundLocation) {
        return new MethodBoundCriterion(string, boundLocation);
    }

    public static final Criterion classBound(String string, BoundLocation boundLocation) {
        return new ClassBoundCriterion(string, boundLocation);
    }

    public static final Criterion astPath(ASTPath aSTPath) {
        return new ASTPathCriterion(aSTPath);
    }
}

