/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.lowerbound;

import java.util.AbstractList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.checkerframework.checker.index.inequality.LessThanChecker;
import org.checkerframework.checker.index.searchindex.SearchIndexChecker;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.framework.source.SuppressWarningsKeys;

@SuppressWarningsKeys(value={"index", "lowerbound"})
public class LowerBoundChecker
extends BaseTypeChecker {
    private HashSet<String> collectionBaseTypeNames;

    public LowerBoundChecker() {
        Class[] collectionBaseClasses = new Class[]{List.class, AbstractList.class};
        this.collectionBaseTypeNames = new HashSet(collectionBaseClasses.length);
        for (Class collectionBaseClass : collectionBaseClasses) {
            this.collectionBaseTypeNames.add(collectionBaseClass.getName());
        }
    }

    @Override
    public boolean shouldSkipUses(String typeName) {
        if (this.collectionBaseTypeNames.contains(typeName)) {
            return true;
        }
        return super.shouldSkipUses(typeName);
    }

    @Override
    protected LinkedHashSet<Class<? extends BaseTypeChecker>> getImmediateSubcheckerClasses() {
        LinkedHashSet<Class<? extends BaseTypeChecker>> checkers = super.getImmediateSubcheckerClasses();
        checkers.add(ValueChecker.class);
        checkers.add(LessThanChecker.class);
        checkers.add(SearchIndexChecker.class);
        return checkers;
    }
}

