/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.samelen;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.qual.PolySameLen;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.samelen.SameLenAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.TreeUtils;

public class SameLenVisitor
extends BaseTypeVisitor<SameLenAnnotatedTypeFactory> {
    public SameLenVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey) {
        if (IndexUtil.isSequenceType(valueType.getUnderlyingType()) && TreeUtils.isExpressionTree(valueTree) && (!valueType.hasAnnotation(PolySameLen.class) || !varType.hasAnnotation(PolySameLen.class))) {
            AnnotationMirror am = valueType.getAnnotation(SameLen.class);
            ArrayList<String> arraysInAnno = am == null ? new ArrayList() : IndexUtil.getValueOfAnnotationWithStringArgument(am);
            FlowExpressions.Receiver rec = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, (ExpressionTree)valueTree);
            if (rec != null && SameLenAnnotatedTypeFactory.shouldUseInAnnotation(rec)) {
                ArrayList<String> names = new ArrayList<String>();
                names.add(rec.toString());
                AnnotationMirror newSameLen = ((SameLenAnnotatedTypeFactory)this.atypeFactory).getCombinedSameLen(arraysInAnno, names);
                valueType.replaceAnnotation(newSameLen);
            }
        }
        super.commonAssignmentCheck(varType, valueType, valueTree, errorKey);
    }
}

