/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.flow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.CFGVisualizer;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ThisLiteralNode;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.dataflow.util.PurityUtils;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.qual.MonotonicQualifier;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.Pair;

public abstract class CFAbstractStore<V extends CFAbstractValue<V>, S extends CFAbstractStore<V, S>>
implements Store<S> {
    protected final CFAbstractAnalysis<V, S, ?> analysis;
    protected final Map<FlowExpressions.LocalVariable, V> localVariableValues;
    protected V thisValue;
    protected Map<FlowExpressions.FieldAccess, V> fieldValues;
    protected Map<FlowExpressions.ArrayAccess, V> arrayValues;
    protected Map<FlowExpressions.MethodCall, V> methodValues;
    protected Map<FlowExpressions.ClassName, V> classValues;
    protected final boolean sequentialSemantics;

    public CFAbstractStore(CFAbstractAnalysis<V, S, ?> analysis, boolean sequentialSemantics) {
        this.analysis = analysis;
        this.localVariableValues = new HashMap<FlowExpressions.LocalVariable, V>();
        this.thisValue = null;
        this.fieldValues = new HashMap<FlowExpressions.FieldAccess, V>();
        this.methodValues = new HashMap<FlowExpressions.MethodCall, V>();
        this.arrayValues = new HashMap<FlowExpressions.ArrayAccess, V>();
        this.classValues = new HashMap<FlowExpressions.ClassName, V>();
        this.sequentialSemantics = sequentialSemantics;
    }

    protected CFAbstractStore(CFAbstractStore<V, S> other) {
        this.analysis = other.analysis;
        this.localVariableValues = new HashMap<FlowExpressions.LocalVariable, V>(other.localVariableValues);
        this.thisValue = other.thisValue;
        this.fieldValues = new HashMap<FlowExpressions.FieldAccess, V>(other.fieldValues);
        this.methodValues = new HashMap<FlowExpressions.MethodCall, V>(other.methodValues);
        this.arrayValues = new HashMap<FlowExpressions.ArrayAccess, V>(other.arrayValues);
        this.classValues = new HashMap<FlowExpressions.ClassName, V>(other.classValues);
        this.sequentialSemantics = other.sequentialSemantics;
    }

    public void initializeMethodParameter(LocalVariableNode p, @Nullable V value) {
        if (value != null) {
            this.localVariableValues.put(new FlowExpressions.LocalVariable(p.getElement()), value);
        }
    }

    public void initializeThisValue(AnnotationMirror a, TypeMirror underlyingType) {
        if (a != null) {
            this.thisValue = this.analysis.createSingleAnnotationValue(a, underlyingType);
        }
    }

    protected boolean isSideEffectFree(AnnotatedTypeFactory atypeFactory, ExecutableElement method) {
        return PurityUtils.isSideEffectFree((AnnotationProvider)atypeFactory, method);
    }

    public void updateForMethodCall(MethodInvocationNode n, AnnotatedTypeFactory atypeFactory, V val) {
        ExecutableElement method = n.getTarget().getMethod();
        if (!this.analysis.checker.hasOption("assumeSideEffectFree") && !this.isSideEffectFree(atypeFactory, method)) {
            HashMap<FlowExpressions.FieldAccess, CFAbstractValue> newFieldValues = new HashMap<FlowExpressions.FieldAccess, CFAbstractValue>();
            for (Map.Entry<FlowExpressions.FieldAccess, V> e : this.fieldValues.entrySet()) {
                FlowExpressions.FieldAccess fieldAccess = e.getKey();
                CFAbstractValue otherVal = (CFAbstractValue)e.getValue();
                List<Pair<AnnotationMirror, AnnotationMirror>> fieldAnnotations = atypeFactory.getAnnotationWithMetaAnnotation(fieldAccess.getField(), MonotonicQualifier.class);
                Object newOtherVal = null;
                for (Pair<AnnotationMirror, AnnotationMirror> fieldAnnotation : fieldAnnotations) {
                    AnnotationMirror monotonicAnnotation = (AnnotationMirror)fieldAnnotation.second;
                    Name annotation = AnnotationUtils.getElementValueClassName(monotonicAnnotation, "value", false);
                    AnnotationMirror target = AnnotationBuilder.fromName(atypeFactory.getElementUtils(), annotation);
                    if (!AnnotationUtils.containsSame(otherVal.getAnnotations(), target)) continue;
                    newOtherVal = this.analysis.createSingleAnnotationValue(target, otherVal.getUnderlyingType()).mostSpecific(newOtherVal, null);
                }
                if (newOtherVal != null) {
                    newFieldValues.put(fieldAccess, newOtherVal);
                    continue;
                }
                if (!fieldAccess.isUnmodifiableByOtherCode()) continue;
                newFieldValues.put(fieldAccess, otherVal);
            }
            this.fieldValues = newFieldValues;
            this.methodValues.clear();
            this.arrayValues.clear();
        }
        FlowExpressions.Receiver methodCall = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), n);
        this.replaceValue(methodCall, val);
    }

    public void insertValue(FlowExpressions.Receiver r, AnnotationMirror a) {
        this.insertValue(r, this.analysis.createSingleAnnotationValue(a, r.getType()));
    }

    public static boolean canInsertReceiver(FlowExpressions.Receiver r) {
        if (r instanceof FlowExpressions.FieldAccess || r instanceof FlowExpressions.ThisReference || r instanceof FlowExpressions.LocalVariable || r instanceof FlowExpressions.MethodCall || r instanceof FlowExpressions.ArrayAccess) {
            return !r.containsUnknown();
        }
        return false;
    }

    public void insertValue(FlowExpressions.Receiver r, @Nullable V value) {
        if (value == null) {
            return;
        }
        if (r.containsUnknown()) {
            return;
        }
        if (r instanceof FlowExpressions.LocalVariable) {
            FlowExpressions.LocalVariable localVar = (FlowExpressions.LocalVariable)r;
            CFAbstractValue oldValue = (CFAbstractValue)this.localVariableValues.get(localVar);
            Object newValue = value.mostSpecific(oldValue, null);
            if (newValue != null) {
                this.localVariableValues.put(localVar, newValue);
            }
        } else if (r instanceof FlowExpressions.FieldAccess) {
            CFAbstractValue oldValue;
            Object newValue;
            FlowExpressions.FieldAccess fieldAcc = (FlowExpressions.FieldAccess)r;
            boolean isMonotonic = this.isMonotonicUpdate(fieldAcc, value);
            if ((this.sequentialSemantics || isMonotonic || fieldAcc.isUnmodifiableByOtherCode()) && (newValue = value.mostSpecific((oldValue = (CFAbstractValue)this.fieldValues.get(fieldAcc)), null)) != null) {
                this.fieldValues.put(fieldAcc, newValue);
            }
        } else if (r instanceof FlowExpressions.MethodCall) {
            CFAbstractValue oldValue;
            Object newValue;
            FlowExpressions.MethodCall method = (FlowExpressions.MethodCall)r;
            if (this.sequentialSemantics && (newValue = value.mostSpecific((oldValue = (CFAbstractValue)this.methodValues.get(method)), null)) != null) {
                this.methodValues.put(method, newValue);
            }
        } else if (r instanceof FlowExpressions.ArrayAccess) {
            CFAbstractValue oldValue;
            Object newValue;
            FlowExpressions.ArrayAccess arrayAccess = (FlowExpressions.ArrayAccess)r;
            if (this.sequentialSemantics && (newValue = value.mostSpecific((oldValue = (CFAbstractValue)this.arrayValues.get(arrayAccess)), null)) != null) {
                this.arrayValues.put(arrayAccess, newValue);
            }
        } else if (r instanceof FlowExpressions.ThisReference) {
            V oldValue;
            Object newValue;
            FlowExpressions.ThisReference thisRef = (FlowExpressions.ThisReference)r;
            if ((this.sequentialSemantics || thisRef.isUnmodifiableByOtherCode()) && (newValue = value.mostSpecific(oldValue = this.thisValue, null)) != null) {
                this.thisValue = newValue;
            }
        } else if (r instanceof FlowExpressions.ClassName) {
            CFAbstractValue oldValue;
            Object newValue;
            FlowExpressions.ClassName className = (FlowExpressions.ClassName)r;
            if ((this.sequentialSemantics || className.isUnmodifiableByOtherCode()) && (newValue = value.mostSpecific((oldValue = (CFAbstractValue)this.classValues.get(className)), null)) != null) {
                this.classValues.put(className, newValue);
            }
        }
    }

    protected boolean isMonotonicUpdate(FlowExpressions.FieldAccess fieldAcc, V value) {
        boolean isMonotonic = false;
        if (!this.sequentialSemantics) {
            GenericAnnotatedTypeFactory atypeFactory = this.analysis.atypeFactory;
            List<Pair<AnnotationMirror, AnnotationMirror>> fieldAnnotations = atypeFactory.getAnnotationWithMetaAnnotation(fieldAcc.getField(), MonotonicQualifier.class);
            for (Pair<AnnotationMirror, AnnotationMirror> fieldAnnotation : fieldAnnotations) {
                AnnotationMirror monotonicAnnotation = (AnnotationMirror)fieldAnnotation.second;
                Name annotation = AnnotationUtils.getElementValueClassName(monotonicAnnotation, "value", false);
                AnnotationMirror target = AnnotationBuilder.fromName(atypeFactory.getElementUtils(), annotation);
                if (!AnnotationUtils.containsSame(((CFAbstractValue)value).getAnnotations(), target)) continue;
                isMonotonic = true;
                break;
            }
        }
        return isMonotonic;
    }

    public void insertThisValue(AnnotationMirror a, TypeMirror underlyingType) {
        V oldValue;
        if (a == null) {
            return;
        }
        Object value = this.analysis.createSingleAnnotationValue(a, underlyingType);
        Object newValue = ((CFAbstractValue)value).mostSpecific(oldValue = this.thisValue, null);
        if (newValue != null) {
            this.thisValue = newValue;
        }
    }

    public void replaceValue(FlowExpressions.Receiver r, @Nullable V value) {
        this.clearValue(r);
        this.insertValue(r, value);
    }

    public void clearValue(FlowExpressions.Receiver r) {
        if (r.containsUnknown()) {
            return;
        }
        if (r instanceof FlowExpressions.LocalVariable) {
            FlowExpressions.LocalVariable localVar = (FlowExpressions.LocalVariable)r;
            this.localVariableValues.remove(localVar);
        } else if (r instanceof FlowExpressions.FieldAccess) {
            FlowExpressions.FieldAccess fieldAcc = (FlowExpressions.FieldAccess)r;
            this.fieldValues.remove(fieldAcc);
        } else if (r instanceof FlowExpressions.MethodCall) {
            FlowExpressions.MethodCall method = (FlowExpressions.MethodCall)r;
            this.methodValues.remove(method);
        } else if (r instanceof FlowExpressions.ArrayAccess) {
            FlowExpressions.ArrayAccess a = (FlowExpressions.ArrayAccess)r;
            this.arrayValues.remove(a);
        } else if (r instanceof FlowExpressions.ClassName) {
            FlowExpressions.ClassName c = (FlowExpressions.ClassName)r;
            this.classValues.remove(c);
        }
    }

    public @Nullable V getValue(FlowExpressions.Receiver expr) {
        if (expr instanceof FlowExpressions.LocalVariable) {
            FlowExpressions.LocalVariable localVar = (FlowExpressions.LocalVariable)expr;
            return (V)((CFAbstractValue)this.localVariableValues.get(localVar));
        }
        if (expr instanceof FlowExpressions.ThisReference) {
            return this.thisValue;
        }
        if (expr instanceof FlowExpressions.FieldAccess) {
            FlowExpressions.FieldAccess fieldAcc = (FlowExpressions.FieldAccess)expr;
            return (V)((CFAbstractValue)this.fieldValues.get(fieldAcc));
        }
        if (expr instanceof FlowExpressions.MethodCall) {
            FlowExpressions.MethodCall method = (FlowExpressions.MethodCall)expr;
            return (V)((CFAbstractValue)this.methodValues.get(method));
        }
        if (expr instanceof FlowExpressions.ArrayAccess) {
            FlowExpressions.ArrayAccess a = (FlowExpressions.ArrayAccess)expr;
            return (V)((CFAbstractValue)this.arrayValues.get(a));
        }
        if (expr instanceof FlowExpressions.ClassName) {
            FlowExpressions.ClassName c = (FlowExpressions.ClassName)expr;
            return (V)((CFAbstractValue)this.classValues.get(c));
        }
        throw new BugInCF("Unexpected FlowExpression: " + expr + " (" + expr.getClass() + ")");
    }

    public @Nullable V getValue(FieldAccessNode n) {
        FlowExpressions.FieldAccess fieldAccess = FlowExpressions.internalReprOfFieldAccess(this.analysis.getTypeFactory(), n);
        return (V)((CFAbstractValue)this.fieldValues.get(fieldAccess));
    }

    public @Nullable V getValue(MethodInvocationNode n) {
        FlowExpressions.Receiver method = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), n, true);
        if (method == null) {
            return null;
        }
        return (V)((CFAbstractValue)this.methodValues.get(method));
    }

    public @Nullable V getValue(ArrayAccessNode n) {
        FlowExpressions.ArrayAccess arrayAccess = FlowExpressions.internalReprOfArrayAccess(this.analysis.getTypeFactory(), n);
        return (V)((CFAbstractValue)this.arrayValues.get(arrayAccess));
    }

    public void updateForAssignment(Node n, @Nullable V val) {
        FlowExpressions.Receiver receiver = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), n);
        if (receiver instanceof FlowExpressions.ArrayAccess) {
            this.updateForArrayAssignment((FlowExpressions.ArrayAccess)receiver, val);
        } else if (receiver instanceof FlowExpressions.FieldAccess) {
            this.updateForFieldAccessAssignment((FlowExpressions.FieldAccess)receiver, val);
        } else if (receiver instanceof FlowExpressions.LocalVariable) {
            this.updateForLocalVariableAssignment((FlowExpressions.LocalVariable)receiver, val);
        } else {
            throw new BugInCF("Unexpected receiver of class " + receiver.getClass());
        }
    }

    protected void updateForFieldAccessAssignment(FlowExpressions.FieldAccess fieldAccess, @Nullable V val) {
        this.removeConflicting(fieldAccess, val);
        if (!fieldAccess.containsUnknown() && val != null) {
            boolean isMonotonic = this.isMonotonicUpdate(fieldAccess, val);
            if (this.sequentialSemantics || isMonotonic || fieldAccess.isUnmodifiableByOtherCode()) {
                this.fieldValues.put(fieldAccess, val);
            }
        }
    }

    protected void updateForArrayAssignment(FlowExpressions.ArrayAccess arrayAccess, @Nullable V val) {
        this.removeConflicting(arrayAccess, val);
        if (!arrayAccess.containsUnknown() && val != null && this.sequentialSemantics) {
            this.arrayValues.put(arrayAccess, val);
        }
    }

    protected void updateForLocalVariableAssignment(FlowExpressions.LocalVariable receiver, @Nullable V val) {
        this.removeConflicting(receiver);
        if (val != null) {
            this.localVariableValues.put(receiver, val);
        }
    }

    protected void removeConflicting(FlowExpressions.FieldAccess fieldAccess, @Nullable V val) {
        HashMap<FlowExpressions.FieldAccess, CFAbstractValue> newFieldValues = new HashMap<FlowExpressions.FieldAccess, CFAbstractValue>();
        for (Map.Entry<FlowExpressions.FieldAccess, V> e : this.fieldValues.entrySet()) {
            FlowExpressions.FieldAccess otherFieldAccess = e.getKey();
            CFAbstractValue otherVal = (CFAbstractValue)e.getValue();
            if (otherFieldAccess.getReceiver().containsModifiableAliasOf(this, fieldAccess)) continue;
            if (fieldAccess.getField().equals(otherFieldAccess.getField()) && this.canAlias(fieldAccess.getReceiver(), otherFieldAccess.getReceiver()) && !otherFieldAccess.isFinal()) {
                if (val == null) continue;
                CFAbstractValue newVal = val.leastUpperBound((CFAbstractValue)otherVal);
                newFieldValues.put(otherFieldAccess, newVal);
                continue;
            }
            newFieldValues.put(otherFieldAccess, otherVal);
        }
        this.fieldValues = newFieldValues;
        HashMap<FlowExpressions.ArrayAccess, CFAbstractValue> newArrayValues = new HashMap<FlowExpressions.ArrayAccess, CFAbstractValue>();
        for (Map.Entry<FlowExpressions.ArrayAccess, V> e : this.arrayValues.entrySet()) {
            FlowExpressions.ArrayAccess otherArrayAccess = e.getKey();
            CFAbstractValue otherVal = (CFAbstractValue)e.getValue();
            if (otherArrayAccess.containsModifiableAliasOf(this, fieldAccess)) continue;
            newArrayValues.put(otherArrayAccess, otherVal);
        }
        this.arrayValues = newArrayValues;
        this.methodValues = new HashMap<FlowExpressions.MethodCall, V>();
    }

    protected void removeConflicting(FlowExpressions.ArrayAccess arrayAccess, @Nullable V val) {
        HashMap<FlowExpressions.ArrayAccess, CFAbstractValue> newArrayValues = new HashMap<FlowExpressions.ArrayAccess, CFAbstractValue>();
        for (Map.Entry<FlowExpressions.ArrayAccess, V> e : this.arrayValues.entrySet()) {
            FlowExpressions.ArrayAccess otherArrayAccess = e.getKey();
            CFAbstractValue otherVal = (CFAbstractValue)e.getValue();
            if (otherArrayAccess.containsModifiableAliasOf(this, arrayAccess) || this.canAlias(arrayAccess.getReceiver(), otherArrayAccess.getReceiver())) continue;
            newArrayValues.put(otherArrayAccess, otherVal);
        }
        this.arrayValues = newArrayValues;
        HashMap<FlowExpressions.FieldAccess, CFAbstractValue> newFieldValues = new HashMap<FlowExpressions.FieldAccess, CFAbstractValue>();
        for (Map.Entry<FlowExpressions.FieldAccess, V> e : this.fieldValues.entrySet()) {
            FlowExpressions.FieldAccess otherFieldAccess = e.getKey();
            CFAbstractValue otherVal = (CFAbstractValue)e.getValue();
            FlowExpressions.Receiver receiver = otherFieldAccess.getReceiver();
            if (receiver.containsModifiableAliasOf(this, arrayAccess) && receiver.containsOfClass(FlowExpressions.ArrayAccess.class)) continue;
            newFieldValues.put(otherFieldAccess, otherVal);
        }
        this.fieldValues = newFieldValues;
        this.methodValues = new HashMap<FlowExpressions.MethodCall, V>();
    }

    protected void removeConflicting(FlowExpressions.LocalVariable var) {
        HashMap newFieldValues = new HashMap();
        for (Map.Entry<FlowExpressions.FieldAccess, V> e : this.fieldValues.entrySet()) {
            FlowExpressions.FieldAccess fieldAccess = e.getKey();
            if (fieldAccess.containsSyntacticEqualReceiver(var)) continue;
            newFieldValues.put(fieldAccess, e.getValue());
        }
        this.fieldValues = newFieldValues;
        HashMap newArrayValues = new HashMap();
        for (Map.Entry entry : this.arrayValues.entrySet()) {
            FlowExpressions.ArrayAccess otherArrayAccess = (FlowExpressions.ArrayAccess)entry.getKey();
            if (otherArrayAccess.containsSyntacticEqualReceiver(var)) continue;
            newArrayValues.put(otherArrayAccess, entry.getValue());
        }
        this.arrayValues = newArrayValues;
        HashMap<FlowExpressions.MethodCall, V> newMethodValues = new HashMap<FlowExpressions.MethodCall, V>();
        for (Map.Entry<FlowExpressions.MethodCall, V> e : this.methodValues.entrySet()) {
            FlowExpressions.MethodCall otherMethodAccess = e.getKey();
            if (otherMethodAccess.containsSyntacticEqualReceiver(var) || otherMethodAccess.containsSyntacticEqualParameter(var)) continue;
            newMethodValues.put(otherMethodAccess, e.getValue());
        }
        this.methodValues = newMethodValues;
    }

    @Override
    public boolean canAlias(FlowExpressions.Receiver a, FlowExpressions.Receiver b) {
        TypeMirror tb = b.getType();
        TypeMirror ta = a.getType();
        Types types = this.analysis.getTypes();
        return types.isSubtype(ta, tb) || types.isSubtype(tb, ta);
    }

    public @Nullable V getValue(LocalVariableNode n) {
        Element el = n.getElement();
        return (V)((CFAbstractValue)this.localVariableValues.get(new FlowExpressions.LocalVariable(el)));
    }

    public @Nullable V getValue(ThisLiteralNode n) {
        return this.thisValue;
    }

    @Override
    public S copy() {
        return (S)this.analysis.createCopiedStore(this);
    }

    @Override
    public S leastUpperBound(S other) {
        return this.upperBound(other, false);
    }

    @Override
    public S widenedUpperBound(S previous) {
        return this.upperBound(previous, true);
    }

    private S upperBound(S other, boolean shouldWiden) {
        CFAbstractValue mergedVal;
        FlowExpressions.Receiver el;
        Object mergedVal2;
        CFAbstractValue thisVal;
        CFAbstractValue otherVal;
        S newStore = this.analysis.createEmptyStore(this.sequentialSemantics);
        for (Map.Entry<FlowExpressions.LocalVariable, V> entry : ((CFAbstractStore)other).localVariableValues.entrySet()) {
            CFAbstractValue mergedVal22;
            FlowExpressions.LocalVariable localVar = entry.getKey();
            if (!this.localVariableValues.containsKey(localVar) || (mergedVal22 = this.upperBoundOfValues(otherVal = (CFAbstractValue)entry.getValue(), thisVal = (CFAbstractValue)this.localVariableValues.get(localVar), shouldWiden)) == null) continue;
            ((CFAbstractStore)newStore).localVariableValues.put(localVar, mergedVal22);
        }
        V otherVal2 = ((CFAbstractStore)other).thisValue;
        V v = this.thisValue;
        Object v0 = mergedVal2 = v == null ? null : this.upperBoundOfValues(otherVal2, v, shouldWiden);
        if (mergedVal2 != null) {
            ((CFAbstractStore)newStore).thisValue = mergedVal2;
        }
        for (Map.Entry<FlowExpressions.Receiver, V> entry : ((CFAbstractStore)other).fieldValues.entrySet()) {
            el = (FlowExpressions.FieldAccess)entry.getKey();
            if (!this.fieldValues.containsKey(el) || (mergedVal = this.upperBoundOfValues(otherVal = (CFAbstractValue)entry.getValue(), thisVal = (CFAbstractValue)this.fieldValues.get(el), shouldWiden)) == null) continue;
            ((CFAbstractStore)newStore).fieldValues.put((FlowExpressions.FieldAccess)el, mergedVal);
        }
        for (Map.Entry<FlowExpressions.Receiver, V> entry : ((CFAbstractStore)other).arrayValues.entrySet()) {
            el = (FlowExpressions.ArrayAccess)entry.getKey();
            if (!this.arrayValues.containsKey(el) || (mergedVal = this.upperBoundOfValues(otherVal = (CFAbstractValue)entry.getValue(), thisVal = (CFAbstractValue)this.arrayValues.get(el), shouldWiden)) == null) continue;
            ((CFAbstractStore)newStore).arrayValues.put((FlowExpressions.ArrayAccess)el, mergedVal);
        }
        for (Map.Entry<FlowExpressions.Receiver, V> entry : ((CFAbstractStore)other).methodValues.entrySet()) {
            el = (FlowExpressions.MethodCall)entry.getKey();
            if (!this.methodValues.containsKey(el) || (mergedVal = this.upperBoundOfValues(otherVal = (CFAbstractValue)entry.getValue(), thisVal = (CFAbstractValue)this.methodValues.get(el), shouldWiden)) == null) continue;
            ((CFAbstractStore)newStore).methodValues.put((FlowExpressions.MethodCall)el, mergedVal);
        }
        for (Map.Entry<FlowExpressions.Receiver, V> entry : ((CFAbstractStore)other).classValues.entrySet()) {
            el = (FlowExpressions.ClassName)entry.getKey();
            if (!this.classValues.containsKey(el) || (mergedVal = this.upperBoundOfValues(otherVal = (CFAbstractValue)entry.getValue(), thisVal = (CFAbstractValue)this.classValues.get(el), shouldWiden)) == null) continue;
            ((CFAbstractStore)newStore).classValues.put((FlowExpressions.ClassName)el, mergedVal);
        }
        return newStore;
    }

    private V upperBoundOfValues(V otherVal, V thisVal, boolean shouldWiden) {
        return shouldWiden ? ((CFAbstractValue)thisVal).widenUpperBound(otherVal) : ((CFAbstractValue)thisVal).leastUpperBound(otherVal);
    }

    protected boolean supersetOf(CFAbstractStore<V, S> other) {
        FlowExpressions.Receiver key;
        for (Map.Entry<FlowExpressions.LocalVariable, V> entry : other.localVariableValues.entrySet()) {
            key = entry.getKey();
            if (this.localVariableValues.containsKey(key) && ((CFAbstractValue)this.localVariableValues.get(key)).equals(entry.getValue())) continue;
            return false;
        }
        for (Map.Entry<FlowExpressions.Receiver, V> entry : other.fieldValues.entrySet()) {
            key = (FlowExpressions.FieldAccess)entry.getKey();
            if (this.fieldValues.containsKey(key) && ((CFAbstractValue)this.fieldValues.get(key)).equals(entry.getValue())) continue;
            return false;
        }
        for (Map.Entry<FlowExpressions.Receiver, V> entry : other.arrayValues.entrySet()) {
            key = (FlowExpressions.ArrayAccess)entry.getKey();
            if (this.arrayValues.containsKey(key) && ((CFAbstractValue)this.arrayValues.get(key)).equals(entry.getValue())) continue;
            return false;
        }
        for (Map.Entry<FlowExpressions.Receiver, V> entry : other.methodValues.entrySet()) {
            key = (FlowExpressions.MethodCall)entry.getKey();
            if (this.methodValues.containsKey(key) && ((CFAbstractValue)this.methodValues.get(key)).equals(entry.getValue())) continue;
            return false;
        }
        for (Map.Entry<FlowExpressions.Receiver, V> entry : other.classValues.entrySet()) {
            key = (FlowExpressions.ClassName)entry.getKey();
            if (this.classValues.containsKey(key) && ((CFAbstractValue)this.classValues.get(key)).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof CFAbstractStore) {
            CFAbstractStore other = (CFAbstractStore)o;
            return this.supersetOf(other) && other.supersetOf(this);
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @SideEffectFree
    public String toString() {
        return "Use a CFGVisualizer to see the Store: " + this.hashCode();
    }

    @Override
    public void visualize(CFGVisualizer<?, S, ?> viz) {
        CFGVisualizer<?, S, ?> castedViz = viz;
        castedViz.visualizeStoreHeader(this.getClass().getCanonicalName());
        this.internalVisualize(castedViz);
        castedViz.visualizeStoreFooter();
    }

    protected void internalVisualize(CFGVisualizer<V, S, ?> viz) {
        for (Map.Entry<FlowExpressions.LocalVariable, V> entry : this.localVariableValues.entrySet()) {
            viz.visualizeStoreLocalVar(entry.getKey(), (AbstractValue)entry.getValue());
        }
        if (this.thisValue != null) {
            viz.visualizeStoreThisVal(this.thisValue);
        }
        for (Map.Entry<FlowExpressions.Receiver, V> entry : this.fieldValues.entrySet()) {
            viz.visualizeStoreFieldVals((FlowExpressions.FieldAccess)entry.getKey(), (AbstractValue)entry.getValue());
        }
        for (Map.Entry<FlowExpressions.Receiver, V> entry : this.arrayValues.entrySet()) {
            viz.visualizeStoreArrayVal((FlowExpressions.ArrayAccess)entry.getKey(), (AbstractValue)entry.getValue());
        }
        for (Map.Entry<FlowExpressions.Receiver, V> entry : this.methodValues.entrySet()) {
            viz.visualizeStoreMethodVals((FlowExpressions.MethodCall)entry.getKey(), (AbstractValue)entry.getValue());
        }
        for (Map.Entry<FlowExpressions.Receiver, V> entry : this.classValues.entrySet()) {
            viz.visualizeStoreClassVals((FlowExpressions.ClassName)entry.getKey(), (AbstractValue)entry.getValue());
        }
    }
}

