/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type.poly;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Name;
import javax.lang.model.util.Elements;
import org.checkerframework.framework.qual.PolymorphicQualifier;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.poly.AbstractQualifierPolymorphism;
import org.checkerframework.framework.type.poly.QualifierPolymorphism;
import org.checkerframework.framework.util.AnnotationMirrorMap;
import org.checkerframework.framework.util.AnnotationMirrorSet;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.BugInCF;

public class DefaultQualifierPolymorphism
extends AbstractQualifierPolymorphism {
    public DefaultQualifierPolymorphism(ProcessingEnvironment env, AnnotatedTypeFactory factory) {
        super(env, factory);
        Elements elements = env.getElementUtils();
        AnnotationMirrorMap<AnnotationMirror> polys = new AnnotationMirrorMap<AnnotationMirror>();
        for (AnnotationMirror annotationMirror : this.qualhierarchy.getTypeQualifiers()) {
            AnnotationMirror ttreetop;
            if (QualifierPolymorphism.isPolyAll(annotationMirror)) {
                polys.put(annotationMirror, (AnnotationMirror)null);
                continue;
            }
            AnnotationMirrorSet topsSeen = new AnnotationMirrorSet();
            AnnotationMirror aa = QualifierPolymorphism.getPolymorphicQualifier(annotationMirror);
            if (aa == null) continue;
            Name plval = AnnotationUtils.getElementValueClassName(aa, "value", true);
            if (PolymorphicQualifier.class.getCanonicalName().contentEquals(plval)) {
                if (this.topQuals.size() != 1) {
                    throw new BugInCF("DefaultQualifierPolymorphism: PolymorphicQualifier has to specify type hierarchy, if more than one exist; top types: " + this.topQuals);
                }
                ttreetop = this.topQuals.iterator().next();
            } else {
                AnnotationMirror ttree = AnnotationBuilder.fromName(elements, plval);
                ttreetop = this.qualhierarchy.getTopAnnotation(ttree);
            }
            if (topsSeen.contains(ttreetop)) {
                throw new BugInCF("DefaultQualifierPolymorphism: checker has multiple polymorphic qualifiers: " + polys.get(ttreetop) + " and " + annotationMirror);
            }
            topsSeen.add(ttreetop);
            polys.put(annotationMirror, ttreetop);
        }
        this.polyQuals.putAll(polys);
    }

    @Override
    protected void replace(AnnotatedTypeMirror type, AnnotationMirrorMap<AnnotationMirrorSet> replacements) {
        for (Map.Entry<AnnotationMirror, AnnotationMirrorSet> pqentry : replacements.entrySet()) {
            AnnotationMirror poly = pqentry.getKey();
            if (poly == null || !type.hasAnnotation(poly)) continue;
            type.removeAnnotation(poly);
            AnnotationMirrorSet quals = pqentry.getValue();
            type.replaceAnnotations(quals);
        }
    }

    @Override
    protected AnnotationMirrorSet combine(AnnotationMirror polyQual, AnnotationMirrorSet a1Annos, AnnotationMirrorSet a2Annos) {
        if (a1Annos == null) {
            if (a2Annos == null) {
                return new AnnotationMirrorSet();
            }
            return a2Annos;
        }
        if (a2Annos == null) {
            return a1Annos;
        }
        AnnotationMirrorSet lubSet = new AnnotationMirrorSet();
        for (AnnotationMirror top : this.topQuals) {
            AnnotationMirror a2;
            AnnotationMirror a1 = this.qualhierarchy.findAnnotationInHierarchy(a1Annos, top);
            AnnotationMirror lub = this.qualhierarchy.leastUpperBoundTypeVariable(a1, a2 = this.qualhierarchy.findAnnotationInHierarchy(a2Annos, top));
            if (lub == null) continue;
            lubSet.add(lub);
        }
        return lubSet;
    }
}

