/*
 * Decompiled with CFR 0.152.
 */
package annotator;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Types;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public final class Source {
    private JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private StandardJavaFileManager fileManager;
    private JavacTask task;
    private StringBuilder source;
    private DiagnosticCollector<JavaFileObject> diagnostics;
    private String path;
    private Types types;

    public Source(String string) throws CompilerException, IOException {
        int n;
        if (this.compiler == null) {
            throw new CompilerException("could not get compiler instance");
        }
        this.diagnostics = new DiagnosticCollector();
        this.fileManager = this.compiler.getStandardFileManager(this.diagnostics, null, null);
        if (this.fileManager == null) {
            throw new CompilerException("could not get file manager");
        }
        Iterable<? extends JavaFileObject> iterable = this.fileManager.getJavaFileObjectsFromStrings(Collections.singletonList(string));
        String[] stringArray = new String[]{"-g", "-Xlint:-options"};
        List<String> list = Arrays.asList(stringArray);
        JavaCompiler.CompilationTask compilationTask = this.compiler.getTask(null, this.fileManager, this.diagnostics, list, null, iterable);
        if (!(compilationTask instanceof JavacTask)) {
            throw new CompilerException("could not get a valid JavacTask: " + compilationTask.getClass());
        }
        this.task = (JavacTask)compilationTask;
        this.types = Types.instance(((JavacTaskImpl)compilationTask).getContext());
        this.path = string;
        this.source = new StringBuilder();
        FileInputStream fileInputStream = new FileInputStream(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = fileInputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        fileInputStream.close();
        this.source.append(byteArrayOutputStream.toString());
        byteArrayOutputStream.close();
        this.fileManager.close();
    }

    public Types getTypes() {
        return this.types;
    }

    /*
     * WARNING - void declaration
     */
    public Set<CompilationUnitTree> parse() {
        try {
            HashSet<CompilationUnitTree> hashSet = new HashSet<CompilationUnitTree>();
            for (CompilationUnitTree compilationUnitTree : this.task.parse()) {
                hashSet.add(compilationUnitTree);
            }
            List<Diagnostic<JavaFileObject>> list = this.diagnostics.getDiagnostics();
            if (!this.diagnostics.getDiagnostics().isEmpty()) {
                void throwable;
                boolean n = false;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Diagnostic diagnostic = (Diagnostic)iterator.next();
                    System.err.println(diagnostic);
                    if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                    ++throwable;
                }
                if (throwable > 0) {
                    System.err.println((int)throwable + " error" + (throwable != true ? "s" : ""));
                    System.err.println("WARNING: Error processing input source files. Please fix and try again.");
                    System.exit(1);
                }
            }
            try {
                this.task.analyze();
            }
            catch (Throwable throwable) {
                System.err.println("WARNING: " + this.path + ": type analysis failed; skipping");
                System.err.println("(incomplete CLASSPATH?)");
                return Collections.emptySet();
            }
            return hashSet;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error(iOException);
        }
    }

    public void insert(int n, String string) {
        this.source.insert(n, string);
    }

    public char charAt(int n) {
        return this.source.charAt(n);
    }

    public String substring(int n, int n2) {
        return this.source.substring(n, n2);
    }

    public String getString() {
        return this.source.toString();
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.source.toString().getBytes());
        outputStream.flush();
        outputStream.close();
    }

    public static class CompilerException
    extends Exception {
        private static final long serialVersionUID = -4751611137146719789L;

        public CompilerException(String string) {
            super(string);
        }
    }
}

