/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.Main;
import annotator.find.Criterion;
import annotator.find.Insertions;
import annotator.find.TreeFinder;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import scenelib.annotations.io.ASTPath;

public class ASTPathCriterion
implements Criterion {
    public static boolean debug = Main.debug;
    ASTPath astPath;

    public ASTPathCriterion(ASTPath aSTPath) {
        this.astPath = aSTPath;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        int n;
        Tree tree;
        int n2;
        ArrayList<Tree> arrayList;
        block15: {
            Object object;
            if (treePath == null) {
                return false;
            }
            arrayList = new ArrayList<Tree>();
            Tree tree2 = treePath.getLeaf();
            Tree.Kind kind = tree2.getKind();
            while (kind != Tree.Kind.METHOD && !ASTPath.isClassEquiv(kind)) {
                arrayList.add(0, tree2);
                treePath = treePath.getParentPath();
                if (treePath == null) break;
                tree2 = treePath.getLeaf();
                kind = tree2.getKind();
            }
            if (treePath != null && !this.astPath.isEmpty() && ((object = ((ASTPath.ASTEntry)this.astPath.get(0)).getTreeKind()) == Tree.Kind.METHOD && kind == Tree.Kind.METHOD || object == Tree.Kind.CLASS && ASTPath.isClassEquiv(kind))) {
                arrayList.add(0, tree2);
            }
            if (debug) {
                System.out.println("ASTPathCriterion.isSatisfiedBy");
                System.out.println("  " + this.astPath);
                for (Tree tree3 : arrayList) {
                    System.out.println("  " + (Object)((Object)tree3.getKind()) + ": " + tree3.toString().replace('\n', ' '));
                }
            }
            int n3 = this.astPath.size();
            n2 = arrayList.size();
            if (n3 == 0 || n2 == 0) {
                return false;
            }
            tree = null;
            n = 0;
            do {
                ASTPath.ASTEntry aSTEntry = (ASTPath.ASTEntry)this.astPath.get(n);
                Tree tree4 = (Tree)arrayList.get(n);
                if (!this.kindsMatch(aSTEntry.getTreeKind(), tree4.getKind())) {
                    return this.isBoundableWildcard(arrayList, n);
                }
                if (debug) {
                    System.out.println("astNode: " + aSTEntry);
                    System.out.println("actualNode: " + (Object)((Object)tree4.getKind()));
                }
                if ((tree = this.getNext(tree4, this.astPath, n)) == null) {
                    return this.checkNull(arrayList, n);
                }
                if (!(tree instanceof JCTree) && n2 == n + 1) {
                    arrayList.add(tree);
                    ++n2;
                }
                if (debug) {
                    System.out.println("next: " + tree);
                }
                if (++n >= n3) break block15;
                if (n < n2) continue;
                return this.checkNull(arrayList, n - 1);
            } while (this.matchNext(tree, (Tree)arrayList.get(n)));
            if (debug) {
                System.out.println("no next match");
            }
            return false;
        }
        if (n < n2 && this.matchNext(tree, (Tree)arrayList.get(n)) || n <= n2 && tree.getKind() == Tree.Kind.NEW_ARRAY) {
            return true;
        }
        if (debug) {
            System.out.println("no next match");
        }
        return false;
    }

    private boolean matchNext(Tree tree, Tree tree2) {
        boolean bl = tree instanceof JCTree;
        boolean bl2 = tree2 instanceof JCTree;
        if (bl && !bl2) {
            tree = Insertions.TypeTree.fromJCTree((JCTree)tree);
        } else if (bl2 && !bl) {
            tree2 = Insertions.TypeTree.fromJCTree((JCTree)tree2);
        }
        try {
            return tree.accept(new SimpleTreeVisitor<Boolean, Tree>(){

                @Override
                public Boolean defaultAction(Tree tree, Tree tree2) {
                    return tree == tree2;
                }

                @Override
                public Boolean visitIdentifier(IdentifierTree identifierTree, Tree tree) {
                    return identifierTree == tree;
                }

                @Override
                public Boolean visitAnnotatedType(AnnotatedTypeTree annotatedTypeTree, Tree tree) {
                    AnnotatedTypeTree annotatedTypeTree2 = (AnnotatedTypeTree)tree;
                    return ASTPathCriterion.this.matchNext(annotatedTypeTree.getUnderlyingType(), annotatedTypeTree2.getUnderlyingType());
                }

                @Override
                public Boolean visitMemberSelect(MemberSelectTree memberSelectTree, Tree tree) {
                    MemberSelectTree memberSelectTree2 = (MemberSelectTree)tree;
                    return memberSelectTree.getIdentifier().toString().equals(memberSelectTree2.getIdentifier().toString()) && ASTPathCriterion.this.matchNext(memberSelectTree.getExpression(), memberSelectTree2.getExpression());
                }

                @Override
                public Boolean visitWildcard(WildcardTree wildcardTree, Tree tree) {
                    return wildcardTree == (WildcardTree)tree;
                }

                @Override
                public Boolean visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, Tree tree) {
                    ParameterizedTypeTree parameterizedTypeTree2 = (ParameterizedTypeTree)tree;
                    java.util.List<? extends Tree> list = parameterizedTypeTree2.getTypeArguments();
                    java.util.List<? extends Tree> list2 = parameterizedTypeTree.getTypeArguments();
                    if (list2.size() == list.size()) {
                        int n = 0;
                        for (Tree tree2 : list2) {
                            Tree tree3;
                            if (ASTPathCriterion.this.matchNext(tree2, tree3 = list.get(n++))) continue;
                            return false;
                        }
                        return ASTPathCriterion.this.matchNext(parameterizedTypeTree.getType(), parameterizedTypeTree2.getType());
                    }
                    return false;
                }
            }, tree2);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    private Tree getNext(Tree tree, ASTPath aSTPath, int n) {
        try {
            ASTPath.ASTEntry aSTEntry = (ASTPath.ASTEntry)aSTPath.get(n);
            switch (tree.getKind()) {
                case ANNOTATED_TYPE: {
                    AnnotatedTypeTree annotatedTypeTree = (AnnotatedTypeTree)tree;
                    if (aSTEntry.childSelectorIs("annotation")) {
                        java.util.List<? extends AnnotationTree> list;
                        int n2 = aSTEntry.getArgument();
                        if (n2 >= (list = annotatedTypeTree.getAnnotations()).size()) {
                            return null;
                        }
                        return list.get(n2);
                    }
                    return annotatedTypeTree.getUnderlyingType();
                }
                case ARRAY_ACCESS: {
                    ArrayAccessTree arrayAccessTree = (ArrayAccessTree)tree;
                    if (aSTEntry.childSelectorIs("expression")) {
                        return arrayAccessTree.getExpression();
                    }
                    return arrayAccessTree.getIndex();
                }
                case ARRAY_TYPE: {
                    ArrayTypeTree arrayTypeTree = (ArrayTypeTree)tree;
                    return arrayTypeTree.getType();
                }
                case ASSERT: {
                    AssertTree assertTree = (AssertTree)tree;
                    if (aSTEntry.childSelectorIs("condition")) {
                        return assertTree.getCondition();
                    }
                    return assertTree.getDetail();
                }
                case ASSIGNMENT: {
                    AssignmentTree assignmentTree = (AssignmentTree)tree;
                    if (aSTEntry.childSelectorIs("variable")) {
                        return assignmentTree.getVariable();
                    }
                    return assignmentTree.getExpression();
                }
                case BLOCK: {
                    BlockTree blockTree = (BlockTree)tree;
                    int n3 = aSTEntry.getArgument();
                    java.util.List<? extends StatementTree> list = blockTree.getStatements();
                    if (n3 >= blockTree.getStatements().size()) {
                        return null;
                    }
                    return list.get(n3);
                }
                case CASE: {
                    java.util.List<? extends StatementTree> list;
                    CaseTree caseTree = (CaseTree)tree;
                    if (aSTEntry.childSelectorIs("expression")) {
                        return caseTree.getExpression();
                    }
                    int n4 = aSTEntry.getArgument();
                    if (n4 >= (list = caseTree.getStatements()).size()) {
                        return null;
                    }
                    return list.get(n4);
                }
                case CATCH: {
                    CatchTree catchTree = (CatchTree)tree;
                    if (aSTEntry.childSelectorIs("parameter")) {
                        return catchTree.getParameter();
                    }
                    return catchTree.getBlock();
                }
                case ANNOTATION: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    ClassTree classTree = (ClassTree)tree;
                    int n5 = aSTEntry.getArgument();
                    if (aSTEntry.childSelectorIs("typeParameter")) {
                        return classTree.getTypeParameters().get(n5);
                    }
                    if (aSTEntry.childSelectorIs("initializer")) {
                        int n6 = 0;
                        for (Tree tree2 : classTree.getMembers()) {
                            if (tree2.getKind() != Tree.Kind.BLOCK || n5 != n6++) continue;
                            return tree2;
                        }
                        return null;
                    }
                    if (aSTEntry.childSelectorIs("bound")) {
                        return n5 < 0 ? classTree.getExtendsClause() : classTree.getImplementsClause().get(n5);
                    }
                    return null;
                }
                case CONDITIONAL_EXPRESSION: {
                    ConditionalExpressionTree conditionalExpressionTree = (ConditionalExpressionTree)tree;
                    if (aSTEntry.childSelectorIs("condition")) {
                        return conditionalExpressionTree.getCondition();
                    }
                    if (aSTEntry.childSelectorIs("trueExpression")) {
                        return conditionalExpressionTree.getTrueExpression();
                    }
                    return conditionalExpressionTree.getFalseExpression();
                }
                case DO_WHILE_LOOP: {
                    DoWhileLoopTree doWhileLoopTree = (DoWhileLoopTree)tree;
                    if (aSTEntry.childSelectorIs("condition")) {
                        return doWhileLoopTree.getCondition();
                    }
                    return doWhileLoopTree.getStatement();
                }
                case ENHANCED_FOR_LOOP: {
                    EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)tree;
                    if (aSTEntry.childSelectorIs("variable")) {
                        return enhancedForLoopTree.getVariable();
                    }
                    if (aSTEntry.childSelectorIs("expression")) {
                        return enhancedForLoopTree.getExpression();
                    }
                    return enhancedForLoopTree.getStatement();
                }
                case EXPRESSION_STATEMENT: {
                    ExpressionStatementTree expressionStatementTree = (ExpressionStatementTree)tree;
                    return expressionStatementTree.getExpression();
                }
                case FOR_LOOP: {
                    ForLoopTree forLoopTree = (ForLoopTree)tree;
                    if (aSTEntry.childSelectorIs("initializer")) {
                        java.util.List<? extends StatementTree> list;
                        int n7 = aSTEntry.getArgument();
                        if (n7 >= (list = forLoopTree.getInitializer()).size()) {
                            return null;
                        }
                        return list.get(n7);
                    }
                    if (aSTEntry.childSelectorIs("condition")) {
                        return forLoopTree.getCondition();
                    }
                    if (aSTEntry.childSelectorIs("update")) {
                        java.util.List<? extends ExpressionStatementTree> list;
                        int n8 = aSTEntry.getArgument();
                        if (n8 >= (list = forLoopTree.getUpdate()).size()) {
                            return null;
                        }
                        return list.get(n8);
                    }
                    return forLoopTree.getStatement();
                }
                case IF: {
                    IfTree ifTree = (IfTree)tree;
                    if (aSTEntry.childSelectorIs("condition")) {
                        return ifTree.getCondition();
                    }
                    if (aSTEntry.childSelectorIs("thenStatement")) {
                        return ifTree.getThenStatement();
                    }
                    return ifTree.getElseStatement();
                }
                case INSTANCE_OF: {
                    InstanceOfTree instanceOfTree = (InstanceOfTree)tree;
                    if (aSTEntry.childSelectorIs("expression")) {
                        return instanceOfTree.getExpression();
                    }
                    return instanceOfTree.getType();
                }
                case LABELED_STATEMENT: {
                    LabeledStatementTree labeledStatementTree = (LabeledStatementTree)tree;
                    return labeledStatementTree.getStatement();
                }
                case LAMBDA_EXPRESSION: {
                    LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)tree;
                    if (aSTEntry.childSelectorIs("parameter")) {
                        java.util.List<? extends VariableTree> list;
                        int n9 = aSTEntry.getArgument();
                        if (n9 >= (list = lambdaExpressionTree.getParameters()).size()) {
                            return null;
                        }
                        return list.get(n9);
                    }
                    return lambdaExpressionTree.getBody();
                }
                case MEMBER_REFERENCE: {
                    java.util.List<? extends ExpressionTree> list;
                    MemberReferenceTree memberReferenceTree = (MemberReferenceTree)tree;
                    if (aSTEntry.childSelectorIs("qualifierExpression")) {
                        return memberReferenceTree.getQualifierExpression();
                    }
                    int n10 = aSTEntry.getArgument();
                    if (n10 >= (list = memberReferenceTree.getTypeArguments()).size()) {
                        return null;
                    }
                    return list.get(n10);
                }
                case MEMBER_SELECT: {
                    MemberSelectTree memberSelectTree = (MemberSelectTree)tree;
                    return memberSelectTree.getExpression();
                }
                case METHOD: {
                    MethodTree methodTree = (MethodTree)tree;
                    if (aSTEntry.childSelectorIs("type")) {
                        return methodTree.getReturnType();
                    }
                    if (aSTEntry.childSelectorIs("parameter")) {
                        int n11 = aSTEntry.getArgument();
                        java.util.List<? extends VariableTree> list = methodTree.getParameters();
                        return n11 < 0 ? methodTree.getReceiverParameter() : (n11 < list.size() ? (Tree)list.get(n11) : null);
                    }
                    if (aSTEntry.childSelectorIs("typeParameter")) {
                        int n12 = aSTEntry.getArgument();
                        return methodTree.getTypeParameters().get(n12);
                    }
                    return methodTree.getBody();
                }
                case METHOD_INVOCATION: {
                    java.util.List<? extends ExpressionTree> list;
                    MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                    if (aSTEntry.childSelectorIs("typeArgument")) {
                        java.util.List<? extends Tree> list2;
                        int n13 = aSTEntry.getArgument();
                        if (n13 >= (list2 = methodInvocationTree.getTypeArguments()).size()) {
                            return null;
                        }
                        return list2.get(n13);
                    }
                    if (aSTEntry.childSelectorIs("methodSelect")) {
                        return methodInvocationTree.getMethodSelect();
                    }
                    int n14 = aSTEntry.getArgument();
                    if (n14 >= (list = methodInvocationTree.getArguments()).size()) {
                        return null;
                    }
                    return list.get(n14);
                }
                case NEW_ARRAY: {
                    java.util.List<? extends ExpressionTree> list;
                    NewArrayTree newArrayTree = (NewArrayTree)tree;
                    if (aSTEntry.childSelectorIs("type")) {
                        Type type = ((JCTree.JCNewArray)newArrayTree).type;
                        Tree tree3 = Insertions.TypeTree.fromJavacType(type);
                        int n15 = aSTEntry.getArgument();
                        if (n15 == 0 && aSTPath.size() == n + 1) {
                            return newArrayTree;
                        }
                        tree3 = ((NewArrayTree)tree3).getType();
                        while (--n15 > 0) {
                            if (tree3.getKind() != Tree.Kind.ARRAY_TYPE) {
                                return null;
                            }
                            tree3 = ((ArrayTypeTree)tree3).getType();
                        }
                        return tree3;
                    }
                    if (aSTEntry.childSelectorIs("dimension")) {
                        java.util.List<? extends ExpressionTree> list3;
                        int n16 = aSTEntry.getArgument();
                        return n16 < (list3 = newArrayTree.getDimensions()).size() ? (Tree)list3.get(n16) : null;
                    }
                    int n17 = aSTEntry.getArgument();
                    return n17 < (list = newArrayTree.getInitializers()).size() ? (Tree)list.get(n17) : null;
                }
                case NEW_CLASS: {
                    NewClassTree newClassTree = (NewClassTree)tree;
                    if (aSTEntry.childSelectorIs("enclosingExpression")) {
                        return newClassTree.getEnclosingExpression();
                    }
                    if (aSTEntry.childSelectorIs("typeArgument")) {
                        java.util.List<? extends Tree> list;
                        int n18 = aSTEntry.getArgument();
                        if (n18 >= (list = newClassTree.getTypeArguments()).size()) {
                            return null;
                        }
                        return list.get(n18);
                    }
                    if (aSTEntry.childSelectorIs("identifier")) {
                        return newClassTree.getIdentifier();
                    }
                    if (aSTEntry.childSelectorIs("argument")) {
                        java.util.List<? extends ExpressionTree> list;
                        int n19 = aSTEntry.getArgument();
                        if (n19 >= (list = newClassTree.getArguments()).size()) {
                            return null;
                        }
                        return list.get(n19);
                    }
                    return newClassTree.getClassBody();
                }
                case PARAMETERIZED_TYPE: {
                    java.util.List<? extends Tree> list;
                    ParameterizedTypeTree parameterizedTypeTree = (ParameterizedTypeTree)tree;
                    if (aSTEntry.childSelectorIs("type")) {
                        return parameterizedTypeTree.getType();
                    }
                    int n20 = aSTEntry.getArgument();
                    if (n20 >= (list = parameterizedTypeTree.getTypeArguments()).size()) {
                        return null;
                    }
                    return list.get(n20);
                }
                case PARENTHESIZED: {
                    ParenthesizedTree parenthesizedTree = (ParenthesizedTree)tree;
                    return parenthesizedTree.getExpression();
                }
                case RETURN: {
                    ReturnTree returnTree = (ReturnTree)tree;
                    return returnTree.getExpression();
                }
                case SWITCH: {
                    java.util.List<? extends CaseTree> list;
                    SwitchTree switchTree = (SwitchTree)tree;
                    if (aSTEntry.childSelectorIs("expression")) {
                        return switchTree.getExpression();
                    }
                    int n21 = aSTEntry.getArgument();
                    if (n21 >= (list = switchTree.getCases()).size()) {
                        return null;
                    }
                    return list.get(n21);
                }
                case SYNCHRONIZED: {
                    SynchronizedTree synchronizedTree = (SynchronizedTree)tree;
                    if (aSTEntry.childSelectorIs("expression")) {
                        return synchronizedTree.getExpression();
                    }
                    return synchronizedTree.getBlock();
                }
                case THROW: {
                    ThrowTree throwTree = (ThrowTree)tree;
                    return throwTree.getExpression();
                }
                case TRY: {
                    java.util.List<? extends Tree> list;
                    TryTree tryTree = (TryTree)tree;
                    if (aSTEntry.childSelectorIs("block")) {
                        return tryTree.getBlock();
                    }
                    if (aSTEntry.childSelectorIs("catch")) {
                        java.util.List<? extends CatchTree> list4;
                        int n22 = aSTEntry.getArgument();
                        if (n22 >= (list4 = tryTree.getCatches()).size()) {
                            return null;
                        }
                        return list4.get(n22);
                    }
                    if (aSTEntry.childSelectorIs("finallyBlock")) {
                        return tryTree.getFinallyBlock();
                    }
                    int n23 = aSTEntry.getArgument();
                    if (n23 >= (list = tryTree.getResources()).size()) {
                        return null;
                    }
                    return list.get(n23);
                }
                case TYPE_CAST: {
                    TypeCastTree typeCastTree = (TypeCastTree)tree;
                    if (aSTEntry.childSelectorIs("type")) {
                        return typeCastTree.getType();
                    }
                    return typeCastTree.getExpression();
                }
                case TYPE_PARAMETER: {
                    TypeParameterTree typeParameterTree = (TypeParameterTree)tree;
                    java.util.List<? extends Tree> list = typeParameterTree.getBounds();
                    int n24 = aSTEntry.getArgument();
                    return list.get(n24);
                }
                case UNION_TYPE: {
                    UnionTypeTree unionTypeTree = (UnionTypeTree)tree;
                    int n25 = aSTEntry.getArgument();
                    java.util.List<? extends Tree> list = unionTypeTree.getTypeAlternatives();
                    if (n25 >= list.size()) {
                        return null;
                    }
                    return list.get(n25);
                }
                case VARIABLE: {
                    VariableTree variableTree = (VariableTree)tree;
                    if (aSTEntry.childSelectorIs("initializer")) {
                        return variableTree.getInitializer();
                    }
                    if (aSTEntry.childSelectorIs("type")) {
                        return variableTree.getType();
                    }
                    return null;
                }
                case WHILE_LOOP: {
                    WhileLoopTree whileLoopTree = (WhileLoopTree)tree;
                    if (aSTEntry.childSelectorIs("condition")) {
                        return whileLoopTree.getCondition();
                    }
                    return whileLoopTree.getStatement();
                }
            }
            if (ASTPath.isBinaryOperator(tree.getKind())) {
                BinaryTree binaryTree = (BinaryTree)tree;
                if (aSTEntry.childSelectorIs("leftOperand")) {
                    return binaryTree.getLeftOperand();
                }
                return binaryTree.getRightOperand();
            }
            if (ASTPath.isCompoundAssignment(tree.getKind())) {
                CompoundAssignmentTree compoundAssignmentTree = (CompoundAssignmentTree)tree;
                if (aSTEntry.childSelectorIs("variable")) {
                    return compoundAssignmentTree.getVariable();
                }
                return compoundAssignmentTree.getExpression();
            }
            if (ASTPath.isUnaryOperator(tree.getKind())) {
                UnaryTree unaryTree = (UnaryTree)tree;
                return unaryTree.getExpression();
            }
            if (this.isWildcard(tree.getKind())) {
                WildcardTree wildcardTree = (WildcardTree)tree;
                return wildcardTree.getBound();
            }
            throw new IllegalArgumentException("Illegal kind: " + (Object)((Object)tree.getKind()));
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private boolean checkNull(java.util.List<Tree> list, int n) {
        Tree tree = list.get(list.size() - 1);
        int n2 = this.astPath.size() - 1;
        ASTPath.ASTEntry aSTEntry = (ASTPath.ASTEntry)this.astPath.get(n);
        Tree.Kind kind = aSTEntry.getTreeKind();
        switch (kind) {
            case CLASS: {
                return ASTPath.isClassEquiv(kind) && n == n2 && aSTEntry.getArgument() == -1 && aSTEntry.childSelectorIs("bound");
            }
            case TYPE_PARAMETER: {
                return tree.getKind() == Tree.Kind.TYPE_PARAMETER && n == n2 && aSTEntry.getArgument() == 0 && aSTEntry.childSelectorIs("bound");
            }
            case METHOD: {
                if (tree.getKind() != Tree.Kind.METHOD) {
                    return false;
                }
                MethodTree methodTree = (MethodTree)tree;
                java.util.List<? extends VariableTree> list2 = methodTree.getParameters();
                if ("<init>".equals(methodTree.getName().toString())) {
                    ASTPath.ASTEntry aSTEntry2;
                    String string;
                    if (n == n2) {
                        return true;
                    }
                    Tree tree2 = "typeParameter".equals(string = (aSTEntry2 = (ASTPath.ASTEntry)this.astPath.get(++n)).getChildSelector()) ? (Tree)methodTree.getTypeParameters().get(aSTEntry2.getArgument()) : ("parameter".equals(string) ? list2.get(aSTEntry2.getArgument()).getType() : null);
                    return tree2 != null && this.checkTypePath(n, tree2);
                }
                if (aSTEntry.childSelectorIs("parameter") && aSTEntry.getArgument() == -1) {
                    if (n == n2) {
                        return true;
                    }
                    VariableTree variableTree = methodTree.getReceiverParameter();
                    if (variableTree != null) {
                        return this.checkTypePath(n + 1, variableTree.getType());
                    }
                }
                return false;
            }
            case NEW_ARRAY: {
                if (tree.getKind() != Tree.Kind.NEW_ARRAY) {
                    return false;
                }
                NewArrayTree newArrayTree = (NewArrayTree)tree;
                int n3 = aSTEntry.getArgument();
                if (aSTEntry.childSelectorIs("type")) {
                    if (n == n2) {
                        return true;
                    }
                    return n3 == ASTPathCriterion.arrayDepth(newArrayTree);
                }
                java.util.List<? extends ExpressionTree> list3 = aSTEntry.childSelectorIs("dimension") ? newArrayTree.getDimensions() : (aSTEntry.childSelectorIs("initializer") ? newArrayTree.getInitializers() : null);
                return list3 != null && n3 < list3.size() && this.checkTypePath(n + 1, list3.get(n3));
            }
            case UNBOUNDED_WILDCARD: {
                return this.isBoundableWildcard(list, list.size() - 1);
            }
        }
        return false;
    }

    private static int arrayDepth(Tree tree) {
        if (tree.getKind() == Tree.Kind.NEW_ARRAY) {
            NewArrayTree newArrayTree = (NewArrayTree)tree;
            Tree tree2 = newArrayTree.getType();
            if (tree2 != null) {
                return tree2.accept(new SimpleTreeVisitor<Integer, Integer>(){

                    @Override
                    public Integer visitArrayType(ArrayTypeTree arrayTypeTree, Integer n) {
                        return arrayTypeTree.getType().accept(this, n + 1);
                    }

                    @Override
                    public Integer defaultAction(Tree tree, Integer n) {
                        return n;
                    }
                }, 1);
            }
            int n = newArrayTree.getDimensions().size();
            for (ExpressionTree expressionTree : newArrayTree.getInitializers()) {
                Tree.Kind kind = expressionTree.getKind();
                if (kind != Tree.Kind.NEW_ARRAY && kind != Tree.Kind.ARRAY_TYPE) continue;
                n = Math.max(n, ASTPathCriterion.arrayDepth(expressionTree) + 1);
            }
            return n;
        }
        if (tree.getKind() == Tree.Kind.ANNOTATED_TYPE) {
            return ASTPathCriterion.arrayDepth(((AnnotatedTypeTree)tree).getUnderlyingType());
        }
        if (tree.getKind() == Tree.Kind.ARRAY_TYPE) {
            return 1 + ASTPathCriterion.arrayDepth(((ArrayTypeTree)tree).getType());
        }
        return 0;
    }

    private boolean checkReceiverType(int n, Type type) {
        if (type == null) {
            return false;
        }
        while (++n < this.astPath.size()) {
            ASTPath.ASTEntry aSTEntry = (ASTPath.ASTEntry)this.astPath.get(n);
            switch (aSTEntry.getTreeKind()) {
                case ANNOTATED_TYPE: {
                    break;
                }
                case ARRAY_TYPE: {
                    if (type.getKind() != TypeKind.ARRAY) {
                        return false;
                    }
                    type = ((Type.ArrayType)type).getComponentType();
                    break;
                }
                case MEMBER_SELECT: {
                    break;
                }
                case PARAMETERIZED_TYPE: {
                    if (!aSTEntry.childSelectorIs("typeParameter")) break;
                    if (!type.isParameterized()) {
                        return false;
                    }
                    List<Type> list = type.getTypeArguments();
                    int n2 = aSTEntry.getArgument();
                    if (n2 >= list.size()) {
                        return false;
                    }
                    type = (Type)list.get(n2);
                    break;
                }
                case TYPE_PARAMETER: {
                    if (type.getKind() != TypeKind.WILDCARD) {
                        return false;
                    }
                    type = type.getLowerBound();
                    break;
                }
                case EXTENDS_WILDCARD: {
                    if (type.getKind() != TypeKind.WILDCARD) {
                        return false;
                    }
                    type = ((Type.WildcardType)type).getExtendsBound();
                    break;
                }
                case SUPER_WILDCARD: {
                    if (type.getKind() != TypeKind.WILDCARD) {
                        return false;
                    }
                    type = ((Type.WildcardType)type).getSuperBound();
                    break;
                }
                case UNBOUNDED_WILDCARD: {
                    if (type.getKind() != TypeKind.WILDCARD) {
                        return false;
                    }
                    type = type.getLowerBound();
                    break;
                }
                default: {
                    return false;
                }
            }
            if (type != null) continue;
            return false;
        }
        return true;
    }

    private static ClassTree methodReceiverType(TreePath treePath) {
        boolean bl;
        Tree tree = treePath.getLeaf();
        if (tree.getKind() != Tree.Kind.METHOD) {
            return null;
        }
        JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)tree;
        if ((jCMethodDecl.mods.flags & 8L) != 0L) {
            return null;
        }
        TreePath treePath2 = treePath.getParentPath();
        Tree tree2 = treePath2.getLeaf();
        Tree.Kind kind = tree2.getKind();
        boolean bl2 = bl = jCMethodDecl.getReturnType() == null;
        while (kind != Tree.Kind.COMPILATION_UNIT && kind != Tree.Kind.NEW_CLASS) {
            if (kind == Tree.Kind.CLASS || kind == Tree.Kind.INTERFACE || kind == Tree.Kind.ENUM || kind == Tree.Kind.ANNOTATION_TYPE) {
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)tree2;
                boolean bl3 = kind == Tree.Kind.INTERFACE || kind == Tree.Kind.ENUM || jCClassDecl.getModifiers().getFlags().contains((Object)Modifier.STATIC);
                if (!(bl &= !bl3) || bl3) {
                    return jCClassDecl;
                }
                bl = false;
            }
            treePath2 = treePath.getParentPath();
            tree2 = treePath2.getLeaf();
            kind = tree2.getKind();
        }
        throw new IllegalArgumentException("no receiver for non-inner constructor");
    }

    private boolean checkTypePath(int n, Tree tree) {
        block11: {
            try {
                block8: while (tree != null && n < this.astPath.size()) {
                    ASTPath.ASTEntry aSTEntry = (ASTPath.ASTEntry)this.astPath.get(n);
                    Tree.Kind kind = aSTEntry.getTreeKind();
                    switch (kind) {
                        case ANNOTATED_TYPE: {
                            tree = ((AnnotatedTypeTree)tree).getUnderlyingType();
                            continue block8;
                        }
                        case ARRAY_TYPE: {
                            tree = ((ArrayTypeTree)tree).getType();
                            break;
                        }
                        case MEMBER_SELECT: {
                            tree = ((MemberSelectTree)tree).getExpression();
                            break;
                        }
                        case PARAMETERIZED_TYPE: {
                            if (aSTEntry.childSelectorIs("typeArgument")) {
                                int n2 = aSTEntry.getArgument();
                                tree = ((ParameterizedTypeTree)tree).getTypeArguments().get(n2);
                                break;
                            }
                            tree = ((ParameterizedTypeTree)tree).getType();
                            break;
                        }
                        default: {
                            if (this.isWildcard(kind)) {
                                return ++n == this.astPath.size();
                            }
                            break block11;
                        }
                    }
                    ++n;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean kindsMatch(Tree.Kind kind, Tree.Kind kind2) {
        return kind == kind2 ? true : (ASTPath.isClassEquiv(kind) ? ASTPath.isClassEquiv(kind2) : (ASTPath.isCompoundAssignment(kind) ? ASTPath.isCompoundAssignment(kind2) : (ASTPath.isUnaryOperator(kind) ? ASTPath.isUnaryOperator(kind2) : (ASTPath.isBinaryOperator(kind) ? ASTPath.isBinaryOperator(kind2) : (ASTPath.isWildcard(kind) ? ASTPath.isWildcard(kind2) : false)))));
    }

    public boolean isBinaryOperator(Tree.Kind kind) {
        return kind == Tree.Kind.MULTIPLY || kind == Tree.Kind.DIVIDE || kind == Tree.Kind.REMAINDER || kind == Tree.Kind.PLUS || kind == Tree.Kind.MINUS || kind == Tree.Kind.LEFT_SHIFT || kind == Tree.Kind.RIGHT_SHIFT || kind == Tree.Kind.UNSIGNED_RIGHT_SHIFT || kind == Tree.Kind.LESS_THAN || kind == Tree.Kind.GREATER_THAN || kind == Tree.Kind.LESS_THAN_EQUAL || kind == Tree.Kind.GREATER_THAN_EQUAL || kind == Tree.Kind.EQUAL_TO || kind == Tree.Kind.NOT_EQUAL_TO || kind == Tree.Kind.AND || kind == Tree.Kind.XOR || kind == Tree.Kind.OR || kind == Tree.Kind.CONDITIONAL_AND || kind == Tree.Kind.CONDITIONAL_OR;
    }

    public boolean isExpression(Tree.Kind kind) {
        switch (kind) {
            case ARRAY_ACCESS: 
            case ASSIGNMENT: 
            case CONDITIONAL_EXPRESSION: 
            case EXPRESSION_STATEMENT: 
            case INSTANCE_OF: 
            case LAMBDA_EXPRESSION: 
            case MEMBER_REFERENCE: 
            case MEMBER_SELECT: 
            case METHOD_INVOCATION: 
            case NEW_ARRAY: 
            case NEW_CLASS: 
            case PARENTHESIZED: 
            case TYPE_CAST: 
            case IDENTIFIER: 
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case UNARY_PLUS: 
            case UNARY_MINUS: 
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: 
            case MULTIPLY: 
            case DIVIDE: 
            case REMAINDER: 
            case PLUS: 
            case MINUS: 
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN_EQUAL: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case AND: 
            case XOR: 
            case OR: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: 
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: 
            case MINUS_ASSIGNMENT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
            case AND_ASSIGNMENT: 
            case XOR_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: 
            case NULL_LITERAL: {
                return true;
            }
        }
        return false;
    }

    private boolean isWildcard(Tree.Kind kind) {
        return kind == Tree.Kind.UNBOUNDED_WILDCARD || kind == Tree.Kind.EXTENDS_WILDCARD || kind == Tree.Kind.SUPER_WILDCARD;
    }

    private boolean isBoundableWildcard(java.util.List<Tree> list, int n) {
        if (n <= 0) {
            return false;
        }
        Tree tree = list.get(n);
        if (tree.getKind() == Tree.Kind.UNBOUNDED_WILDCARD) {
            Tree tree2 = list.get(n - 1);
            if (tree2.getKind() == Tree.Kind.INSTANCE_OF) {
                TreeFinder.warn.debug("WARNING: wildcard bounds not allowed in 'instanceof' expression; skipping insertion%n", new Object[0]);
                return false;
            }
            if (n > 1 && tree2.getKind() == Tree.Kind.PARAMETERIZED_TYPE && (tree2 = list.get(n - 2)).getKind() == Tree.Kind.ARRAY_TYPE) {
                TreeFinder.warn.debug("WARNING: wildcard bounds not allowed in 'instanceof' expression; skipping insertion%n", new Object[0]);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.AST_PATH;
    }

    public String toString() {
        return "ASTPathCriterion: " + this.astPath;
    }
}

