/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import annotator.scanner.MethodCallScanner;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import scenelib.annotations.el.RelativeLocation;

public class CallCriterion
implements Criterion {
    private final String methodName;
    private final RelativeLocation loc;

    public CallCriterion(String string, RelativeLocation relativeLocation) {
        this.methodName = string;
        this.loc = relativeLocation;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Tree tree = treePath.getLeaf();
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            int n;
            int n2 = MethodCallScanner.indexOfMethodCallTree(treePath, tree);
            boolean bl = this.loc.isBytecodeOffset() ? n2 == (n = MethodCallScanner.getMethodCallIndex(this.methodName, this.loc.offset).intValue()) : n2 == this.loc.index;
            return bl;
        }
        boolean bl = this.isSatisfiedBy(treePath.getParentPath());
        return bl;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.METHOD_CALL;
    }

    public String toString() {
        return "CallCriterion: in method: " + this.methodName + " location: " + this.loc;
    }
}

