/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criteria;
import annotator.find.Insertion;
import annotator.find.ReceiverInsertion;
import annotator.find.TypedInsertion;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import scenelib.type.Type;

public class ConstructorInsertion
extends TypedInsertion {
    private ReceiverInsertion receiverInsertion = null;
    private Set<Insertion> declarationInsertions = new LinkedHashSet<Insertion>();

    public ConstructorInsertion(Type type, Criteria criteria, List<Insertion> list) {
        super(type, criteria, true, list);
    }

    @Override
    protected String getText(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.annotationsOnly) {
            return "";
        }
        boolean bl3 = bl && this.getBaseType().getName().isEmpty();
        String string = this.typeToString(this.type, bl3, true);
        int n = string.lastIndexOf(36);
        string = string.substring(n + 1);
        for (Insertion insertion : this.declarationInsertions) {
            stringBuilder.append(insertion.getText(bl3, bl2)).append("\n");
            if (!bl2) continue;
            this.packageNames.addAll(insertion.getPackageNames());
        }
        stringBuilder.append("public ").append(string).append("(");
        if (this.receiverInsertion != null && !this.receiverInsertion.isInserted()) {
            stringBuilder.append(this.receiverInsertion.getText(bl, bl2));
        }
        stringBuilder.append(") { super(); }");
        return stringBuilder.toString();
    }

    protected ReceiverInsertion getReceiverInsertion() {
        return this.receiverInsertion;
    }

    public void addReceiverInsertion(ReceiverInsertion receiverInsertion) {
        if (this.receiverInsertion == null) {
            this.receiverInsertion = receiverInsertion;
        } else {
            this.receiverInsertion.getInnerTypeInsertions().addAll(receiverInsertion.getInnerTypeInsertions());
        }
    }

    public void addDeclarationInsertion(Insertion insertion) {
        this.declarationInsertions.add(insertion);
        insertion.setInserted(true);
    }

    @Override
    protected boolean addLeadingSpace(boolean bl, int n, char c) {
        return false;
    }

    @Override
    protected boolean addTrailingSpace(boolean bl) {
        return false;
    }

    @Override
    public Insertion.Kind getKind() {
        return Insertion.Kind.CONSTRUCTOR;
    }

    @Override
    public void setInserted(boolean bl) {
        super.setInserted(false);
        if (this.receiverInsertion != null) {
            this.receiverInsertion.setInserted(false);
        }
        for (Insertion insertion : this.declarationInsertions) {
            insertion.setInserted(false);
        }
    }
}

